/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.CommonBoard;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.CommonTree;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.ServicesTree;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.event.NotificationEvent;

public class ServicesBoard
extends CommonBoard {
    private static Log log = LogFactory.getLog(ServicesBoard.class);

    public ServicesBoard(RegistryModel model, CommonConsole console, PropertyChannel channel) {
        this(model, console, channel, new ServicesTree(model, console));
    }

    public ServicesBoard(RegistryModel model, CommonConsole console, PropertyChannel channel, CommonTree customTree) {
        super(model, channel);
        this.tree = customTree;
        this.tree.setPropertyChannel(channel);
        this.createItself();
        this.model.addNotificationListener(this);
    }

    @Override
    public void notified(NotificationEvent event) {
        switch (event.getType()) {
            case 15: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.boardId + "-" + event.toString()));
                }
                this.createProgressBar(3);
                this.insertProgressBar();
                break;
            }
            case 16: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.boardId + "-" + event.toString()));
                }
                if (!(event.getMessage() instanceof Integer)) break;
                this.calibrateProgressBar((Integer)event.getMessage());
                break;
            }
            case 17: {
                this.channel.fire(this, "status-msg", event.getMessage());
                break;
            }
            case 18: {
                this.addToProgressBar();
                break;
            }
            case 19: 
            case 23: 
            case 27: {
                Object initiator;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.boardId + "-" + event.toString()));
                }
                if (this.tree == (initiator = event.getSource())) {
                    this.channel.fire(this, "status-msg", "Done");
                }
                this.removeProgressBar();
                break;
            }
            case 31: {
                Object initiator;
                this.removeProgressBar();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.boardId + "-" + event.toString()));
                }
                if (this.tree == (initiator = event.getSource())) break;
                this.tree.update(-1, (MobyService[])event.getDetails());
            }
        }
    }
}

