/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.CommonNode;
import org.biomoby.service.dashboard.CommonTree;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyServiceType;
import org.tulsoft.shared.UUtils;

public class ServiceTypesTree
extends CommonTree {
    private static Log log = LogFactory.getLog(ServiceTypesTree.class);
    RegistryModel registryModel;
    CommonConsole console;
    static final String SERVICE_TYPES_ACCESS_ERROR = "An error happened when accessing a list of available service types.\n\nCheck please values in text fields (in Registry Browser)\nspecifying registry endpoint and namespace, and in the\none specifying directory used as a local cache. Then\nright-click in the data types area and select 'Reload'.\n\n";

    public ServiceTypesTree(RegistryModel registryModel, CommonConsole console) {
        super("Service Types");
        this.registryModel = registryModel;
        this.console = console;
        this.createPopups("Service Types Menu");
        this.setLeafIcon(stLeafIcon);
    }

    @Override
    protected void createPopups(String title) {
        super.createPopups(title);
        this.addSortingItems();
    }

    @Override
    public void update(int howSorted, Object newData) {
        if (howSorted < 0) {
            howSorted = this.lastSorted;
        }
        this.lastSorted = howSorted;
        this.setEnabledPopup(false);
        final ServiceTypesTree source = this;
        final int sorted = howSorted;
        final MobyServiceType[] newServiceTypes = newData == null ? null : (MobyServiceType[])newData;
        SwingWorker worker = new SwingWorker(){
            MobyException updateException = null;
            MobyServiceType[] serviceTypes = null;

            @Override
            public Object construct() {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Tree " + ServiceTypesTree.this.treeId + " update request. Sorted: " + sorted + ", Data: " + newServiceTypes));
                    }
                    this.serviceTypes = newServiceTypes == null ? ServiceTypesTree.this.registryModel.getServiceTypes(source) : newServiceTypes;
                }
                catch (MobyException e) {
                    this.updateException = e;
                }
                return this.serviceTypes;
            }

            @Override
            public void finished() {
                if (this.updateException != null) {
                    CommonTree.error(ServiceTypesTree.SERVICE_TYPES_ACCESS_ERROR, (Exception)((Object)this.updateException));
                }
                if (this.serviceTypes != null) {
                    if (sorted == 1) {
                        ServiceTypesTree.this.onUpdateServiceTypesTreeByAuth(this.serviceTypes);
                    } else {
                        ServiceTypesTree.this.onUpdateServiceTypesTree(this.serviceTypes);
                    }
                    if (this.serviceTypes.length > 0) {
                        ServiceTypesTree.this.setEnabledPopup(true);
                    }
                }
            }
        };
        worker.start();
    }

    void onUpdateServiceTypesTree(MobyServiceType[] theServiceTypes) {
        Object[] serviceTypes = this.copy(theServiceTypes);
        Arrays.sort(serviceTypes);
        DefaultTreeModel tModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tModel.getRoot();
        root.removeAllChildren();
        HashMap<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>(serviceTypes.length);
        for (int i = 0; i < serviceTypes.length; ++i) {
            String[] parents;
            String thisName = serviceTypes[i].getName();
            DefaultMutableTreeNode thisNode = (DefaultMutableTreeNode)nodes.get(thisName);
            if (thisNode == null) {
                thisNode = new DefaultMutableTreeNode(new CommonNode(thisName, 13));
                nodes.put(thisName, thisNode);
            }
            if ((parents = serviceTypes[i].getParentNames()).length == 0) {
                root.add(thisNode);
                continue;
            }
            String parentName = parents[0];
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)nodes.get(parentName);
            if (parentNode == null) {
                parentNode = new DefaultMutableTreeNode(new CommonNode(parentName, 13));
                nodes.put(parentName, parentNode);
            }
            parentNode.add(thisNode);
        }
        tModel.reload();
    }

    void onUpdateServiceTypesTreeByAuth(MobyServiceType[] theServiceTypes) {
        MobyServiceType[] serviceTypes = this.copy(theServiceTypes);
        Arrays.sort(serviceTypes, MobyServiceType.getAuthorityComparator());
        DefaultTreeModel tModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tModel.getRoot();
        root.removeAllChildren();
        HashMap<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>(serviceTypes.length);
        for (int i = 0; i < serviceTypes.length; ++i) {
            DefaultMutableTreeNode authNode;
            String authority;
            String thisName = serviceTypes[i].getName();
            DefaultMutableTreeNode thisNode = (DefaultMutableTreeNode)nodes.get(thisName);
            if (thisNode == null) {
                thisNode = new DefaultMutableTreeNode(new CommonNode(thisName, 13));
                nodes.put(thisName, thisNode);
            }
            if (UUtils.isEmpty((String)(authority = serviceTypes[i].getAuthority()))) {
                authority = "<unknown>";
            }
            if ((authNode = (DefaultMutableTreeNode)nodes.get(authority)) == null) {
                authNode = new DefaultMutableTreeNode(new CommonNode(authority, 15));
                nodes.put(authority, authNode);
                root.add(authNode);
            }
            authNode.add(thisNode);
        }
        tModel.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MobyServiceType[] copy(MobyServiceType[] s) {
        MobyServiceType[] mobyServiceTypeArray = s;
        synchronized (s) {
            MobyServiceType[] result = new MobyServiceType[s.length];
            System.arraycopy(s, 0, result, 0, s.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    @Override
    protected void reload() {
        this.update(this.lastSorted, null);
    }

    @Override
    protected void search(String searchText) {
        final String regex = searchText;
        SwingWorker worker = new SwingWorker(){
            Set<String> found = new HashSet<String>();

            @Override
            public Object construct() {
                try {
                    if (UUtils.notEmpty((String)regex)) {
                        this.found = ServiceTypesTree.this.registryModel.findInServiceTypes(regex);
                    }
                }
                catch (MobyException e) {
                    CommonTree.error(ServiceTypesTree.SERVICE_TYPES_ACCESS_ERROR, (Exception)((Object)e));
                }
                return this.found;
            }

            @Override
            public void finished() {
                if (this.found != null) {
                    ServiceTypesTree.this.highlightAndJumpTo(this.found);
                }
            }
        };
        worker.start();
    }

    @Override
    protected void selected(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        final CommonNode nodeObject = (CommonNode)node.getUserObject();
        SwingWorker worker = new SwingWorker(){
            MobyServiceType serviceType;

            @Override
            public Object construct() {
                try {
                    this.serviceType = ServiceTypesTree.this.registryModel.getServiceType(nodeObject.getValue());
                }
                catch (MobyException e) {
                    CommonTree.error(ServiceTypesTree.SERVICE_TYPES_ACCESS_ERROR, (Exception)((Object)e));
                }
                return this.serviceType;
            }

            @Override
            public void finished() {
                if (this.serviceType != null) {
                    ServiceTypesTree.this.console.setText(this.serviceType.toString());
                }
            }
        };
        worker.start();
    }
}

