/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.CommonBoard;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.CommonTree;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.ServiceTypesTree;
import org.biomoby.shared.MobyServiceType;
import org.biomoby.shared.event.NotificationEvent;

public class ServiceTypesBoard
extends CommonBoard {
    private static Log log = LogFactory.getLog(ServiceTypesBoard.class);

    public ServiceTypesBoard(RegistryModel model, CommonConsole console, PropertyChannel channel) {
        this(model, console, channel, new ServiceTypesTree(model, console));
    }

    public ServiceTypesBoard(RegistryModel model, CommonConsole console, PropertyChannel channel, CommonTree customTree) {
        super(model, channel);
        this.tree = customTree;
        this.tree.setPropertyChannel(channel);
        this.createItself();
        this.model.addNotificationListener(this);
    }

    @Override
    public void notified(NotificationEvent event) {
        switch (event.getType()) {
            case 5: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.boardId + "-" + event.toString()));
                }
                this.createProgressBar(2);
                this.insertProgressBar();
                break;
            }
            case 6: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.boardId + "-" + event.toString()));
                }
                if (!(event.getMessage() instanceof Integer)) break;
                this.calibrateProgressBar((Integer)event.getMessage());
                break;
            }
            case 7: {
                this.channel.fire(this, "status-msg", event.getMessage());
                break;
            }
            case 8: {
                this.addToProgressBar();
                break;
            }
            case 9: 
            case 21: 
            case 25: {
                Object initiator;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.boardId + "-" + event.toString()));
                }
                if (this.tree == (initiator = event.getSource())) {
                    this.channel.fire(this, "status-msg", "Done");
                }
                this.removeProgressBar();
                break;
            }
            case 29: {
                Object initiator;
                this.removeProgressBar();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.boardId + "-" + event.toString()));
                }
                if (this.tree == (initiator = event.getSource())) break;
                this.tree.update(-1, (MobyServiceType[])event.getDetails());
            }
        }
    }
}

