/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import org.biomoby.client.ExtendedProtocolClient;
import org.biomoby.client.ExtendedServiceLocator;
import org.biomoby.client.MobyServiceLocator;
import org.biomoby.service.dashboard.AbstractModel;
import org.biomoby.service.dashboard.data.DataContainer;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.parser.MobyJob;
import org.biomoby.shared.parser.MobyPackage;
import org.tulsoft.shared.UUtils;

public class ServiceCallerModel
extends AbstractModel {
    public void runIt(DataContainer data) throws MobyException {
        SimpleClient worker = new SimpleClient(data);
        worker.process();
    }

    protected class MyServiceLocator
    extends ExtendedServiceLocator {
        public MyServiceLocator() throws MobyException {
            String password;
            MobyService selService = (MobyService)ServiceCallerModel.this.propertyChannel.get("dp-sc-service");
            if (selService == null) {
                throw new MobyException("No service given.");
            }
            MobyService clonedService = new MobyService(selService.getName(), selService.getAuthority());
            clonedService.setURL(selService.getURL());
            this.setService(clonedService);
            String howToCall = ServiceCallerModel.this.propertyChannel.getString("howToCallService");
            if ("service-new-endpoint".equals(howToCall)) {
                String sEndpoint = ServiceCallerModel.this.propertyChannel.getString("serviceEndpoint");
                if (!UUtils.isEmpty((String)sEndpoint)) {
                    clonedService.setURL(sEndpoint);
                }
            } else if ("as-registered".equals(howToCall)) {
                clonedService.setURL(null);
                this.setRegistryEndpoint(ServiceCallerModel.this.propertyChannel.getString("dp-registry-endpoint"));
                this.setRegistryNamespace(ServiceCallerModel.this.propertyChannel.getString("dp-registry-namespace"));
            } else if ("local-class".equals(howToCall)) {
                String localClass = ServiceCallerModel.this.propertyChannel.getString("serviceImplClass");
                if (UUtils.isEmpty((String)localClass)) {
                    throw new MobyException("No local class given.");
                }
                this.setLocalClass(localClass);
            } else if ("no-call".equals(howToCall)) {
                this.setLoop(true);
            }
            this.setAsBytes(ServiceCallerModel.this.propertyChannel.getBoolean("sendInputAsBytes", false));
            String user = ServiceCallerModel.this.propertyChannel.getString("service-authentication-user");
            if (user.length() > 0) {
                this.setUser(user);
            }
            if ((password = ServiceCallerModel.this.propertyChannel.getString("service-authentication-passwd")).length() > 0) {
                this.setPassword(password);
            }
        }
    }

    protected class SimpleClient
    extends ExtendedProtocolClient {
        DataContainer data;

        public SimpleClient(DataContainer data) {
            this.data = data;
        }

        public MobyServiceLocator getServiceLocator() throws MobyException {
            return new MyServiceLocator();
        }

        public boolean fillRequest(MobyJob request, MobyPackage inputContext) throws MobyException {
            return true;
        }

        public boolean useResponse(MobyJob response, MobyPackage responseContext) throws MobyException {
            return true;
        }

        public String fillRequest() throws MobyException {
            if (this.data == null) {
                throw new MobyException("No input data given.");
            }
            return (String)this.data.getData();
        }

        public boolean useResponse(String xmlResponse) throws MobyException {
            this.data.setData(xmlResponse);
            if (((ExtendedServiceLocator)this.getServiceLocator()).isLoop()) {
                return false;
            }
            return false;
        }
    }
}

