/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.biomoby.service.dashboard.CommonDataTable;
import org.biomoby.shared.MobySecondaryData;
import org.tulsoft.shared.StringUtils;

public class SecondaryDataTable
extends CommonDataTable {
    public static final int COL_ARTICLE = 1;
    public static final int COL_DATATYPE = 2;
    public static final int COL_DEFAULT = 3;
    public static final int COL_MIN = 4;
    public static final int COL_MAX = 5;
    public static final int COL_ENUM = 6;
    public static final int COL_DESC = 7;

    public SecondaryDataTable() {
        this.tableModel = new SecondaryDataTableModel();
        this.setModel(this.tableModel);
        this.createItself();
    }

    public MobySecondaryData[] getData() {
        Vector v = this.tableModel.getData();
        Object[] result = new MobySecondaryData[v.size()];
        v.copyInto(result);
        return result;
    }

    @Override
    protected void createItself() {
        super.createItself();
        TableColumn dtColumn = this.getColumnModel().getColumn(2);
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("String");
        comboBox.addItem("Integer");
        comboBox.addItem("Float");
        comboBox.addItem("Boolean");
        comboBox.addItem("DateTime");
        dtColumn.setCellRenderer(new DefaultTableCellRenderer());
        dtColumn.setCellEditor(new DefaultCellEditor(comboBox));
        TableColumn descColumn = this.getColumnModel().getColumn(7);
        if (tAreaIcon != null) {
            descColumn.setMaxWidth(tAreaIcon.getIconWidth() + 2);
        }
        descColumn.setCellRenderer(new MoreLinesButtonRenderer());
        descColumn.setCellEditor(new MoreLinesButtonEditor());
        descColumn.setHeaderRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return (JComponent)value;
            }
        });
        descColumn.setHeaderValue(new JButton("", tAreaIcon));
    }

    class MoreLinesButtonEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        MoreLinesButtonEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            MoreLinesButton button = new MoreLinesButton(this);
            button.rememberRow(row);
            return button;
        }
    }

    class MoreLinesButtonRenderer
    extends MoreLinesButton
    implements TableCellRenderer {
        public MoreLinesButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }

    class MoreLinesButton
    extends JButton {
        JTextArea editArea;
        JPanel editPanel;
        String[] buttons;
        int currentRow = -1;
        protected AbstractCellEditor editor;

        public MoreLinesButton() {
            this(null);
        }

        public MoreLinesButton(AbstractCellEditor editor) {
            this.setText("");
            this.setFocusPainted(false);
            this.editor = editor;
            this.setToolTipText("Click here to enter a value - possibly containing more lines");
            this.setIcon(CommonDataTable.tAreaIcon);
            if (editor != null) {
                this.editArea = new JTextArea(10, 40);
                this.editArea.setCaretPosition(0);
                this.editArea.setLineWrap(true);
                this.editArea.setWrapStyleWord(true);
                this.editPanel = new JPanel();
                this.editPanel.add(new JScrollPane(this.editArea));
                this.buttons = new String[]{"Done", "Clear", "Cancel"};
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String currentValue;
                        String string = currentValue = MoreLinesButton.this.currentRow >= 0 ? SecondaryDataTable.this.getValueAt(MoreLinesButton.this.currentRow, 7) : "";
                        if (currentValue != null) {
                            MoreLinesButton.this.editArea.setText(currentValue.toString());
                        }
                        int selected = JOptionPane.showOptionDialog(MoreLinesButton.this, MoreLinesButton.this.editPanel, "Enter/Edit multi-line data...", 0, -1, null, MoreLinesButton.this.buttons, null);
                        String newValue = null;
                        if (selected == 0) {
                            newValue = MoreLinesButton.this.editArea.getText();
                        } else if (selected == 1) {
                            newValue = "";
                        }
                        if (newValue != null && MoreLinesButton.this.currentRow >= 0) {
                            SecondaryDataTable.this.setValueAt(newValue, MoreLinesButton.this.currentRow, 7);
                        }
                        MoreLinesButton.this.editor.stopCellEditing();
                    }
                });
            }
        }

        public void rememberRow(int row) {
            this.currentRow = row;
        }
    }

    protected class SecondaryDataTableModel
    extends CommonDataTable.CommonDataTableModel {
        public static final int COL_ARTICLE = 1;
        public static final int COL_DATATYPE = 2;
        public static final int COL_DEFAULT = 3;
        public static final int COL_MIN = 4;
        public static final int COL_MAX = 5;
        public static final int COL_ENUM = 6;
        public static final int COL_DESC = 7;

        public SecondaryDataTableModel() {
            this.columnToolTips = new String[]{"Click in this column to remove data from this service", "Click to edit article name", "Select a primitive data type that will represent this parameter", "Click to edit parameter's default value", "Click to edit parameter's minimum value", "Click to edit parameter's maximum value", "Click to edit parameter's allowed values - separate them by commas", "Click to edit description - multi-lines are possible"};
            this.columnNames = new String[]{"Remove", "Article name", "Data Type", "Default", "Min", "Max", "Allowed", ""};
            this.columnClasses = new Class[]{Integer.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
        }

        @Override
        public void addEmptyData() {
            this.data.addElement(new MobySecondaryData(""));
            int rowCount = this.getRowCount();
            this.fireTableRowsInserted(rowCount - 1, rowCount - 1);
        }

        @Override
        public Object getValueAt(int row, int col) {
            try {
                MobySecondaryData d = (MobySecondaryData)this.data.elementAt(row);
                switch (col) {
                    case 0: {
                        return new Integer(row);
                    }
                    case 1: {
                        return d.getName();
                    }
                    case 2: {
                        return d.getDataType();
                    }
                    case 3: {
                        return d.getDefaultValue();
                    }
                    case 4: {
                        return d.getMinValue();
                    }
                    case 5: {
                        return d.getMaxValue();
                    }
                    case 6: {
                        return StringUtils.join((String[])d.getAllowedValues(), (String)",");
                    }
                    case 7: {
                        return d.getDescription();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (value == null) {
                return;
            }
            try {
                MobySecondaryData d = (MobySecondaryData)this.data.elementAt(row);
                switch (col) {
                    case 1: {
                        d.setName(value.toString());
                        break;
                    }
                    case 2: {
                        d.setDataType(value.toString());
                        break;
                    }
                    case 3: {
                        d.setDefaultValue(value.toString());
                        break;
                    }
                    case 4: {
                        d.setMinValue(value.toString());
                        break;
                    }
                    case 5: {
                        d.setMaxValue(value.toString());
                        break;
                    }
                    case 6: {
                        d.setAllowedValues(value.toString().split("\\s*,\\s*"));
                        break;
                    }
                    case 7: {
                        d.setDescription(value.toString());
                    }
                }
                this.fireTableCellUpdated(row, col);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }
    }
}

