/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.GraphColours;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.service.dashboard.data.DataContainer;
import org.biomoby.service.dashboard.renderers.Renderer;
import org.biomoby.service.dashboard.renderers.RendererRegistry;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.datatypes.MobyObject;
import org.biomoby.shared.parser.MobyCollection;
import org.biomoby.shared.parser.MobyDataElement;
import org.biomoby.shared.parser.MobyJob;
import org.biomoby.shared.parser.MobyPackage;
import org.biomoby.shared.parser.MobySimple;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.gui.SwingUtils;

public class ResultsPanel
extends AbstractPanel
implements ChangeListener {
    private static Log log = LogFactory.getLog(ResultsPanel.class);
    protected static final String SAVE_ERROR = "Sorry, an error happened when saving...\n\n";
    protected static final String VIEWER_ERROR = "Sorry, an error happened when displaying a result...\n\n";
    protected static final String VIEWER2_ERROR = "Sorry, an error happened when preparing a result.\n\nIf it is because of missing generated Java classes\n(see the error text below) then you may see less\nviewers than it is available for this particular\nresult. Please consider to follow hints (if any)\nin the message below to rectify the problem.\n\nPlease note that this error will be reported only\nthe first time when is encountered.\n\n";
    protected static final String NOT_SAVED = "Sorry, the contents was not saved. It is possible\nthat the current viewer does not support saving.\n\n";
    protected static final Insets B_TOP = new Insets(2, 0, 0, 0);
    protected ArrayList results = new ArrayList();
    protected RendererRegistry rendRegistry;
    JButton detachButton;
    JButton cleanButton;
    JButton saveButton;
    JFileChooser saveChooser;
    JComboBox viewers;
    JTabbedPane resultsPane;
    boolean alreadyReported = false;
    static Icon cleanIcon;
    static Icon cleanIconDis;
    static Icon saveIcon;
    static Icon saveIconDis;
    static Icon detachIcon;
    static Icon detachIconDis;

    public void adjustForDetachement() {
        if (this.pComponent != null) {
            this.pComponent.remove(this.detachButton);
            this.pComponent.remove(this.cleanButton);
        }
    }

    @Override
    public JComponent getComponent(PropertyChannel aPropertyChannel) {
        this.setPropertyChannel(aPropertyChannel);
        if (this.pComponent != null) {
            return this.pComponent;
        }
        this.pComponent = new JPanel(new GridBagLayout(), true);
        this.pComponent.setBorder(ResultsPanel.createFatBorder("Service Results", GraphColours.getColour("cadetblue", Color.blue)));
        this.resultsPane = new JTabbedPane();
        this.resultsPane.addChangeListener(this);
        this.viewers = new JComboBox(new DefaultComboBoxModel());
        this.viewers.setEnabled(false);
        this.viewers.setToolTipText("Available viewers");
        this.viewers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ResultsPanel.this.resultsPane.getSelectedIndex();
                if (index > -1) {
                    JComponent comp;
                    ResultContainer res = (ResultContainer)ResultsPanel.this.results.get(index);
                    JComboBox cb = (JComboBox)e.getSource();
                    DelegateRenderer dr = (DelegateRenderer)cb.getSelectedItem();
                    if (dr != null && (comp = dr.getComponent()) != null) {
                        ResultsPanel.this.resultsPane.setComponentAt(index, comp);
                        ResultsPanel.this.resultsPane.setIconAt(index, dr.getIcon());
                        int current = cb.getSelectedIndex();
                        if (current > -1) {
                            res.setIndexOfLastShown(current);
                        }
                    }
                }
            }
        });
        this.cleanButton = ResultsPanel.createButton("", "Discard all results", -1, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ResultsPanel.this.results.size() > 0 && AbstractPanel.confirm(ResultsPanel.this.getParent(), "Discard all results?")) {
                    ResultsPanel.this.removeResults();
                }
            }
        });
        this.cleanButton.setIcon(cleanIcon);
        this.cleanButton.setDisabledIcon(cleanIconDis);
        this.cleanButton.setEnabled(false);
        SwingUtils.compact((JButton)this.cleanButton);
        this.saveChooser = new JFileChooser();
        String initValue = this.getPrefValue("resultFile", System.getProperty("user.dir"));
        this.saveChooser.setDialogTitle("Save result");
        if (UUtils.notEmpty((String)initValue)) {
            File file = new File(initValue);
            this.saveChooser.setSelectedFile(file);
        }
        this.saveButton = ResultsPanel.createButton("", "Save displayed result to a file", -1, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.onSave();
            }
        });
        this.saveButton.setIcon(saveIcon);
        this.saveButton.setDisabledIcon(saveIconDis);
        this.saveButton.setEnabled(false);
        SwingUtils.compact((JButton)this.saveButton);
        this.detachButton = ResultsPanel.createButton("", "Detach this result panel from the Dashboard", -1, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.propertyChannel.fire("detachViewers", "");
            }
        });
        this.detachButton.setIcon(detachIcon);
        this.detachButton.setDisabledIcon(detachIconDis);
        this.detachButton.setEnabled(false);
        SwingUtils.compact((JButton)this.detachButton);
        Component glue = Box.createHorizontalGlue();
        SwingUtils.addComponent((JComponent)this.pComponent, (Component)this.resultsPane, (int)0, (int)0, (int)5, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        SwingUtils.addComponent((JComponent)this.pComponent, (Component)this.cleanButton, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)B_TOP);
        SwingUtils.addComponent((JComponent)this.pComponent, (Component)this.saveButton, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)B_TOP);
        SwingUtils.addComponent((JComponent)this.pComponent, (Component)this.detachButton, (int)2, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)B_TOP);
        SwingUtils.addComponent((JComponent)this.pComponent, (Component)glue, (int)3, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)B_TOP);
        SwingUtils.addComponent((JComponent)this.pComponent, (Component)this.viewers, (int)4, (int)1, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0, (Insets)B_TOP);
        return this.pComponent;
    }

    @Override
    protected void loadIcons() {
        super.loadIcons();
        if (cleanIcon == null) {
            cleanIcon = ResultsPanel.loadIcon("images/smallClear.gif");
        }
        if (cleanIconDis == null) {
            cleanIconDis = ResultsPanel.loadIcon("images/smallClear_dis.gif");
        }
        if (saveIcon == null) {
            saveIcon = ResultsPanel.loadIcon("images/smallSave.gif");
        }
        if (saveIconDis == null) {
            saveIconDis = ResultsPanel.loadIcon("images/smallSave_dis.gif");
        }
        if (detachIcon == null) {
            detachIcon = ResultsPanel.loadIcon("images/smallDetach.gif");
        }
        if (detachIconDis == null) {
            detachIconDis = ResultsPanel.loadIcon("images/smallDetach_dis.gif");
        }
    }

    protected String showSaveDialog() {
        if (this.saveChooser.showSaveDialog(this) != 0) {
            return null;
        }
        String fileName = this.saveChooser.getSelectedFile().getAbsolutePath();
        this.setPrefValue("resultFile", fileName);
        return fileName;
    }

    protected void onSave() {
        final String fileName = this.showSaveDialog();
        if (UUtils.isEmpty((String)fileName)) {
            return;
        }
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;

            @Override
            public Object construct() {
                try {
                    DelegateRenderer dr = (DelegateRenderer)ResultsPanel.this.viewers.getSelectedItem();
                    if (dr != null && !dr.save2File(new File(fileName))) {
                        AbstractPanel.error(ResultsPanel.NOT_SAVED);
                    }
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error(ResultsPanel.SAVE_ERROR, (Exception)((Object)this.exception));
                }
            }
        };
        worker.start();
    }

    protected void removeResults() {
        this.resultsPane.removeAll();
        this.results = new ArrayList();
        this.viewers.removeAllItems();
        this.viewers.setEnabled(false);
        this.cleanButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.detachButton.setEnabled(false);
    }

    protected void selectResult(int index) {
        this.updateViewers(index);
        this.viewers.setEnabled(true);
        this.cleanButton.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.detachButton.setEnabled(true);
    }

    public void updateComponent(DataContainer data) {
        MobyPackage moby;
        ResultContainer forAll;
        block11: {
            if (this.resultsPane == null) {
                log.error((Object)"updateComponent() called before getComponent()");
                return;
            }
            this.removeResults();
            this.rendRegistry = RendererRegistry.instance();
            forAll = new ResultContainer("All");
            this.results.add(forAll);
            this.findAndAddRenderers("class-name", data.getData().getClass().getName(), forAll, data, this.rendRegistry);
            if (data.getData() instanceof String && ((String)data.getData()).startsWith("<?xml")) {
                this.findAndAddRenderers("mime-type", "text/xml", forAll, data, this.rendRegistry);
            }
            moby = null;
            try {
                moby = MobyPackage.createFromXML((Object)data.getData());
            }
            catch (MobyException e) {
                if (this.alreadyReported) break block11;
                this.alreadyReported = true;
                ResultsPanel.error(VIEWER2_ERROR, (Exception)((Object)e));
            }
        }
        if (moby != null) {
            DataContainer mobyData = new DataContainer(moby, this.propertyChannel);
            this.findAndAddRenderers("moby-type", "", forAll, mobyData, this.rendRegistry);
            MobyJob[] jobs = moby.getJobs();
            for (int i = 0; i < jobs.length; ++i) {
                MobyJob job = jobs[i];
                MobyDataElement[] outputs = job.getDataElements();
                for (int j = 0; j < outputs.length; ++j) {
                    MobyDataElement output = outputs[j];
                    String resultName = output.getName();
                    if (jobs.length > 1) {
                        resultName = resultName + " (" + job.getId() + ")";
                    }
                    ResultContainer rescon = new ResultContainer(resultName);
                    this.processOneOutput(rescon, output, this.rendRegistry);
                    this.results.add(rescon);
                }
            }
        }
        boolean somethingToDisplay = false;
        for (ResultContainer res : this.results) {
            JComponent comp = res.getDefaultComponent();
            if (comp == null) continue;
            this.resultsPane.addTab(res.getResultName(), res.getDefaultIcon(), comp);
            somethingToDisplay = true;
        }
        if (somethingToDisplay) {
            this.selectResult(0);
        } else {
            this.resultsPane.addTab("Empty", new JLabel("No results, or no viewers..."));
        }
    }

    protected boolean findAndAddRenderers(String criterion, String value, ResultContainer resultContainer, DataContainer data, RendererRegistry registry) {
        boolean somethingAdded = false;
        List rs = registry.getRenderers(criterion, value);
        Iterator i = rs.iterator();
        while (i.hasNext()) {
            resultContainer.addRenderer((Renderer)i.next(), data);
            somethingAdded = true;
        }
        return somethingAdded;
    }

    protected void processOneOutput(ResultContainer rescon, MobyDataElement output, RendererRegistry registry) {
        MobySimple[] elems;
        if (output instanceof MobySimple) {
            MobyObject mObj = ((MobySimple)output).getData();
            if (mObj != null) {
                DataContainer mobyResult = new DataContainer(mObj, this.propertyChannel);
                this.findAndAddRenderers("moby-type", mObj.getMobyTypeName(), rescon, mobyResult, this.rendRegistry);
            }
        } else if (output instanceof MobyCollection && (elems = ((MobyCollection)output).getData()).length > 0) {
            ArrayList<MobyObject> a = new ArrayList<MobyObject>();
            for (int k = 0; k < elems.length; ++k) {
                MobyObject mo = elems[k].getData();
                if (mo == null) continue;
                a.add(mo);
            }
            if (a.size() > 0) {
                MobyObject[] collection = new MobyObject[a.size()];
                a.toArray(collection);
                MobyObject mObj0 = collection[0];
                DataContainer mobyColl = new DataContainer(collection, this.propertyChannel);
                this.findAndAddRenderers("moby-type", mObj0.getMobyTypeName(), rescon, mobyColl, this.rendRegistry);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.resultsPane.getSelectedIndex();
        if (index > -1) {
            this.updateViewers(index);
        }
    }

    protected void updateViewers(int index) {
        ResultContainer res = (ResultContainer)this.results.get(index);
        ActionListener[] als = this.viewers.getActionListeners();
        for (int l = 0; l < als.length; ++l) {
            this.viewers.removeActionListener(als[l]);
        }
        this.viewers.removeAllItems();
        int i = 0;
        List rs = res.getRenderers();
        for (Renderer r : rs) {
            this.viewers.addItem(new DelegateRenderer(r, res.getDataContainer(i)));
            ++i;
        }
        for (int l = 0; l < als.length; ++l) {
            this.viewers.addActionListener(als[l]);
        }
        this.viewers.setSelectedIndex(res.getIndexOfLastShown());
    }

    @Override
    public String getName() {
        return "Results";
    }

    protected class ResultContainer {
        ArrayList data = new ArrayList();
        ArrayList renderers = new ArrayList();
        String resultName;
        int lastShown = 0;

        public ResultContainer(String resultName) {
            this.resultName = resultName;
        }

        public String getResultName() {
            return this.resultName;
        }

        public synchronized void addRenderer(Renderer r, DataContainer container) {
            String rendererName = r.getName();
            Iterator iter = this.renderers.iterator();
            while (iter.hasNext()) {
                if (!rendererName.equals(((Renderer)iter.next()).getName())) continue;
                return;
            }
            this.renderers.add(r);
            this.data.add(container);
        }

        public List getRenderers() {
            return this.renderers;
        }

        public DataContainer getDataContainer(int index) {
            return (DataContainer)this.data.get(index);
        }

        public JComponent getDefaultComponent() {
            if (this.renderers.size() > 0) {
                try {
                    return ((Renderer)this.renderers.get(0)).getComponent((DataContainer)this.data.get(0));
                }
                catch (MobyException e) {
                    AbstractPanel.error(ResultsPanel.VIEWER_ERROR, (Exception)((Object)e));
                }
            }
            return null;
        }

        public Icon getDefaultIcon() {
            if (this.renderers.size() > 0) {
                return ((Renderer)this.renderers.get(0)).getIcon();
            }
            return null;
        }

        public int getIndexOfLastShown() {
            return this.lastShown;
        }

        public void setIndexOfLastShown(int lastShown) {
            this.lastShown = lastShown;
        }
    }

    private class DelegateRenderer {
        Renderer delegate;
        DataContainer data;

        public DelegateRenderer(Renderer realRenderer, DataContainer data) {
            this.delegate = realRenderer;
            this.data = data;
        }

        public JComponent getComponent() {
            try {
                return this.delegate.getComponent(this.data);
            }
            catch (MobyException e) {
                AbstractPanel.error(ResultsPanel.VIEWER_ERROR, (Exception)((Object)e));
                return null;
            }
        }

        public Icon getIcon() {
            return this.delegate.getIcon();
        }

        public boolean save2File(File file) throws MobyException {
            return this.delegate.save2File(this.data, file);
        }

        public String toString() {
            return this.delegate.getName();
        }
    }
}

