/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.registry.meta.Registries;
import org.biomoby.registry.meta.RegistriesList;
import org.biomoby.registry.meta.Registry;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.DashboardConfig;
import org.biomoby.service.dashboard.DataTypesBoard;
import org.biomoby.service.dashboard.NamespacesBoard;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.ServiceTypesBoard;
import org.biomoby.service.dashboard.ServicesBoard;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.shared.MobyException;
import org.tulsoft.tools.gui.JFileChooserWithHistory;
import org.tulsoft.tools.gui.JTextFieldWithHistory;
import org.tulsoft.tools.gui.SwingUtils;

public class RegistryPanel
extends AbstractPanel {
    private static Log log = LogFactory.getLog(RegistryPanel.class);
    static final String USE_CACHE = "use-cache";
    static final String SHOW_REG_INFO = "show-reg-info";
    RegistryModel registryModel;
    JTextFieldWithHistory registryURL;
    JTextFieldWithHistory registryNS;
    JFileChooserWithHistory cacheDir;
    JLabel labelCacheDir;
    CommonConsole console;
    JCheckBox bServices;
    JCheckBox bDataTypes;
    JCheckBox bNamespaces;
    JCheckBox bServiceTypes;
    JCheckBox bAll;
    JButton infoButton;
    JButton updateButton;
    JButton eraseButton;
    DataTypesBoard dataTypesBoard;
    ServiceTypesBoard serviceTypesBoard;
    NamespacesBoard namespacesBoard;
    ServicesBoard servicesBoard;
    protected static Icon defaultsIcon;
    protected static Icon reloadIcon;
    protected static Icon infoIcon;
    protected static Icon updateIcon;
    protected static Icon eraseIcon;
    static final String UPDATE_LABEL = "<html>Update or reload your local cache<br>for the entities selected below.<p><p><font color='red'>Update</font> is faster than reload but<br>it may not reflect changes in the<br>contents of the entities.<p><p><font color='red'>Reload</font> is slower than update but it<br>guarantees that the full contents<br>of all cached entities is up to date.<p>";

    public RegistryPanel() {
        this.panelIconFileName = "images/registry.gif";
    }

    @Override
    protected void loadIcons() {
        super.loadIcons();
        if (defaultsIcon == null) {
            defaultsIcon = RegistryPanel.loadIcon("images/smallUndo.gif");
        }
        if (reloadIcon == null) {
            reloadIcon = RegistryPanel.loadIcon("images/smallReload.gif");
        }
        if (infoIcon == null) {
            infoIcon = RegistryPanel.loadIcon("images/smallInfo.gif");
        }
        if (updateIcon == null) {
            updateIcon = RegistryPanel.loadIcon("images/smallSynch.gif");
        }
        if (eraseIcon == null) {
            eraseIcon = RegistryPanel.loadIcon("images/smallTrash.gif");
        }
    }

    protected String getUserTmpDir() {
        String userName;
        String standardTmpDir = System.getProperty("java.io.tmpdir");
        if (standardTmpDir.indexOf(userName = System.getProperty("user.name")) > -1) {
            return standardTmpDir;
        }
        File userTmpDir = new File(standardTmpDir, userName);
        if (userTmpDir.exists()) {
            return userTmpDir.getAbsolutePath();
        }
        if (userTmpDir.mkdirs()) {
            return userTmpDir.getAbsolutePath();
        }
        return standardTmpDir;
    }

    @Override
    public JComponent getComponent(PropertyChannel propertyChannel) {
        this.setPropertyChannel(propertyChannel);
        this.registryModel = this.createRegistryModel();
        if (this.pComponent != null) {
            return this.pComponent;
        }
        this.pComponent = new JPanel(new GridBagLayout(), true);
        JPanel regLocation = this.getRegistryLocation();
        JPanel cacheLocation = this.getCacheLocation();
        this.console = new CommonConsole();
        this.console.setAppendMode(false);
        this.dataTypesBoard = new DataTypesBoard(this.registryModel, this.console, propertyChannel);
        this.serviceTypesBoard = new ServiceTypesBoard(this.registryModel, this.console, propertyChannel);
        this.namespacesBoard = new NamespacesBoard(this.registryModel, this.console, propertyChannel);
        this.servicesBoard = new ServicesBoard(this.registryModel, this.console, propertyChannel);
        this.dataTypesBoard.updateTree(0);
        log.debug((Object)"Data Types tree update started");
        this.serviceTypesBoard.updateTree(0);
        log.debug((Object)"Service Types tree update started");
        this.namespacesBoard.updateTree(0);
        log.debug((Object)"Namespaces tree update started");
        this.servicesBoard.updateTree(0);
        log.debug((Object)"Services tree update started");
        JSplitPane split1 = this.hSplit(this.servicesBoard, this.dataTypesBoard, 0.5);
        JSplitPane split2 = this.hSplit(this.serviceTypesBoard, this.namespacesBoard, 0.5);
        JSplitPane split3 = this.hSplit(split1, split2, 0.5);
        JSplitPane split4 = this.vSplit(split3, this.console, 0.5);
        SwingUtils.addComponent((JComponent)this.pComponent, (Component)split4, (int)0, (int)0, (int)1, (int)2, (int)1, (int)18, (double)1.0, (double)1.0);
        SwingUtils.addComponent((JComponent)this.pComponent, (Component)regLocation, (int)1, (int)0, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)this.pComponent, (Component)cacheLocation, (int)1, (int)1, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        return this.pComponent;
    }

    protected void onReloadAll() {
        this.dataTypesBoard.updateTree(-1);
        this.serviceTypesBoard.updateTree(-1);
        this.namespacesBoard.updateTree(-1);
        this.servicesBoard.updateTree(-1);
    }

    protected void onDefaults() {
        this.registryURL.setText(this.registryModel.getDefaultRegistryEndpoint());
        this.registryNS.setText(this.registryModel.getDefaultRegistryNamespace());
    }

    private JPanel createCacheDialog(String introText) {
        JPanel p = new JPanel(new GridBagLayout());
        JLabel start = new JLabel(introText);
        this.bServices = RegistryPanel.createCheckBox("Services", false, 83, null);
        this.bDataTypes = RegistryPanel.createCheckBox("Data types", false, 68, null);
        this.bNamespaces = RegistryPanel.createCheckBox("Namespaces", false, 78, null);
        this.bServiceTypes = RegistryPanel.createCheckBox("Service types", false, 84, null);
        this.bAll = RegistryPanel.createCheckBox("All", false, 65, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() != 1;
                RegistryPanel.this.bServices.setEnabled(enabled);
                RegistryPanel.this.bDataTypes.setEnabled(enabled);
                RegistryPanel.this.bNamespaces.setEnabled(enabled);
                RegistryPanel.this.bServiceTypes.setEnabled(enabled);
            }
        });
        SwingUtils.addComponent((JComponent)p, (Component)start, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.bServices, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)p, (Component)this.bDataTypes, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.bNamespaces, (int)0, (int)3, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.bServiceTypes, (int)0, (int)4, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.bAll, (int)0, (int)5, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        return p;
    }

    protected void onCacheInfo() {
        final JLabel contents = new JLabel();
        final String[] buttons = new String[]{"Copy to console", "Done"};
        this.propertyChannel.fire("status-msg", "Retrieving cache info...");
        this.infoButton.setEnabled(false);
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;
            String info = null;

            @Override
            public Object construct() {
                try {
                    this.info = RegistryPanel.this.registryModel.getCacheInfoFormatted();
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception == null) {
                    contents.setText("<html><pre>" + this.info + "</pre>");
                } else {
                    contents.setText("<html>Sorry, I could not retrieve any info...<br>I think that the problem is actually here:<p><pre>" + this.exception.getMessage() + "</pre>");
                }
                if (JOptionPane.showOptionDialog(null, contents, "Info on local cache", 0, -1, AbstractPanel.confirmIcon, buttons, null) == 0) {
                    RegistryPanel.this.console.setText(this.info);
                }
                RegistryPanel.this.propertyChannel.fire("status-msg", "Done");
                RegistryPanel.this.infoButton.setEnabled(true);
            }
        };
        worker.start();
    }

    protected void onCacheErase() {
    }

    protected void onCacheUpdate() {
        boolean toReload;
        Object[] buttons;
        JPanel p = this.createCacheDialog(UPDATE_LABEL);
        int selected = JOptionPane.showOptionDialog(null, p, "Update/Reload local cache", 0, 3, confirmIcon, buttons = new String[]{"Update", "Reload", "Cancel"}, null);
        if (selected == 0) {
            toReload = false;
        } else if (selected == 1) {
            toReload = true;
        } else {
            return;
        }
        boolean all = this.bAll.isSelected();
        if (all || this.bServices.isSelected()) {
            this.updateCache(1, toReload);
        }
        if (all || this.bDataTypes.isSelected()) {
            this.updateCache(2, toReload);
        }
        if (all || this.bNamespaces.isSelected()) {
            this.updateCache(8, toReload);
        }
        if (all || this.bServiceTypes.isSelected()) {
            this.updateCache(4, toReload);
        }
    }

    private void updateCache(int cachePart, boolean reload) {
        final int myCachePart = cachePart;
        final boolean myReload = reload;
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;

            @Override
            public Object construct() {
                try {
                    switch (myCachePart) {
                        case 1: {
                            if (myReload) {
                                RegistryPanel.this.registryModel.reloadServicesCache();
                                break;
                            }
                            RegistryPanel.this.registryModel.updateServicesCache();
                            break;
                        }
                        case 2: {
                            if (myReload) {
                                RegistryPanel.this.registryModel.reloadDataTypesCache();
                                break;
                            }
                            RegistryPanel.this.registryModel.updateDataTypesCache();
                            break;
                        }
                        case 4: {
                            if (myReload) {
                                RegistryPanel.this.registryModel.reloadServiceTypesCache();
                                break;
                            }
                            RegistryPanel.this.registryModel.updateServiceTypesCache();
                            break;
                        }
                        case 8: {
                            if (myReload) {
                                RegistryPanel.this.registryModel.reloadNamespacesCache();
                                break;
                            }
                            RegistryPanel.this.registryModel.updateNamespacesCache();
                        }
                    }
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (log.isDebugEnabled()) {
                    log.debug((Object)((myReload ? "Reload of " : "Update of part ") + myCachePart + " finished"));
                }
                if (this.exception != null) {
                    AbstractPanel.error("An error occured when filling/updating the cache.\n\n", (Exception)((Object)this.exception));
                }
            }
        };
        worker.start();
    }

    protected void onUseCache(boolean enabled) {
        this.cacheDir.setEnabled(enabled);
        this.labelCacheDir.setEnabled(enabled);
        this.infoButton.setEnabled(enabled);
        this.updateButton.setEnabled(enabled);
        this.setPrefValue(USE_CACHE, enabled);
        this.propertyChannel.put("dp-use-cache", new Boolean(enabled).toString());
    }

    protected JPanel getKnownRegistries() {
        JLabel labelReg = new JLabel("Known registries");
        boolean showingReg = this.getPrefValue(SHOW_REG_INFO, false);
        JCheckBox showReg = RegistryPanel.createCheckBox("Show info", showingReg, -1, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() == 1;
                RegistryPanel.this.setPrefValue(RegistryPanel.SHOW_REG_INFO, enabled);
                RegistryPanel.this.propertyChannel.put("dp-reg-info", new Boolean(enabled).toString());
            }
        });
        this.propertyChannel.put("dp-reg-info", new Boolean(showingReg).toString());
        showReg.setToolTipText("Each time you select a registry, an info appears in console window");
        final Registries regs = RegistriesList.getInstance();
        JComboBox<String> regList = new JComboBox<String>(RegistryPanel.getOnlyWantedRegistries(regs.list()));
        regList.setToolTipText("A selection will fill text fields below");
        final String defaultRegistry = RegistryPanel.getDefaultRegistrySynonym();
        regList.setSelectedItem(this.getPrefValue("dp-registry-synonym", defaultRegistry));
        regList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String contents = (String)((JComboBox)e.getSource()).getSelectedItem();
                RegistryPanel.this.setPrefValue("dp-registry-synonym", contents);
                Registry theReg = null;
                try {
                    theReg = regs.get(contents);
                }
                catch (MobyException ee) {
                    try {
                        theReg = regs.get(defaultRegistry);
                    }
                    catch (MobyException ee2) {
                        log.error((Object)"List of registries does not contain the default registry.");
                    }
                }
                if (theReg != null) {
                    boolean show = RegistryPanel.this.propertyChannel.getBoolean("dp-reg-info", false);
                    if (show) {
                        RegistryPanel.this.console.setText(theReg.toString());
                    }
                    RegistryPanel.this.registryURL.setText(theReg.getEndpoint());
                    RegistryPanel.this.registryNS.setText(theReg.getNamespace());
                }
            }
        });
        JPanel p = new JPanel(new GridBagLayout());
        SwingUtils.addComponent((JComponent)p, (Component)labelReg, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, regList, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)showReg, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        return p;
    }

    protected static String[] getOnlyWantedRegistries(String[] regs) {
        String[] wantedRegs = DashboardConfig.getStrings("dashboard.wanted.registries", null);
        if (wantedRegs.length == 0) {
            return regs;
        }
        ArrayList<String> registeredAndWanted = new ArrayList<String>();
        for (String wantedReg : wantedRegs) {
            boolean found = false;
            for (String knownReg : regs) {
                if (!wantedReg.equals(knownReg)) continue;
                found = true;
                break;
            }
            if (found) {
                registeredAndWanted.add(wantedReg);
                continue;
            }
            log.warn((Object)("An unknown registry synonym found in the property dashboard.wanted.registries: " + wantedReg));
        }
        if (registeredAndWanted.size() > 0) {
            return registeredAndWanted.toArray(new String[0]);
        }
        return regs;
    }

    protected static String getDefaultRegistrySynonym() {
        String[] wantedRegs;
        String defaultReg = DashboardConfig.getString("dashboard.default.registry", null);
        if (defaultReg == null) {
            defaultReg = "default";
        }
        for (String wantedReg : wantedRegs = RegistryPanel.getOnlyWantedRegistries(RegistriesList.getInstance().list())) {
            if (!defaultReg.equals(wantedReg)) continue;
            return defaultReg;
        }
        log.warn((Object)("Default registry '" + defaultReg + "' is not found in wanted registries."));
        return defaultReg;
    }

    protected JPanel getRegistryLocation() {
        JPanel regs = this.getKnownRegistries();
        JLabel labelRegistryURL = new JLabel("Endpoint");
        this.registryURL = this.createText(null, "registryEndpoint", "dp-registry-endpoint");
        JLabel labelRegistryNS = new JLabel("Namespace (URI)");
        this.registryNS = this.createText(null, "registryNamespace", "dp-registry-namespace");
        JButton reloadAllButton = RegistryPanel.createButton(" Reload all lists ", "Reload all ontology trees from a Biomoby registry, or from the cache", 82, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryPanel.this.onReloadAll();
            }
        });
        reloadAllButton.setIcon(reloadIcon);
        JButton defaultsButton = RegistryPanel.createButton(" Restore defaults ", "Fill the text fields above with the default values", 68, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryPanel.this.onDefaults();
            }
        });
        defaultsButton.setIcon(defaultsIcon);
        JPanel buttonPanel = RegistryPanel.createButtonPanel(new JButton[]{reloadAllButton, defaultsButton});
        JPanel rLocation = RegistryPanel.createTitledPanel("Biomoby registry location");
        SwingUtils.addComponent((JComponent)rLocation, (Component)regs, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)rLocation, (Component)labelRegistryURL, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)rLocation, (Component)this.registryURL, (int)0, (int)2, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)rLocation, (Component)labelRegistryNS, (int)0, (int)3, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)rLocation, (Component)this.registryNS, (int)0, (int)4, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)rLocation, (Component)buttonPanel, (int)0, (int)5, (int)1, (int)1, (int)0, (int)16, (double)0.0, (double)0.0);
        return rLocation;
    }

    protected JPanel getCacheLocation() {
        boolean usingCache = this.getPrefValue(USE_CACHE, true);
        JCheckBox useCache = RegistryPanel.createCheckBox("Use local cache", usingCache, 67, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RegistryPanel.this.onUseCache(e.getStateChange() == 1);
            }
        });
        this.propertyChannel.put("dp-use-cache", new Boolean(usingCache).toString());
        this.labelCacheDir = new JLabel("Cache directory");
        this.cacheDir = this.createFileSelector("Select directory for/with local cache", "Select", FilenameUtils.separatorsToSystem((String)DashboardConfig.getString("registry.cache.dir", this.getUserTmpDir())), "cacheDirectory", "dp-cache-dir");
        this.cacheDir.getFileChooser().setFileSelectionMode(1);
        this.infoButton = RegistryPanel.createButton(" Info ", "Show current information about the local cache", 73, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryPanel.this.onCacheInfo();
            }
        });
        this.infoButton.setIcon(infoIcon);
        this.updateButton = RegistryPanel.createButton(" Update ", "Update local cache from Biomoby registry", 85, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryPanel.this.onCacheUpdate();
            }
        });
        this.updateButton.setIcon(updateIcon);
        JPanel buttonPanel = RegistryPanel.createButtonPanel(new JButton[]{this.infoButton, this.updateButton});
        this.onUseCache(usingCache);
        JPanel cLocation = RegistryPanel.createTitledPanel("Local cache");
        SwingUtils.addComponent((JComponent)cLocation, (Component)useCache, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)cLocation, (Component)this.labelCacheDir, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)cLocation, (Component)this.cacheDir, (int)0, (int)2, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)cLocation, (Component)buttonPanel, (int)0, (int)3, (int)1, (int)1, (int)0, (int)16, (double)0.0, (double)0.0);
        return cLocation;
    }

    @Override
    public String getName() {
        return "Registry Browser";
    }

    @Override
    public String getDescription() {
        return "A panel showing all Biomoby entities, allowing different sort orders. It also defines which Biomoby registry to use and how and where to cache Biomoby entities locally.";
    }

    @Override
    public boolean isMandatory() {
        return true;
    }
}

