/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.client.CentralDigestCachedImpl;
import org.biomoby.service.dashboard.AbstractModel;
import org.biomoby.shared.CentralAll;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.MobyServiceType;
import org.biomoby.shared.NoSuccessException;
import org.biomoby.shared.PendingCurationException;
import org.biomoby.shared.event.NotificationEvent;
import org.biomoby.shared.event.NotificationListener;
import org.biomoby.shared.event.Notifier;
import org.tulsoft.shared.FileUtils;
import org.tulsoft.shared.GException;

public class RegistryModel
extends AbstractModel
implements Notifier {
    private static Log log = LogFactory.getLog(RegistryModel.class);
    public static final int PART_SERVICES = 1;
    public static final int PART_DATA_TYPES = 2;
    public static final int PART_SERVICE_TYPES = 4;
    public static final int PART_NAMESPACES = 8;
    CentralAll worker;
    CentralDigestCachedImpl castWorker;
    boolean useCache = true;
    Hashtable dataTypesTable = new Hashtable();
    Hashtable serviceTypesTable = new Hashtable();
    Hashtable namespacesTable = new Hashtable();
    Hashtable servicesTable = new Hashtable();
    private static final String MSG_REG_PENDING_CURATION = "Registration reports 'Pending curation'...\nWell, nobody knows what it means. Call Mark!";
    private static final String MSG_REG_NO_SUCCESS = "Registration reports 'No Success'...\n";
    private static final String MSG_UNREG_PENDING_CURATION = "Unregistration reports 'Pending curation'...\nWell, nobody knows what it means. Call Mark!";
    private static final String MSG_UNREG_NO_SUCCESS = "Unregistration reports 'No Success'...\n";

    public String getDefaultRegistryEndpoint() {
        return "http://moby.ucalgary.ca/moby/MOBY-Central.pl";
    }

    public String getDefaultRegistryNamespace() {
        return "http://moby.ucalgary.ca/MOBY/Central";
    }

    public boolean setVerbose(boolean enabled) {
        try {
            this.initWorker();
            return this.worker.setDebug(enabled);
        }
        catch (Exception e) {
            log.error((Object)("Cannot set verbose mode: " + e.getMessage()));
            return false;
        }
    }

    public String callRegistry(String methodName, File inputXML) throws MobyException {
        this.initWorker();
        try {
            String xml = FileUtils.getFile((String)inputXML.getAbsolutePath(), (boolean)false);
            return this.worker.call(methodName, xml);
        }
        catch (IOException e) {
            throw new MobyException("Problem reading file. " + e.toString());
        }
        catch (GException e) {
            throw new MobyException(e.getMessage());
        }
    }

    public void registerDataType(MobyDataType dataType) throws MobyException {
        this.initWorker();
        try {
            this.worker.registerDataType(dataType);
        }
        catch (PendingCurationException e) {
            throw new MobyException(MSG_REG_PENDING_CURATION);
        }
        catch (NoSuccessException e) {
            throw new MobyException(MSG_REG_NO_SUCCESS + e.getMessage());
        }
    }

    public String getRegisterDataTypeXML(MobyDataType dataType) throws MobyException {
        this.initWorker();
        return ((CentralDigestCachedImpl)this.worker).getRegisterDataTypeXML(dataType);
    }

    public void unRegisterDataType(MobyDataType dataType) throws MobyException {
        this.initWorker();
        try {
            this.worker.unregisterDataType(dataType);
        }
        catch (PendingCurationException e) {
            throw new MobyException(MSG_UNREG_PENDING_CURATION);
        }
        catch (NoSuccessException e) {
            throw new MobyException(MSG_UNREG_NO_SUCCESS + e.getMessage());
        }
    }

    public void updateDataTypesCache() throws MobyException {
        this.initWorker();
        this.castWorker.updateCache("c1");
        this.fireEvent(28, "", null);
    }

    public void reloadDataTypesCache() throws MobyException {
        this.initWorker();
        this.castWorker.removeFromCache("c1");
        this.castWorker.updateCache("c1");
        this.fireEvent(28, "", null);
    }

    public MobyDataType[] getDataTypes(Object initiator) throws MobyException {
        this.initWorker();
        if (initiator != null) {
            this.fireEvent(initiator, 20, "", null);
        }
        MobyDataType[] dataTypes = this.worker.getDataTypes();
        this.dataTypesTable.clear();
        for (int i = 0; i < dataTypes.length; ++i) {
            this.dataTypesTable.put(dataTypes[i].getName(), dataTypes[i]);
        }
        if (initiator != null) {
            this.fireEvent(initiator, 28, "", dataTypes);
        }
        return dataTypes;
    }

    public MobyDataType getDataType(String dataTypeName) throws MobyException {
        if (dataTypeName == null) {
            return null;
        }
        this.getDataTypes(null);
        return (MobyDataType)this.dataTypesTable.get(dataTypeName);
    }

    public HashSet findInDataTypes(String searchText) throws MobyException {
        HashSet<String> found = new HashSet<String>();
        MobyDataType[] dataTypes = this.getDataTypes(null);
        if (!searchText.startsWith("(?i)")) {
            searchText = "(?i)" + searchText;
        }
        Pattern pattern = Pattern.compile(searchText);
        for (int i = 0; i < dataTypes.length; ++i) {
            if (!pattern.matcher(dataTypes[i].toString()).find()) continue;
            found.add(dataTypes[i].getName());
        }
        return found;
    }

    public void registerServiceType(MobyServiceType serviceType) throws MobyException {
        this.initWorker();
        try {
            this.worker.registerServiceType(serviceType);
        }
        catch (PendingCurationException e) {
            throw new MobyException(MSG_REG_PENDING_CURATION);
        }
        catch (NoSuccessException e) {
            throw new MobyException(MSG_REG_NO_SUCCESS + e.getMessage());
        }
    }

    public String getRegisterServiceTypeXML(MobyServiceType serviceType) throws MobyException {
        this.initWorker();
        return ((CentralDigestCachedImpl)this.worker).getRegisterServiceTypeXML(serviceType);
    }

    public void unRegisterServiceType(MobyServiceType serviceType) throws MobyException {
        this.initWorker();
        try {
            this.worker.unregisterServiceType(serviceType);
        }
        catch (PendingCurationException e) {
            throw new MobyException(MSG_UNREG_PENDING_CURATION);
        }
        catch (NoSuccessException e) {
            throw new MobyException(MSG_UNREG_NO_SUCCESS + e.getMessage());
        }
    }

    public void updateServiceTypesCache() throws MobyException {
        this.initWorker();
        this.castWorker.updateCache("c3");
        this.fireEvent(29, "", null);
    }

    public void reloadServiceTypesCache() throws MobyException {
        this.initWorker();
        this.castWorker.removeFromCache("c3");
        this.castWorker.updateCache("c3");
        this.fireEvent(29, "", null);
    }

    public MobyServiceType[] getServiceTypes(Object initiator) throws MobyException {
        this.initWorker();
        if (initiator != null) {
            this.fireEvent(initiator, 21, "", null);
        }
        MobyServiceType[] serviceTypes = this.worker.getFullServiceTypes();
        this.serviceTypesTable = new Hashtable();
        for (int i = 0; i < serviceTypes.length; ++i) {
            this.serviceTypesTable.put(serviceTypes[i].getName(), serviceTypes[i]);
        }
        if (initiator != null) {
            this.fireEvent(initiator, 29, "", serviceTypes);
        }
        return serviceTypes;
    }

    public MobyServiceType getServiceType(String serviceTypeName) throws MobyException {
        if (serviceTypeName == null) {
            return null;
        }
        this.getServiceTypes(null);
        return (MobyServiceType)this.serviceTypesTable.get(serviceTypeName);
    }

    public Set<String> findInServiceTypes(String searchText) throws MobyException {
        HashSet<String> found = new HashSet<String>();
        MobyServiceType[] serviceTypes = this.getServiceTypes(null);
        if (!searchText.startsWith("(?i)")) {
            searchText = "(?i)" + searchText;
        }
        Pattern pattern = Pattern.compile(searchText);
        for (int i = 0; i < serviceTypes.length; ++i) {
            if (!pattern.matcher(serviceTypes[i].toString()).find()) continue;
            found.add(serviceTypes[i].getName());
        }
        return found;
    }

    public void registerNamespace(MobyNamespace namespace) throws MobyException {
        this.initWorker();
        try {
            this.worker.registerNamespace(namespace);
        }
        catch (PendingCurationException e) {
            throw new MobyException(MSG_REG_PENDING_CURATION);
        }
        catch (NoSuccessException e) {
            throw new MobyException(MSG_REG_NO_SUCCESS + e.getMessage());
        }
    }

    public String getRegisterNamespaceXML(MobyNamespace namespace) throws MobyException {
        this.initWorker();
        return ((CentralDigestCachedImpl)this.worker).getRegisterNamespaceXML(namespace);
    }

    public void unRegisterNamespace(MobyNamespace namespace) throws MobyException {
        this.initWorker();
        try {
            this.worker.unregisterNamespace(namespace);
        }
        catch (PendingCurationException e) {
            throw new MobyException(MSG_UNREG_PENDING_CURATION);
        }
        catch (NoSuccessException e) {
            throw new MobyException(MSG_UNREG_NO_SUCCESS + e.getMessage());
        }
    }

    public void updateNamespacesCache() throws MobyException {
        this.initWorker();
        this.castWorker.updateCache("c4");
        this.fireEvent(30, "", null);
    }

    public void reloadNamespacesCache() throws MobyException {
        this.initWorker();
        this.castWorker.removeFromCache("c4");
        this.castWorker.updateCache("c4");
        this.fireEvent(30, "", null);
    }

    public MobyNamespace[] getNamespaces(Object initiator) throws MobyException {
        this.initWorker();
        if (initiator != null) {
            this.fireEvent(initiator, 22, "", null);
        }
        MobyNamespace[] namespaces = this.worker.getFullNamespaces();
        this.namespacesTable.clear();
        for (int i = 0; i < namespaces.length; ++i) {
            this.namespacesTable.put(namespaces[i].getName(), namespaces[i]);
        }
        if (initiator != null) {
            this.fireEvent(initiator, 30, "", namespaces);
        }
        return namespaces;
    }

    public MobyNamespace getNamespace(String namespace) throws MobyException {
        if (namespace == null) {
            return null;
        }
        this.getNamespaces(null);
        return (MobyNamespace)this.namespacesTable.get(namespace);
    }

    public HashSet findInNamespaces(String searchText) throws MobyException {
        HashSet<String> found = new HashSet<String>();
        MobyNamespace[] namespaces = this.getNamespaces(null);
        if (!searchText.startsWith("(?i)")) {
            searchText = "(?i)" + searchText;
        }
        Pattern pattern = Pattern.compile(searchText);
        for (int i = 0; i < namespaces.length; ++i) {
            if (!pattern.matcher(namespaces[i].toString()).find()) continue;
            found.add(namespaces[i].getName());
        }
        return found;
    }

    public void registerService(MobyService service) throws MobyException {
        this.initWorker();
        try {
            this.worker.registerService(service);
        }
        catch (PendingCurationException e) {
            throw new MobyException(MSG_REG_PENDING_CURATION);
        }
        catch (NoSuccessException e) {
            throw new MobyException(MSG_REG_NO_SUCCESS + e.getMessage());
        }
    }

    public String getRegisterServiceXML(MobyService service) throws MobyException {
        this.initWorker();
        return ((CentralDigestCachedImpl)this.worker).getRegisterServiceXML(service);
    }

    public void unRegisterService(MobyService service) throws MobyException {
        this.initWorker();
        try {
            this.worker.unregisterService(service);
        }
        catch (PendingCurationException e) {
            throw new MobyException(MSG_UNREG_PENDING_CURATION);
        }
        catch (NoSuccessException e) {
            throw new MobyException(MSG_UNREG_NO_SUCCESS + e.getMessage());
        }
    }

    public void updateServicesCache() throws MobyException {
        this.initWorker();
        this.castWorker.updateCache("c2");
        this.fireEvent(31, "", null);
    }

    public void reloadServicesCache() throws MobyException {
        this.initWorker();
        this.castWorker.removeFromCache("c2");
        this.castWorker.updateCache("c2");
        this.fireEvent(31, "", null);
    }

    public MobyService[] getServices(Object initiator) throws MobyException {
        this.initWorker();
        if (initiator != null) {
            this.fireEvent(initiator, 23, "", null);
        }
        MobyService[] services = this.worker.getServices();
        this.servicesTable = new Hashtable();
        for (int i = 0; i < services.length; ++i) {
            this.servicesTable.put(services[i].getUniqueName(), services[i]);
        }
        if (initiator != null) {
            this.fireEvent(initiator, 31, "", services);
        }
        return services;
    }

    public MobyService getService(String combinedServiceName) throws MobyException {
        if (combinedServiceName == null) {
            return null;
        }
        this.getServices(null);
        return (MobyService)this.servicesTable.get(combinedServiceName);
    }

    public Set<String> findInServices(String searchText) throws MobyException {
        HashSet<String> found = new HashSet<String>();
        MobyService[] services = this.getServices(null);
        if (!searchText.startsWith("(?i)")) {
            searchText = "(?i)" + searchText;
        }
        Pattern pattern = Pattern.compile(searchText);
        for (int i = 0; i < services.length; ++i) {
            if (!pattern.matcher(services[i].toString()).find()) continue;
            found.add(services[i].getUniqueName());
        }
        return found;
    }

    protected String getCacheDir() {
        if (this.worker instanceof CentralDigestCachedImpl) {
            return ((CentralDigestCachedImpl)this.worker).getCacheDir();
        }
        return null;
    }

    public String getCacheInfoFormatted() throws MobyException {
        this.initWorker();
        StringBuffer buf = new StringBuffer(500);
        buf.append(this.castWorker.getCacheInfoFormatted("c2"));
        buf.append(this.castWorker.getCacheInfoFormatted("c1"));
        buf.append(this.castWorker.getCacheInfoFormatted("c4"));
        buf.append(this.castWorker.getCacheInfoFormatted("c3"));
        return new String(buf);
    }

    protected void initWorker() throws MobyException {
        this.initWorker(null);
    }

    protected synchronized void initWorker(NotificationListener[] l) throws MobyException {
        if (this.worker == null) {
            String registryURL = this.propertyChannel.getString("dp-registry-endpoint");
            String registryNS = this.propertyChannel.getString("dp-registry-namespace");
            String cacheDir = this.propertyChannel.getString("dp-cache-dir");
            this.useCache = this.propertyChannel.getBoolean("dp-use-cache", true);
            if (!this.useCache) {
                cacheDir = null;
            }
            this.worker = new CentralDigestCachedImpl(registryURL, registryNS, cacheDir);
        } else {
            String maybeNewRegistryURL = this.propertyChannel.getString("dp-registry-endpoint");
            String maybeNewRegistryNS = this.propertyChannel.getString("dp-registry-namespace");
            String maybeNewCacheDir = this.propertyChannel.getString("dp-cache-dir");
            boolean maybeUseCache = this.propertyChannel.getBoolean("dp-use-cache", true);
            if (maybeUseCache == this.useCache && maybeNewRegistryURL.equals(this.worker.getRegistryEndpoint()) && maybeNewRegistryNS.equals(this.worker.getRegistryNamespace()) && maybeNewCacheDir.equals(this.getCacheDir())) {
                if (l != null) {
                    ((Notifier)this.worker).addNotificationListeners(l);
                }
                return;
            }
            this.useCache = maybeUseCache;
            if (!this.useCache) {
                maybeNewCacheDir = null;
            }
            NotificationListener[] nls = ((Notifier)this.worker).getNotificationListeners();
            ((Notifier)this.worker).removeNotificationListeners(nls);
            this.worker = new CentralDigestCachedImpl(maybeNewRegistryURL, maybeNewRegistryNS, maybeNewCacheDir);
            ((Notifier)this.worker).addNotificationListeners(nls);
        }
        if (l != null) {
            ((Notifier)this.worker).addNotificationListeners(l);
        }
        this.castWorker = (CentralDigestCachedImpl)this.worker;
    }

    public void addNotificationListener(NotificationListener l) {
        try {
            this.initWorker(new NotificationListener[]{l});
            log.debug((Object)("ADD listener: " + ClassUtils.getShortClassName((Object)l, (String)"unknown")));
        }
        catch (MobyException e) {
            log.error((Object)e.getMessage());
        }
    }

    public void addNotificationListeners(NotificationListener[] l) {
        try {
            this.initWorker(l);
        }
        catch (MobyException e) {
            log.error((Object)e.getMessage());
        }
    }

    public synchronized void removeNotificationListener(NotificationListener l) {
        try {
            this.initWorker();
            ((Notifier)this.worker).removeNotificationListener(l);
            log.debug((Object)("DEL listener: " + l.getClass().getName()));
        }
        catch (MobyException e) {
            log.error((Object)e.getMessage());
        }
    }

    public void removeNotificationListeners(NotificationListener[] l) {
        try {
            this.initWorker();
            ((Notifier)this.worker).removeNotificationListeners(l);
        }
        catch (MobyException e) {
            log.error((Object)e.getMessage());
        }
    }

    public NotificationListener[] getNotificationListeners() {
        try {
            this.initWorker();
            return ((Notifier)this.worker).getNotificationListeners();
        }
        catch (MobyException e) {
            log.error((Object)e.getMessage());
            return new NotificationListener[0];
        }
    }

    public void callback(int signal) {
        if (this.worker != null) {
            ((Notifier)this.worker).callback(signal);
        }
    }

    public void fireEvent(int type, Object message, Object details) {
        if (this.worker != null) {
            ((Notifier)this.worker).fireEvent(type, message, details);
        }
    }

    public void fireEvent(NotificationEvent event) {
        if (this.worker != null) {
            ((Notifier)this.worker).fireEvent(event);
        }
    }

    protected void fireEvent(Object source, int type, Object message, Object details) {
        NotificationEvent event = null;
        event = details == null ? new NotificationEvent(source, type, message) : new NotificationEvent(source, type, message, details);
        this.fireEvent(event);
    }
}

