/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.CommonNode;
import org.biomoby.service.dashboard.CommonTree;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistrationPanel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.ServiceTypesBoard;
import org.biomoby.service.dashboard.ServiceTypesTree;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyServiceType;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.gui.JTextFieldWithHistory;
import org.tulsoft.tools.gui.SwingUtils;

public class RegistrationServiceTypeSubPanel
extends RegistrationPanel {
    static final String COPY_BY_SELECT_ST = "st-copy-by-select";
    static final String REG_ST_FROM_XML = "reg-st-from-xml-file";
    static final String REG_ST_ISA = "reg-st-isa-parent";
    JTextFieldWithHistory stName;
    JTextFieldWithHistory stAuth;
    JTextFieldWithHistory stEmail;
    JTextArea stDescArea;
    JLabel stISA;
    CustomServiceTypesTree serviceTypeTree;
    JButton unregisButton;

    public JComponent getComponent(PropertyChannel propertyChannel, CommonConsole console) {
        this.setPropertyChannel(propertyChannel);
        this.registryModel = this.createRegistryModel();
        this.console = console;
        JPanel p = new JPanel(new GridBagLayout());
        JLabel labelSTName = new JLabel("Service Type Name");
        this.stName = this.createText(null, "serviceTypeName", "dp-reg-st-name");
        JLabel labelSTAuth = new JLabel("Authority (usually a domain name)");
        this.stAuth = this.createText(null, "serviceTypeAuth", "dp-reg-st-auth");
        JLabel labelSTEmail = new JLabel("Contact email");
        this.stEmail = this.createText(null, "serviceTypeEmail", "dp-reg-st-email");
        this.stDescArea = new JTextArea();
        JPanel stDesc = this.createCustomTextArea("Description", null, "serviceTypeDesc", "dp-reg-st-desc", this.stDescArea);
        JLabel labelSTISA = new JLabel("Parent type: ");
        this.stISA = new JLabel(this.getPrefValue(REG_ST_ISA, ""));
        JPanel defs = RegistrationServiceTypeSubPanel.createTitledPanel("New Service Type");
        SwingUtils.addComponent((JComponent)defs, (Component)labelSTName, (int)0, (int)0, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)this.stName, (int)0, (int)1, (int)2, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)labelSTAuth, (int)0, (int)2, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)defs, (Component)this.stAuth, (int)0, (int)3, (int)2, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)labelSTEmail, (int)0, (int)4, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)defs, (Component)this.stEmail, (int)0, (int)5, (int)2, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)stDesc, (int)0, (int)6, (int)2, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)defs, (Component)labelSTISA, (int)0, (int)7, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)defs, (Component)this.stISA, (int)1, (int)7, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        this.serviceTypeTree = new CustomServiceTypesTree(this.registryModel, console);
        ServiceTypesBoard serviceTypesBoard = new ServiceTypesBoard(this.registryModel, console, propertyChannel, this.serviceTypeTree);
        serviceTypesBoard.updateTree(0);
        boolean usingCopyBySelect = this.getPrefValue(COPY_BY_SELECT_ST, false);
        this.copyBySelect = RegistrationServiceTypeSubPanel.createCheckBox("Fill new Service Type when selected", usingCopyBySelect, 79, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RegistrationServiceTypeSubPanel.this.onCopyBySelectST(e.getStateChange() == 1);
            }
        });
        JPanel board = new JPanel(new GridBagLayout());
        SwingUtils.addComponent((JComponent)board, (Component)serviceTypesBoard, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        SwingUtils.addComponent((JComponent)board, (Component)this.copyBySelect, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        JSplitPane split = this.hSplit(defs, board, 0.5);
        this.registerButton = this.createRegisterButton(" Register Service Type ", "Register a new service type in a Biomoby registry", 84);
        this.showXMLButton = this.createShowXMLButton("Create and show XML for registering this service type", 88);
        this.fromXMLButton = this.createFromXMLButton("Register this service type from a raw XML in a file", "registerServiceType", 70, REG_ST_FROM_XML, this.createXMLChooser(REG_ST_FROM_XML));
        this.unregisButton = RegistrationServiceTypeSubPanel.createButton(" Unregister Service Type ", "Remove an existing service type from a Biomoby registry", 85, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationServiceTypeSubPanel.this.serviceTypeTree.onUnregisterServiceType();
            }
        });
        this.unregisButton.setIcon(unregisterIcon);
        this.unregisButton.setDisabledIcon(unregisterIconDis);
        this.unregisButton.setEnabled(false);
        SwingUtils.addComponent((JComponent)p, (Component)split, (int)0, (int)0, (int)4, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.registerButton, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.showXMLButton, (int)1, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.fromXMLButton, (int)2, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.unregisButton, (int)3, (int)1, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0);
        return p;
    }

    protected void onCopyBySelectST(boolean enabled) {
        this.setPrefValue(COPY_BY_SELECT_ST, enabled);
    }

    @Override
    public void checkAndRegister(boolean realRegistration) throws MobyException {
        String value = this.stName.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Service type name is still missing. Please fill it first.");
        }
        MobyServiceType serviceType = new MobyServiceType(value);
        value = this.stAuth.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Every service type must have an authority.\nFill it, or (if such authority already exists)\nselect it from the service types tree sorted by authority.");
        }
        serviceType.setAuthority(value);
        value = this.stEmail.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Every service type must have a contact person.\nPlease fill in an email address.");
        }
        serviceType.setEmailContact(value);
        value = this.stDescArea.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Every service type must have a description.\nPlease fill in the most detailed one.");
        }
        serviceType.setDescription(value);
        value = this.stISA.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Every service type must inherit from an existing type.\nPlease select a type from available service types\nand add it as a parent type (right-click in the tree).");
        }
        serviceType.addParentName(value);
        if (realRegistration) {
            this.console.setText("Service type to be registered:\n------------------------------\n" + serviceType.toString() + "\n");
            this.registryModel.registerServiceType(serviceType);
            this.console.setText("\nRegistration successful!\n\n");
            this.updateCache();
        } else {
            String xml = this.registryModel.getRegisterServiceTypeXML(serviceType);
            this.console.setText("\n" + xml + "\n");
        }
    }

    @Override
    protected void updateCache() throws MobyException {
        this.registryModel.updateServiceTypesCache();
    }

    protected class CustomServiceTypesTree
    extends ServiceTypesTree {
        protected static final String AC_PARENT = "ac-parent";
        protected static final String AC_UNREG = "ac-unreg";

        public CustomServiceTypesTree(RegistryModel model, CommonConsole console) {
            super(model, console);
        }

        @Override
        protected void createPopups(String title) {
            super.createPopups(title);
            this.removeFromPopups("ac-reload");
            this.removeSeparatorAfter("ac-collapse");
            this.popup.addSeparator();
            this.popup.add(CustomServiceTypesTree.createMenuItem(new AbstractAction("Add selected as a parent type - ISA"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomServiceTypesTree.this.onParentSelectedST();
                }
            }, AC_PARENT, RegistrationPanel.menuAddISAIcon, RegistrationPanel.menuAddISAIconDis));
            this.popup.addSeparator();
            this.popup.add(CustomServiceTypesTree.createMenuItem(new AbstractAction("Unregister"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomServiceTypesTree.this.onUnregisterServiceType();
                }
            }, AC_UNREG, RegistrationPanel.unregisterIcon, RegistrationPanel.unregisterIconDis));
        }

        @Override
        protected void setEnabledPopup(boolean enabled) {
            super.setEnabledPopup(enabled);
            this.selected(null);
        }

        @Override
        protected void selected(DefaultMutableTreeNode node) {
            if (node == null) {
                this.setEnabledPopupItem(AC_UNREG, false);
                this.setEnabledPopupItem(AC_PARENT, false);
                if (RegistrationServiceTypeSubPanel.this.unregisButton != null) {
                    RegistrationServiceTypeSubPanel.this.unregisButton.setEnabled(false);
                }
                return;
            }
            final CommonNode nodeObject = (CommonNode)node.getUserObject();
            final boolean isServiceType = nodeObject.getType() == 13;
            final boolean isAuthority = nodeObject.getType() == 15;
            this.setEnabledPopupItem(AC_UNREG, isServiceType);
            this.setEnabledPopupItem(AC_PARENT, isServiceType);
            SwingWorker worker = new SwingWorker(){
                MobyServiceType serviceType = null;

                @Override
                public Object construct() {
                    try {
                        if (isServiceType) {
                            this.serviceType = CustomServiceTypesTree.this.registryModel.getServiceType(nodeObject.getValue());
                        }
                        RegistrationServiceTypeSubPanel.this.unregisButton.setEnabled(isServiceType);
                    }
                    catch (MobyException e) {
                        CommonTree.error("An error happened when accessing a list of available service types.\n\nCheck please values in text fields (in Registry Browser)\nspecifying registry endpoint and namespace, and in the\none specifying directory used as a local cache. Then\nright-click in the data types area and select 'Reload'.\n\n", (Exception)((Object)e));
                    }
                    return this.serviceType;
                }

                @Override
                public void finished() {
                    if (this.serviceType != null) {
                        CustomServiceTypesTree.this.console.setText(this.serviceType.toString() + "\n");
                        if (RegistrationServiceTypeSubPanel.this.copyBySelect.isSelected()) {
                            RegistrationServiceTypeSubPanel.this.stName.setText(this.serviceType.getName());
                            RegistrationServiceTypeSubPanel.this.stAuth.setText(this.serviceType.getAuthority());
                            RegistrationServiceTypeSubPanel.this.stEmail.setText(this.serviceType.getEmailContact());
                            RegistrationServiceTypeSubPanel.this.stDescArea.setText(this.serviceType.getDescription());
                            RegistrationServiceTypeSubPanel.this.stISA.setText(this.serviceType.getParentName());
                        }
                    } else if (isAuthority && RegistrationServiceTypeSubPanel.this.copyBySelect.isSelected()) {
                        RegistrationServiceTypeSubPanel.this.stAuth.setText(nodeObject.getValue());
                    }
                }
            };
            worker.start();
        }

        protected void onParentSelectedST() {
            CommonNode nodeObject;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            if (node != null && (nodeObject = (CommonNode)node.getUserObject()).getType() == 13) {
                String value = nodeObject.getValue();
                RegistrationServiceTypeSubPanel.this.stISA.setText(value);
                RegistrationServiceTypeSubPanel.this.setPrefValue(RegistrationServiceTypeSubPanel.REG_ST_ISA, value);
                this.propertyChannel.put("dp-reg-st-isa", value);
            }
        }

        protected void onUnregisterServiceType() {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            CommonNode nodeObject = (CommonNode)node.getUserObject();
            final String name = nodeObject.getValue();
            if (!AbstractPanel.confirm("Are you sure you wish to unregister\nservice type: " + name + " ?")) {
                return;
            }
            SwingWorker worker = new SwingWorker(){
                boolean oldAppendMode;
                MobyException exception = null;

                @Override
                public Object construct() {
                    try {
                        RegistrationServiceTypeSubPanel.this.unregisButton.setEnabled(false);
                        MobyServiceType serviceType = new MobyServiceType(name);
                        this.oldAppendMode = CustomServiceTypesTree.this.console.setAppendMode(true);
                        CustomServiceTypesTree.this.console.setText("Service type to be unregistered: " + name + "\n");
                        CustomServiceTypesTree.this.registryModel.unRegisterServiceType(serviceType);
                        CustomServiceTypesTree.this.console.setText("\nUnregistration successful!\n\n");
                        RegistrationServiceTypeSubPanel.this.updateCache();
                    }
                    catch (MobyException e) {
                        this.exception = e;
                    }
                    return null;
                }

                @Override
                public void finished() {
                    if (this.exception != null) {
                        CommonTree.error("An error occured when trying to unregister a service type.\n\n", (Exception)((Object)this.exception));
                    }
                    CustomServiceTypesTree.this.console.setAppendMode(this.oldAppendMode);
                }
            };
            worker.start();
        }
    }
}

