/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.CommonNode;
import org.biomoby.service.dashboard.DataTypesBoard;
import org.biomoby.service.dashboard.DataTypesTree;
import org.biomoby.service.dashboard.NamespacesBoard;
import org.biomoby.service.dashboard.NamespacesTree;
import org.biomoby.service.dashboard.PrimaryDataTable;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistrationPanel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.SecondaryDataTable;
import org.biomoby.service.dashboard.ServiceTypesBoard;
import org.biomoby.service.dashboard.ServiceTypesTree;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.shared.MobyData;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobySecondaryData;
import org.biomoby.shared.MobyService;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.gui.JFileChooserWithHistory;
import org.tulsoft.tools.gui.JTextFieldWithHistory;
import org.tulsoft.tools.gui.SwingUtils;

public class RegistrationServiceSubPanel
extends RegistrationPanel
implements PropertyChangeListener {
    static final String USE_SIGNATURE = "use-signature";
    static final String USE_AUTHORITATIVE = "use-authoritative";
    static final String REG_S_TYPE = "reg-s-type";
    static final String REG_S_FROM_XML = "reg-service-from-xml-file";
    static final String COPY_BY_SELECT_S = "s-copy-by-select";
    JTextFieldWithHistory sName;
    JTextFieldWithHistory sAuth;
    JTextFieldWithHistory sEmail;
    JTextFieldWithHistory sURL;
    JTextFieldWithHistory sSigURL;
    JComboBox sCategories;
    JTextArea sDescArea;
    JLabel sType;
    JLabel labelSigURL;
    JLabel labelRDFPath;
    JFileChooserWithHistory localRDFFile;
    JCheckBox useAuth;
    JCheckBox useSignature;
    JRadioButton rbInputs;
    JRadioButton rbOutputs;
    PrimaryDataTable primInTable;
    PrimaryDataTable primOutTable;
    SecondaryDataTable secTable;
    JButton unregisButton;
    JButton agentButton;

    public JComponent getComponent(PropertyChannel propertyChannel, CommonConsole console) {
        this.setPropertyChannel(propertyChannel);
        this.registryModel = this.createRegistryModel();
        this.console = console;
        this.propertyChannel.addPropertyChangeListener(this);
        JPanel p = new JPanel(new GridBagLayout());
        JLabel labelSName = new JLabel("Service name");
        this.sName = this.createText(null, "serviceName", "dp-reg-s-name");
        JLabel labelSAuth = new JLabel("Authority");
        this.sAuth = this.createText(null, "serviceAuth", "dp-reg-s-auth");
        JLabel labelSEmail = new JLabel("Contact email");
        this.sEmail = this.createText(null, "serviceEmail", "dp-reg-s-email");
        JLabel labelSCat = new JLabel("Service category");
        this.sCategories = new JComboBox<String>(new String[]{"moby", "moby-async", "doc-literal", "doc-literal-async", "cgi", "cgi-async"});
        this.sCategories.setToolTipText("What kind of BioMoby service you wish to register");
        this.sCategories.setSelectedItem(this.getPrefValue("dp-reg-s-category", "moby"));
        this.sCategories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String contents = (String)((JComboBox)e.getSource()).getSelectedItem();
                RegistrationServiceSubPanel.this.setPrefValue("dp-reg-s-category", contents);
            }
        });
        JLabel labelSURL = new JLabel("Service endpoint - URL");
        this.sURL = this.createText(null, "serviceURL", "dp-reg-s-url");
        boolean usingAuth = this.getPrefValue(USE_AUTHORITATIVE, true);
        this.useAuth = RegistrationServiceSubPanel.createCheckBox("authoritative", usingAuth, 65, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RegistrationServiceSubPanel.this.onAuth(e.getStateChange() == 1);
            }
        });
        this.onAuth(usingAuth);
        this.labelSigURL = new JLabel("RDF endpoint - signature URL");
        this.sSigURL = this.createText(null, "signatureURL", "dp-reg-s-rdf-url");
        this.labelRDFPath = new JLabel("Where to store RDF document");
        String defValue = System.getProperty("java.io.tmpdir") + File.separator + "service.rdf";
        this.localRDFFile = this.createFileSelector("File name for RDF service signature", "Select", defValue, "localRDFFile", "dp-reg-s-rdf-path");
        boolean usingSignature = this.getPrefValue(USE_SIGNATURE, false);
        this.useSignature = RegistrationServiceSubPanel.createCheckBox("Use RDF signature", usingSignature, 82, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RegistrationServiceSubPanel.this.onUseRDFSignature(e.getStateChange() == 1);
            }
        });
        this.onUseRDFSignature(usingSignature);
        JPanel pRDF = RegistrationServiceSubPanel.createTitledPanel("Service RDF Signature");
        SwingUtils.addComponent((JComponent)pRDF, (Component)this.useSignature, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pRDF, (Component)this.labelSigURL, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)pRDF, (Component)this.sSigURL, (int)0, (int)2, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pRDF, (Component)this.labelRDFPath, (int)0, (int)3, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pRDF, (Component)this.localRDFFile, (int)0, (int)4, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        JPanel serviceType = new JPanel(new GridBagLayout());
        JLabel labelST = new JLabel("Service type: ");
        this.sType = new JLabel(this.getPrefValue(REG_S_TYPE, ""));
        SwingUtils.addComponent((JComponent)serviceType, (Component)labelST, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)serviceType, (Component)this.sType, (int)1, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        this.copyBySelect = RegistrationServiceSubPanel.createCheckBox("Fill new Service when selected in browser panel", false, 67, null);
        JPanel defs = new JPanel(new GridBagLayout());
        SwingUtils.addComponent((JComponent)defs, (Component)labelSName, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)this.sName, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)this.useAuth, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_LEFT);
        SwingUtils.addComponent((JComponent)defs, (Component)labelSAuth, (int)0, (int)2, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)this.sAuth, (int)0, (int)3, (int)2, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)labelSEmail, (int)0, (int)4, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)this.sEmail, (int)0, (int)5, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)labelSCat, (int)1, (int)4, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_LEFT);
        SwingUtils.addComponent((JComponent)defs, (Component)this.sCategories, (int)1, (int)5, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_LEFT);
        SwingUtils.addComponent((JComponent)defs, (Component)labelSURL, (int)0, (int)6, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)this.sURL, (int)0, (int)7, (int)2, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)pRDF, (int)0, (int)8, (int)2, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)defs, (Component)serviceType, (int)0, (int)9, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        this.sDescArea = new JTextArea();
        JPanel sDesc = this.createCustomTextArea("Description", null, "serviceDesc", null, this.sDescArea);
        ServiceTypesBoard stBoard = new ServiceTypesBoard(this.registryModel, console, propertyChannel, new CustomServiceTypesTree2(this.registryModel, console));
        stBoard.updateTree(0);
        JPanel main = RegistrationServiceSubPanel.createTitledPanel("New Service");
        SwingUtils.addComponent((JComponent)main, (Component)defs, (int)0, (int)0, (int)2, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)main, (Component)sDesc, (int)0, (int)1, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)main, (Component)stBoard, (int)1, (int)1, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (Insets)BREATH_TOP_LEFT);
        SwingUtils.addComponent((JComponent)main, (Component)this.copyBySelect, (int)0, (int)2, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        JTabbedPane dataPane = new JTabbedPane();
        dataPane.addTab("Primary Inputs and Outputs", this.getPrimaryData());
        dataPane.addTab("Secondary Inputs", this.getSecondaryInputs());
        JSplitPane split = this.hSplit(main, dataPane, 0.3);
        this.registerButton = this.createRegisterButton(" Register Service ", "Register a new service in a Biomoby registry", 83);
        this.showXMLButton = this.createShowXMLButton("Create and show XML for registering this service", 88);
        this.fromXMLButton = this.createFromXMLButton("Register this service from a raw XML in a file", "registerService", 70, REG_S_FROM_XML, this.createXMLChooser(REG_S_FROM_XML));
        this.unregisButton = RegistrationServiceSubPanel.createButton(" Unregister service ", "Remove an existing service from a Biomoby registry", 85, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationServiceSubPanel.this.onUnregisterService();
            }
        });
        this.unregisButton.setIcon(unregisterIcon);
        this.unregisButton.setDisabledIcon(unregisterIconDis);
        this.agentButton = RegistrationServiceSubPanel.createButton(" Call RDF Agent ", "Ask a registry agent to come and to check your RDF document describing your services", 65, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationServiceSubPanel.this.onCallAgent();
            }
        });
        this.agentButton.setIcon(agentIcon);
        this.agentButton.setDisabledIcon(agentIconDis);
        Component glue = Box.createHorizontalGlue();
        SwingUtils.addComponent((JComponent)p, (Component)split, (int)0, (int)0, (int)6, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.registerButton, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.showXMLButton, (int)1, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.fromXMLButton, (int)2, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.agentButton, (int)3, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)glue, (int)4, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.unregisButton, (int)5, (int)1, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0);
        return p;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.copyBySelect == null || !this.copyBySelect.isSelected()) {
            return;
        }
        String prop = event.getPropertyName();
        if (prop == null) {
            return;
        }
        Object obj = event.getNewValue();
        if (obj == null || !(obj instanceof MobyService)) {
            return;
        }
        final MobyService service = (MobyService)obj;
        if ("dp-s-selected".equals(prop)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RegistrationServiceSubPanel.this.onFillService(service);
                }
            });
        }
    }

    protected void onFillService(MobyService service) {
        this.sName.setText(service.getName());
        this.sAuth.setText(service.getAuthority());
        this.sEmail.setText(service.getEmailContact());
        this.sURL.setText(service.getURL());
        this.sSigURL.setText(service.getSignatureURL());
        this.sDescArea.setText(service.getDescription());
        this.useAuth.setEnabled(service.isAuthoritative());
        this.sType.setText(service.getType());
        String value = service.getPathToRDF();
        if (UUtils.notEmpty((String)value)) {
            this.localRDFFile.getTextField().setText(service.getPathToRDF());
        }
        this.primInTable.setData((MobyData[])service.getPrimaryInputs());
        this.primOutTable.setData((MobyData[])service.getPrimaryOutputs());
        this.secTable.setData((MobyData[])service.getSecondaryInputs());
    }

    protected void onUseRDFSignature(boolean enabled) {
        this.sSigURL.setEnabled(enabled);
        this.labelSigURL.setEnabled(enabled);
        this.localRDFFile.setEnabled(enabled);
        this.labelRDFPath.setEnabled(enabled);
        this.setPrefValue(USE_SIGNATURE, enabled);
        this.propertyChannel.put("dp-use-signature", new Boolean(enabled).toString());
    }

    protected void onAuth(boolean enabled) {
        this.setPrefValue(USE_AUTHORITATIVE, enabled);
        this.propertyChannel.put("dp-use-auth", new Boolean(enabled).toString());
    }

    protected JPanel getPrimaryData() {
        JPanel p = RegistrationServiceSubPanel.createTitledPanel("");
        this.primInTable = new PrimaryDataTable();
        this.primOutTable = new PrimaryDataTable();
        JButton addButtonIn = RegistrationServiceSubPanel.createButton(" Add input data ", "Add new primary input data to the service definition", 73, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationServiceSubPanel.this.rbInputs.setSelected(true);
                RegistrationServiceSubPanel.this.primInTable.addEmptyData();
            }
        });
        addButtonIn.setIcon(addDataIcon);
        addButtonIn.setDisabledIcon(addDataIconDis);
        JButton addButtonOut = RegistrationServiceSubPanel.createButton(" Add output data ", "Add new primary output data to the service definition", 79, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationServiceSubPanel.this.rbOutputs.setSelected(true);
                RegistrationServiceSubPanel.this.primOutTable.addEmptyData();
            }
        });
        addButtonOut.setIcon(addDataIcon);
        addButtonOut.setDisabledIcon(addDataIconDis);
        this.rbInputs = new JRadioButton();
        this.rbInputs.setSelected(true);
        this.rbOutputs = new JRadioButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbInputs);
        group.add(this.rbOutputs);
        DataTypesBoard dataTypesBoard = new DataTypesBoard(this.registryModel, this.console, this.propertyChannel, new CustomDataTypesSimplestTree(this.registryModel, this.console));
        dataTypesBoard.updateTree(0);
        NamespacesBoard namespacesBoard = new NamespacesBoard(this.registryModel, this.console, this.propertyChannel, new CustomNamespacesSimplestTree(this.registryModel, this.console));
        namespacesBoard.updateTree(0);
        JSplitPane split = this.hSplit(dataTypesBoard, namespacesBoard, 0.5);
        SwingUtils.addComponent((JComponent)p, (Component)this.rbInputs, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)addButtonIn, (int)1, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.primInTable.scrollable(), (int)0, (int)1, (int)2, (int)1, (int)1, (int)18, (double)1.0, (double)0.3, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)p, (Component)this.rbOutputs, (int)0, (int)2, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)p, (Component)addButtonOut, (int)1, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)p, (Component)this.primOutTable.scrollable(), (int)0, (int)3, (int)2, (int)1, (int)1, (int)18, (double)1.0, (double)0.3, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)p, (Component)split, (int)0, (int)4, (int)2, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (Insets)BREATH_TOP);
        return p;
    }

    protected JPanel getSecondaryInputs() {
        JPanel p = RegistrationServiceSubPanel.createTitledPanel("");
        this.secTable = new SecondaryDataTable();
        JButton addButtonSec = RegistrationServiceSubPanel.createButton(" Add input data ", "Add new secondary input data/parameters to the service definition", 73, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationServiceSubPanel.this.secTable.addEmptyData();
            }
        });
        addButtonSec.setIcon(addDataIcon);
        addButtonSec.setDisabledIcon(addDataIconDis);
        SwingUtils.addComponent((JComponent)p, (Component)addButtonSec, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.secTable.scrollable(), (int)0, (int)1, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (Insets)BREATH_TOP);
        return p;
    }

    @Override
    public void checkAndRegister(boolean realRegistration) throws MobyException {
        String value = this.sName.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Service name is still missing.\nPlease fill it first.");
        }
        MobyService service = new MobyService(value);
        value = this.sAuth.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Every service must have an authority.\nPlease fill it.");
        }
        service.setAuthority(value);
        value = this.sEmail.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Every service must have a contact person.\nPlease fill in an email address.");
        }
        service.setEmailContact(value);
        value = (String)this.sCategories.getSelectedItem();
        service.setCategory(value);
        value = this.sDescArea.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Every service must have a description.\nPlease fill in the most detailed one.");
        }
        service.setDescription(value);
        value = this.sURL.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Every service must have an endpoint (URL).\nPlease fill in a service URL.");
        }
        service.setURL(value);
        value = this.sType.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Every service must belong to an existing service type.\nPlease select a type from available service types.");
        }
        service.setType(value);
        service.setAuthoritative(this.useAuth.isSelected());
        MobyPrimaryData[] primInputs = this.primInTable.getData();
        for (int i = 0; i < primInputs.length; ++i) {
            this.checkPrimaryData(primInputs[i]);
            service.addInput((MobyData)primInputs[i]);
        }
        MobySecondaryData[] params = this.secTable.getData();
        for (int i = 0; i < params.length; ++i) {
            this.checkSecondaryData(params[i]);
            service.addInput((MobyData)params[i]);
        }
        MobyPrimaryData[] primOutputs = this.primOutTable.getData();
        for (int i = 0; i < primOutputs.length; ++i) {
            this.checkPrimaryData(primOutputs[i]);
            service.addOutput((MobyData)primOutputs[i]);
        }
        if (this.useSignature.isSelected() && UUtils.notEmpty((String)(value = this.sSigURL.getText()))) {
            if (!RegistrationServiceSubPanel.confirm("You specified an RDF endpoint of your service.\nThis means that you will not be able\nto unregister your service yourself,\nyou will need to wait for a Biomoby 'agent'\nto come and fail to find your RDF document.\n \nWhile this is a legitimate and in long-run term\nthe only correct way, you may not wish to do so\nif you are only testing your service and expecting\nstill to change service attributes.\n \nAre you sure you wish to register the service\nwith the RDF signature?\n \n")) {
                return;
            }
            service.setSignatureURL(value);
            value = this.localRDFFile.getTextField().getText();
            if (UUtils.isEmpty((String)value)) {
                try {
                    value = File.createTempFile(service.getName() + "-", ".rdf").getAbsolutePath();
                }
                catch (IOException e2) {
                    throw new MobyException("Problem with creating temporary file: " + e2.toString());
                }
            }
            service.setPathToRDF(value);
        }
        if (realRegistration) {
            this.console.setText("Service to be registered:\n-------------------------\n" + service.toString());
            this.registryModel.registerService(service);
            this.console.setText("\nRegistration successful!\n\n");
            this.updateCache();
        } else {
            String xml = this.registryModel.getRegisterServiceXML(service);
            this.console.setText("\n" + xml + "\n");
        }
    }

    private void checkData(MobyData data) throws MobyException {
        String name = data.getName();
        if (UUtils.isEmpty((String)name)) {
            throw new MobyException("All service data must be named.\nPlease add an article name.");
        }
    }

    private void checkPrimaryData(MobyPrimaryData data) throws MobyException {
        this.checkData((MobyData)data);
        MobyDataType dataType = data.getDataType();
        if (dataType == null || UUtils.isEmpty((String)dataType.getName())) {
            throw new MobyException("Data type is missing by datum " + data.getName() + "\nPlease select a data type.");
        }
    }

    private void checkSecondaryData(MobySecondaryData data) throws MobyException {
        this.checkData((MobyData)data);
        if (UUtils.isEmpty((String)data.getDataType())) {
            throw new MobyException("Data type is missing by datum " + data.getName() + "\nPlease select a data type.");
        }
    }

    public void checkAndCallAgent() throws MobyException {
        String value;
        if (this.useSignature.isSelected()) {
            value = this.sSigURL.getText();
            if (UUtils.isEmpty((String)value)) {
                throw new MobyException("RDF endpoint (signature URL) is still empty.\nPlease fill it first.");
            }
        } else {
            throw new MobyException("In order to call an RDF agent, a Signature URL is needed.\nPlease enable 'Service RDF Signature' and fill the 'RDF endpoint'.");
        }
        MobyService service = new MobyService("");
        service.setSignatureURL(value);
        this.registryModel.registerService(service);
        this.console.setText("\nRDF Agent call was successful!\n\n");
        this.updateCache();
    }

    protected void onUnregisterService() {
        String name = this.sName.getText();
        if (UUtils.isEmpty((String)name)) {
            AbstractPanel.error("Specify name and authority of a service\nthat you wish to be unregistered.");
            return;
        }
        final MobyService service = new MobyService(name);
        String auth = this.sAuth.getText();
        if (UUtils.isEmpty((String)auth)) {
            AbstractPanel.error("For unregistering you also need\nto fill in a service authority.\n");
            return;
        }
        service.setAuthority(auth);
        if (!RegistrationServiceSubPanel.confirm("Are you sure you wish to unregister\nservice: " + name + " ?")) {
            return;
        }
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;
            boolean oldAppendMode;

            @Override
            public Object construct() {
                try {
                    RegistrationServiceSubPanel.this.unregisButton.setEnabled(false);
                    this.oldAppendMode = RegistrationServiceSubPanel.this.console.setAppendMode(true);
                    RegistrationServiceSubPanel.this.console.setText("Service to be unregistered: " + service.getName() + "\n");
                    RegistrationServiceSubPanel.this.registryModel.unRegisterService(service);
                    RegistrationServiceSubPanel.this.console.setText("\nUnregistration successful!\n\n");
                    RegistrationServiceSubPanel.this.updateCache();
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error("An error occured when trying to unregister a service.\n\n", (Exception)((Object)this.exception));
                }
                RegistrationServiceSubPanel.this.console.setAppendMode(this.oldAppendMode);
                RegistrationServiceSubPanel.this.unregisButton.setEnabled(true);
            }
        };
        worker.start();
    }

    protected void onCallAgent() {
        this.agentButton.setEnabled(false);
        SwingWorker worker = new SwingWorker(){
            boolean oldAppendMode;
            RegistrationPanel.StatusBag bag;
            MobyException exception = null;

            @Override
            public Object construct() {
                try {
                    RegistrationServiceSubPanel.this.checkAndCallAgent();
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error("An error occured when trying to call an RDF agent.\n\n", (Exception)((Object)this.exception));
                }
                RegistrationServiceSubPanel.this.agentButton.setEnabled(true);
                RegistrationServiceSubPanel.this.maybeDisableVerbose(this.bag);
                RegistrationServiceSubPanel.this.console.setAppendMode(this.oldAppendMode);
            }
        };
        worker.start();
    }

    @Override
    protected void updateCache() throws MobyException {
        this.registryModel.updateServicesCache();
    }

    protected class CustomNamespacesSimplestTree
    extends NamespacesTree {
        public CustomNamespacesSimplestTree(RegistryModel model, CommonConsole console) {
            super(model, console);
        }

        @Override
        protected void createPopups(String title) {
            super.createPopups(title);
            this.removeFromPopups("ac-reload");
            this.removeSeparatorAfter("ac-collapse");
        }

        @Override
        protected void setEnabledPopup(boolean enabled) {
            super.setEnabledPopup(enabled);
            this.selected(null);
        }

        @Override
        protected void selected(DefaultMutableTreeNode node) {
            if (node == null) {
                return;
            }
            CommonNode nodeObject = (CommonNode)node.getUserObject();
            if (nodeObject.getType() == 12) {
                PrimaryDataTable table = RegistrationServiceSubPanel.this.rbInputs.isSelected() ? RegistrationServiceSubPanel.this.primInTable : RegistrationServiceSubPanel.this.primOutTable;
                int[] rows = table.getSelectedRows();
                for (int i = 0; i < rows.length; ++i) {
                    String value = nodeObject.getValue();
                    MobyPrimaryData data = (MobyPrimaryData)table.getValueAt(rows[i], 4);
                    data.addNamespace(new MobyNamespace(value));
                    table.setValueAt(data, rows[i], 4);
                }
            }
        }
    }

    protected class CustomDataTypesSimplestTree
    extends DataTypesTree {
        public CustomDataTypesSimplestTree(RegistryModel model, CommonConsole console) {
            super(model, console);
        }

        @Override
        protected void createPopups(String title) {
            super.createPopups(title);
            this.removeFromPopups("ac-reload");
            this.removeFromPopups("ac-hasa");
            this.removeFromPopups("ac-depr");
            this.removeSeparatorAfter("ac-asort");
            this.removeSeparatorAfter("ac-collapse");
        }

        @Override
        protected void setEnabledPopup(boolean enabled) {
            super.setEnabledPopup(enabled);
            this.selected(null);
        }

        @Override
        protected void selected(DefaultMutableTreeNode node) {
            if (node == null) {
                return;
            }
            CommonNode nodeObject = (CommonNode)node.getUserObject();
            if (nodeObject.getType() == 11) {
                PrimaryDataTable table = RegistrationServiceSubPanel.this.rbInputs.isSelected() ? RegistrationServiceSubPanel.this.primInTable : RegistrationServiceSubPanel.this.primOutTable;
                int[] rows = table.getSelectedRows();
                for (int i = 0; i < rows.length; ++i) {
                    String value = nodeObject.getValue();
                    table.setValueAt(value, rows[i], 2);
                    Object article = table.getValueAt(rows[i], 1);
                    if (article != null && !UUtils.isEmpty((String)article.toString())) continue;
                    table.setValueAt(value, rows[i], 1);
                }
            }
        }
    }

    protected class CustomServiceTypesTree2
    extends ServiceTypesTree {
        public CustomServiceTypesTree2(RegistryModel model, CommonConsole console) {
            super(model, console);
        }

        @Override
        protected void createPopups(String title) {
            super.createPopups(title);
            this.removeFromPopups("ac-reload");
            this.removeSeparatorAfter("ac-collapse");
        }

        @Override
        protected void setEnabledPopup(boolean enabled) {
            super.setEnabledPopup(enabled);
            this.selected(null);
        }

        @Override
        protected void selected(DefaultMutableTreeNode node) {
            if (node == null) {
                return;
            }
            CommonNode nodeObject = (CommonNode)node.getUserObject();
            if (nodeObject.getType() == 13) {
                String value = nodeObject.getValue();
                RegistrationServiceSubPanel.this.sType.setText(value);
                RegistrationServiceSubPanel.this.setPrefValue(RegistrationServiceSubPanel.REG_S_TYPE, value);
                this.propertyChannel.put("dp-reg-s-type", value);
            }
        }
    }
}

