/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistrationDataTypeSubPanel;
import org.biomoby.service.dashboard.RegistrationNamespaceSubPanel;
import org.biomoby.service.dashboard.RegistrationServiceSubPanel;
import org.biomoby.service.dashboard.RegistrationServiceTypeSubPanel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.shared.MobyException;
import org.tulsoft.tools.gui.SwingUtils;

public class RegistrationPanel
extends AbstractPanel {
    private static Log log = LogFactory.getLog(RegistrationPanel.class);
    protected RegistryModel registryModel;
    protected CommonConsole console;
    protected JButton registerButton;
    protected JButton showXMLButton;
    protected JButton fromXMLButton;
    protected JCheckBox copyBySelect;
    protected static Icon menuAddISAIcon;
    protected static Icon menuAddISAIconDis;
    protected static Icon menuAddHASAIcon;
    protected static Icon menuAddHASAIconDis;
    protected static Icon menuAddHASIcon;
    protected static Icon menuAddHASIconDis;
    protected static Icon unregisterIcon;
    protected static Icon unregisterIconDis;
    protected static Icon agentIcon;
    protected static Icon agentIconDis;
    protected static Icon registerIcon;
    protected static Icon registerIconDis;
    protected static Icon register2Icon;
    protected static Icon showXMLIcon;
    protected static Icon showXMLIconDis;
    protected static Icon fromXMLIcon;
    protected static Icon fromXMLIconDis;
    protected static Icon addDataIcon;
    protected static Icon addDataIconDis;
    protected static Icon editDataIcon;
    protected static Icon editDataIconDis;
    protected static Icon deleteDataIcon;
    protected static Icon trashIcon;

    public RegistrationPanel() {
        this.panelIconFileName = "images/registration.gif";
    }

    @Override
    protected void loadIcons() {
        super.loadIcons();
        if (menuAddISAIcon == null) {
            menuAddISAIcon = RegistrationPanel.loadIcon("images/smallAddISA.gif");
        }
        if (menuAddISAIconDis == null) {
            menuAddISAIconDis = RegistrationPanel.loadIcon("images/smallAddISA_dis.gif");
        }
        if (menuAddHASAIcon == null) {
            menuAddHASAIcon = RegistrationPanel.loadIcon("images/smallAddHASA.gif");
        }
        if (menuAddHASAIconDis == null) {
            menuAddHASAIconDis = RegistrationPanel.loadIcon("images/smallAddHASA_dis.gif");
        }
        if (menuAddHASIcon == null) {
            menuAddHASIcon = RegistrationPanel.loadIcon("images/smallAddHAS.gif");
        }
        if (menuAddHASIconDis == null) {
            menuAddHASIconDis = RegistrationPanel.loadIcon("images/smallAddHAS_dis.gif");
        }
        if (unregisterIcon == null) {
            unregisterIcon = RegistrationPanel.loadIcon("images/smallTrash.gif");
        }
        if (unregisterIconDis == null) {
            unregisterIconDis = RegistrationPanel.loadIcon("images/smallTrash_dis.gif");
        }
        if (agentIcon == null) {
            agentIcon = RegistrationPanel.loadIcon("images/smallAgent.gif");
        }
        if (agentIconDis == null) {
            agentIconDis = RegistrationPanel.loadIcon("images/smallAgent_dis.gif");
        }
        if (registerIcon == null) {
            registerIcon = RegistrationPanel.loadIcon("images/smallRegister.gif");
        }
        if (registerIconDis == null) {
            registerIconDis = RegistrationPanel.loadIcon("images/smallRegister_dis.gif");
        }
        if (register2Icon == null) {
            register2Icon = RegistrationPanel.loadIcon("images/register2.gif");
        }
        if (showXMLIcon == null) {
            showXMLIcon = RegistrationPanel.loadIcon("images/smallToDoc.gif");
        }
        if (showXMLIconDis == null) {
            showXMLIconDis = RegistrationPanel.loadIcon("images/smallToDoc_dis.gif");
        }
        if (fromXMLIcon == null) {
            fromXMLIcon = RegistrationPanel.loadIcon("images/smallFromDoc.gif");
        }
        if (fromXMLIconDis == null) {
            fromXMLIconDis = RegistrationPanel.loadIcon("images/smallFromDoc_dis.gif");
        }
        if (addDataIcon == null) {
            addDataIcon = RegistrationPanel.loadIcon("images/smallAddData.gif");
        }
        if (addDataIconDis == null) {
            addDataIconDis = RegistrationPanel.loadIcon("images/smallAddData_dis.gif");
        }
        if (editDataIcon == null) {
            editDataIcon = RegistrationPanel.loadIcon("images/smallEdit.gif");
        }
        if (editDataIconDis == null) {
            editDataIconDis = RegistrationPanel.loadIcon("images/smallEdit_dis.gif");
        }
        if (deleteDataIcon == null) {
            deleteDataIcon = RegistrationPanel.loadIcon("images/smallRemove.gif");
        }
        if (trashIcon == null) {
            trashIcon = RegistrationPanel.loadIcon("images/smallTrash.gif");
        }
    }

    @Override
    public JComponent getComponent(PropertyChannel propertyChannel) {
        this.setPropertyChannel(propertyChannel);
        this.registryModel = this.createRegistryModel();
        if (this.pComponent != null) {
            return this.pComponent;
        }
        this.console = new CommonConsole();
        this.console.setAppendMode(true);
        this.console.setPropertyChannel(propertyChannel);
        this.pComponent = new JPanel(new GridBagLayout(), true);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Data Type Registration", register2Icon, new RegistrationDataTypeSubPanel().getComponent(propertyChannel, this.console));
        tabbedPane.addTab("Service Registration", register2Icon, new RegistrationServiceSubPanel().getComponent(propertyChannel, this.console));
        tabbedPane.addTab("Namespace Registration", register2Icon, new RegistrationNamespaceSubPanel().getComponent(propertyChannel, this.console));
        tabbedPane.addTab("Service Type Registration", register2Icon, new RegistrationServiceTypeSubPanel().getComponent(propertyChannel, this.console));
        JSplitPane split = this.vSplit(tabbedPane, this.console, 0.6);
        SwingUtils.addComponent((JComponent)this.pComponent, (Component)split, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        return this.pComponent;
    }

    @Override
    public String getName() {
        return "Registration";
    }

    @Override
    public String getDescription() {
        return "A panel allowing to register and unregister any Biomoby entity.";
    }

    @Override
    public boolean loadOnlyOnDemand() {
        return true;
    }

    protected JFileChooser createXMLChooser(String preferenceKey) {
        JFileChooser chooser = new JFileChooser();
        File file = new File(this.getPrefValue(preferenceKey, System.getProperty("user.dir")));
        chooser.setSelectedFile(file);
        chooser.setDialogTitle("Registration from raw XML");
        chooser.setApproveButtonText("Select XML file");
        chooser.addChoosableFileFilter(RegistrationPanel.getXMLFilter());
        return chooser;
    }

    protected JButton createFromXMLButton(String toolTip, String methodName, int mnemonic, String preferenceKey, JFileChooser chooser) {
        final String myMethodName = methodName;
        final String myPreferenceKey = preferenceKey;
        final JFileChooser myChooser = chooser;
        JButton button = RegistrationPanel.createButton(" Register from XML ", toolTip, mnemonic, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (myChooser.showDialog(null, null) == 0) {
                    File selFile = myChooser.getSelectedFile();
                    RegistrationPanel.this.setPrefValue(myPreferenceKey, selFile.getParent());
                    RegistrationPanel.this.onRegisterFromXML(selFile, myMethodName);
                }
            }
        });
        button.setIcon(fromXMLIcon);
        button.setDisabledIcon(fromXMLIconDis);
        return button;
    }

    protected JButton createRegisterButton(String label, String toolTip, int mnemonic) {
        JButton button = RegistrationPanel.createButton(label, toolTip, mnemonic, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationPanel.this.onRegister(true);
            }
        });
        button.setIcon(registerIcon);
        button.setDisabledIcon(registerIconDis);
        return button;
    }

    protected JButton createShowXMLButton(String toolTip, int mnemonic) {
        JButton button = RegistrationPanel.createButton(" Show raw XML ", toolTip, mnemonic, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationPanel.this.onRegister(false);
            }
        });
        button.setIcon(showXMLIcon);
        button.setDisabledIcon(showXMLIconDis);
        return button;
    }

    protected void onRegister(final boolean realRegistration) {
        if (realRegistration) {
            this.registerButton.setEnabled(false);
        } else {
            this.fromXMLButton.setEnabled(false);
        }
        SwingWorker worker = new SwingWorker(){
            boolean oldAppendMode;
            StatusBag bag;
            MobyException exception = null;

            @Override
            public Object construct() {
                try {
                    RegistrationPanel.this.checkAndRegister(realRegistration);
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error("An error occured when trying to register a new entity.\n\n", (Exception)((Object)this.exception));
                }
                RegistrationPanel.this.registerButton.setEnabled(true);
                RegistrationPanel.this.fromXMLButton.setEnabled(true);
                RegistrationPanel.this.maybeDisableVerbose(this.bag);
                RegistrationPanel.this.console.setAppendMode(this.oldAppendMode);
            }
        };
        worker.start();
    }

    public void checkAndRegister(boolean realRegistration) throws MobyException {
    }

    protected void updateCache() throws MobyException {
    }

    protected void onRegisterFromXML(File fromFile, String methodName) {
        final File xmlFile = fromFile;
        final String myMethodName = methodName;
        this.registerButton.setEnabled(false);
        this.fromXMLButton.setEnabled(false);
        SwingWorker worker = new SwingWorker(){
            boolean oldAppendMode;
            StatusBag bag;
            MobyException exception = null;

            @Override
            public Object construct() {
                try {
                    this.bag = RegistrationPanel.this.maybeEnableVerbose();
                    this.oldAppendMode = RegistrationPanel.this.console.setAppendMode(true);
                    RegistrationPanel.this.console.setText("Registering entity from raw XML:\n--------------------------------\n");
                    RegistrationPanel.this.console.setText(RegistrationPanel.this.registryModel.callRegistry(myMethodName, xmlFile));
                    RegistrationPanel.this.console.setText("\n");
                    RegistrationPanel.this.updateCache();
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error("An error occured when trying to register using file:\n" + xmlFile.getAbsolutePath() + "\n\n", (Exception)((Object)this.exception));
                }
                RegistrationPanel.this.registerButton.setEnabled(true);
                RegistrationPanel.this.fromXMLButton.setEnabled(true);
                RegistrationPanel.this.maybeDisableVerbose(this.bag);
                RegistrationPanel.this.console.setAppendMode(this.oldAppendMode);
            }
        };
        worker.start();
    }

    protected StatusBag maybeEnableVerbose() {
        if (this.console == null || !this.console.isVerboseMode()) {
            return null;
        }
        this.console.setVerboseEventName("dp-reg-verbose");
        StatusBag bag = new StatusBag();
        bag.err = System.err;
        PipedInputStream pipeIn = null;
        try {
            PipedOutputStream pipeOut = new PipedOutputStream();
            pipeIn = new PipedInputStream(pipeOut);
            System.err.flush();
            System.setErr(new PrintStream(pipeOut));
        }
        catch (IOException e) {
            log.error((Object)("Cannot create pipe for verbose messages: " + e.toString()));
            return null;
        }
        bag.verbose = this.registryModel.setVerbose(true);
        FireVerboseThread firingThread = new FireVerboseThread(pipeIn, "dp-reg-verbose", bag);
        bag.firingThread = firingThread;
        firingThread.start();
        return bag;
    }

    protected void maybeDisableVerbose(StatusBag bag) {
        if (bag == null) {
            return;
        }
        Thread thread = bag.firingThread;
        bag.firingThread = null;
        thread.interrupt();
        this.registryModel.setVerbose(bag.verbose);
        System.err.flush();
        System.setErr(bag.err);
    }

    protected class StatusBag {
        public PrintStream err;
        public boolean verbose;
        public Thread firingThread;

        protected StatusBag() {
        }
    }

    class FireVerboseThread
    extends Thread {
        private BufferedReader reader;
        private String verboseEventName;
        private StatusBag bag;

        public FireVerboseThread(InputStream in, String verboseEventName, StatusBag bag) {
            this.reader = new BufferedReader(new InputStreamReader(in));
            this.verboseEventName = verboseEventName;
            this.bag = bag;
        }

        @Override
        public void run() {
            String input = null;
            try {
                Thread thisThread = Thread.currentThread();
                while ((input = this.reader.readLine()) != null) {
                    RegistrationPanel.this.propertyChannel.fire(this.verboseEventName, input + "\n");
                    if (thisThread == this.bag.firingThread) continue;
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

