/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.CommonNode;
import org.biomoby.service.dashboard.CommonTree;
import org.biomoby.service.dashboard.NamespacesBoard;
import org.biomoby.service.dashboard.NamespacesTree;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistrationPanel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyNamespace;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.gui.JTextFieldWithHistory;
import org.tulsoft.tools.gui.SwingUtils;

public class RegistrationNamespaceSubPanel
extends RegistrationPanel {
    static final String COPY_BY_SELECT_NS = "ns-copy-by-select";
    static final String REG_NS_FROM_XML = "reg-ns-from-xml-file";
    JTextFieldWithHistory nsName;
    JTextFieldWithHistory nsAuth;
    JTextFieldWithHistory nsEmail;
    JTextArea nsDescArea;
    JButton unregisButton;
    CustomNamespacesTree namespacesTree;

    public JComponent getComponent(PropertyChannel propertyChannel, CommonConsole console) {
        this.setPropertyChannel(propertyChannel);
        this.registryModel = this.createRegistryModel();
        this.console = console;
        JPanel p = new JPanel(new GridBagLayout());
        JLabel labelNSName = new JLabel("Namespace");
        this.nsName = this.createText(null, "namespaceName", "dp-reg-ns-name");
        JLabel labelNSAuth = new JLabel("Authority (usually a domain name)");
        this.nsAuth = this.createText(null, "namespaceAuth", "dp-reg-ns-auth");
        JLabel labelNSEmail = new JLabel("Contact email");
        this.nsEmail = this.createText(null, "namespaceEmail", "dp-reg-ns-email");
        this.nsDescArea = new JTextArea();
        JPanel nsDesc = this.createCustomTextArea("Description", null, "namespaceDesc", "dp-reg-ns-desc", this.nsDescArea);
        JPanel defs = RegistrationNamespaceSubPanel.createTitledPanel("New Namespace");
        SwingUtils.addComponent((JComponent)defs, (Component)labelNSName, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)this.nsName, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)labelNSAuth, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)defs, (Component)this.nsAuth, (int)0, (int)3, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)labelNSEmail, (int)0, (int)4, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)defs, (Component)this.nsEmail, (int)0, (int)5, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)nsDesc, (int)0, (int)6, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (Insets)BREATH_TOP);
        this.namespacesTree = new CustomNamespacesTree(this.registryModel, console);
        NamespacesBoard namespacesBoard = new NamespacesBoard(this.registryModel, console, propertyChannel, this.namespacesTree);
        namespacesBoard.updateTree(0);
        boolean usingCopyBySelect = this.getPrefValue(COPY_BY_SELECT_NS, false);
        this.copyBySelect = RegistrationNamespaceSubPanel.createCheckBox("Fill new Namespace when selected", usingCopyBySelect, 67, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RegistrationNamespaceSubPanel.this.onCopyBySelectNS(e.getStateChange() == 1);
            }
        });
        JPanel board = new JPanel(new GridBagLayout());
        SwingUtils.addComponent((JComponent)board, (Component)namespacesBoard, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        SwingUtils.addComponent((JComponent)board, (Component)this.copyBySelect, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        JSplitPane split = this.hSplit(defs, board, 0.5);
        this.registerButton = this.createRegisterButton(" Register Namespace ", "Register a new namespace in a Biomoby registry", 78);
        this.showXMLButton = this.createShowXMLButton("Create and show XML for registering this namespace", 88);
        this.fromXMLButton = this.createFromXMLButton("Register this namespace from a raw XML in a file", "registerNamespace", 70, REG_NS_FROM_XML, this.createXMLChooser(REG_NS_FROM_XML));
        this.unregisButton = RegistrationNamespaceSubPanel.createButton(" Unregister Namespace ", "Remove an existing namespace from a Biomoby registry", 85, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationNamespaceSubPanel.this.namespacesTree.onUnregisterNamespace();
            }
        });
        this.unregisButton.setIcon(unregisterIcon);
        this.unregisButton.setDisabledIcon(unregisterIconDis);
        this.unregisButton.setEnabled(false);
        SwingUtils.addComponent((JComponent)p, (Component)split, (int)0, (int)0, (int)4, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.registerButton, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.showXMLButton, (int)1, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.fromXMLButton, (int)2, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.unregisButton, (int)3, (int)1, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0);
        return p;
    }

    protected void onCopyBySelectNS(boolean enabled) {
        this.setPrefValue(COPY_BY_SELECT_NS, enabled);
    }

    @Override
    public void checkAndRegister(boolean realRegistration) throws MobyException {
        String value = this.nsName.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Namespace name is still missing. Please fill it first.");
        }
        MobyNamespace namespace = new MobyNamespace(value);
        value = this.nsAuth.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Every namespace must have an authority.\nFill it, or (if such authority already exists)\nselect it from the namespace tree sorted by authority.");
        }
        namespace.setAuthority(value);
        value = this.nsEmail.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Every namespace must have a contact person.\nPlease fill in an email address.");
        }
        namespace.setEmailContact(value);
        value = this.nsDescArea.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Every namespace must have a description.\nPlease fill in the most detailed one.");
        }
        namespace.setDescription(value);
        if (realRegistration) {
            this.console.setText("Namespace to be registered:\n---------------------------\n" + namespace.toString());
            this.registryModel.registerNamespace(namespace);
            this.console.setText("\nRegistration successful!\n\n");
            this.updateCache();
        } else {
            String xml = this.registryModel.getRegisterNamespaceXML(namespace);
            this.console.setText("\n" + xml + "\n");
        }
    }

    @Override
    protected void updateCache() throws MobyException {
        this.registryModel.updateNamespacesCache();
    }

    protected class CustomNamespacesTree
    extends NamespacesTree {
        protected static final String AC_UNREG = "ac-unreg";

        public CustomNamespacesTree(RegistryModel model, CommonConsole console) {
            super(model, console);
        }

        @Override
        protected void createPopups(String title) {
            super.createPopups(title);
            this.removeFromPopups("ac-reload");
            this.removeSeparatorAfter("ac-collapse");
            this.popup.addSeparator();
            this.popup.add(CustomNamespacesTree.createMenuItem(new AbstractAction("Unregister"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomNamespacesTree.this.onUnregisterNamespace();
                }
            }, AC_UNREG, RegistrationPanel.unregisterIcon, RegistrationPanel.unregisterIconDis));
        }

        @Override
        protected void setEnabledPopup(boolean enabled) {
            super.setEnabledPopup(enabled);
            this.selected(null);
        }

        @Override
        protected void selected(DefaultMutableTreeNode node) {
            if (node == null) {
                this.setEnabledPopupItem(AC_UNREG, false);
                return;
            }
            final CommonNode nodeObject = (CommonNode)node.getUserObject();
            final boolean isNamespace = nodeObject.getType() == 12;
            final boolean isAuthority = nodeObject.getType() == 15;
            this.setEnabledPopupItem(AC_UNREG, isNamespace);
            SwingWorker worker = new SwingWorker(){
                MobyNamespace namespace = null;

                @Override
                public Object construct() {
                    try {
                        if (isNamespace) {
                            this.namespace = CustomNamespacesTree.this.registryModel.getNamespace(nodeObject.getValue());
                        }
                        RegistrationNamespaceSubPanel.this.unregisButton.setEnabled(isNamespace);
                    }
                    catch (MobyException e) {
                        CommonTree.error("An error happened when accessing a list of available namespaces.\n\nCheck please values in text fields (in Registry Browser)\nspecifying registry endpoint and namespace, and in the\none specifying directory used as a local cache. Then\nright-click in the data types area and select 'Reload'.\n\n", (Exception)((Object)e));
                    }
                    return this.namespace;
                }

                @Override
                public void finished() {
                    if (this.namespace != null) {
                        CustomNamespacesTree.this.console.setText(this.namespace.toString() + "\n");
                        if (RegistrationNamespaceSubPanel.this.copyBySelect.isSelected()) {
                            RegistrationNamespaceSubPanel.this.nsName.setText(this.namespace.getName());
                            RegistrationNamespaceSubPanel.this.nsAuth.setText(this.namespace.getAuthority());
                            RegistrationNamespaceSubPanel.this.nsEmail.setText(this.namespace.getEmailContact());
                            RegistrationNamespaceSubPanel.this.nsDescArea.setText(this.namespace.getDescription());
                        }
                    } else if (isAuthority && RegistrationNamespaceSubPanel.this.copyBySelect.isSelected()) {
                        RegistrationNamespaceSubPanel.this.nsAuth.setText(nodeObject.getValue());
                    }
                }
            };
            worker.start();
        }

        protected void onUnregisterNamespace() {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            CommonNode nodeObject = (CommonNode)node.getUserObject();
            final String name = nodeObject.getValue();
            if (!AbstractPanel.confirm("Are you sure you wish to unregister\nnamespace: " + name + " ?")) {
                return;
            }
            SwingWorker worker = new SwingWorker(){
                MobyException exception = null;

                @Override
                public Object construct() {
                    try {
                        RegistrationNamespaceSubPanel.this.unregisButton.setEnabled(false);
                        MobyNamespace namespace = new MobyNamespace(name);
                        CustomNamespacesTree.this.console.setText("Namespace to be unregistered: " + name + "\n");
                        CustomNamespacesTree.this.registryModel.unRegisterNamespace(namespace);
                        CustomNamespacesTree.this.console.setText("\nUnregistration successful!\n\n");
                        RegistrationNamespaceSubPanel.this.updateCache();
                    }
                    catch (MobyException e) {
                        this.exception = e;
                    }
                    return null;
                }

                @Override
                public void finished() {
                    if (this.exception != null) {
                        CommonTree.error("An error occured when trying to unregister a namespace.\n\n", (Exception)((Object)this.exception));
                    }
                }
            };
            worker.start();
        }
    }
}

