/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.BuildDataTypeTree;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.CommonNode;
import org.biomoby.service.dashboard.CommonTree;
import org.biomoby.service.dashboard.DataTypesBoard;
import org.biomoby.service.dashboard.DataTypesTree;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistrationPanel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.service.generator.DataTypesGenerator;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyRelationship;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.gui.JTextFieldWithHistory;
import org.tulsoft.tools.gui.SwingUtils;

public class RegistrationDataTypeSubPanel
extends RegistrationPanel {
    static final String COPY_BY_SELECT_DT = "dt-copy-by-select";
    static final String REG_DT_FROM_XML = "reg-dt-from-xml-file";
    BuildDataTypeTree buildTree;
    JTextFieldWithHistory dtName;
    JTextFieldWithHistory dtAuth;
    JTextFieldWithHistory dtEmail;
    JTextArea dtDescArea;
    MobyException dtUnregException;
    CustomDataTypesTree datatypeTree;
    JButton unregisButton;
    static final String DATA_TYPE_UNREG_PROLOGUE = "An error occured when trying to unregister a data type.\n\n";

    public JComponent getComponent(PropertyChannel propertyChannel, CommonConsole console) {
        this.setPropertyChannel(propertyChannel);
        this.registryModel = this.createRegistryModel();
        this.console = console;
        JPanel p = new JPanel(new GridBagLayout());
        JLabel labelDTName = new JLabel("Data type name");
        this.dtName = this.createText(null, "dataTypeName", "dp-reg-dt-name");
        JLabel labelDTAuth = new JLabel("Authority (usually a domain name)");
        this.dtAuth = this.createText(null, "dataTypeAuth", "dp-reg-dt-auth");
        JLabel labelDTEmail = new JLabel("Contact email");
        this.dtEmail = this.createText(null, "dataTypeEmail", "dp-reg-dt-email");
        this.dtDescArea = new JTextArea();
        JPanel dtDesc = this.createCustomTextArea("Description", null, "dataTypeDesc", "dp-reg-dt-desc", this.dtDescArea);
        JPanel defs = RegistrationDataTypeSubPanel.createTitledPanel("New Data Type");
        SwingUtils.addComponent((JComponent)defs, (Component)labelDTName, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)this.dtName, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)labelDTAuth, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)defs, (Component)this.dtAuth, (int)0, (int)3, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)labelDTEmail, (int)0, (int)4, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)defs, (Component)this.dtEmail, (int)0, (int)5, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)defs, (Component)dtDesc, (int)0, (int)6, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (Insets)BREATH_TOP);
        this.datatypeTree = new CustomDataTypesTree(this.registryModel, console);
        DataTypesBoard dataTypesBoard = new DataTypesBoard(this.registryModel, console, propertyChannel, this.datatypeTree);
        dataTypesBoard.updateTree(0);
        boolean usingCopyBySelect = this.getPrefValue(COPY_BY_SELECT_DT, false);
        this.copyBySelect = RegistrationDataTypeSubPanel.createCheckBox("Fill new Data Type when selected", usingCopyBySelect, 67, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RegistrationDataTypeSubPanel.this.onCopyBySelectDT(e.getStateChange() == 1);
            }
        });
        JPanel board = new JPanel(new GridBagLayout());
        SwingUtils.addComponent((JComponent)board, (Component)dataTypesBoard, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        SwingUtils.addComponent((JComponent)board, (Component)this.copyBySelect, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        this.buildTree = new BuildDataTypeTree(propertyChannel);
        this.registerButton = this.createRegisterButton(" Register Data Type ", "Register a new data in a Biomoby registry", 68);
        this.showXMLButton = this.createShowXMLButton("Create and show XML for registering this data type", 88);
        this.fromXMLButton = this.createFromXMLButton("Register this data type from a raw XML in a file", "registerObjectClass", 70, REG_DT_FROM_XML, this.createXMLChooser(REG_DT_FROM_XML));
        this.unregisButton = RegistrationDataTypeSubPanel.createButton(" Unregister Data Type ", "Remove an existing datatype from a Biomoby registry", 85, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationDataTypeSubPanel.this.datatypeTree.onUnregisterDataType();
            }
        });
        this.unregisButton.setIcon(unregisterIcon);
        this.unregisButton.setDisabledIcon(unregisterIconDis);
        this.unregisButton.setEnabled(false);
        JSplitPane split = this.hSplit(this.hSplit(this.buildTree.scrollable(), defs, 0.5), board, 0.6);
        SwingUtils.addComponent((JComponent)p, (Component)split, (int)0, (int)0, (int)4, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.registerButton, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.showXMLButton, (int)1, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.fromXMLButton, (int)2, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.unregisButton, (int)3, (int)1, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0);
        return p;
    }

    protected void onCopyBySelectDT(boolean enabled) {
        this.setPrefValue(COPY_BY_SELECT_DT, enabled);
    }

    @Override
    public void checkAndRegister(boolean realRegistration) throws MobyException {
        MobyDataType dataType = null;
        Object obj = this.propertyChannel.get("dp-reg-dt-tree");
        if (obj == null) {
            throw new MobyException("Strange. No information about data type...");
        }
        dataType = (MobyDataType)obj;
        String name = dataType.getName();
        if (name == null || "_dummy_".equals(name)) {
            throw new MobyException("Data name is still missing. Please fill it first.");
        }
        String[] parents = dataType.getParentNames();
        if (parents.length == 0) {
            throw new MobyException("Every data type must inherit from a existing data type.\nPlease select a data type from available data types\nand add it as a parent type (using ISA relationship).");
        }
        String value = this.dtAuth.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Every data type must have an authority.\nFill it, or (if such authority already exists)\nselect it from the data type tree sorted by authority.");
        }
        dataType.setAuthority(value);
        value = this.dtEmail.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Every data type must have a contact person.\nPlease fill in an email address.");
        }
        dataType.setEmailContact(value);
        value = this.dtDescArea.getText();
        if (UUtils.isEmpty((String)value)) {
            throw new MobyException("Every data type must have a description.\nPlease fill in the most detailed one.");
        }
        dataType.setDescription(value);
        if (realRegistration) {
            this.console.setText("Data type to be registered:\n---------------------------\n" + dataType.toString());
            this.registryModel.registerDataType(dataType);
            this.console.setText("\nRegistration successful!\n\n");
            this.updateCache();
        } else {
            String xml = this.registryModel.getRegisterDataTypeXML(dataType);
            this.console.setText("\n" + xml + "\n");
        }
    }

    @Override
    protected void updateCache() throws MobyException {
        this.registryModel.updateDataTypesCache();
    }

    protected class CustomDataTypesTree
    extends DataTypesTree {
        protected static final String AC_PARENT = "ac-parent";
        protected static final String AC_MHASA = "ac-m-hasa";
        protected static final String AC_MHAS = "ac-m-has";
        protected static final String AC_UNREG = "ac-unreg";

        public CustomDataTypesTree(RegistryModel model, CommonConsole console) {
            super(model, console);
        }

        @Override
        protected void createPopups(String title) {
            super.createPopups(title);
            this.removeFromPopups("ac-reload");
            this.removeFromPopups("ac-hasa");
            this.removeFromPopups("ac-depr");
            this.removeSeparatorAfter("ac-collapse");
            this.popup.add(CustomDataTypesTree.createMenuItem(new AbstractAction("Add selected as a parent type - ISA"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomDataTypesTree.this.onParentSelectedDT();
                }
            }, AC_PARENT, RegistrationPanel.menuAddISAIcon, RegistrationPanel.menuAddISAIconDis));
            this.popup.add(CustomDataTypesTree.createMenuItem(new AbstractAction("Add selected as a member - HASA"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomDataTypesTree.this.onMemberSelected(2);
                }
            }, AC_MHASA, RegistrationPanel.menuAddHASAIcon, RegistrationPanel.menuAddHASAIconDis));
            this.popup.add(CustomDataTypesTree.createMenuItem(new AbstractAction("Add selected as a list of members - HAS"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomDataTypesTree.this.onMemberSelected(3);
                }
            }, AC_MHAS, RegistrationPanel.menuAddHASIcon, RegistrationPanel.menuAddHASIconDis));
            this.popup.addSeparator();
            this.popup.add(CustomDataTypesTree.createMenuItem(new AbstractAction("Unregister"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomDataTypesTree.this.onUnregisterDataType();
                }
            }, AC_UNREG, RegistrationPanel.unregisterIcon, RegistrationPanel.unregisterIconDis));
        }

        @Override
        protected void setEnabledPopup(boolean enabled) {
            super.setEnabledPopup(enabled);
            this.selected(null);
        }

        @Override
        protected void selected(DefaultMutableTreeNode node) {
            if (node == null) {
                this.setEnabledPopupItem(AC_UNREG, false);
                this.setEnabledPopupItem(AC_PARENT, false);
                this.setEnabledPopupItem(AC_MHASA, false);
                this.setEnabledPopupItem(AC_MHAS, false);
                return;
            }
            final CommonNode nodeObject = (CommonNode)node.getUserObject();
            final boolean isDataType = nodeObject.getType() == 11;
            final boolean isAuthority = nodeObject.getType() == 15;
            this.setEnabledPopupItem(AC_UNREG, isDataType);
            this.setEnabledPopupItem(AC_PARENT, isDataType);
            this.setEnabledPopupItem(AC_MHASA, isDataType);
            this.setEnabledPopupItem(AC_MHAS, isDataType);
            SwingWorker worker = new SwingWorker(){
                MobyDataType dataType = null;

                @Override
                public Object construct() {
                    try {
                        if (isDataType) {
                            this.dataType = CustomDataTypesTree.this.registryModel.getDataType(nodeObject.getValue());
                        }
                        RegistrationDataTypeSubPanel.this.unregisButton.setEnabled(isDataType);
                    }
                    catch (MobyException e) {
                        CommonTree.error("An error happened when accessing a list of available data types.\n\nCheck please values in text fields (in Registry Browser)\nspecifying registry endpoint and namespace, and in the\none specifying directory used as a local cache. Then\nright-click in the data types area and select 'Reload'.\n\n", (Exception)((Object)e));
                    }
                    return this.dataType;
                }

                @Override
                public void finished() {
                    if (this.dataType != null) {
                        CustomDataTypesTree.this.console.setText(this.dataType.toString());
                        if (RegistrationDataTypeSubPanel.this.copyBySelect.isSelected()) {
                            RegistrationDataTypeSubPanel.this.dtName.setText(this.dataType.getName());
                            RegistrationDataTypeSubPanel.this.dtAuth.setText(this.dataType.getAuthority());
                            RegistrationDataTypeSubPanel.this.dtEmail.setText(this.dataType.getEmailContact());
                            RegistrationDataTypeSubPanel.this.dtDescArea.setText(this.dataType.getDescription());
                            RegistrationDataTypeSubPanel.this.buildTree.setParent(this.dataType.getParentName());
                            RegistrationDataTypeSubPanel.this.buildTree.removeAllChildren();
                            MobyRelationship[] children = this.dataType.getChildren();
                            for (int i = 0; i < children.length; ++i) {
                                RegistrationDataTypeSubPanel.this.buildTree.addMember(children[i]);
                            }
                        }
                    } else if (isAuthority && RegistrationDataTypeSubPanel.this.copyBySelect.isSelected()) {
                        RegistrationDataTypeSubPanel.this.dtAuth.setText(nodeObject.getValue());
                    }
                }
            };
            worker.start();
        }

        protected void onParentSelectedDT() {
            String value;
            CommonNode nodeObject;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            if (node != null && (nodeObject = (CommonNode)node.getUserObject()).getType() == 11 && !DataTypesGenerator.isPrimitiveType((String)(value = nodeObject.getValue()))) {
                RegistrationDataTypeSubPanel.this.buildTree.setParent(value);
            }
        }

        protected void onMemberSelected(int relationshipType) {
            CommonNode nodeObject;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            if (node != null && (nodeObject = (CommonNode)node.getUserObject()).getType() == 11) {
                RegistrationDataTypeSubPanel.this.buildTree.addMember(nodeObject.getValue(), relationshipType);
            }
        }

        protected void onUnregisterDataType() {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            CommonNode nodeObject = (CommonNode)node.getUserObject();
            final String dataTypeName = nodeObject.getValue();
            if (DataTypesGenerator.isPrimitiveType((String)dataTypeName) || dataTypeName.equals("Object")) {
                AbstractPanel.error("Sorry, but the top-level object and\nthe objects representing primitive types\ncannot unregister. At least not so easily.");
                return;
            }
            if (!AbstractPanel.confirm("Are you sure you wish to unregister\ndata type: " + dataTypeName + " ?")) {
                return;
            }
            RegistrationDataTypeSubPanel.this.dtUnregException = null;
            SwingWorker worker = new SwingWorker(){

                @Override
                public Object construct() {
                    try {
                        RegistrationDataTypeSubPanel.this.unregisButton.setEnabled(false);
                        MobyDataType dataType = new MobyDataType(dataTypeName);
                        CustomDataTypesTree.this.console.setText("Data type to be unregistered: " + dataTypeName + "\n");
                        CustomDataTypesTree.this.registryModel.unRegisterDataType(dataType);
                        CustomDataTypesTree.this.console.setText("\nUnregistration successful!\n\n");
                        RegistrationDataTypeSubPanel.this.updateCache();
                    }
                    catch (MobyException e) {
                        RegistrationDataTypeSubPanel.this.dtUnregException = e;
                    }
                    return null;
                }

                @Override
                public void finished() {
                    if (RegistrationDataTypeSubPanel.this.dtUnregException != null) {
                        CommonTree.error(RegistrationDataTypeSubPanel.DATA_TYPE_UNREG_PROLOGUE, (Exception)((Object)RegistrationDataTypeSubPanel.this.dtUnregException));
                    }
                }
            };
            worker.start();
        }
    }
}

