/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.DashboardPanel;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.Utils;
import org.tulsoft.shared.UUtils;

public class PropertyChannel
extends Hashtable {
    private static Log log = LogFactory.getLog(PropertyChannel.class);
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    @Override
    public Object put(Object key, Object value) {
        Object previous = super.put(key, value);
        this.fire(key.toString(), value);
        return previous;
    }

    public Object put(Object source, Object key, Object value) {
        Object previous = super.put(key, value);
        this.fire(source, key.toString(), value);
        return previous;
    }

    public String getString(Object key) {
        Object value = this.get(key);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public boolean getBoolean(Object key, boolean defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return UUtils.is((String)value.toString());
    }

    public void fire(String key, Object value) {
        if (log.isDebugEnabled()) {
            this.logDebug(null, key, value);
        }
        this.support.firePropertyChange(key.toString(), null, value);
    }

    public void fire(Object source, String key, Object value) {
        if (log.isDebugEnabled()) {
            this.logDebug(source, key, value);
        }
        this.support.firePropertyChange(new PropertyChangeEvent(source, key.toString(), null, value));
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.support != null) {
            this.support.addPropertyChangeListener(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.support != null) {
            this.support.removePropertyChangeListener(l);
        }
    }

    protected void logDebug(Object source, String key, Object value) {
        if ("status-msg".equals(key)) {
            return;
        }
        if ("dp-s-selected".equals(key)) {
            return;
        }
        StringBuffer buf = new StringBuffer(100);
        if (source != null) {
            buf.append("[");
            if (source instanceof DashboardPanel) {
                buf.append(Utils.simpleClassName((String)((DashboardPanel)source).getName()));
            } else {
                buf.append(Utils.simpleClassName((String)source.getClass().getName()));
            }
            buf.append("] ");
        }
        buf.append(key);
        buf.append(": ");
        if (value != null) {
            if (value instanceof MobyService) {
                buf.append(((MobyService)value).getName());
            } else {
                buf.append(value.toString());
            }
        }
        log.debug((Object)buf);
    }
}

