/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.biomoby.service.dashboard.CommonDataTable;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobyPrimaryDataSet;
import org.biomoby.shared.MobyPrimaryDataSimple;

public class PrimaryDataTable
extends CommonDataTable {
    public static final int COL_ARTICLE = 1;
    public static final int COL_DATATYPE = 2;
    public static final int COL_IN_SET = 3;
    public static final int COL_NAMESPACE = 4;

    public PrimaryDataTable() {
        this.tableModel = new PrimaryDataTableModel();
        this.setModel(this.tableModel);
        this.createItself();
    }

    public MobyPrimaryData[] getData() {
        Vector v = this.tableModel.getData();
        Object[] result = new MobyPrimaryData[v.size()];
        v.copyInto(result);
        return result;
    }

    @Override
    protected void createItself() {
        super.createItself();
        TableColumn nsColumn = this.getColumnModel().getColumn(4);
        nsColumn.setCellRenderer(new NamespaceRenderer());
        nsColumn.setCellEditor(new NamespaceEditor());
    }

    protected class PrimaryDataTableModel
    extends CommonDataTable.CommonDataTableModel {
        public static final int COL_ARTICLE = 1;
        public static final int COL_DATATYPE = 2;
        public static final int COL_IN_SET = 3;
        public static final int COL_NAMESPACE = 4;

        public PrimaryDataTableModel() {
            this.columnToolTips = new String[]{"Click in this column to remove data from this service", "Click to edit article name", "Select a row, then select a data type in the data types tree", "Check the box if this data should be a collection", "Select a row, then select one or more namespaces in the namespaces tree"};
            this.columnNames = new String[]{"Remove", "Article name", "Data Type", "Collection", "Namespaces"};
            this.columnClasses = new Class[]{Integer.class, String.class, String.class, Boolean.class, MobyPrimaryData.class};
        }

        @Override
        public void addEmptyData() {
            this.data.addElement(new MobyPrimaryDataSimple(""));
            int rowCount = this.getRowCount();
            this.fireTableRowsInserted(rowCount - 1, rowCount - 1);
        }

        @Override
        public Object getValueAt(int row, int col) {
            try {
                MobyPrimaryData d = (MobyPrimaryData)this.data.elementAt(row);
                switch (col) {
                    case 0: {
                        return new Integer(row);
                    }
                    case 1: {
                        return d.getName();
                    }
                    case 2: {
                        return this.getDataTypeName(d);
                    }
                    case 3: {
                        return new Boolean(d instanceof MobyPrimaryDataSet);
                    }
                    case 4: {
                        return d;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "";
        }

        private String getDataTypeName(MobyPrimaryData theData) {
            if (theData == null) {
                return "";
            }
            MobyDataType dataType = theData.getDataType();
            if (dataType == null) {
                return "";
            }
            String name = dataType.getName();
            return name == null ? "" : name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValueAt(Object value, int row, int col) {
            if (value == null) {
                return;
            }
            try {
                MobyPrimaryData d = (MobyPrimaryData)this.data.elementAt(row);
                switch (col) {
                    case 1: {
                        d.setName(value.toString());
                        break;
                    }
                    case 2: {
                        d.setDataType(new MobyDataType(value.toString()));
                        break;
                    }
                    case 3: {
                        MobyPrimaryDataSimple[] simples;
                        if (((Boolean)value).booleanValue()) {
                            if (!(d instanceof MobyPrimaryDataSimple)) break;
                            MobyPrimaryDataSet set = new MobyPrimaryDataSet(d.getName());
                            ((MobyPrimaryDataSimple)d).setName("");
                            set.addElement((MobyPrimaryDataSimple)d);
                            Vector vector = this.data;
                            synchronized (vector) {
                                this.data.removeElementAt(row);
                                this.data.insertElementAt(set, row);
                                break;
                            }
                        }
                        if (!(d instanceof MobyPrimaryDataSet) || (simples = ((MobyPrimaryDataSet)d).getElements()).length <= 0) break;
                        simples[0].setName(d.getName());
                        Vector vector = this.data;
                        synchronized (vector) {
                            this.data.removeElementAt(row);
                            this.data.insertElementAt(simples[0], row);
                            break;
                        }
                    }
                }
                this.fireTableCellUpdated(row, col);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 2;
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setIcon(CommonDataTable.trashIcon);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (index > -1) {
                    list.setToolTipText("To remove a namespace, hold CTRL and select it");
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    class NamespaceEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        DefaultComboBoxModel comboModel = new DefaultComboBoxModel();
        JComboBox comboBox;
        DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
        JTable table;
        int row;
        int col;
        MobyPrimaryDataSimple lastSimple = null;

        public NamespaceEditor() {
            this.defaultRenderer.setText("");
            this.comboBox = new JComboBox(this.comboModel);
            this.comboBox.setOpaque(true);
            this.comboBox.setRenderer(new ComboBoxRenderer());
            this.comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox cb;
                    Object selectedItem;
                    if ((e.getModifiers() & 2) > 0 && (selectedItem = (cb = (JComboBox)e.getSource()).getSelectedItem()) != null) {
                        String namespace = selectedItem.toString();
                        if (NamespaceEditor.this.lastSimple != null) {
                            NamespaceEditor.this.lastSimple.removeNamespace(namespace);
                            ((AbstractTableModel)NamespaceEditor.this.table.getModel()).fireTableCellUpdated(NamespaceEditor.this.row, NamespaceEditor.this.col);
                        }
                    }
                    NamespaceEditor.this.fireEditingStopped();
                }
            });
            this.comboBox.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    NamespaceEditor.this.fireEditingStopped();
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable aTable, Object value, boolean isSelected, int aRow, int aCol) {
            MobyNamespace[] nss;
            MobyPrimaryDataSimple[] simples;
            this.table = aTable;
            this.row = aRow;
            this.col = aCol;
            if (value == null) {
                return this.defaultRenderer;
            }
            this.lastSimple = null;
            if (value instanceof MobyPrimaryDataSimple) {
                this.lastSimple = (MobyPrimaryDataSimple)value;
            } else if (value instanceof MobyPrimaryDataSet && (simples = ((MobyPrimaryDataSet)value).getElements()).length > 0) {
                this.lastSimple = simples[0];
            }
            if (this.lastSimple != null && (nss = this.lastSimple.getNamespaces()).length > 0) {
                this.comboModel.removeAllElements();
                for (int i = 0; i < nss.length; ++i) {
                    this.comboModel.addElement(nss[i].getName());
                }
                return this.comboBox;
            }
            return this.defaultRenderer;
        }
    }

    class NamespaceRenderer
    extends DefaultTableCellRenderer {
        public NamespaceRenderer() {
            this.setOpaque(true);
        }

        @Override
        protected void setValue(Object value) {
            if (value == null) {
                this.setText("");
            } else {
                MobyNamespace[] nss = ((MobyPrimaryData)value).getNamespaces();
                if (nss.length == 0) {
                    this.setText("");
                } else if (nss.length == 1) {
                    this.setText(nss[0].getName());
                } else {
                    this.setText(nss.length + " chosen");
                }
            }
        }
    }
}

