/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.StyledEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FilenameUtils;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.CommonNode;
import org.biomoby.service.dashboard.GraphColours;
import org.biomoby.service.dashboard.PerlMoSeSSyntaxDocument;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.ServicesBoard;
import org.biomoby.service.dashboard.ServicesTree;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.event.NotificationEvent;
import org.biomoby.shared.event.NotificationListener;
import org.tulsoft.tools.gui.JTextFieldWithHistory;
import org.tulsoft.tools.gui.SwingUtils;

public class PerlMoSeSPanel
extends AbstractPanel {
    static String PM_WARNING = "perl-moses-warning";
    static String PM_ERROR = "perl-moses-error";
    static String PM_INFORMATION = "perl-moses-information";
    static String PM_OVERWRITE = "perl-moses-overwrite";
    static String PM_CGI = "perl-moses-cgi";
    static String PM_SOAP = "perl-moses-soap";
    static String PM_ASYNC = "perl-moses-async";
    static String PM_CGI_ASYNC = "perl-moses-cgi-async";
    static String PM_SYNC_DATATYPES = "perl-moses-sync-datatypes";
    static String PM_SYNC_SERVICES = "perl-moses-sync-services";
    static String PM_GENERATING_SPECIFIC_SERVICES = "perl-moses-generating-specific-services";
    static String PM_GENERATING_BY_AUTHORITY = "perl-moses-generating-by-authority";
    static String PM_FILE_ACTION_SAVE = "perl-moses-file-action-save";
    static String PM_FILE_ACTION_OPEN = "perl-moses-file-action-open";
    static String PM_FILE_ACTION_CLOSE = "perl-moses-file-action-close";
    static String PM_FILE_CURRENT = "perl-moses-file-current";
    static String PM_FILE_CURRENT_CHECKSUM = "perl-moses-file-current-checksum";
    static String PM_FILE_LAST_DIRECTORY = "perl-moses-file-last-directory";
    static String PM_PERL_LIB_1 = "perl-moses-perl-lib-1";
    static String PM_PERL_LIB_2 = "perl-moses-perl-lib-2";
    static String PM_SCRIPTS_INSTALL_DIR = "perl-moses-scripts-install-dir";
    static String PM_PERL_INSTALL_DIR = "perl-moses-perl-install-dir";
    static String PM_EDITOR_FONT = "perl-moses-editor-font";
    private static final long serialVersionUID = 1379466985182986776L;
    private RegistryModel registryModel;
    private CommonConsole console;
    private JLabel aSelectedCount;
    private JLabel sSelectedCount;
    private JLabel currentlyEditing;
    private JLabel currentPosition;
    private JButton editorSaveButton;
    private JButton editorCloseButton;
    private JButton editorOpenButton;
    private JButton scriptsBtn;
    private JButton generateBtn;
    private boolean enable_moses_actions = true;
    private boolean is_windows_pc = false;
    private Icon openFileIcon;
    private Icon openFileIconDis;
    private Icon closeFileIcon;
    private Icon closeFileIconDis;
    private Icon saveFileIcon;
    private Icon saveFileIconDis;
    private Icon zoomInIcon;
    private Icon zoomInIconDis;
    private Icon zoomOutIcon;
    private Icon zoomOutIconDis;
    private static JTextPane editorTextPane;
    private JComboBox fonts;
    private String SERVICE_CACHE_DOESNT_EXIST = "Please create a services cache first!";
    private String DATATYPE_CACHE_DOESNT_EXIST = "Please create a datatype cache first!";
    private ActionListener howToListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String howTo = e.getActionCommand();
            PerlMoSeSPanel.this.propertyChannel.put(PM_CGI, (Object)howTo.equals(PM_CGI));
            PerlMoSeSPanel.this.propertyChannel.put(PM_CGI_ASYNC, (Object)howTo.equals(PM_CGI_ASYNC));
            PerlMoSeSPanel.this.propertyChannel.put(PM_ASYNC, (Object)howTo.equals(PM_ASYNC));
            PerlMoSeSPanel.this.propertyChannel.put(PM_SOAP, (Object)howTo.equals(PM_SOAP));
        }
    };

    public PerlMoSeSPanel() {
        this.panelIconFileName = "images/pMoses.gif";
        if (System.getProperty("os.name").startsWith("Windows")) {
            this.is_windows_pc = true;
        }
        this.check_install();
        if (!this.enable_moses_actions) {
            String s = "";
            s = this.getPrefValue(PM_PERL_INSTALL_DIR, "");
            if (s.equals("")) {
                this.setPrefValue(PM_PERL_INSTALL_DIR, this.is_windows_pc ? "perl.exe" : "/usr/bin/perl");
            }
        }
    }

    private void check_install() {
        String[] command;
        ArrayList<String> prefix = new ArrayList<String>();
        if (this.is_windows_pc) {
            prefix.add("moses-cache-tester.bat");
            command = prefix.toArray(new String[0]);
        } else {
            prefix.add("moses-cache-tester.pl");
            command = prefix.toArray(new String[0]);
        }
        try {
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while (br.readLine() != null) {
            }
            process.waitFor();
            this.enable_moses_actions = true;
        }
        catch (Exception e) {
            this.enable_moses_actions = false;
        }
    }

    private void user_check_install() {
        String[] command;
        ArrayList<String> prefix = this.generatePerlPrefix();
        if (this.is_windows_pc) {
            prefix.add("moses-cache-tester.bat");
            command = prefix.toArray(new String[0]);
        } else {
            prefix.add((prefix.size() > 0 ? prefix.remove(prefix.size() - 1) : "") + "moses-cache-tester.pl");
            command = prefix.toArray(new String[0]);
        }
        try {
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while (br.readLine() != null) {
            }
            process.waitFor();
            this.enable_moses_actions = true;
        }
        catch (Exception e) {
            this.enable_moses_actions = false;
        }
    }

    private ArrayList<String> generatePerlPrefix() {
        if (this.is_windows_pc) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        String script_path = this.propertyChannel.getString(PM_SCRIPTS_INSTALL_DIR);
        String lib1 = this.propertyChannel.getString(PM_PERL_LIB_1);
        String lib2 = this.propertyChannel.getString(PM_PERL_LIB_2);
        String perl = this.propertyChannel.getString(PM_PERL_INSTALL_DIR);
        if (perl != null && !perl.trim().equals("") && script_path != null && !script_path.trim().equals("")) {
            list.add(perl);
            if (lib1 != null && !lib1.trim().equals("")) {
                list.add("-I" + lib1.trim());
            }
            if (lib2 != null && !lib2.trim().equals("")) {
                list.add("-I" + lib2.trim());
            }
            if (!script_path.endsWith("/")) {
                script_path = script_path + "/";
            }
            list.add(script_path);
        }
        return list;
    }

    @Override
    public JComponent getComponent(PropertyChannel propertyChannel) {
        this.setPropertyChannel(propertyChannel);
        this.determineMoSeSDirectory();
        propertyChannel.put(PM_GENERATING_BY_AUTHORITY, new Boolean(false));
        propertyChannel.put(PM_GENERATING_SPECIFIC_SERVICES, new Boolean(false));
        propertyChannel.put(PM_SYNC_SERVICES, new Boolean(false));
        propertyChannel.put(PM_SYNC_DATATYPES, new Boolean(false));
        propertyChannel.put(PM_OVERWRITE, new Boolean(false));
        propertyChannel.put(PM_CGI, new Boolean(false));
        propertyChannel.put(PM_CGI_ASYNC, new Boolean(false));
        propertyChannel.put(PM_ASYNC, new Boolean(false));
        propertyChannel.put(PM_PERL_INSTALL_DIR, this.getPrefValue(PM_PERL_INSTALL_DIR, ""));
        propertyChannel.put(PM_PERL_LIB_1, this.getPrefValue(PM_PERL_LIB_1, ""));
        propertyChannel.put(PM_PERL_LIB_2, this.getPrefValue(PM_PERL_LIB_2, ""));
        propertyChannel.put(PM_SCRIPTS_INSTALL_DIR, this.getPrefValue(PM_SCRIPTS_INSTALL_DIR, ""));
        propertyChannel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals(PM_ERROR)) {
                    AbstractPanel.error(e.getNewValue());
                    PerlMoSeSPanel.this.console.setText("Error:" + e.getNewValue().toString() + "\n");
                    return;
                }
                if (e.getPropertyName().equals(PM_WARNING)) {
                    JOptionPane.showMessageDialog(null, e.getNewValue(), "Warning", 2);
                    PerlMoSeSPanel.this.console.setText("Warning:" + e.getNewValue().toString() + "\n");
                    return;
                }
                if (e.getPropertyName().equals(PM_INFORMATION)) {
                    PerlMoSeSPanel.this.console.setText("Information:" + e.getNewValue().toString() + "\n");
                    return;
                }
                if (e.getPropertyName().equals(PM_FILE_ACTION_SAVE)) {
                    PerlMoSeSPanel.this.doSaveFile();
                    return;
                }
                if (e.getPropertyName().equals(PM_FILE_ACTION_OPEN)) {
                    PerlMoSeSPanel.this.doOpenFile(e.getNewValue().toString());
                    return;
                }
                if (e.getPropertyName().equals(PM_FILE_ACTION_CLOSE)) {
                    PerlMoSeSPanel.this.doCloseFile();
                    return;
                }
            }
        });
        this.registryModel = this.createRegistryModel();
        this.registryModel.addNotificationListener(new NotificationListener(){

            public void notified(NotificationEvent e) {
                if (e.getType() == 31 && PerlMoSeSPanel.this.enable_moses_actions && !PerlMoSeSPanel.this.getPropertyChannel().getBoolean(PM_SYNC_SERVICES, false)) {
                    PerlMoSeSPanel.this.getPropertyChannel().put(PM_SYNC_SERVICES, (Object)true);
                    PerlMoSeSPanel.this.onUpdateServiceCache();
                    return;
                }
                if (PerlMoSeSPanel.this.enable_moses_actions && e.getType() == 28 && !PerlMoSeSPanel.this.getPropertyChannel().getBoolean(PM_SYNC_DATATYPES, false)) {
                    PerlMoSeSPanel.this.getPropertyChannel().put(PM_SYNC_DATATYPES, (Object)true);
                    PerlMoSeSPanel.this.onUpdateDatatypeCache();
                    return;
                }
            }
        });
        if (this.pComponent != null) {
            return this.pComponent;
        }
        this.pComponent = new JPanel(new GridBagLayout(), true);
        this.console = new CommonConsole();
        this.console.setAppendMode(true);
        this.console.setVerboseMode(true);
        JSplitPane vsplit = this.vSplit(this.getServicesSelectionPanel(), this.getMoSeSPanel(), 0.8);
        JSplitPane vsplit2 = this.vSplit(this.getEditorPanel(), this.console, 0.8);
        JSplitPane splitPane = this.hSplit(vsplit, vsplit2, 0.1);
        SwingUtils.addComponent((JComponent)this.pComponent, (Component)splitPane, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        return this.pComponent;
    }

    private void determineMoSeSDirectory() {
        try {
            File f = new File(System.getProperty("user.home"), "Perl-MoSeS");
            if (f.exists() && f.isDirectory() && f.canRead() && f.canWrite()) {
                this.propertyChannel.put(PM_FILE_LAST_DIRECTORY, f.getPath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final PropertyChannel getPropertyChannel() {
        return this.propertyChannel;
    }

    private JPanel getMoSeSPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(PerlMoSeSPanel.createFatBorder("Perl-MoSeS", GraphColours.getColour("cadetblue", Color.blue)));
        JPanel sPanel = PerlMoSeSPanel.createTitledPanel("Local User Config");
        if (!this.enable_moses_actions) {
            this.scriptsBtn = PerlMoSeSPanel.createButton("Confirm values are correct", "Check whether or not your local user config is correct", 82, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!PerlMoSeSPanel.this.enable_moses_actions) {
                        if (PerlMoSeSPanel.this.propertyChannel.getString(PM_SCRIPTS_INSTALL_DIR) != null && !PerlMoSeSPanel.this.propertyChannel.getString(PM_SCRIPTS_INSTALL_DIR).endsWith("/")) {
                            PerlMoSeSPanel.this.propertyChannel.put(PM_SCRIPTS_INSTALL_DIR, PerlMoSeSPanel.this.propertyChannel.getString(PM_SCRIPTS_INSTALL_DIR) + "/");
                        }
                        PerlMoSeSPanel.this.user_check_install();
                        if (PerlMoSeSPanel.this.enable_moses_actions) {
                            PerlMoSeSPanel.this.propertyChannel.fire(PM_INFORMATION, "Your local configuration was successful!");
                            if (PerlMoSeSPanel.this.enable_moses_actions && !PerlMoSeSPanel.this.getPropertyChannel().getBoolean(PM_SYNC_SERVICES, false)) {
                                PerlMoSeSPanel.this.propertyChannel.fire(PM_INFORMATION, "Setting up Perl-MoSeS services!");
                                PerlMoSeSPanel.this.getPropertyChannel().put(PM_SYNC_SERVICES, (Object)true);
                                PerlMoSeSPanel.this.onUpdateServiceCache();
                            }
                            if (!PerlMoSeSPanel.this.getPropertyChannel().getBoolean(PM_SYNC_DATATYPES, false)) {
                                PerlMoSeSPanel.this.propertyChannel.fire(PM_INFORMATION, "Setting up Perl-MoSeS datatypes!");
                                PerlMoSeSPanel.this.getPropertyChannel().put(PM_SYNC_DATATYPES, (Object)true);
                                PerlMoSeSPanel.this.onUpdateDatatypeCache();
                            }
                            PerlMoSeSPanel.this.scriptsBtn.setEnabled(!PerlMoSeSPanel.this.enable_moses_actions);
                        } else {
                            PerlMoSeSPanel.this.propertyChannel.fire(PM_ERROR, "Sorry, your configuration resulted in error.\nPlease review your values and try again!");
                        }
                    }
                }
            });
            JTextFieldWithHistory lib1 = this.createText(null, PM_PERL_LIB_1, PM_PERL_LIB_1);
            lib1.setText(this.propertyChannel.getString(PM_PERL_LIB_1));
            JTextFieldWithHistory lib2 = this.createText(null, PM_PERL_LIB_2, PM_PERL_LIB_2);
            lib2.setText(this.propertyChannel.getString(PM_PERL_LIB_2));
            JTextFieldWithHistory install_path = this.createText(null, PM_SCRIPTS_INSTALL_DIR, PM_SCRIPTS_INSTALL_DIR);
            install_path.setText(this.propertyChannel.getString(PM_SCRIPTS_INSTALL_DIR));
            JTextFieldWithHistory perl_install_path = this.createText(null, PM_PERL_INSTALL_DIR, PM_PERL_INSTALL_DIR);
            perl_install_path.setText(this.propertyChannel.getString(PM_PERL_INSTALL_DIR));
            SwingUtils.addComponent((JComponent)sPanel, (Component)new JLabel("Perl Path: "), (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
            SwingUtils.addComponent((JComponent)sPanel, (Component)perl_install_path, (int)1, (int)0, (int)3, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
            SwingUtils.addComponent((JComponent)sPanel, (Component)new JLabel("PERL5LIB dir: "), (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
            SwingUtils.addComponent((JComponent)sPanel, (Component)lib1, (int)1, (int)1, (int)3, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
            SwingUtils.addComponent((JComponent)sPanel, (Component)new JLabel("PERL5LIB dir (2): "), (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
            SwingUtils.addComponent((JComponent)sPanel, (Component)lib2, (int)1, (int)2, (int)3, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
            SwingUtils.addComponent((JComponent)sPanel, (Component)new JLabel("MoSeS Scripts dir: "), (int)0, (int)3, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
            SwingUtils.addComponent((JComponent)sPanel, (Component)install_path, (int)1, (int)3, (int)3, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
            SwingUtils.addComponent((JComponent)sPanel, (Component)this.scriptsBtn, (int)1, (int)4, (int)3, (int)1, (int)0, (int)18, (double)1.0, (double)0.0);
        } else {
            this.propertyChannel.put(PM_PERL_INSTALL_DIR, "");
            this.propertyChannel.put(PM_PERL_LIB_1, "");
            this.propertyChannel.put(PM_PERL_LIB_2, "");
            this.propertyChannel.put(PM_SCRIPTS_INSTALL_DIR, "");
        }
        JPanel bPanel = PerlMoSeSPanel.createTitledPanel("Generate");
        JCheckBox genOverwrite = this.createActionBox("Overwrite Existing Code", PM_OVERWRITE);
        this.generateBtn = PerlMoSeSPanel.createButton("Generate Skeletons", "Generate skeletons from selected services", 71, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PerlMoSeSPanel.this.propertyChannel.get("selectedAuthorities") == null && PerlMoSeSPanel.this.propertyChannel.get("selectedServices") == null) {
                    PerlMoSeSPanel.this.propertyChannel.put(PM_ERROR, "There were no services selected. Generating of skeletons failed.");
                    return;
                }
                PerlMoSeSPanel.this.generateBtn.setEnabled(false);
                PerlMoSeSPanel.this.propertyChannel.fire("status-msg", "Processing MoSeS skeletons...");
                if (PerlMoSeSPanel.this.propertyChannel.get("selectedServices") != null) {
                    PerlMoSeSPanel.this.propertyChannel.put(PM_GENERATING_SPECIFIC_SERVICES, new Boolean(true));
                    PerlMoSeSPanel.this.onGenerateSpecificService();
                }
                if (PerlMoSeSPanel.this.propertyChannel.get("selectedAuthorities") != null) {
                    PerlMoSeSPanel.this.propertyChannel.put(PM_GENERATING_BY_AUTHORITY, new Boolean(true));
                    PerlMoSeSPanel.this.onGenerateFromAuthority();
                }
                PerlMoSeSPanel.this.propertyChannel.fire("status-msg", "Processing MoSeS skeletons completed");
            }
        });
        this.generateBtn.setEnabled(this.enable_moses_actions);
        ButtonGroup group = new ButtonGroup();
        JRadioButton genCgi = this.createHowToButton("Generate CGI Service", PM_CGI);
        group.add(genCgi);
        JRadioButton genCgiAsync = this.createHowToButton("Generate ASYNC CGI Service", PM_CGI_ASYNC);
        group.add(genCgiAsync);
        JRadioButton genSoap = this.createHowToButton("Generate SOAP Service", PM_SOAP);
        group.add(genSoap);
        JRadioButton genAsync = this.createHowToButton("Generate ASYNC SOAP Service", PM_ASYNC);
        group.add(genAsync);
        SwingUtils.addComponent((JComponent)bPanel, (Component)genOverwrite, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)bPanel, (Component)genCgi, (int)0, (int)1, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)bPanel, (Component)genCgiAsync, (int)0, (int)2, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)bPanel, (Component)genSoap, (int)0, (int)3, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)bPanel, (Component)genAsync, (int)0, (int)4, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)bPanel, (Component)this.generateBtn, (int)0, (int)5, (int)2, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        int count = 0;
        if (!this.enable_moses_actions) {
            SwingUtils.addComponent((JComponent)p, (Component)sPanel, (int)0, (int)count++, (int)2, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        }
        SwingUtils.addComponent((JComponent)p, (Component)bPanel, (int)0, (int)count++, (int)2, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        return p;
    }

    @Override
    public String getName() {
        return "Perl-MoSeS Generator";
    }

    @Override
    public String getDescription() {
        return "A Panel for those wishing to create Perl based Biomoby Web Services.";
    }

    @Override
    public boolean loadOnlyOnDemand() {
        return true;
    }

    @Override
    protected void loadIcons() {
        if (this.openFileIconDis == null) {
            this.openFileIconDis = PerlMoSeSPanel.loadIcon("images/smallEdit_dis.gif");
        }
        if (this.openFileIcon == null) {
            this.openFileIcon = PerlMoSeSPanel.loadIcon("images/smallEdit.gif");
        }
        if (this.saveFileIcon == null) {
            this.saveFileIcon = PerlMoSeSPanel.loadIcon("images/smallSave.gif");
        }
        if (this.saveFileIconDis == null) {
            this.saveFileIconDis = PerlMoSeSPanel.loadIcon("images/smallSave_dis.gif");
        }
        if (this.closeFileIcon == null) {
            this.closeFileIcon = PerlMoSeSPanel.loadIcon("images/smallClear.gif");
        }
        if (this.closeFileIconDis == null) {
            this.closeFileIconDis = PerlMoSeSPanel.loadIcon("images/smallClear_dis.gif");
        }
        if (this.zoomInIcon == null) {
            this.zoomInIcon = PerlMoSeSPanel.loadIcon("images/smallZoomIn.gif");
        }
        if (this.zoomInIconDis == null) {
            this.zoomInIconDis = PerlMoSeSPanel.loadIcon("images/smallZoomIn_dis.gif");
        }
        if (this.zoomOutIcon == null) {
            this.zoomOutIcon = PerlMoSeSPanel.loadIcon("images/smallZoomOut.gif");
        }
        if (this.zoomOutIconDis == null) {
            this.zoomOutIconDis = PerlMoSeSPanel.loadIcon("images/smallZoomOut_dis.gif");
        }
    }

    private JPanel getEditorPanel() {
        JPanel p = new JPanel();
        BorderLayout thisLayout = new BorderLayout();
        p.setLayout(thisLayout);
        Border blackline = BorderFactory.createLineBorder(Color.black);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(blackline, "Perl-MoSeS: Editor"), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.setBorder(compoundBorder);
        JPanel footer = new JPanel();
        footer.setLayout(new BorderLayout());
        this.currentlyEditing = new JLabel("");
        this.currentPosition = new JLabel("");
        footer.add((Component)this.currentlyEditing, "West");
        footer.add((Component)this.currentPosition, "East");
        editorTextPane = new JTextPane();
        editorTextPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int dot = e.getDot();
                int line = ((JTextPane)e.getSource()).getDocument().getDefaultRootElement().getElementIndex(dot);
                int pos = dot - ((JTextPane)e.getSource()).getDocument().getDefaultRootElement().getElement(line).getStartOffset();
                PerlMoSeSPanel.this.currentPosition.setText(++line + ":" + ++pos);
            }
        });
        StyledEditorKit editorKit = new StyledEditorKit(){
            private static final long serialVersionUID = 1L;

            @Override
            public Document createDefaultDocument() {
                return new PerlMoSeSSyntaxDocument();
            }
        };
        editorTextPane.setEditorKitForContentType("text/perl", editorKit);
        editorTextPane.setContentType("text/perl");
        editorTextPane.setEditable(false);
        KeyStroke key = KeyStroke.getKeyStroke(83, 2);
        editorTextPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerlMoSeSPanel.this.propertyChannel.fire(PM_FILE_ACTION_SAVE, "");
            }
        }, key, 2);
        JScrollPane scrollPane = new JScrollPane(editorTextPane);
        p.add((Component)this.getFontChooser(), "First");
        p.add((Component)footer, "Last");
        p.add((Component)scrollPane, "Center");
        Font f = new Font(this.fonts.getSelectedItem().toString(), editorTextPane.getFont().getStyle(), editorTextPane.getFont().getSize());
        editorTextPane.setFont(f);
        return p;
    }

    protected static void moveCursor(int pos) {
        if (editorTextPane != null && editorTextPane.isEnabled() && pos >= 0 && pos < editorTextPane.getText().length()) {
            editorTextPane.setCaretPosition(pos);
        }
    }

    private JComponent getFontChooser() {
        JLabel label = new JLabel("Font:");
        JToolBar toolbar = new JToolBar("Editor");
        toolbar.setLayout(new BoxLayout(toolbar, 0));
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontFamilies = env.getAvailableFontFamilyNames();
        int index = 0;
        String saved_font = this.getPrefValue(PM_EDITOR_FONT, "");
        if (saved_font.equals("")) {
            saved_font = new Font(null).getName();
            this.setPrefValue(PM_EDITOR_FONT, saved_font);
        }
        if (saved_font != null && !saved_font.trim().equals("")) {
            index = 0;
            for (String f : fontFamilies) {
                if (f.equals(saved_font)) break;
                ++index;
            }
            Font oldFont = editorTextPane.getFont();
            Font font = new Font(saved_font, oldFont.getStyle(), oldFont.getSize());
            editorTextPane.setFont(font);
        }
        this.fonts = new JComboBox<String>(fontFamilies);
        this.fonts.setSelectedIndex(index >= fontFamilies.length ? 0 : index);
        this.fonts.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String newFont = (String)e.getItem();
                Font oldFont = editorTextPane.getFont();
                PerlMoSeSPanel.this.setPrefValue(PM_EDITOR_FONT, newFont);
                Font font = new Font(newFont, oldFont.getStyle(), oldFont.getSize());
                editorTextPane.setFont(font);
            }
        });
        this.fonts.setPreferredSize(this.fonts.getMinimumSize());
        JButton zoomInButton = AbstractPanel.createButton("", "Increase font in the editor", -1, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font font = editorTextPane.getFont();
                editorTextPane.setFont(font.deriveFont(font.getSize2D() + 1.0f));
            }
        });
        zoomInButton.setIcon(this.zoomInIcon);
        zoomInButton.setDisabledIcon(this.zoomInIconDis);
        SwingUtils.compact((JButton)zoomInButton);
        JButton zoomOutButton = AbstractPanel.createButton("", "Decrease font in the editor", -1, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font font = editorTextPane.getFont();
                editorTextPane.setFont(font.deriveFont(Math.max(1.0f, font.getSize2D() - 1.0f)));
            }
        });
        zoomOutButton.setIcon(this.zoomOutIcon);
        zoomOutButton.setDisabledIcon(this.zoomOutIconDis);
        SwingUtils.compact((JButton)zoomOutButton);
        this.editorOpenButton = new JButton("Open", this.openFileIcon);
        this.editorOpenButton.setIcon(this.openFileIcon);
        this.editorOpenButton.setDisabledIcon(this.openFileIconDis);
        this.editorOpenButton.setVerticalTextPosition(3);
        this.editorOpenButton.setHorizontalTextPosition(0);
        this.editorOpenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = PerlMoSeSPanel.this.propertyChannel.getString(PM_FILE_LAST_DIRECTORY);
                JFileChooser openFile = path == null ? new JFileChooser() : new JFileChooser(path);
                openFile.setDialogTitle("Open a Perl Script:");
                openFile.setApproveButtonText("Open script");
                openFile.setFileSelectionMode(0);
                openFile.addChoosableFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        String extension = FilenameUtils.getExtension((String)f.getName());
                        return "pm".equalsIgnoreCase(extension) || "pl".equalsIgnoreCase(extension) || "cgi".equalsIgnoreCase(extension);
                    }

                    @Override
                    public String getDescription() {
                        return "Perl scripts";
                    }
                });
                int doOpen = openFile.showOpenDialog(null);
                if (doOpen == 0) {
                    PerlMoSeSPanel.this.propertyChannel.fire(PM_FILE_ACTION_OPEN, openFile.getSelectedFile().getPath());
                }
            }
        });
        this.editorSaveButton = new JButton("Save", this.saveFileIcon);
        this.editorSaveButton.setIcon(this.saveFileIcon);
        this.editorSaveButton.setDisabledIcon(this.saveFileIconDis);
        this.editorSaveButton.setVerticalTextPosition(3);
        this.editorSaveButton.setHorizontalTextPosition(0);
        this.editorSaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerlMoSeSPanel.this.propertyChannel.fire(PM_FILE_ACTION_SAVE, "");
            }
        });
        this.editorCloseButton = new JButton("Close", this.closeFileIcon);
        this.editorCloseButton.setIcon(this.closeFileIcon);
        this.editorCloseButton.setDisabledIcon(this.closeFileIconDis);
        this.editorCloseButton.setVerticalTextPosition(3);
        this.editorCloseButton.setHorizontalTextPosition(0);
        this.editorCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerlMoSeSPanel.this.propertyChannel.fire(PM_FILE_ACTION_CLOSE, "");
            }
        });
        this.editorOpenButton.setEnabled(true);
        this.editorCloseButton.setEnabled(false);
        this.editorSaveButton.setEnabled(false);
        toolbar.add(this.editorOpenButton);
        toolbar.add(this.editorSaveButton);
        toolbar.add(this.editorCloseButton);
        toolbar.addSeparator();
        toolbar.add(label);
        toolbar.addSeparator();
        toolbar.add(this.fonts);
        toolbar.addSeparator();
        toolbar.add(zoomInButton);
        toolbar.add(zoomOutButton);
        toolbar.add(Box.createGlue());
        Box b = Box.createHorizontalBox();
        SwingUtils.addComponent((JComponent)b, (Component)toolbar, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        return b;
    }

    private JRadioButton createHowToButton(String title, String howTo) {
        JRadioButton radio = new JRadioButton(title);
        radio.setActionCommand(howTo);
        radio.addActionListener(this.howToListener);
        if (!howTo.equals(PM_CGI) && !howTo.equals(PM_ASYNC)) {
            radio.setSelected(true);
            radio.setEnabled(true);
            this.propertyChannel.put(PM_CGI, (Object)false);
            this.propertyChannel.put(PM_CGI_ASYNC, (Object)false);
            this.propertyChannel.put(PM_ASYNC, (Object)false);
        }
        return radio;
    }

    private JPanel getServicesSelectionPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(PerlMoSeSPanel.createFatBorder("Select services to work with", GraphColours.getColour("cadetblue", Color.blue)));
        ServicesBoard servicesBoard = new ServicesBoard(this.registryModel, this.console, this.propertyChannel, new CustomServicesTree(this.registryModel, this.console));
        servicesBoard.updateTree(1);
        JPanel counters = new JPanel(new GridBagLayout());
        JLabel lASelected = new JLabel(" selected authorities");
        this.aSelectedCount = new JLabel("0");
        this.aSelectedCount.setHorizontalAlignment(4);
        JLabel lSSelected = new JLabel(" selected services");
        this.sSelectedCount = new JLabel("0");
        this.sSelectedCount.setHorizontalAlignment(4);
        SwingUtils.addComponent((JComponent)counters, (Component)this.aSelectedCount, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)counters, (Component)lASelected, (int)1, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)counters, (Component)this.sSelectedCount, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)counters, (Component)lSSelected, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)servicesBoard, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        SwingUtils.addComponent((JComponent)p, (Component)counters, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        return p;
    }

    private JCheckBox createActionBox(String title, final String preferenceKey) {
        boolean initValue = this.getPrefValue(preferenceKey, true);
        this.propertyChannel.put(preferenceKey, new Boolean(initValue).toString());
        return PerlMoSeSPanel.createCheckBox(title, initValue, -1, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() == 1;
                PerlMoSeSPanel.this.setPrefValue(preferenceKey, enabled);
                PerlMoSeSPanel.this.propertyChannel.put(preferenceKey, new Boolean(enabled).toString());
            }
        });
    }

    private void onUpdateDatatypeCache() {
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;
            boolean updateFailed = false;

            @Override
            public Object construct() {
                if (PerlMoSeSPanel.this.generateBtn != null) {
                    PerlMoSeSPanel.this.generateBtn.setEnabled(false);
                }
                PerlMoSeSPanel.this.propertyChannel.fire("status-msg", "Synchronizing Perl-MoSeS Datatype Cache...");
                PerlMoSeSPanel.this.console.setEnabledAppendMode(false);
                ArrayList<String> command = new ArrayList<String>();
                StringBuffer inputstream = new StringBuffer();
                StringBuffer errorstream = new StringBuffer();
                try {
                    for (int x = 0; x < 2; ++x) {
                        inputstream = new StringBuffer();
                        errorstream = new StringBuffer();
                        command = new ArrayList();
                        command.addAll(PerlMoSeSPanel.this.generatePerlPrefix());
                        String s = command.size() > 0 ? (String)command.remove(command.size() - 1) : "";
                        command.add(PerlMoSeSPanel.this.is_windows_pc ? "moses-generate-datatypes.bat" : s + "moses-generate-datatypes.pl");
                        command.add("-R");
                        command.add(PerlMoSeSPanel.this.propertyChannel.getString("dp-registry-endpoint"));
                        command.add(this.updateFailed ? "-f" : "-u");
                        String[] com = command.toArray(new String[0]);
                        Process p = Runtime.getRuntime().exec(com);
                        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            inputstream.append(line + System.getProperty("line.separator"));
                        }
                        BufferedReader errorBr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        line = null;
                        while ((line = errorBr.readLine()) != null) {
                            errorstream.append(line + System.getProperty("line.separator"));
                        }
                        p.waitFor();
                        if (inputstream.toString().indexOf(PerlMoSeSPanel.this.DATATYPE_CACHE_DOESNT_EXIST) > 0 || errorstream.toString().indexOf(PerlMoSeSPanel.this.DATATYPE_CACHE_DOESNT_EXIST) > 0) {
                            this.updateFailed = true;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    this.exception = new MobyException("There was a problem synchronizing the datatype cache(x001):\n" + ioe.getMessage(), (Throwable)ioe);
                }
                catch (InterruptedException ie) {
                    this.exception = new MobyException("There was a problem synchronizing the datatype cache(x002)\n: + ie.getMessage()", (Throwable)ie);
                }
                PerlMoSeSPanel.this.console.setText(inputstream.toString());
                PerlMoSeSPanel.this.console.setText(errorstream.toString());
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error("Problem executing 'moses-generate-datatypes.pl'", (Exception)((Object)this.exception));
                }
                PerlMoSeSPanel.this.console.setEnabledAppendMode(true);
                PerlMoSeSPanel.this.propertyChannel.fire("status-msg", "Synchronization of Perl-MoSeS Datatype Cache Complete");
                PerlMoSeSPanel.this.propertyChannel.put(PM_SYNC_DATATYPES, new Boolean(false));
                if (!PerlMoSeSPanel.this.propertyChannel.getBoolean(PM_SYNC_DATATYPES, false) && !PerlMoSeSPanel.this.propertyChannel.getBoolean(PM_SYNC_SERVICES, false)) {
                    PerlMoSeSPanel.this.generateBtn.setEnabled(true);
                }
            }
        };
        worker.start();
    }

    private void onUpdateServiceCache() {
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;
            boolean updateFailed = false;

            @Override
            public Object construct() {
                PerlMoSeSPanel.this.propertyChannel.fire("status-msg", "Synchronizing Perl-MoSeS Service Cache...");
                PerlMoSeSPanel.this.generateBtn.setEnabled(false);
                PerlMoSeSPanel.this.console.setEnabledAppendMode(false);
                ArrayList<String> command = new ArrayList<String>();
                StringBuffer inputstream = new StringBuffer();
                StringBuffer errorstream = new StringBuffer();
                try {
                    for (int x = 0; x < 2; ++x) {
                        inputstream = new StringBuffer();
                        errorstream = new StringBuffer();
                        command = new ArrayList();
                        command.addAll(PerlMoSeSPanel.this.generatePerlPrefix());
                        String s = command.size() > 0 ? (String)command.remove(command.size() - 1) : "";
                        command.add(PerlMoSeSPanel.this.is_windows_pc ? "moses-generate-services.bat" : s + "moses-generate-services.pl");
                        command.add("-R");
                        command.add(PerlMoSeSPanel.this.propertyChannel.getString("dp-registry-endpoint"));
                        command.add(this.updateFailed ? "-f" : "-u");
                        String[] com = command.toArray(new String[0]);
                        Process p = Runtime.getRuntime().exec(com);
                        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            inputstream.append(line + System.getProperty("line.separator"));
                        }
                        BufferedReader errorBr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        line = null;
                        while ((line = errorBr.readLine()) != null) {
                            errorstream.append(line + System.getProperty("line.separator"));
                        }
                        p.waitFor();
                        if (inputstream.toString().indexOf(PerlMoSeSPanel.this.SERVICE_CACHE_DOESNT_EXIST) > 0 || errorstream.toString().indexOf(PerlMoSeSPanel.this.SERVICE_CACHE_DOESNT_EXIST) > 0) {
                            this.updateFailed = true;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    this.exception = new MobyException("There was a problem synchronizing the service cache(x001):\n" + ioe.getMessage(), (Throwable)ioe);
                }
                catch (InterruptedException ie) {
                    this.exception = new MobyException("There was a problem synchronizing the service cache(x002):\n" + ie.getMessage(), (Throwable)ie);
                }
                PerlMoSeSPanel.this.console.setText(inputstream.toString());
                PerlMoSeSPanel.this.console.setText(errorstream.toString());
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error("Problem executing 'moses-generate-services.pl'", (Exception)((Object)this.exception));
                }
                PerlMoSeSPanel.this.console.setEnabledAppendMode(true);
                PerlMoSeSPanel.this.propertyChannel.put(PM_SYNC_SERVICES, new Boolean(false));
                PerlMoSeSPanel.this.propertyChannel.fire("status-msg", "Synchronization of Perl-MoSeS Service Cache Complete");
                if (!PerlMoSeSPanel.this.propertyChannel.getBoolean(PM_SYNC_DATATYPES, false) && !PerlMoSeSPanel.this.propertyChannel.getBoolean(PM_SYNC_SERVICES, false)) {
                    PerlMoSeSPanel.this.generateBtn.setEnabled(true);
                }
            }
        };
        worker.start();
    }

    private void onGenerateFromAuthority() {
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;

            @Override
            public Object construct() {
                Vector services = (Vector)PerlMoSeSPanel.this.propertyChannel.get("selectedAuthorities");
                for (String authority : services) {
                    PerlMoSeSPanel.this.propertyChannel.fire("status-msg", "Processing service provider '" + authority + "' ...");
                    PerlMoSeSPanel.this.console.setEnabledAppendMode(false);
                    ArrayList<String> command = new ArrayList<String>();
                    command = new ArrayList();
                    command.addAll(PerlMoSeSPanel.this.generatePerlPrefix());
                    String s = command.size() > 0 ? (String)command.remove(command.size() - 1) : "";
                    try {
                        command.add(PerlMoSeSPanel.this.is_windows_pc ? "moses-generate-services.bat" : s + "moses-generate-services.pl");
                        if (Boolean.parseBoolean(PerlMoSeSPanel.this.propertyChannel.getString(PM_OVERWRITE))) {
                            command.add("-F");
                        }
                        command.add("-R");
                        command.add(PerlMoSeSPanel.this.propertyChannel.getString("dp-registry-endpoint"));
                        if (Boolean.parseBoolean(PerlMoSeSPanel.this.propertyChannel.getString(PM_CGI))) {
                            command.add("-c");
                        } else if (Boolean.parseBoolean(PerlMoSeSPanel.this.propertyChannel.getString(PM_ASYNC))) {
                            command.add("-A");
                        } else if (Boolean.parseBoolean(PerlMoSeSPanel.this.propertyChannel.getString(PM_CGI_ASYNC))) {
                            command.add("-C");
                        }
                        command.add(authority);
                        String[] com = command.toArray(new String[0]);
                        Process p = Runtime.getRuntime().exec(com);
                        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            PerlMoSeSPanel.this.console.setText(line + System.getProperty("line.separator"));
                        }
                        BufferedReader errorBr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        line = null;
                        while ((line = errorBr.readLine()) != null) {
                            PerlMoSeSPanel.this.console.setText(line + System.getProperty("line.separator"));
                        }
                        p.waitFor();
                    }
                    catch (IOException ioe) {
                        this.exception = new MobyException("There was a problem generating MoSeS skeletons for '" + authority + "'(x001):\n" + ioe.getMessage(), (Throwable)ioe);
                    }
                    catch (InterruptedException ie) {
                        this.exception = new MobyException("There was a problem generating MoSeS skeletons for '" + authority + "'(x002):\n" + ie.getMessage(), (Throwable)ie);
                    }
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error("Problem executing 'moses-generate-services.pl'", (Exception)((Object)this.exception));
                }
                PerlMoSeSPanel.this.console.setEnabledAppendMode(true);
                PerlMoSeSPanel.this.propertyChannel.put(PM_GENERATING_BY_AUTHORITY, new Boolean(false));
                if (!PerlMoSeSPanel.this.propertyChannel.getBoolean(PM_GENERATING_BY_AUTHORITY, false) && !PerlMoSeSPanel.this.propertyChannel.getBoolean(PM_GENERATING_SPECIFIC_SERVICES, false)) {
                    PerlMoSeSPanel.this.generateBtn.setEnabled(true);
                    PerlMoSeSPanel.this.propertyChannel.fire("status-msg", "Generating Perl-MoSeS service skeletons complete!");
                    PerlMoSeSPanel.this.propertyChannel.fire(PM_INFORMATION, "Processing of selected service completed! Any errors encountered should be reported above.");
                }
            }
        };
        worker.start();
    }

    private void onGenerateSpecificService() {
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;

            @Override
            public Object construct() {
                Vector services = (Vector)PerlMoSeSPanel.this.propertyChannel.get("selectedServices");
                for (String str : services) {
                    String[] parts = str.split("/", 2);
                    if (parts.length != 2) continue;
                    String auth = parts[1];
                    String name = parts[0];
                    PerlMoSeSPanel.this.propertyChannel.fire("status-msg", "Processing service '" + name + "' provided by '" + auth + "' ...");
                    PerlMoSeSPanel.this.console.setEnabledAppendMode(false);
                    ArrayList<String> command = new ArrayList<String>();
                    command.addAll(PerlMoSeSPanel.this.generatePerlPrefix());
                    String s = command.size() > 0 ? (String)command.remove(command.size() - 1) : "";
                    try {
                        command.add(PerlMoSeSPanel.this.is_windows_pc ? "moses-generate-services.bat" : s + "moses-generate-services.pl");
                        if (Boolean.parseBoolean(PerlMoSeSPanel.this.propertyChannel.getString(PM_OVERWRITE))) {
                            command.add("-F");
                        }
                        command.add("-R");
                        command.add(PerlMoSeSPanel.this.propertyChannel.getString("dp-registry-endpoint"));
                        if (Boolean.parseBoolean(PerlMoSeSPanel.this.propertyChannel.getString(PM_CGI))) {
                            command.add("-c");
                        } else if (Boolean.parseBoolean(PerlMoSeSPanel.this.propertyChannel.getString(PM_ASYNC))) {
                            command.add("-A");
                        } else if (Boolean.parseBoolean(PerlMoSeSPanel.this.propertyChannel.getString(PM_CGI_ASYNC))) {
                            command.add("-C");
                        }
                        command.add(auth);
                        command.add(name);
                        String[] com = command.toArray(new String[0]);
                        Process p = Runtime.getRuntime().exec(com);
                        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            PerlMoSeSPanel.this.console.setText(line + System.getProperty("line.separator"));
                        }
                        BufferedReader errorBr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        line = null;
                        while ((line = errorBr.readLine()) != null) {
                            PerlMoSeSPanel.this.console.setText(line + System.getProperty("line.separator"));
                        }
                        p.waitFor();
                    }
                    catch (IOException ioe) {
                        this.exception = new MobyException("There was a problem generating service skeleton for service '" + name + "' provided by '" + auth + "' (x001):\n" + ioe.getMessage(), (Throwable)ioe);
                    }
                    catch (InterruptedException ie) {
                        this.exception = new MobyException("There was a problem generating service skeleton for service '" + name + "' provided by '" + auth + "' (x002):\n" + ie.getMessage(), (Throwable)ie);
                    }
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error("Problem executing 'moses-generate-services.pl'", (Exception)((Object)this.exception));
                }
                PerlMoSeSPanel.this.console.setEnabledAppendMode(true);
                PerlMoSeSPanel.this.propertyChannel.put(PM_GENERATING_SPECIFIC_SERVICES, new Boolean(false));
                if (!PerlMoSeSPanel.this.propertyChannel.getBoolean(PM_GENERATING_BY_AUTHORITY, false) && !PerlMoSeSPanel.this.propertyChannel.getBoolean(PM_GENERATING_SPECIFIC_SERVICES, false)) {
                    PerlMoSeSPanel.this.generateBtn.setEnabled(true);
                    PerlMoSeSPanel.this.propertyChannel.fire("status-msg", "Generating Perl-MoSeS service skeletons complete!");
                    PerlMoSeSPanel.this.propertyChannel.fire(PM_INFORMATION, "Processing of selected service completed! Any errors encountered should be reported above.");
                }
            }
        };
        worker.start();
    }

    private void doOpenFile(String name) {
        File f = new File(name);
        if (f.isDirectory()) {
            PerlMoSeSPanel.error("The file '" + f.getAbsolutePath() + "' is not a file, but a directory.\nPlease choose a file!");
            return;
        }
        if (!f.canRead()) {
            PerlMoSeSPanel.error("The file '" + f.getAbsolutePath() + "' is not readable ...");
            return;
        }
        if (!f.canWrite()) {
            PerlMoSeSPanel.error("The file '" + f.getAbsolutePath() + "' is not writable ...");
            return;
        }
        try {
            StringBuilder sb = new StringBuilder();
            BufferedReader br = new BufferedReader(new FileReader(f));
            String newline = System.getProperty("line.separator");
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + newline);
            }
            this.propertyChannel.put(PM_FILE_CURRENT_CHECKSUM, this.getMD5Checksum(sb.toString()));
            editorTextPane.setText(sb.toString());
            this.currentlyEditing.setText("Editing: " + f.getAbsolutePath());
            this.currentPosition.setText("");
            editorTextPane.setCaretPosition(0);
            editorTextPane.setEditable(true);
            this.editorCloseButton.setEnabled(true);
            this.editorSaveButton.setEnabled(true);
            this.editorOpenButton.setEnabled(false);
        }
        catch (Exception e) {
            PerlMoSeSPanel.error("There were problems opening the file!", e);
        }
        this.fonts.setSelectedItem(editorTextPane.getFont().getFamily());
        this.propertyChannel.put(PM_FILE_CURRENT, name);
        this.propertyChannel.put(PM_FILE_LAST_DIRECTORY, f.getParent());
    }

    private void doCloseFile() {
        String text = editorTextPane.getText();
        String checksum = this.getMD5Checksum(text);
        if (!checksum.equals(this.propertyChannel.getString(PM_FILE_CURRENT_CHECKSUM)) && JOptionPane.showConfirmDialog(null, "File has changed. Shall we save it?", "Save the file?", 0) == 0) {
            this.doSaveFile();
        }
        editorTextPane.setText("");
        this.currentlyEditing.setText("");
        this.currentPosition.setText("");
        editorTextPane.setEditable(false);
        this.editorCloseButton.setEnabled(false);
        this.editorSaveButton.setEnabled(false);
        this.editorOpenButton.setEnabled(true);
    }

    private void doSaveFile() {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.propertyChannel.getString(PM_FILE_CURRENT)));
            out.write(editorTextPane.getText());
            out.close();
            this.propertyChannel.put(PM_FILE_CURRENT_CHECKSUM, this.getMD5Checksum(editorTextPane.getText()));
        }
        catch (IOException e) {
            PerlMoSeSPanel.error("There was a problem saving to the file!", e);
        }
    }

    private String getMD5Checksum(String text) {
        MessageDigest complete;
        try {
            complete = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
        byte[] b = complete.digest(text.getBytes());
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    private class CustomServicesTree
    extends ServicesTree {
        private static final long serialVersionUID = 1L;

        public CustomServicesTree(RegistryModel model, CommonConsole console) {
            super(model, console);
            this.getSelectionModel().setSelectionMode(4);
        }

        @Override
        protected void createPopups(String title) {
            super.createPopups(title);
            this.removeFromPopups("ac-reload");
            this.removeSeparatorAfter("ac-collapse");
        }

        @Override
        protected void selected(DefaultMutableTreeNode node) {
            String name;
            if (node == null) {
                this.console.setText("Nothing selected\n");
                PerlMoSeSPanel.this.setPrefValue("selectedAuthorities", "");
                this.propertyChannel.remove("selectedAuthorities");
                PerlMoSeSPanel.this.setPrefValue("selectedServices", "");
                this.propertyChannel.remove("selectedServices");
                PerlMoSeSPanel.this.aSelectedCount.setText("0");
                PerlMoSeSPanel.this.sSelectedCount.setText("0");
                return;
            }
            TreePath[] paths = this.getSelectionModel().getSelectionPaths();
            if (paths == null) {
                return;
            }
            Vector<String> a = new Vector<String>();
            Vector<String> s = new Vector<String>();
            for (int i = 0; i < paths.length; ++i) {
                DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                Object uo = aNode.getUserObject();
                if (!(uo instanceof CommonNode)) continue;
                int nodeType = ((CommonNode)uo).getType();
                if (nodeType == 15) {
                    if (aNode.isLeaf()) continue;
                    a.addElement(((CommonNode)uo).getValue());
                    Enumeration<TreeNode> en = aNode.children();
                    while (en.hasMoreElements()) {
                        Object uo2 = ((DefaultMutableTreeNode)en.nextElement()).getUserObject();
                        if (!(uo2 instanceof CommonNode)) continue;
                        System.out.println(((CommonNode)uo2).getValue());
                    }
                    continue;
                }
                if (nodeType != 14) continue;
                s.addElement(((CommonNode)uo).getValue());
                System.out.println((String)s.lastElement());
            }
            StringBuffer conBuf = new StringBuffer(100);
            StringBuffer prefBufA = new StringBuffer(100);
            StringBuffer prefBufS = new StringBuffer(100);
            if (a.size() > 0) {
                conBuf.append("Selected authorities:\n");
                Enumeration en = a.elements();
                while (en.hasMoreElements()) {
                    name = en.nextElement().toString();
                    conBuf.append("\t");
                    conBuf.append(name);
                    conBuf.append("\n");
                    if (prefBufA.length() > 0) {
                        prefBufA.append("|");
                    }
                    prefBufA.append(name);
                }
                this.propertyChannel.put("selectedAuthorities", a);
            } else {
                this.propertyChannel.remove("selectedAuthorities");
            }
            PerlMoSeSPanel.this.setPrefValue("selectedAuthorities", new String(prefBufA));
            PerlMoSeSPanel.this.aSelectedCount.setText("" + a.size());
            if (s.size() > 0) {
                conBuf.append("Selected services:\n");
                Enumeration en = s.elements();
                while (en.hasMoreElements()) {
                    name = en.nextElement().toString();
                    conBuf.append("\t");
                    conBuf.append(name);
                    conBuf.append("\n");
                    if (prefBufS.length() > 0) {
                        prefBufS.append("|");
                    }
                    prefBufS.append(name);
                }
                this.propertyChannel.put("selectedServices", s);
            } else {
                this.propertyChannel.remove("selectedServices");
            }
            PerlMoSeSPanel.this.setPrefValue("selectedServices", new String(prefBufS));
            PerlMoSeSPanel.this.sSelectedCount.setText("" + s.size());
            if (conBuf.length() > 0) {
                this.console.setText(new String(conBuf));
            } else {
                this.console.setText("Nothing selected\n");
            }
        }
    }
}

