/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.CommonNode;
import org.biomoby.service.dashboard.CommonTree;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyNamespace;
import org.tulsoft.shared.UUtils;

public class NamespacesTree
extends CommonTree {
    private static Log log = LogFactory.getLog(NamespacesTree.class);
    RegistryModel registryModel;
    CommonConsole console;
    static final String NAMESPACES_ACCESS_ERROR = "An error happened when accessing a list of available namespaces.\n\nCheck please values in text fields (in Registry Browser)\nspecifying registry endpoint and namespace, and in the\none specifying directory used as a local cache. Then\nright-click in the data types area and select 'Reload'.\n\n";

    public NamespacesTree(RegistryModel registryModel, CommonConsole console) {
        super("Namespaces");
        this.registryModel = registryModel;
        this.console = console;
        this.createPopups("Namespaces Menu");
        this.setLeafIcon(nsLeafIcon);
    }

    @Override
    protected void createPopups(String title) {
        super.createPopups(title);
        this.addSortingItems();
    }

    @Override
    public void update(int howSorted, Object newData) {
        if (howSorted < 0) {
            howSorted = this.lastSorted;
        }
        this.lastSorted = howSorted;
        this.setEnabledPopup(false);
        final NamespacesTree source = this;
        final int sorted = howSorted;
        final MobyNamespace[] newNamespaces = newData == null ? null : (MobyNamespace[])newData;
        SwingWorker worker = new SwingWorker(){
            MobyException updateException = null;
            MobyNamespace[] namespaces = null;

            @Override
            public Object construct() {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Tree " + NamespacesTree.this.treeId + " update request. Sorted: " + sorted + ", Data: " + newNamespaces));
                    }
                    this.namespaces = newNamespaces == null ? NamespacesTree.this.registryModel.getNamespaces(source) : newNamespaces;
                }
                catch (MobyException e) {
                    this.updateException = e;
                }
                return this.namespaces;
            }

            @Override
            public void finished() {
                if (this.updateException != null) {
                    CommonTree.error(NamespacesTree.NAMESPACES_ACCESS_ERROR, (Exception)((Object)this.updateException));
                }
                if (this.namespaces != null) {
                    if (sorted == 1) {
                        NamespacesTree.this.onUpdateNamespacesTreeByAuth(this.namespaces);
                    } else {
                        NamespacesTree.this.onUpdateNamespacesTree(this.namespaces);
                    }
                    if (this.namespaces.length > 0) {
                        NamespacesTree.this.setEnabledPopup(true);
                        boolean sortedByName = sorted == 0;
                        NamespacesTree.this.setEnabledPopupItem("ac-expand", !sortedByName);
                        NamespacesTree.this.setEnabledPopupItem("ac-collapse", !sortedByName);
                    }
                }
            }
        };
        worker.start();
    }

    void onUpdateNamespacesTree(MobyNamespace[] theNamespaces) {
        Object[] namespaces = this.copy(theNamespaces);
        Arrays.sort(namespaces);
        DefaultTreeModel tModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tModel.getRoot();
        root.removeAllChildren();
        for (int i = 0; i < namespaces.length; ++i) {
            String thisName = namespaces[i].getName();
            root.add(new DefaultMutableTreeNode(new CommonNode(thisName, 12)));
        }
        tModel.reload();
    }

    void onUpdateNamespacesTreeByAuth(MobyNamespace[] theNamespaces) {
        MobyNamespace[] namespaces = this.copy(theNamespaces);
        Arrays.sort(namespaces, MobyNamespace.getAuthorityComparator());
        DefaultTreeModel tModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tModel.getRoot();
        root.removeAllChildren();
        HashMap<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>(namespaces.length);
        for (int i = 0; i < namespaces.length; ++i) {
            DefaultMutableTreeNode authNode;
            String authority;
            String thisName = namespaces[i].getName();
            DefaultMutableTreeNode thisNode = (DefaultMutableTreeNode)nodes.get(thisName);
            if (thisNode == null) {
                thisNode = new DefaultMutableTreeNode(new CommonNode(thisName, 12));
                nodes.put(thisName, thisNode);
            }
            if (UUtils.isEmpty((String)(authority = namespaces[i].getAuthority()))) {
                authority = "<unknown>";
            }
            if ((authNode = (DefaultMutableTreeNode)nodes.get(authority)) == null) {
                authNode = new DefaultMutableTreeNode(new CommonNode(authority, 15));
                nodes.put(authority, authNode);
                root.add(authNode);
            }
            authNode.add(thisNode);
        }
        tModel.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MobyNamespace[] copy(MobyNamespace[] s) {
        MobyNamespace[] mobyNamespaceArray = s;
        synchronized (s) {
            MobyNamespace[] result = new MobyNamespace[s.length];
            System.arraycopy(s, 0, result, 0, s.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    @Override
    protected void reload() {
        this.update(this.lastSorted, null);
    }

    @Override
    protected void search(String searchText) {
        final String regex = searchText;
        SwingWorker worker = new SwingWorker(){
            HashSet found = new HashSet();

            @Override
            public Object construct() {
                try {
                    if (UUtils.notEmpty((String)regex)) {
                        this.found = NamespacesTree.this.registryModel.findInNamespaces(regex);
                    }
                }
                catch (MobyException e) {
                    CommonTree.error(NamespacesTree.NAMESPACES_ACCESS_ERROR, (Exception)((Object)e));
                }
                return this.found;
            }

            @Override
            public void finished() {
                if (this.found != null) {
                    NamespacesTree.this.highlightAndJumpTo(this.found);
                }
            }
        };
        worker.start();
    }

    @Override
    protected void selected(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        final CommonNode nodeObject = (CommonNode)node.getUserObject();
        SwingWorker worker = new SwingWorker(){
            MobyNamespace namespace;

            @Override
            public Object construct() {
                try {
                    this.namespace = NamespacesTree.this.registryModel.getNamespace(nodeObject.getValue());
                }
                catch (MobyException e) {
                    CommonTree.error(NamespacesTree.NAMESPACES_ACCESS_ERROR, (Exception)((Object)e));
                }
                return this.namespace;
            }

            @Override
            public void finished() {
                if (this.namespace != null) {
                    NamespacesTree.this.console.setText(this.namespace.toString() + "\n");
                }
            }
        };
        worker.start();
    }
}

