/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.CommonBoard;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.CommonTree;
import org.biomoby.service.dashboard.NamespacesTree;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.event.NotificationEvent;

public class NamespacesBoard
extends CommonBoard {
    private static Log log = LogFactory.getLog(NamespacesBoard.class);

    public NamespacesBoard(RegistryModel model, CommonConsole console, PropertyChannel channel) {
        this(model, console, channel, new NamespacesTree(model, console));
    }

    public NamespacesBoard(RegistryModel model, CommonConsole console, PropertyChannel channel, CommonTree customTree) {
        super(model, channel);
        this.tree = customTree;
        this.tree.setPropertyChannel(channel);
        this.createItself();
        this.model.addNotificationListener(this);
    }

    @Override
    public void notified(NotificationEvent event) {
        switch (event.getType()) {
            case 10: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.boardId + "-" + event.toString()));
                }
                this.createProgressBar(4);
                this.insertProgressBar();
                break;
            }
            case 11: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.boardId + "-" + event.toString()));
                }
                if (!(event.getMessage() instanceof Integer)) break;
                this.calibrateProgressBar((Integer)event.getMessage());
                break;
            }
            case 12: {
                this.channel.fire(this, "status-msg", event.getMessage());
                break;
            }
            case 13: {
                this.addToProgressBar();
                break;
            }
            case 14: 
            case 22: 
            case 26: {
                Object initiator;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.boardId + "-" + event.toString()));
                }
                if (this.tree == (initiator = event.getSource())) {
                    this.channel.fire(this, "status-msg", "Done");
                }
                this.removeProgressBar();
                break;
            }
            case 30: {
                Object initiator;
                this.removeProgressBar();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.boardId + "-" + event.toString()));
                }
                if (this.tree == (initiator = event.getSource())) break;
                this.tree.update(-1, (MobyNamespace[])event.getDetails());
            }
        }
    }
}

