/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import com.hp.hpl.jena.rdf.model.Model;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.client.rdf.builder.ServiceInstanceRDF;
import org.biomoby.registry.meta.Registry;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.CommonNode;
import org.biomoby.service.dashboard.DashboardConfig;
import org.biomoby.service.dashboard.GraphColours;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.ServicesBoard;
import org.biomoby.service.dashboard.ServicesTree;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.service.dashboard.UnitTestingResultPanel;
import org.biomoby.service.dashboard.UnitTestingServiceCallermodel;
import org.biomoby.service.dashboard.data.DataContainer;
import org.biomoby.service.dashboard.data.ServiceInputPanel;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.MobyUnitTest;
import org.biomoby.shared.Utils;
import org.biomoby.shared.extended.ServiceInstanceParser;
import org.tulsoft.shared.PrefsUtils;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.gui.AwtUtils;
import org.tulsoft.tools.gui.JFileChooserWithHistory;
import org.tulsoft.tools.gui.JTextFieldWithHistory;
import org.tulsoft.tools.gui.SwingUtils;

public class MobyUnitTestingPanel
extends AbstractPanel {
    private static final long serialVersionUID = -370045034538998854L;
    private static Log log = LogFactory.getLog(MobyUnitTestingPanel.class);
    protected static final String P_S_TITLE_COLOR = "simpleclient.service.title.color";
    protected static final String P_S_EDIT_BGCOLOR = "simpleclient.service.edit.bgcolor";
    protected static final String INIT_SELECT = "<html><center><font color='red'>Start by selecting a service<br>that you wish to call.</font></center>";
    protected static final String CALLER_ERROR = "Sorry, an error happened when calling a service.\n\n";
    RegistryModel registryModel;
    UnitTestingServiceCallermodel callerModel;
    JLabel selService;
    JFileChooserWithHistory inFile;
    JFileChooserWithHistory rdfFile;
    JButton runButton;
    JButton stopButton;
    JButton testXpathButton;
    JButton saveRDFButton;
    JButton downloadTestButton;
    JButton testRegexButton;
    JButton testOutputButton;
    JButton copyServiceResultsButton;
    JCheckBox iFromFile;
    JFileChooser saveChooser;
    JTextFieldWithHistory endpoint;
    JTextFieldWithHistory regularExpression;
    JTextFieldWithHistory xpathExpression;
    JPanel dataTablesPanel;
    ServiceInputPanel inputDataTables;
    MySwingWorker runWorker;
    UnitTestingResultPanel results;
    JComponent resultsComp;
    JSplitPane resSplit;
    JTextArea regularExpressionMatchingText;
    protected static Icon runIcon;
    protected static Icon runIconDis;
    protected static Icon saveIcon;
    protected static Icon saveIconDis;
    protected static Icon loadIcon;
    protected static Icon loadIconDis;
    protected static Icon testOutputIcon;
    protected static Icon testOutputIconDis;
    protected static Icon copyIcon;
    protected static Icon copyIconDis;
    protected static Icon stopIcon;
    protected static Icon stopIconDis;
    protected static Icon addDataIcon;
    protected static Icon addDataIconDis;
    private Color default_button_color;
    private String serviceOutput = "";
    private static EditableConsole serviceOutputConsole;
    static final String UT_REGULAR_EXPRESSION = "ut-regular-expression";
    static final String UT_XPATH_EXPRESSION = "ut-xpath-expression";
    static final String UT_SC_SERVICE = "ut-sc-service";
    static final String UT_SC_SERVICE_NAME = "ut-sc-service-name";
    static final String UT_SC_INPUT_FILE = "ut-service-input-file";
    static final String UT_SC_IN_FILE = "ut-service-in-file";
    static final String UT_INPUT_FILE = "ut-input-file";
    static final String UT_SC_RDF_OUTPUT_FILE = "ut-service-output-file";
    static final String UT_RDF_OUTPUT_FILE = "ut-rdf-output-file-name";
    private ActionListener howToListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String howTo = e.getActionCommand();
            MobyUnitTestingPanel.this.setPrefValue("howToCallService", howTo);
            MobyUnitTestingPanel.this.propertyChannel.put("howToCallService", howTo);
            MobyUnitTestingPanel.this.endpoint.setEnabled(howTo.equals("service-new-endpoint"));
        }
    };

    public MobyUnitTestingPanel() {
        this.panelIconFileName = "images/unitTest.gif";
        this.saveChooser = new JFileChooser();
        this.saveChooser.setDialogTitle("Save Biomoby Service Input");
    }

    @Override
    protected void loadIcons() {
        super.loadIcons();
        if (runIcon == null) {
            runIcon = MobyUnitTestingPanel.loadIcon("images/smallRun.gif");
        }
        if (runIconDis == null) {
            runIconDis = MobyUnitTestingPanel.loadIcon("images/smallRun_dis.gif");
        }
        if (stopIcon == null) {
            stopIcon = MobyUnitTestingPanel.loadIcon("images/smallCancel.gif");
        }
        if (stopIconDis == null) {
            stopIconDis = MobyUnitTestingPanel.loadIcon("images/smallCancel_dis.gif");
        }
        if (addDataIcon == null) {
            addDataIcon = MobyUnitTestingPanel.loadIcon("images/smallAnnotate.gif");
        }
        if (addDataIconDis == null) {
            addDataIconDis = MobyUnitTestingPanel.loadIcon("images/smallAnnonate_dis.gif");
        }
        if (saveIcon == null) {
            saveIcon = MobyUnitTestingPanel.loadIcon("images/smallSave.gif");
        }
        if (saveIconDis == null) {
            saveIconDis = MobyUnitTestingPanel.loadIcon("images/smallSave_dis.gif");
        }
        if (loadIcon == null) {
            loadIcon = MobyUnitTestingPanel.loadIcon("images/smallDeploy.gif");
        }
        if (loadIconDis == null) {
            loadIconDis = MobyUnitTestingPanel.loadIcon("images/smallDeploy_dis.gif");
        }
        if (copyIcon == null) {
            copyIcon = MobyUnitTestingPanel.loadIcon("images/smallClone.gif");
        }
        if (copyIconDis == null) {
            copyIconDis = MobyUnitTestingPanel.loadIcon("images/smallClone_dis.gif");
        }
        if (testOutputIcon == null) {
            testOutputIcon = MobyUnitTestingPanel.loadIcon("images/smallAgent.gif");
        }
        if (testOutputIconDis == null) {
            testOutputIconDis = MobyUnitTestingPanel.loadIcon("images/smallAgent_dis.gif");
        }
    }

    @Override
    public JComponent getComponent(PropertyChannel aPropertyChannel) {
        this.setPropertyChannel(aPropertyChannel);
        this.registryModel = this.createRegistryModel();
        this.callerModel = new UnitTestingServiceCallermodel();
        this.callerModel.setPropertyChannel(aPropertyChannel);
        if (this.pComponent != null) {
            return this.pComponent;
        }
        this.pComponent = new JPanel(new GridBagLayout(), true);
        this.results = new UnitTestingResultPanel();
        this.resultsComp = this.results.getComponent(aPropertyChannel);
        JPanel controls = this.getControlPanel();
        JPanel inputData = this.getInputPanel();
        this.updateInputDataPanel(INIT_SELECT);
        JPanel expressionPanel = new JPanel(new GridBagLayout());
        expressionPanel.setBorder(MobyUnitTestingPanel.createFatBorder("Moby Unit Test Cases", GraphColours.getColour("cadetblue", Color.blue)));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("XPath Tester", null, this.getXpathSubpanel());
        tabbedPane.addTab("Regex Tester", null, this.getRegexSubpanel());
        tabbedPane.addTab("Service Output XML Tester", null, this.getValidServiceOutputSubpanel());
        SwingUtils.addComponent((JComponent)expressionPanel, (Component)tabbedPane, (int)0, (int)0, (int)2, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        JPanel sBoard = new JPanel(new GridBagLayout());
        ServicesBoard servicesBoard = new ServicesBoard(this.registryModel, null, this.propertyChannel, new CustomServicesTree(this.registryModel, null));
        log.debug((Object)"Services tree update started");
        servicesBoard.updateTree(1);
        SwingUtils.addComponent((JComponent)sBoard, (Component)servicesBoard, (int)0, (int)2, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        this.resSplit = this.vSplit(this.hSplit(controls, sBoard, 0.5), this.resultsComp, 0.1);
        JSplitPane split = this.hSplit(this.resSplit, this.vSplit(inputData, expressionPanel, 0.9), 0.5);
        SwingUtils.addComponent((JComponent)this.pComponent, (Component)split, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        String lastServiceName = this.getPrefValue(UT_SC_SERVICE_NAME, "");
        if (!"".equals(lastServiceName)) {
            this.selectService(lastServiceName);
        }
        return this.pComponent;
    }

    private Component getValidServiceOutputSubpanel() {
        JPanel panel = MobyUnitTestingPanel.createTitledPanel("Expected service output XML");
        serviceOutputConsole = new EditableConsole();
        SwingUtils.addComponent((JComponent)panel, (Component)serviceOutputConsole, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        return panel;
    }

    private Component getRegexSubpanel() {
        JPanel panel = MobyUnitTestingPanel.createTitledPanel("Regular Expression for Unit Testing");
        this.regularExpression = this.createText(null, UT_REGULAR_EXPRESSION, UT_REGULAR_EXPRESSION);
        this.regularExpressionMatchingText = new JTextArea("", 5, 5);
        JScrollPane scroll = new JScrollPane(this.regularExpressionMatchingText);
        scroll.setMinimumSize(this.regularExpressionMatchingText.getPreferredScrollableViewportSize());
        this.testRegexButton = new JButton("Test Regular Expression");
        this.testRegexButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MobyUnitTest unitTest = new MobyUnitTest();
                unitTest.setValidREGEX(MobyUnitTestingPanel.this.regularExpression.getText());
                if (unitTest.compareXmlWithREGEX(MobyUnitTestingPanel.this.serviceOutput, true)) {
                    Pattern p = Pattern.compile(unitTest.getValidREGEX(), 8);
                    Matcher m = p.matcher(MobyUnitTestingPanel.this.serviceOutput);
                    MobyUnitTestingPanel.this.regularExpressionMatchingText.setText("");
                    StringBuilder sb = new StringBuilder();
                    while (m.find()) {
                        int start = 0;
                        int stop = 0;
                        if (m.start() == 0) {
                            start = 0;
                        } else if (m.start() - 10 >= 0) {
                            start = m.start() - 10;
                        }
                        stop = m.end() + 10 >= MobyUnitTestingPanel.this.serviceOutput.length() - 1 ? MobyUnitTestingPanel.this.serviceOutput.length() - 1 : m.end() + 10;
                        sb.append("Match: " + m.group() + " in text:\n\t" + MobyUnitTestingPanel.this.serviceOutput.substring(start, stop).replaceAll("\n", "") + " @ (" + m.start() + "," + m.end() + ")\n");
                    }
                    MobyUnitTestingPanel.this.regularExpressionMatchingText.setText(sb.toString());
                } else {
                    MobyUnitTestingPanel.this.regularExpressionMatchingText.setText("No matches found");
                }
            }
        });
        this.testRegexButton.setEnabled(false);
        JPanel statusPanel = MobyUnitTestingPanel.createButtonPanel(new JButton[]{this.testRegexButton});
        SwingUtils.addComponent((JComponent)panel, (Component)new JLabel("RegEx: "), (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)panel, (Component)this.regularExpression, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)panel, (Component)new JLabel("Matching Text: "), (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)panel, (Component)scroll, (int)0, (int)3, (int)1, (int)2, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)panel, (Component)statusPanel, (int)0, (int)5, (int)1, (int)1, (int)2, (int)10, (double)1.0, (double)0.0);
        return panel;
    }

    private Component getXpathSubpanel() {
        JPanel panel = MobyUnitTestingPanel.createTitledPanel("XPath Expression for Unit Testing");
        this.xpathExpression = this.createText(null, UT_XPATH_EXPRESSION, UT_XPATH_EXPRESSION);
        this.xpathExpression.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                MobyUnitTestingPanel.this.testXpathButton.setBackground(MobyUnitTestingPanel.this.default_button_color);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                MobyUnitTestingPanel.this.testXpathButton.setBackground(MobyUnitTestingPanel.this.default_button_color);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                MobyUnitTestingPanel.this.testXpathButton.setBackground(MobyUnitTestingPanel.this.default_button_color);
            }
        });
        this.testXpathButton = new JButton("Test XPATH Expression");
        this.default_button_color = this.testXpathButton.getBackground();
        this.testXpathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MobyUnitTest unitTest = new MobyUnitTest();
                unitTest.setValidXPath(MobyUnitTestingPanel.this.xpathExpression.getText());
                boolean success = false;
                try {
                    success = unitTest.compareXmlWithXpath(MobyUnitTestingPanel.this.serviceOutput);
                }
                catch (MobyException me) {
                    AbstractPanel.error("XPath Error", (Exception)((Object)me));
                    return;
                }
                if (success) {
                    ((JButton)e.getSource()).setBackground(Color.GREEN);
                } else {
                    ((JButton)e.getSource()).setBackground(Color.RED);
                }
            }
        });
        this.testXpathButton.setEnabled(false);
        JPanel statusPanel = MobyUnitTestingPanel.createButtonPanel(new JButton[]{this.testXpathButton});
        SwingUtils.addComponent((JComponent)panel, (Component)new JLabel("XPath: "), (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)panel, (Component)this.xpathExpression, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)panel, (Component)statusPanel, (int)0, (int)2, (int)1, (int)1, (int)2, (int)10, (double)1.0, (double)0.0);
        return panel;
    }

    protected JPanel getControlPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        this.selService = new JLabel();
        this.selService.setFont(FAT_BORDER_FONT);
        this.selService.setForeground(GraphColours.getColour(DashboardConfig.getString(P_S_TITLE_COLOR, null), Color.blue));
        JPanel howTo = MobyUnitTestingPanel.createTitledPanel("Service invocation");
        this.endpoint = this.createText(null, "serviceEndpoint", "serviceEndpoint");
        ButtonGroup group = new ButtonGroup();
        JRadioButton htRegistry = this.createHowToButton("Ask registry where service is, and call it", "as-registered");
        group.add(htRegistry);
        JRadioButton htNewURL = this.createHowToButton("Use this endpoint", "service-new-endpoint");
        group.add(htNewURL);
        boolean usingAsBytes = this.getPrefValue("sendInputAsBytes", false);
        String runLabel = " Call Service ";
        this.runButton = MobyUnitTestingPanel.createButton(runLabel, "Invoke selected service", 67, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MobyService srv = (MobyService)MobyUnitTestingPanel.this.propertyChannel.get(MobyUnitTestingPanel.UT_SC_SERVICE);
                if (srv != null) {
                    MobyUnitTestingPanel.this.runWorker = new MySwingWorker(srv);
                    MobyUnitTestingPanel.this.runWorker.start();
                }
            }
        });
        this.runButton.setIcon(runIcon);
        this.runButton.setDisabledIcon(runIconDis);
        this.runButton.setEnabled(false);
        this.stopButton = MobyUnitTestingPanel.createButton(" Stop service ", "Cancel connection to a running service", 83, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MobyUnitTestingPanel.this.runWorker != null) {
                    MobyUnitTestingPanel.this.runWorker.cancel();
                }
                MobyUnitTestingPanel.this.serviceFinished();
            }
        });
        this.stopButton.setIcon(stopIcon);
        this.stopButton.setDisabledIcon(stopIconDis);
        this.stopButton.setEnabled(false);
        JPanel buttonPanel = MobyUnitTestingPanel.createButtonPanel(new JButton[]{this.runButton, this.stopButton});
        JCheckBox asBytes = MobyUnitTestingPanel.createCheckBox("Send data to service as a byte array", usingAsBytes, -1, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() == 1;
                MobyUnitTestingPanel.this.setPropertySelect(enabled, "sendInputAsBytes");
                MobyUnitTestingPanel.this.setPrefValue("sendInputAsBytes", enabled);
                MobyUnitTestingPanel.this.propertyChannel.put("sendInputAsBytes", new Boolean(enabled).toString());
            }
        });
        this.setPropertySelect(usingAsBytes, "sendInputAsBytes");
        asBytes.setToolTipText("It should not have any effect on result; it is for debugging");
        JPanel saveUnitTest = MobyUnitTestingPanel.createTitledPanel(" Moby Unit Tests ");
        this.saveRDFButton = MobyUnitTestingPanel.createButton(" Save Your Unit Test ", "Use this button to create service RDF that contains this unit test", 85, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MobyUnitTestingPanel.this.saveRDFButton.setEnabled(false);
                MobyUnitTestingPanel.this.saveUnitTest();
            }
        });
        this.saveRDFButton.setEnabled(false);
        this.saveRDFButton.setIcon(saveIcon);
        this.saveRDFButton.setDisabledIcon(saveIconDis);
        this.downloadTestButton = MobyUnitTestingPanel.createButton(" Download Unit Test ", "Use this button to load Unit test information from the service provider", 68, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String serviceOfInterest = MobyUnitTestingPanel.this.getPrefValue(MobyUnitTestingPanel.UT_SC_SERVICE_NAME, null);
                if (serviceOfInterest == null) {
                    AbstractPanel.error("You shouldn't be able to load unit tests without first selecting a service!");
                    return;
                }
                MobyService selectedService = (MobyService)MobyUnitTestingPanel.this.propertyChannel.get(MobyUnitTestingPanel.UT_SC_SERVICE);
                if (selectedService == null) {
                    MobyUnitTestingPanel.this.selectService(serviceOfInterest);
                }
                MobyUnitTestingPanel.this.loadUnitTest(serviceOfInterest, selectedService);
            }
        });
        this.downloadTestButton.setDisabledIcon(loadIconDis);
        this.downloadTestButton.setIcon(loadIcon);
        this.downloadTestButton.setEnabled(false);
        JPanel saveButtonPanel = MobyUnitTestingPanel.createButtonPanel(new JButton[]{this.downloadTestButton, this.saveRDFButton});
        SwingUtils.addComponent((JComponent)saveUnitTest, (Component)saveButtonPanel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)howTo, (Component)htNewURL, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)howTo, (Component)this.endpoint, (int)1, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)howTo, (Component)htRegistry, (int)0, (int)1, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)howTo, (Component)asBytes, (int)0, (int)2, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)howTo, (Component)buttonPanel, (int)0, (int)3, (int)2, (int)1, (int)0, (int)10, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.selService, (int)0, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)howTo, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)saveUnitTest, (int)0, (int)2, (int)1, (int)2, (int)2, (int)10, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)p, (Component)Box.createVerticalGlue(), (int)0, (int)4, (int)1, (int)1, (int)3, (int)18, (double)0.0, (double)1.0);
        return p;
    }

    protected void removeUnitTestData() {
        if (this.xpathExpression != null) {
            this.xpathExpression.setText("");
            this.testXpathButton.setBackground(this.default_button_color);
        }
        if (this.regularExpression != null) {
            this.regularExpression.setText("");
        }
        if (serviceOutputConsole != null) {
            serviceOutputConsole.getArea().setText("");
        }
    }

    protected void setPropertySelect(boolean enabled, String property) {
        this.setPrefValue(property, enabled);
        this.propertyChannel.put(property, new Boolean(enabled).toString());
    }

    private JRadioButton createHowToButton(String title, String howTo) {
        JRadioButton radio = new JRadioButton(title);
        radio.setActionCommand(howTo);
        radio.addActionListener(this.howToListener);
        String initHowTo = this.getPrefValue("howToCallService", "as-registered");
        if (!initHowTo.trim().equals("as-registered") || !initHowTo.trim().equals("service-endpoint")) {
            initHowTo = "as-registered";
        }
        if (howTo.equals(initHowTo)) {
            radio.setSelected(true);
            radio.setEnabled(true);
            this.propertyChannel.put("howToCallService", howTo);
        }
        this.endpoint.setEnabled(initHowTo.equals("service-new-endpoint"));
        return radio;
    }

    private JCheckBox createDataBox(String title, final String preferenceKey, boolean defaultValue) {
        boolean initValue = this.getPrefValue(preferenceKey, defaultValue);
        this.propertyChannel.put(preferenceKey, new Boolean(initValue).toString());
        return MobyUnitTestingPanel.createCheckBox(title, initValue, -1, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() == 1;
                MobyUnitTestingPanel.this.setPrefValue(preferenceKey, enabled);
                MobyUnitTestingPanel.this.propertyChannel.put(preferenceKey, new Boolean(enabled).toString());
                MobyUnitTestingPanel.this.inFile.setEnabled(MobyUnitTestingPanel.this.iFromFile.isSelected());
            }
        });
    }

    protected JPanel getInputPanel() {
        JPanel inputData = new JPanel(new GridBagLayout());
        inputData.setBorder(MobyUnitTestingPanel.createFatBorder("Service Input Data", GraphColours.getColour("cadetblue", Color.blue)));
        JPanel upper = new JPanel(new GridBagLayout());
        this.dataTablesPanel = new JPanel(new GridBagLayout());
        this.iFromFile = this.createDataBox("Take an input from this XML file", UT_SC_IN_FILE, false);
        this.inFile = this.createFileSelector("Select input XML for calling a service", "Select", null, UT_SC_INPUT_FILE, UT_SC_INPUT_FILE);
        this.inFile.setEnabled(this.iFromFile.isSelected());
        JButton saveButton = AbstractPanel.createButton("Save Input to File", "Save Service Input to File", -1, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MobyUnitTestingPanel.this.onSave();
            }
        });
        saveButton.setIcon(saveIcon);
        SwingUtils.compact((JButton)saveButton);
        SwingUtils.addComponent((JComponent)upper, (Component)this.dataTablesPanel, (int)0, (int)0, (int)2, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        SwingUtils.addComponent((JComponent)upper, (Component)this.iFromFile, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)upper, (Component)this.inFile, (int)1, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)upper, (Component)MobyUnitTestingPanel.createButtonPanel(new JButton[]{saveButton}), (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)inputData, (Component)upper, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        return inputData;
    }

    protected void onSave() {
        final String fileName = this.showSaveDialog();
        if (UUtils.isEmpty((String)fileName)) {
            return;
        }
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;

            @Override
            public Object construct() {
                try {
                    Utils.createFile((File)new File(fileName), (String)MobyUnitTestingPanel.this.inputDataTables.toXML());
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error("Sorry, an error happened when saving...\n\n", (Exception)((Object)this.exception));
                }
            }
        };
        worker.start();
    }

    protected String showSaveDialog() {
        Preferences node = PrefsUtils.getNode(this.getClass());
        String initValue = node.get(UT_INPUT_FILE, System.getProperty("user.dir"));
        if (UUtils.notEmpty((String)initValue)) {
            File file = new File(initValue);
            this.saveChooser.setSelectedFile(file);
        }
        if (this.saveChooser.showSaveDialog(this) != 0) {
            return null;
        }
        String fileName = this.saveChooser.getSelectedFile().getAbsolutePath();
        node.put(UT_INPUT_FILE, fileName);
        return fileName;
    }

    protected void updateInputDataPanel(String info) {
        this.dataTablesPanel.removeAll();
        AwtUtils.redisplay((Component)this.dataTablesPanel);
        JLabel text = new JLabel(info);
        SwingUtils.addComponent((JComponent)this.dataTablesPanel, (Component)text, (int)0, (int)0, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0);
        this.dataTablesPanel.validate();
    }

    protected void updateInputDataPanel(MobyService service, MobyDataType[] dataTypes) {
        this.dataTablesPanel.removeAll();
        this.inputDataTables = new ServiceInputPanel(service, dataTypes);
        SwingUtils.addComponent((JComponent)this.dataTablesPanel, (Component)this.inputDataTables, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        this.dataTablesPanel.validate();
    }

    protected MobyDataType findDataType(String dataTypeToBeFound, MobyDataType[] dataTypes) {
        for (int i = 0; i < dataTypes.length; ++i) {
            if (!dataTypeToBeFound.equals(dataTypes[i].getName())) continue;
            return dataTypes[i];
        }
        log.error((Object)("Strange, data type '" + dataTypeToBeFound + "' was not found in " + dataTypes.length + " data types."));
        return null;
    }

    protected void serviceFinished() {
        this.runButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.testRegexButton.setEnabled(true);
        this.testXpathButton.setEnabled(true);
        this.testOutputButton.setEnabled(true);
        this.copyServiceResultsButton.setEnabled(true);
    }

    protected void selectService(final String serviceName) {
        final MobyUnitTestingPanel source = this;
        SwingWorker worker = new SwingWorker(){
            MobyService service;
            MobyDataType[] dataTypes;

            @Override
            public Object construct() {
                try {
                    this.service = MobyUnitTestingPanel.this.registryModel.getService(serviceName);
                    this.dataTypes = MobyUnitTestingPanel.this.registryModel.getDataTypes(source);
                }
                catch (MobyException e) {
                    AbstractPanel.error("An error happened when accessing a list of available services.\n\nCheck please values in text fields (in Registry Browser)\nspecifying registry endpoint and namespace, and in the\none specifying directory used as a local cache. Then\nright-click in the data types area and select 'Reload'.\n\n", (Exception)((Object)e));
                }
                return this.service;
            }

            @Override
            public void finished() {
                if (this.service == null) {
                    MobyUnitTestingPanel.this.deselectService();
                } else {
                    MobyUnitTestingPanel.this.updateInputDataPanel(this.service, this.dataTypes);
                    MobyUnitTestingPanel.this.selService.setText(this.service.getName());
                    MobyUnitTestingPanel.this.propertyChannel.put(MobyUnitTestingPanel.UT_SC_SERVICE, this.service);
                    MobyUnitTestingPanel.this.runButton.setEnabled(true);
                    MobyUnitTestingPanel.this.downloadTestButton.setEnabled(true);
                    MobyUnitTestingPanel.this.saveRDFButton.setEnabled(true);
                }
            }
        };
        worker.start();
    }

    protected void loadUnitTest(final String serviceName, final MobyService service) {
        SwingWorker worker = new SwingWorker(){
            boolean found = false;

            @Override
            public Object construct() {
                MobyUnitTestingPanel.this.downloadTestButton.setEnabled(false);
                MobyUnitTestingPanel.this.saveRDFButton.setEnabled(false);
                String url = service.getSignatureURL();
                if (url == null || url.trim().equals("")) {
                    MobyUnitTestingPanel.this.removeUnitTestData();
                }
                try {
                    MobyService[] services;
                    ServiceInstanceParser sip = new ServiceInstanceParser(url);
                    for (MobyService service2 : services = sip.getMobyServicesFromRDF()) {
                        if (!service2.getUniqueName().equals(serviceName)) continue;
                        this.found = true;
                        if (service2.getUnitTests() != null && service2.getUnitTests().length > 0) {
                            MobyUnitTest ut = service2.getUnitTests()[0];
                            MobyUnitTestingPanel.this.xpathExpression.setText(ut.getValidXPath());
                            MobyUnitTestingPanel.this.testXpathButton.setBackground(MobyUnitTestingPanel.this.default_button_color);
                            MobyUnitTestingPanel.this.regularExpression.setText(ut.getValidREGEX());
                            serviceOutputConsole.getArea().setText(ut.getValidOutputXML());
                            MobyUnitTestingPanel.this.inputDataTables.setValues(ut.getExampleInput());
                        }
                        break;
                    }
                }
                catch (MobyException me) {
                    MobyUnitTestingPanel.this.downloadTestButton.setEnabled(true);
                    MobyUnitTestingPanel.this.saveRDFButton.setEnabled(true);
                    AbstractPanel.error("There was an error while getting unit test information!", (Exception)((Object)me));
                }
                return service;
            }

            @Override
            public void finished() {
                if (!this.found) {
                    MobyUnitTestingPanel.this.removeUnitTestData();
                    return;
                }
                if (MobyUnitTestingPanel.this.iFromFile.isSelected()) {
                    MobyUnitTestingPanel.this.iFromFile.setSelected(false);
                }
                MobyUnitTestingPanel.this.downloadTestButton.setEnabled(true);
                MobyUnitTestingPanel.this.saveRDFButton.setEnabled(true);
            }
        };
        worker.start();
    }

    public void saveUnitTest() {
        SwingWorker worker = new SwingWorker(){
            private boolean success = false;
            private String filename = "";

            @Override
            public Object construct() {
                MobyService service = (MobyService)MobyUnitTestingPanel.this.propertyChannel.get(MobyUnitTestingPanel.UT_SC_SERVICE);
                if (service == null) {
                    this.success = false;
                    AbstractPanel.error("Problem saving unit test. Did you select a service?");
                    return null;
                }
                MobyUnitTest unitTest = new MobyUnitTest();
                if (!MobyUnitTestingPanel.this.xpathExpression.getText().trim().equals("")) {
                    unitTest.setValidXPath(MobyUnitTestingPanel.this.xpathExpression.getText().trim());
                }
                if (!MobyUnitTestingPanel.this.regularExpression.getText().trim().equals("")) {
                    unitTest.setValidREGEX(MobyUnitTestingPanel.this.regularExpression.getText().trim());
                }
                if (!serviceOutputConsole.getArea().getText().trim().equals("")) {
                    unitTest.setValidOutputXML(serviceOutputConsole.getArea().getText().trim());
                }
                try {
                    DataContainer data = new DataContainer();
                    if (MobyUnitTestingPanel.this.propertyChannel.getBoolean(MobyUnitTestingPanel.UT_SC_IN_FILE, false)) {
                        String inputFile = MobyUnitTestingPanel.this.propertyChannel.getString(MobyUnitTestingPanel.UT_SC_INPUT_FILE);
                        if (UUtils.isEmpty((String)inputFile)) {
                            AbstractPanel.error("Empty File!", (Exception)((Object)new MobyException("No input XML file given.")));
                            this.success = false;
                            return null;
                        }
                        data.setDataFromFile(new File(inputFile));
                    } else {
                        data.setData(MobyUnitTestingPanel.this.inputDataTables.toXML());
                    }
                    unitTest.setExampleInput((String)data.getData());
                }
                catch (MobyException me) {
                    AbstractPanel.error("Unknown error ...", (Exception)((Object)me));
                    this.success = false;
                    return false;
                }
                service.addUnitTest(unitTest);
                try {
                    Preferences node;
                    String initValue;
                    ServiceInstanceRDF siRdf = new ServiceInstanceRDF(new Registry(MobyUnitTestingPanel.this.propertyChannel.getString("dp-registry-endpoint"), MobyUnitTestingPanel.this.propertyChannel.getString("dp-registry-endpoint"), MobyUnitTestingPanel.this.propertyChannel.getString("dp-registry-namespace")));
                    Model m = siRdf.createRDFModel(null, new MobyService[]{service}, true);
                    String rdf = siRdf.serializeModel(m);
                    if (MobyUnitTestingPanel.this.rdfFile == null) {
                        MobyUnitTestingPanel.this.rdfFile = MobyUnitTestingPanel.this.createFileSelector("Save your RDF to", "Save", service.getName(), MobyUnitTestingPanel.UT_SC_RDF_OUTPUT_FILE, MobyUnitTestingPanel.UT_SC_RDF_OUTPUT_FILE);
                        MobyUnitTestingPanel.this.rdfFile.setEnabled(true);
                    }
                    if (UUtils.notEmpty((String)(initValue = (node = PrefsUtils.getNode(this.getClass())).get(MobyUnitTestingPanel.UT_RDF_OUTPUT_FILE, System.getProperty("user.dir"))))) {
                        File file = new File(initValue);
                        MobyUnitTestingPanel.this.rdfFile.setSelectedFile(file);
                    }
                    if (MobyUnitTestingPanel.this.rdfFile.getFileChooser().showSaveDialog(null) == 0) {
                        this.filename = MobyUnitTestingPanel.this.rdfFile.getFileChooser().getSelectedFile().getAbsolutePath();
                        node.put(MobyUnitTestingPanel.UT_RDF_OUTPUT_FILE, this.filename);
                        Utils.createFile((File)new File(this.filename), (String)rdf);
                        this.success = true;
                    }
                }
                catch (MobyException me) {
                    AbstractPanel.error("Problem saving file ...", (Exception)((Object)me));
                    this.success = false;
                    MobyUnitTestingPanel.this.saveRDFButton.setEnabled(true);
                    return null;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.success) {
                    SwingUtils.msg(null, (String)"Success", (Object)("Your unit test has been successfully saved to\n\t'" + this.filename + "'!\nDon't forget to put that document at the location specified by your signature URL!\n"), (Icon)AbstractPanel.confirmIcon);
                }
                MobyUnitTestingPanel.this.saveRDFButton.setEnabled(true);
            }
        };
        worker.start();
    }

    protected void deselectService() {
        this.selService.setText("");
        this.updateInputDataPanel(INIT_SELECT);
        this.propertyChannel.remove(UT_SC_SERVICE);
        this.runButton.setEnabled(false);
        this.downloadTestButton.setEnabled(false);
        this.saveRDFButton.setEnabled(false);
    }

    @Override
    public String getName() {
        return "Moby Unit Testing";
    }

    @Override
    public String getDescription() {
        return "A panel for creating and unit testing your moby services.";
    }

    protected class CustomServicesTree
    extends ServicesTree {
        private static final long serialVersionUID = 5884117301201885425L;

        public CustomServicesTree(RegistryModel model, CommonConsole console) {
            super(model, console);
        }

        @Override
        protected void createPopups(String title) {
            super.createPopups(title);
            this.removeFromPopups("ac-reload");
            this.removeSeparatorAfter("ac-collapse");
        }

        @Override
        protected void selected(DefaultMutableTreeNode node) {
            if (node == null) {
                MobyUnitTestingPanel.this.deselectService();
                return;
            }
            MobyUnitTestingPanel.this.updateInputDataPanel("Loading...");
            MobyUnitTestingPanel.this.selService.setText("");
            CommonNode nodeObject = (CommonNode)node.getUserObject();
            String currentServiceName = nodeObject.getValue();
            MobyUnitTestingPanel.this.selectService(currentServiceName);
            MobyUnitTestingPanel.this.setPrefValue(MobyUnitTestingPanel.UT_SC_SERVICE_NAME, currentServiceName);
        }
    }

    class MySwingWorker
    extends SwingWorker {
        MobyException exception = null;
        DataContainer data = new DataContainer();
        boolean wasCancelled = false;
        MobyService service;

        public MySwingWorker(MobyService service) {
            this.service = service;
            this.data.setMetadata(MobyUnitTestingPanel.this.propertyChannel);
        }

        public void cancel() {
            this.wasCancelled = true;
            MobyUnitTestingPanel.this.propertyChannel.fire("status-msg", "Service invocation cancelled.");
        }

        @Override
        public Object construct() {
            try {
                MobyUnitTestingPanel.this.runButton.setEnabled(false);
                MobyUnitTestingPanel.this.propertyChannel.fire("status-msg", "Calling service " + this.service.getName() + "...");
                if (MobyUnitTestingPanel.this.propertyChannel.getBoolean(MobyUnitTestingPanel.UT_SC_IN_FILE, false)) {
                    String inputFile = MobyUnitTestingPanel.this.propertyChannel.getString(MobyUnitTestingPanel.UT_SC_INPUT_FILE);
                    if (UUtils.isEmpty((String)inputFile)) {
                        throw new MobyException("No input XML file given.");
                    }
                    this.data.setDataFromFile(new File(inputFile));
                    try {
                        MobyUnitTestingPanel.this.inputDataTables.setValues(this.data.getData().toString());
                    }
                    catch (MobyException mobyException) {}
                } else {
                    this.data.setData(MobyUnitTestingPanel.this.inputDataTables.toXML());
                }
                MobyUnitTestingPanel.this.stopButton.setEnabled(true);
                MobyUnitTestingPanel.this.callerModel.runIt(this.data);
            }
            catch (MobyException e) {
                this.exception = e;
            }
            catch (Error e) {
                this.exception = new MobyException(e.toString());
            }
            return null;
        }

        @Override
        public void finished() {
            if (this.wasCancelled) {
                return;
            }
            if (this.exception == null) {
                MobyUnitTestingPanel.this.propertyChannel.fire("status-msg", "Service invocation finished.");
                if (!"no-call".equals(MobyUnitTestingPanel.this.propertyChannel.getString("howToCallService"))) {
                    MobyUnitTestingPanel.this.results.updateComponent(this.data);
                    MobyUnitTestingPanel.this.serviceOutput = this.data.getData().toString();
                }
            } else {
                MobyUnitTestingPanel.this.propertyChannel.fire("status-msg", "Service invocation failed.");
                AbstractPanel.error(MobyUnitTestingPanel.CALLER_ERROR, (Exception)((Object)this.exception));
                this.exception.printStackTrace();
            }
            MobyUnitTestingPanel.this.serviceFinished();
        }
    }

    class EditableConsole
    extends CommonConsole {
        private static final long serialVersionUID = 1060691168904057586L;

        public EditableConsole() {
            this.textArea.setEditable(true);
            this.textArea.setBackground(GraphColours.getColour(DashboardConfig.getString(MobyUnitTestingPanel.P_S_EDIT_BGCOLOR, null), this.textArea.getBackground()));
            MobyUnitTestingPanel.this.copyServiceResultsButton = AbstractPanel.createButton("Copy", "Copy over service invocation results", -1, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditableConsole.this.textArea.setText(MobyUnitTestingPanel.this.serviceOutput);
                }
            });
            MobyUnitTestingPanel.this.copyServiceResultsButton.setIcon(copyIcon);
            MobyUnitTestingPanel.this.copyServiceResultsButton.setDisabledIcon(copyIconDis);
            MobyUnitTestingPanel.this.copyServiceResultsButton.setEnabled(false);
            SwingUtils.compact((JButton)MobyUnitTestingPanel.this.copyServiceResultsButton);
            SwingUtils.addComponent((JComponent)this, (Component)MobyUnitTestingPanel.this.copyServiceResultsButton, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
            MobyUnitTestingPanel.this.testOutputButton = AbstractPanel.createButton("Test", "Test your services real ouput against this XML", -1, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MobyUnitTest unitTest = new MobyUnitTest();
                    unitTest.setValidOutputXML(EditableConsole.this.textArea.getText());
                    boolean success = false;
                    try {
                        success = unitTest.compareOutputXML(MobyUnitTestingPanel.this.serviceOutput);
                    }
                    catch (MobyException me) {
                        AbstractPanel.error("Differences found!\n", (Exception)((Object)me));
                        return;
                    }
                    if (success) {
                        SwingUtils.msg(null, (String)"Success", (Object)"Service output XML is as expected!", (Icon)AbstractPanel.confirmIcon);
                    } else {
                        AbstractPanel.error("Differences found!\n", (Exception)((Object)new MobyException(unitTest.getXMLDifferences(MobyUnitTestingPanel.this.serviceOutput))));
                    }
                }
            });
            MobyUnitTestingPanel.this.testOutputButton.setIcon(testOutputIcon);
            MobyUnitTestingPanel.this.testOutputButton.setDisabledIcon(testOutputIconDis);
            MobyUnitTestingPanel.this.testOutputButton.setEnabled(false);
            SwingUtils.compact((JButton)MobyUnitTestingPanel.this.testOutputButton);
            SwingUtils.addComponent((JComponent)this, (Component)MobyUnitTestingPanel.this.testOutputButton, (int)2, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        }

        @Override
        public boolean hasAppendModeSwitcher() {
            return false;
        }

        @Override
        public boolean hasVerboseModeSwitcher() {
            return false;
        }

        @Override
        public boolean hasSaveButton() {
            return false;
        }

        @Override
        public boolean hasCleanButton() {
            return false;
        }
    }
}

