/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class LookAndFeelUtils {
    public static JMenu getLookAndFeelMenu(String title, Icon icon, final JFrame frame) {
        UIManager.LookAndFeelInfo[] lafi = UIManager.getInstalledLookAndFeels();
        ButtonGroup lafGroup = new ButtonGroup();
        JMenu options = new JMenu(title);
        options.setIcon(icon);
        for (int i = 0; i < lafi.length; ++i) {
            JRadioButtonMenuItem rb = new JRadioButtonMenuItem(lafi[i].getName());
            options.add(rb);
            rb.setSelected(UIManager.getLookAndFeel().getName().equals(lafi[i].getName()));
            rb.putClientProperty("UIKey", lafi[i]);
            rb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ae) {
                    JRadioButtonMenuItem rb2 = (JRadioButtonMenuItem)ae.getSource();
                    if (rb2.isSelected()) {
                        UIManager.LookAndFeelInfo info = (UIManager.LookAndFeelInfo)rb2.getClientProperty("UIKey");
                        try {
                            UIManager.setLookAndFeel(info.getClassName());
                            SwingUtilities.updateComponentTreeUI(frame);
                        }
                        catch (Exception e) {
                            rb2.setEnabled(false);
                        }
                    }
                }
            });
            lafGroup.add(rb);
        }
        return options;
    }
}

