/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Color;
import java.util.Hashtable;

public abstract class GraphColours {
    private static Hashtable colorTable = new Hashtable(660, 10.0f);
    private static Hashtable colorLookUp = new Hashtable(660, 10.0f);
    public static final Color defaultForeground;
    public static final Color defaultBackground;
    public static final Color defaultXOR;
    public static final Color defaultFontcolor;
    public static final Color defaultColor;

    public static void addColor(String name, Color color) throws IllegalArgumentException {
        if (name == null || color == null) {
            throw new IllegalArgumentException("supplied name or color is null");
        }
        String canonName = GraphColours.canonColor(name);
        if (canonName == null) {
            throw new IllegalArgumentException("supplied name does not contain alphabetics (" + name + ")");
        }
        GraphColours.doAddColor(canonName, color);
    }

    private static void doAddColor(String name, Color color, boolean override) {
        colorTable.put(name, color);
        if (override || colorLookUp.get(color) == null) {
            colorLookUp.put(color, name);
        }
    }

    private static void doAddColor(String name, Color color) {
        GraphColours.doAddColor(name, color, true);
    }

    private static Color parseNumericColor(String value) {
        char first = value.charAt(0);
        if (first == '#') {
            String v2 = value.trim();
            if (v2.length() != 7 && v2.length() != 9) {
                return null;
            }
            return new Color(Integer.parseInt(v2.substring(1, 7), 16));
        }
        if (Character.isDigit(first) || first == '.') {
            int i = 1;
            int start = 0;
            int N = 0;
            float[] array = new float[3];
            while (N < 3) {
                char curr;
                if (i == value.length()) {
                    return null;
                }
                while ((curr = value.charAt(i)) != ',' && curr != ' ' && ++i < value.length()) {
                }
                try {
                    array[N++] = Float.parseFloat(value.substring(start, i));
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
                boolean comma = false;
                while (i < value.length()) {
                    char curr2 = value.charAt(i);
                    if (curr2 == ',') {
                        if (comma) {
                            return null;
                        }
                        comma = true;
                    } else if (curr2 != ' ') break;
                    ++i;
                }
                start = i;
            }
            return new Color(Color.HSBtoRGB(array[0], array[1], array[2]));
        }
        return null;
    }

    private static String canonColor(String name) {
        if (name == null) {
            return null;
        }
        char[] array = name.toCharArray();
        int len = 0;
        for (int i = 0; i < array.length; ++i) {
            if (Character.isLetterOrDigit(array[i])) {
                array[len++] = Character.toLowerCase(array[i]);
                continue;
            }
            if (!Character.isLowerCase(array[i]) && !Character.isDigit(array[i])) continue;
            array[len++] = array[i];
        }
        return new String(array, 0, len);
    }

    public static Color getColour(String name, Color def) {
        if (def == null) {
            def = defaultColor;
        }
        if (name == null) {
            return def;
        }
        Color retColor = GraphColours.parseNumericColor(name);
        if (retColor == null) {
            String canonName = GraphColours.canonColor(name);
            retColor = (Color)colorTable.get(canonName);
        }
        return retColor == null ? def : retColor;
    }

    public static String getColorName(Color color) {
        if (color == null) {
            return null;
        }
        String name = (String)colorLookUp.get(color);
        if (name == null) {
            float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            name = hsb[0] + "," + hsb[1] + "," + hsb[2];
        }
        return name;
    }

    static {
        GraphColours.doAddColor("aliceblue", new Color(240, 248, 255));
        GraphColours.doAddColor("antiquewhite", new Color(250, 235, 215));
        GraphColours.doAddColor("antiquewhite1", new Color(255, 239, 219), false);
        GraphColours.doAddColor("antiquewhite2", new Color(238, 223, 204), false);
        GraphColours.doAddColor("antiquewhite3", new Color(205, 192, 176), false);
        GraphColours.doAddColor("antiquewhite4", new Color(139, 131, 120), false);
        GraphColours.doAddColor("aquamarine", new Color(127, 255, 212));
        GraphColours.doAddColor("aquamarine1", new Color(127, 255, 212), false);
        GraphColours.doAddColor("aquamarine2", new Color(118, 238, 198), false);
        GraphColours.doAddColor("aquamarine3", new Color(102, 205, 170), false);
        GraphColours.doAddColor("aquamarine4", new Color(69, 139, 116), false);
        GraphColours.doAddColor("azure", new Color(240, 255, 255));
        GraphColours.doAddColor("azure1", new Color(240, 255, 255), false);
        GraphColours.doAddColor("azure2", new Color(224, 238, 238), false);
        GraphColours.doAddColor("azure3", new Color(193, 205, 205), false);
        GraphColours.doAddColor("azure4", new Color(131, 139, 139), false);
        GraphColours.doAddColor("beige", new Color(245, 245, 220));
        GraphColours.doAddColor("bisque", new Color(255, 228, 196));
        GraphColours.doAddColor("bisque1", new Color(255, 228, 196), false);
        GraphColours.doAddColor("bisque2", new Color(238, 213, 183), false);
        GraphColours.doAddColor("bisque3", new Color(205, 183, 158), false);
        GraphColours.doAddColor("bisque4", new Color(139, 125, 107), false);
        GraphColours.doAddColor("black", new Color(0, 0, 0));
        GraphColours.doAddColor("blanchedalmond", new Color(255, 235, 205));
        GraphColours.doAddColor("blue", new Color(0, 0, 255));
        GraphColours.doAddColor("blue1", new Color(0, 0, 255), false);
        GraphColours.doAddColor("blue2", new Color(0, 0, 238), false);
        GraphColours.doAddColor("blue3", new Color(0, 0, 205), false);
        GraphColours.doAddColor("blue4", new Color(0, 0, 139), false);
        GraphColours.doAddColor("blueviolet", new Color(138, 43, 226));
        GraphColours.doAddColor("brown", new Color(165, 42, 42));
        GraphColours.doAddColor("brown1", new Color(255, 64, 64), false);
        GraphColours.doAddColor("brown2", new Color(238, 59, 59), false);
        GraphColours.doAddColor("brown3", new Color(205, 51, 51), false);
        GraphColours.doAddColor("brown4", new Color(139, 35, 35), false);
        GraphColours.doAddColor("burlywood", new Color(222, 184, 135));
        GraphColours.doAddColor("burlywood1", new Color(255, 211, 155), false);
        GraphColours.doAddColor("burlywood2", new Color(238, 197, 145), false);
        GraphColours.doAddColor("burlywood3", new Color(205, 170, 125), false);
        GraphColours.doAddColor("burlywood4", new Color(139, 115, 85), false);
        GraphColours.doAddColor("cadetblue", new Color(95, 158, 160));
        GraphColours.doAddColor("cadetblue1", new Color(152, 245, 255), false);
        GraphColours.doAddColor("cadetblue2", new Color(142, 229, 238), false);
        GraphColours.doAddColor("cadetblue3", new Color(122, 197, 205), false);
        GraphColours.doAddColor("cadetblue4", new Color(83, 134, 139), false);
        GraphColours.doAddColor("chartreuse", new Color(127, 255, 0));
        GraphColours.doAddColor("chartreuse1", new Color(127, 255, 0), false);
        GraphColours.doAddColor("chartreuse2", new Color(118, 238, 0), false);
        GraphColours.doAddColor("chartreuse3", new Color(102, 205, 0), false);
        GraphColours.doAddColor("chartreuse4", new Color(69, 139, 0), false);
        GraphColours.doAddColor("chocolate", new Color(210, 105, 30));
        GraphColours.doAddColor("chocolate1", new Color(255, 127, 36), false);
        GraphColours.doAddColor("chocolate2", new Color(238, 118, 33), false);
        GraphColours.doAddColor("chocolate3", new Color(205, 102, 29), false);
        GraphColours.doAddColor("chocolate4", new Color(139, 69, 19), false);
        GraphColours.doAddColor("coral", new Color(255, 127, 80));
        GraphColours.doAddColor("coral1", new Color(255, 114, 86), false);
        GraphColours.doAddColor("coral2", new Color(238, 106, 80), false);
        GraphColours.doAddColor("coral3", new Color(205, 91, 69), false);
        GraphColours.doAddColor("coral4", new Color(139, 62, 47), false);
        GraphColours.doAddColor("cornflowerblue", new Color(100, 149, 237));
        GraphColours.doAddColor("cornsilk", new Color(255, 248, 220));
        GraphColours.doAddColor("cornsilk1", new Color(255, 248, 220), false);
        GraphColours.doAddColor("cornsilk2", new Color(238, 232, 205), false);
        GraphColours.doAddColor("cornsilk3", new Color(205, 200, 177), false);
        GraphColours.doAddColor("cornsilk4", new Color(139, 136, 120), false);
        GraphColours.doAddColor("crimson", new Color(220, 20, 60));
        GraphColours.doAddColor("cyan", new Color(0, 255, 255));
        GraphColours.doAddColor("cyan1", new Color(0, 255, 255), false);
        GraphColours.doAddColor("cyan2", new Color(0, 238, 238), false);
        GraphColours.doAddColor("cyan3", new Color(0, 205, 205), false);
        GraphColours.doAddColor("cyan4", new Color(0, 139, 139), false);
        GraphColours.doAddColor("darkblue", new Color(0, 0, 139));
        GraphColours.doAddColor("darkcyan", new Color(0, 139, 139));
        GraphColours.doAddColor("darkgoldenrod", new Color(184, 134, 11));
        GraphColours.doAddColor("darkgoldenrod1", new Color(255, 185, 15), false);
        GraphColours.doAddColor("darkgoldenrod2", new Color(238, 173, 14), false);
        GraphColours.doAddColor("darkgoldenrod3", new Color(205, 149, 12), false);
        GraphColours.doAddColor("darkgoldenrod4", new Color(139, 101, 8), false);
        GraphColours.doAddColor("darkgray", new Color(169, 169, 169));
        GraphColours.doAddColor("darkgreen", new Color(0, 100, 0));
        GraphColours.doAddColor("darkgrey", new Color(169, 169, 169), false);
        GraphColours.doAddColor("darkkhaki", new Color(189, 183, 107));
        GraphColours.doAddColor("darkmagenta", new Color(139, 0, 139));
        GraphColours.doAddColor("darkolivegreen", new Color(85, 107, 47));
        GraphColours.doAddColor("darkolivegreen1", new Color(202, 255, 112), false);
        GraphColours.doAddColor("darkolivegreen2", new Color(188, 238, 104), false);
        GraphColours.doAddColor("darkolivegreen3", new Color(162, 205, 90), false);
        GraphColours.doAddColor("darkolivegreen4", new Color(110, 139, 61), false);
        GraphColours.doAddColor("darkorange", new Color(255, 140, 0));
        GraphColours.doAddColor("darkorange1", new Color(255, 127, 0), false);
        GraphColours.doAddColor("darkorange2", new Color(238, 118, 0), false);
        GraphColours.doAddColor("darkorange3", new Color(205, 102, 0), false);
        GraphColours.doAddColor("darkorange4", new Color(139, 69, 0), false);
        GraphColours.doAddColor("darkorchid", new Color(153, 50, 204));
        GraphColours.doAddColor("darkorchid1", new Color(191, 62, 255), false);
        GraphColours.doAddColor("darkorchid2", new Color(178, 58, 238), false);
        GraphColours.doAddColor("darkorchid3", new Color(154, 50, 205), false);
        GraphColours.doAddColor("darkorchid4", new Color(104, 34, 139), false);
        GraphColours.doAddColor("darkred", new Color(139, 0, 0));
        GraphColours.doAddColor("darksalmon", new Color(233, 150, 122));
        GraphColours.doAddColor("darkseagreen", new Color(143, 188, 143));
        GraphColours.doAddColor("darkseagreen1", new Color(193, 255, 193), false);
        GraphColours.doAddColor("darkseagreen2", new Color(180, 238, 180), false);
        GraphColours.doAddColor("darkseagreen3", new Color(155, 205, 155), false);
        GraphColours.doAddColor("darkseagreen4", new Color(105, 139, 105), false);
        GraphColours.doAddColor("darkslateblue", new Color(72, 61, 139));
        GraphColours.doAddColor("darkslategray", new Color(47, 79, 79));
        GraphColours.doAddColor("darkslategray1", new Color(151, 255, 255), false);
        GraphColours.doAddColor("darkslategray2", new Color(141, 238, 238), false);
        GraphColours.doAddColor("darkslategray3", new Color(121, 205, 205), false);
        GraphColours.doAddColor("darkslategray4", new Color(82, 139, 139), false);
        GraphColours.doAddColor("darkslategrey", new Color(47, 79, 79), false);
        GraphColours.doAddColor("darkturquoise", new Color(0, 206, 209));
        GraphColours.doAddColor("darkviolet", new Color(148, 0, 211));
        GraphColours.doAddColor("deeppink", new Color(255, 20, 147));
        GraphColours.doAddColor("deeppink1", new Color(255, 20, 147), false);
        GraphColours.doAddColor("deeppink2", new Color(238, 18, 137), false);
        GraphColours.doAddColor("deeppink3", new Color(205, 16, 118), false);
        GraphColours.doAddColor("deeppink4", new Color(139, 10, 80), false);
        GraphColours.doAddColor("deepskyblue", new Color(0, 191, 255));
        GraphColours.doAddColor("deepskyblue1", new Color(0, 191, 255), false);
        GraphColours.doAddColor("deepskyblue2", new Color(0, 178, 238), false);
        GraphColours.doAddColor("deepskyblue3", new Color(0, 154, 205), false);
        GraphColours.doAddColor("deepskyblue4", new Color(0, 104, 139), false);
        GraphColours.doAddColor("dimgray", new Color(105, 105, 105));
        GraphColours.doAddColor("dimgrey", new Color(105, 105, 105), false);
        GraphColours.doAddColor("dodgerblue", new Color(30, 144, 255));
        GraphColours.doAddColor("dodgerblue1", new Color(30, 144, 255), false);
        GraphColours.doAddColor("dodgerblue2", new Color(28, 134, 238), false);
        GraphColours.doAddColor("dodgerblue3", new Color(24, 116, 205), false);
        GraphColours.doAddColor("dodgerblue4", new Color(16, 78, 139), false);
        GraphColours.doAddColor("firebrick", new Color(178, 34, 34));
        GraphColours.doAddColor("firebrick1", new Color(255, 48, 48), false);
        GraphColours.doAddColor("firebrick2", new Color(238, 44, 44), false);
        GraphColours.doAddColor("firebrick3", new Color(205, 38, 38), false);
        GraphColours.doAddColor("firebrick4", new Color(139, 26, 26), false);
        GraphColours.doAddColor("floralwhite", new Color(255, 250, 240));
        GraphColours.doAddColor("forestgreen", new Color(34, 139, 34));
        GraphColours.doAddColor("gainsboro", new Color(220, 220, 220));
        GraphColours.doAddColor("ghostwhite", new Color(248, 248, 255));
        GraphColours.doAddColor("gold", new Color(255, 215, 0));
        GraphColours.doAddColor("gold1", new Color(255, 215, 0), false);
        GraphColours.doAddColor("gold2", new Color(238, 201, 0), false);
        GraphColours.doAddColor("gold3", new Color(205, 173, 0), false);
        GraphColours.doAddColor("gold4", new Color(139, 117, 0), false);
        GraphColours.doAddColor("goldenrod", new Color(218, 165, 32));
        GraphColours.doAddColor("goldenrod1", new Color(255, 193, 37), false);
        GraphColours.doAddColor("goldenrod2", new Color(238, 180, 34), false);
        GraphColours.doAddColor("goldenrod3", new Color(205, 155, 29), false);
        GraphColours.doAddColor("goldenrod4", new Color(139, 105, 20), false);
        GraphColours.doAddColor("green", new Color(0, 255, 0));
        GraphColours.doAddColor("green1", new Color(0, 255, 0), false);
        GraphColours.doAddColor("green2", new Color(0, 238, 0), false);
        GraphColours.doAddColor("green3", new Color(0, 205, 0), false);
        GraphColours.doAddColor("green4", new Color(0, 139, 0), false);
        GraphColours.doAddColor("greenyellow", new Color(173, 255, 47));
        GraphColours.doAddColor("gray", new Color(190, 190, 190));
        GraphColours.doAddColor("grey", new Color(190, 190, 190), false);
        GraphColours.doAddColor("gray0", new Color(0, 0, 0), false);
        GraphColours.doAddColor("grey0", new Color(0, 0, 0), false);
        GraphColours.doAddColor("gray1", new Color(3, 3, 3), false);
        GraphColours.doAddColor("grey1", new Color(3, 3, 3), false);
        GraphColours.doAddColor("gray2", new Color(5, 5, 5), false);
        GraphColours.doAddColor("grey2", new Color(5, 5, 5), false);
        GraphColours.doAddColor("gray3", new Color(8, 8, 8), false);
        GraphColours.doAddColor("grey3", new Color(8, 8, 8), false);
        GraphColours.doAddColor("gray4", new Color(10, 10, 10), false);
        GraphColours.doAddColor("grey4", new Color(10, 10, 10), false);
        GraphColours.doAddColor("gray5", new Color(13, 13, 13), false);
        GraphColours.doAddColor("grey5", new Color(13, 13, 13), false);
        GraphColours.doAddColor("gray6", new Color(15, 15, 15), false);
        GraphColours.doAddColor("grey6", new Color(15, 15, 15), false);
        GraphColours.doAddColor("gray7", new Color(18, 18, 18), false);
        GraphColours.doAddColor("grey7", new Color(18, 18, 18), false);
        GraphColours.doAddColor("gray8", new Color(20, 20, 20), false);
        GraphColours.doAddColor("grey8", new Color(20, 20, 20), false);
        GraphColours.doAddColor("gray9", new Color(23, 23, 23), false);
        GraphColours.doAddColor("grey9", new Color(23, 23, 23), false);
        GraphColours.doAddColor("gray10", new Color(26, 26, 26), false);
        GraphColours.doAddColor("grey10", new Color(26, 26, 26), false);
        GraphColours.doAddColor("gray11", new Color(28, 28, 28), false);
        GraphColours.doAddColor("grey11", new Color(28, 28, 28), false);
        GraphColours.doAddColor("gray12", new Color(31, 31, 31), false);
        GraphColours.doAddColor("grey12", new Color(31, 31, 31), false);
        GraphColours.doAddColor("gray13", new Color(33, 33, 33), false);
        GraphColours.doAddColor("grey13", new Color(33, 33, 33), false);
        GraphColours.doAddColor("gray14", new Color(36, 36, 36), false);
        GraphColours.doAddColor("grey14", new Color(36, 36, 36), false);
        GraphColours.doAddColor("gray15", new Color(38, 38, 38), false);
        GraphColours.doAddColor("grey15", new Color(38, 38, 38), false);
        GraphColours.doAddColor("gray16", new Color(41, 41, 41), false);
        GraphColours.doAddColor("grey16", new Color(41, 41, 41), false);
        GraphColours.doAddColor("gray17", new Color(43, 43, 43), false);
        GraphColours.doAddColor("grey17", new Color(43, 43, 43), false);
        GraphColours.doAddColor("gray18", new Color(46, 46, 46), false);
        GraphColours.doAddColor("grey18", new Color(46, 46, 46), false);
        GraphColours.doAddColor("gray19", new Color(48, 48, 48), false);
        GraphColours.doAddColor("grey19", new Color(48, 48, 48), false);
        GraphColours.doAddColor("gray20", new Color(51, 51, 51), false);
        GraphColours.doAddColor("grey20", new Color(51, 51, 51), false);
        GraphColours.doAddColor("gray21", new Color(54, 54, 54), false);
        GraphColours.doAddColor("grey21", new Color(54, 54, 54), false);
        GraphColours.doAddColor("gray22", new Color(56, 56, 56), false);
        GraphColours.doAddColor("grey22", new Color(56, 56, 56), false);
        GraphColours.doAddColor("gray23", new Color(59, 59, 59), false);
        GraphColours.doAddColor("grey23", new Color(59, 59, 59), false);
        GraphColours.doAddColor("gray24", new Color(61, 61, 61), false);
        GraphColours.doAddColor("grey24", new Color(61, 61, 61), false);
        GraphColours.doAddColor("gray25", new Color(64, 64, 64), false);
        GraphColours.doAddColor("grey25", new Color(64, 64, 64), false);
        GraphColours.doAddColor("gray26", new Color(66, 66, 66), false);
        GraphColours.doAddColor("grey26", new Color(66, 66, 66), false);
        GraphColours.doAddColor("gray27", new Color(69, 69, 69), false);
        GraphColours.doAddColor("grey27", new Color(69, 69, 69), false);
        GraphColours.doAddColor("gray28", new Color(71, 71, 71), false);
        GraphColours.doAddColor("grey28", new Color(71, 71, 71), false);
        GraphColours.doAddColor("gray29", new Color(74, 74, 74), false);
        GraphColours.doAddColor("grey29", new Color(74, 74, 74), false);
        GraphColours.doAddColor("gray30", new Color(77, 77, 77), false);
        GraphColours.doAddColor("grey30", new Color(77, 77, 77), false);
        GraphColours.doAddColor("gray31", new Color(79, 79, 79), false);
        GraphColours.doAddColor("grey31", new Color(79, 79, 79), false);
        GraphColours.doAddColor("gray32", new Color(82, 82, 82), false);
        GraphColours.doAddColor("grey32", new Color(82, 82, 82), false);
        GraphColours.doAddColor("gray33", new Color(84, 84, 84), false);
        GraphColours.doAddColor("grey33", new Color(84, 84, 84), false);
        GraphColours.doAddColor("gray34", new Color(87, 87, 87), false);
        GraphColours.doAddColor("grey34", new Color(87, 87, 87), false);
        GraphColours.doAddColor("gray35", new Color(89, 89, 89), false);
        GraphColours.doAddColor("grey35", new Color(89, 89, 89), false);
        GraphColours.doAddColor("gray36", new Color(92, 92, 92), false);
        GraphColours.doAddColor("grey36", new Color(92, 92, 92), false);
        GraphColours.doAddColor("gray37", new Color(94, 94, 94), false);
        GraphColours.doAddColor("grey37", new Color(94, 94, 94), false);
        GraphColours.doAddColor("gray38", new Color(97, 97, 97), false);
        GraphColours.doAddColor("grey38", new Color(97, 97, 97), false);
        GraphColours.doAddColor("gray39", new Color(99, 99, 99), false);
        GraphColours.doAddColor("grey39", new Color(99, 99, 99), false);
        GraphColours.doAddColor("gray40", new Color(102, 102, 102), false);
        GraphColours.doAddColor("grey40", new Color(102, 102, 102), false);
        GraphColours.doAddColor("gray41", new Color(105, 105, 105), false);
        GraphColours.doAddColor("grey41", new Color(105, 105, 105), false);
        GraphColours.doAddColor("gray42", new Color(107, 107, 107), false);
        GraphColours.doAddColor("grey42", new Color(107, 107, 107), false);
        GraphColours.doAddColor("gray43", new Color(110, 110, 110), false);
        GraphColours.doAddColor("grey43", new Color(110, 110, 110), false);
        GraphColours.doAddColor("gray44", new Color(112, 112, 112), false);
        GraphColours.doAddColor("grey44", new Color(112, 112, 112), false);
        GraphColours.doAddColor("gray45", new Color(115, 115, 115), false);
        GraphColours.doAddColor("grey45", new Color(115, 115, 115), false);
        GraphColours.doAddColor("gray46", new Color(117, 117, 117), false);
        GraphColours.doAddColor("grey46", new Color(117, 117, 117), false);
        GraphColours.doAddColor("gray47", new Color(120, 120, 120), false);
        GraphColours.doAddColor("grey47", new Color(120, 120, 120), false);
        GraphColours.doAddColor("gray48", new Color(122, 122, 122), false);
        GraphColours.doAddColor("grey48", new Color(122, 122, 122), false);
        GraphColours.doAddColor("gray49", new Color(125, 125, 125), false);
        GraphColours.doAddColor("grey49", new Color(125, 125, 125), false);
        GraphColours.doAddColor("gray50", new Color(127, 127, 127), false);
        GraphColours.doAddColor("grey50", new Color(127, 127, 127), false);
        GraphColours.doAddColor("gray51", new Color(130, 130, 130), false);
        GraphColours.doAddColor("grey51", new Color(130, 130, 130), false);
        GraphColours.doAddColor("gray52", new Color(133, 133, 133), false);
        GraphColours.doAddColor("grey52", new Color(133, 133, 133), false);
        GraphColours.doAddColor("gray53", new Color(135, 135, 135), false);
        GraphColours.doAddColor("grey53", new Color(135, 135, 135), false);
        GraphColours.doAddColor("gray54", new Color(138, 138, 138), false);
        GraphColours.doAddColor("grey54", new Color(138, 138, 138), false);
        GraphColours.doAddColor("gray55", new Color(140, 140, 140), false);
        GraphColours.doAddColor("grey55", new Color(140, 140, 140), false);
        GraphColours.doAddColor("gray56", new Color(143, 143, 143), false);
        GraphColours.doAddColor("grey56", new Color(143, 143, 143), false);
        GraphColours.doAddColor("gray57", new Color(145, 145, 145), false);
        GraphColours.doAddColor("grey57", new Color(145, 145, 145), false);
        GraphColours.doAddColor("gray58", new Color(148, 148, 148), false);
        GraphColours.doAddColor("grey58", new Color(148, 148, 148), false);
        GraphColours.doAddColor("gray59", new Color(150, 150, 150), false);
        GraphColours.doAddColor("grey59", new Color(150, 150, 150), false);
        GraphColours.doAddColor("gray60", new Color(153, 153, 153), false);
        GraphColours.doAddColor("grey60", new Color(153, 153, 153), false);
        GraphColours.doAddColor("gray61", new Color(156, 156, 156), false);
        GraphColours.doAddColor("grey61", new Color(156, 156, 156), false);
        GraphColours.doAddColor("gray62", new Color(158, 158, 158), false);
        GraphColours.doAddColor("grey62", new Color(158, 158, 158), false);
        GraphColours.doAddColor("gray63", new Color(161, 161, 161), false);
        GraphColours.doAddColor("grey63", new Color(161, 161, 161), false);
        GraphColours.doAddColor("gray64", new Color(163, 163, 163), false);
        GraphColours.doAddColor("grey64", new Color(163, 163, 163), false);
        GraphColours.doAddColor("gray65", new Color(166, 166, 166), false);
        GraphColours.doAddColor("grey65", new Color(166, 166, 166), false);
        GraphColours.doAddColor("gray66", new Color(168, 168, 168), false);
        GraphColours.doAddColor("grey66", new Color(168, 168, 168), false);
        GraphColours.doAddColor("gray67", new Color(171, 171, 171), false);
        GraphColours.doAddColor("grey67", new Color(171, 171, 171), false);
        GraphColours.doAddColor("gray68", new Color(173, 173, 173), false);
        GraphColours.doAddColor("grey68", new Color(173, 173, 173), false);
        GraphColours.doAddColor("gray69", new Color(176, 176, 176), false);
        GraphColours.doAddColor("grey69", new Color(176, 176, 176), false);
        GraphColours.doAddColor("gray70", new Color(179, 179, 179), false);
        GraphColours.doAddColor("grey70", new Color(179, 179, 179), false);
        GraphColours.doAddColor("gray71", new Color(181, 181, 181), false);
        GraphColours.doAddColor("grey71", new Color(181, 181, 181), false);
        GraphColours.doAddColor("gray72", new Color(184, 184, 184), false);
        GraphColours.doAddColor("grey72", new Color(184, 184, 184), false);
        GraphColours.doAddColor("gray73", new Color(186, 186, 186), false);
        GraphColours.doAddColor("grey73", new Color(186, 186, 186), false);
        GraphColours.doAddColor("gray74", new Color(189, 189, 189), false);
        GraphColours.doAddColor("grey74", new Color(189, 189, 189), false);
        GraphColours.doAddColor("gray75", new Color(191, 191, 191), false);
        GraphColours.doAddColor("grey75", new Color(191, 191, 191), false);
        GraphColours.doAddColor("gray76", new Color(194, 194, 194), false);
        GraphColours.doAddColor("grey76", new Color(194, 194, 194), false);
        GraphColours.doAddColor("gray77", new Color(196, 196, 196), false);
        GraphColours.doAddColor("grey77", new Color(196, 196, 196), false);
        GraphColours.doAddColor("gray78", new Color(199, 199, 199), false);
        GraphColours.doAddColor("grey78", new Color(199, 199, 199), false);
        GraphColours.doAddColor("gray79", new Color(201, 201, 201), false);
        GraphColours.doAddColor("grey79", new Color(201, 201, 201), false);
        GraphColours.doAddColor("gray80", new Color(204, 204, 204), false);
        GraphColours.doAddColor("grey80", new Color(204, 204, 204), false);
        GraphColours.doAddColor("gray81", new Color(207, 207, 207), false);
        GraphColours.doAddColor("grey81", new Color(207, 207, 207), false);
        GraphColours.doAddColor("gray82", new Color(209, 209, 209), false);
        GraphColours.doAddColor("grey82", new Color(209, 209, 209), false);
        GraphColours.doAddColor("gray83", new Color(212, 212, 212), false);
        GraphColours.doAddColor("grey83", new Color(212, 212, 212), false);
        GraphColours.doAddColor("gray84", new Color(214, 214, 214), false);
        GraphColours.doAddColor("grey84", new Color(214, 214, 214), false);
        GraphColours.doAddColor("gray85", new Color(217, 217, 217), false);
        GraphColours.doAddColor("grey85", new Color(217, 217, 217), false);
        GraphColours.doAddColor("gray86", new Color(219, 219, 219), false);
        GraphColours.doAddColor("grey86", new Color(219, 219, 219), false);
        GraphColours.doAddColor("gray87", new Color(222, 222, 222), false);
        GraphColours.doAddColor("grey87", new Color(222, 222, 222), false);
        GraphColours.doAddColor("gray88", new Color(224, 224, 224), false);
        GraphColours.doAddColor("grey88", new Color(224, 224, 224), false);
        GraphColours.doAddColor("gray89", new Color(227, 227, 227), false);
        GraphColours.doAddColor("grey89", new Color(227, 227, 227), false);
        GraphColours.doAddColor("gray90", new Color(229, 229, 229), false);
        GraphColours.doAddColor("grey90", new Color(229, 229, 229), false);
        GraphColours.doAddColor("gray91", new Color(232, 232, 232), false);
        GraphColours.doAddColor("grey91", new Color(232, 232, 232), false);
        GraphColours.doAddColor("gray92", new Color(235, 235, 235), false);
        GraphColours.doAddColor("grey92", new Color(235, 235, 235), false);
        GraphColours.doAddColor("gray93", new Color(237, 237, 237), false);
        GraphColours.doAddColor("grey93", new Color(237, 237, 237), false);
        GraphColours.doAddColor("gray94", new Color(240, 240, 240), false);
        GraphColours.doAddColor("grey94", new Color(240, 240, 240), false);
        GraphColours.doAddColor("gray95", new Color(242, 242, 242), false);
        GraphColours.doAddColor("grey95", new Color(242, 242, 242), false);
        GraphColours.doAddColor("gray96", new Color(245, 245, 245), false);
        GraphColours.doAddColor("grey96", new Color(245, 245, 245), false);
        GraphColours.doAddColor("gray97", new Color(247, 247, 247), false);
        GraphColours.doAddColor("grey97", new Color(247, 247, 247), false);
        GraphColours.doAddColor("gray98", new Color(250, 250, 250), false);
        GraphColours.doAddColor("grey98", new Color(250, 250, 250), false);
        GraphColours.doAddColor("gray99", new Color(252, 252, 252), false);
        GraphColours.doAddColor("grey99", new Color(252, 252, 252), false);
        GraphColours.doAddColor("gray100", new Color(255, 255, 255), false);
        GraphColours.doAddColor("grey100", new Color(255, 255, 255), false);
        GraphColours.doAddColor("honeydew", new Color(240, 255, 240));
        GraphColours.doAddColor("honeydew1", new Color(240, 255, 240), false);
        GraphColours.doAddColor("honeydew2", new Color(224, 238, 224), false);
        GraphColours.doAddColor("honeydew3", new Color(193, 205, 193), false);
        GraphColours.doAddColor("honeydew4", new Color(131, 139, 131), false);
        GraphColours.doAddColor("hotpink", new Color(255, 105, 180));
        GraphColours.doAddColor("hotpink1", new Color(255, 110, 180), false);
        GraphColours.doAddColor("hotpink2", new Color(238, 106, 167), false);
        GraphColours.doAddColor("hotpink3", new Color(205, 96, 144), false);
        GraphColours.doAddColor("hotpink4", new Color(139, 58, 98), false);
        GraphColours.doAddColor("indianred", new Color(205, 92, 92));
        GraphColours.doAddColor("indianred1", new Color(255, 106, 106), false);
        GraphColours.doAddColor("indianred2", new Color(238, 99, 99), false);
        GraphColours.doAddColor("indianred3", new Color(205, 85, 85), false);
        GraphColours.doAddColor("indianred4", new Color(139, 58, 58), false);
        GraphColours.doAddColor("indigo", new Color(75, 0, 130));
        GraphColours.doAddColor("ivory", new Color(255, 255, 240));
        GraphColours.doAddColor("ivory1", new Color(255, 255, 240), false);
        GraphColours.doAddColor("ivory2", new Color(238, 238, 224), false);
        GraphColours.doAddColor("ivory3", new Color(205, 205, 193), false);
        GraphColours.doAddColor("ivory4", new Color(139, 139, 131), false);
        GraphColours.doAddColor("khaki", new Color(240, 230, 140));
        GraphColours.doAddColor("khaki1", new Color(255, 246, 143), false);
        GraphColours.doAddColor("khaki2", new Color(238, 230, 133), false);
        GraphColours.doAddColor("khaki3", new Color(205, 198, 115), false);
        GraphColours.doAddColor("khaki4", new Color(139, 134, 78), false);
        GraphColours.doAddColor("lavender", new Color(230, 230, 250));
        GraphColours.doAddColor("lavenderblush", new Color(255, 240, 245));
        GraphColours.doAddColor("lavenderblush1", new Color(255, 240, 245), false);
        GraphColours.doAddColor("lavenderblush2", new Color(238, 224, 229), false);
        GraphColours.doAddColor("lavenderblush3", new Color(205, 193, 197), false);
        GraphColours.doAddColor("lavenderblush4", new Color(139, 131, 134), false);
        GraphColours.doAddColor("lawngreen", new Color(124, 252, 0));
        GraphColours.doAddColor("lemonchiffon", new Color(255, 250, 205));
        GraphColours.doAddColor("lemonchiffon1", new Color(255, 250, 205), false);
        GraphColours.doAddColor("lemonchiffon2", new Color(238, 233, 191), false);
        GraphColours.doAddColor("lemonchiffon3", new Color(205, 201, 165), false);
        GraphColours.doAddColor("lemonchiffon4", new Color(139, 137, 112), false);
        GraphColours.doAddColor("lightblue", new Color(173, 216, 230));
        GraphColours.doAddColor("lightblue1", new Color(191, 239, 255), false);
        GraphColours.doAddColor("lightblue2", new Color(178, 223, 238), false);
        GraphColours.doAddColor("lightblue3", new Color(154, 192, 205), false);
        GraphColours.doAddColor("lightblue4", new Color(104, 131, 139), false);
        GraphColours.doAddColor("lightcoral", new Color(240, 128, 128));
        GraphColours.doAddColor("lightcyan", new Color(224, 255, 255));
        GraphColours.doAddColor("lightcyan1", new Color(224, 255, 255), false);
        GraphColours.doAddColor("lightcyan2", new Color(209, 238, 238), false);
        GraphColours.doAddColor("lightcyan3", new Color(180, 205, 205), false);
        GraphColours.doAddColor("lightcyan4", new Color(122, 139, 139), false);
        GraphColours.doAddColor("lightgoldenrod", new Color(238, 221, 130));
        GraphColours.doAddColor("lightgoldenrod1", new Color(255, 236, 139), false);
        GraphColours.doAddColor("lightgoldenrod2", new Color(238, 220, 130), false);
        GraphColours.doAddColor("lightgoldenrod3", new Color(205, 190, 112), false);
        GraphColours.doAddColor("lightgoldenrod4", new Color(139, 129, 76), false);
        GraphColours.doAddColor("lightgoldenrodyellow", new Color(250, 250, 210));
        GraphColours.doAddColor("lightgray", new Color(211, 211, 211));
        GraphColours.doAddColor("lightgreen", new Color(144, 238, 144));
        GraphColours.doAddColor("lightgrey", new Color(211, 211, 211), false);
        GraphColours.doAddColor("lightpink", new Color(255, 182, 193));
        GraphColours.doAddColor("lightpink1", new Color(255, 174, 185), false);
        GraphColours.doAddColor("lightpink2", new Color(238, 162, 173), false);
        GraphColours.doAddColor("lightpink3", new Color(205, 140, 149), false);
        GraphColours.doAddColor("lightpink4", new Color(139, 95, 101), false);
        GraphColours.doAddColor("lightsalmon", new Color(255, 160, 122));
        GraphColours.doAddColor("lightsalmon1", new Color(255, 160, 122), false);
        GraphColours.doAddColor("lightsalmon2", new Color(238, 149, 114), false);
        GraphColours.doAddColor("lightsalmon3", new Color(205, 129, 98), false);
        GraphColours.doAddColor("lightsalmon4", new Color(139, 87, 66), false);
        GraphColours.doAddColor("lightseagreen", new Color(32, 178, 170));
        GraphColours.doAddColor("lightskyblue", new Color(135, 206, 250));
        GraphColours.doAddColor("lightskyblue1", new Color(176, 226, 255), false);
        GraphColours.doAddColor("lightskyblue2", new Color(164, 211, 238), false);
        GraphColours.doAddColor("lightskyblue3", new Color(141, 182, 205), false);
        GraphColours.doAddColor("lightskyblue4", new Color(96, 123, 139), false);
        GraphColours.doAddColor("lightslateblue", new Color(132, 112, 255));
        GraphColours.doAddColor("lightslategray", new Color(119, 136, 153));
        GraphColours.doAddColor("lightslategrey", new Color(119, 136, 153), false);
        GraphColours.doAddColor("lightsteelblue", new Color(176, 196, 222));
        GraphColours.doAddColor("lightsteelblue1", new Color(202, 225, 255), false);
        GraphColours.doAddColor("lightsteelblue2", new Color(188, 210, 238), false);
        GraphColours.doAddColor("lightsteelblue3", new Color(162, 181, 205), false);
        GraphColours.doAddColor("lightsteelblue4", new Color(110, 123, 139), false);
        GraphColours.doAddColor("lightyellow", new Color(255, 255, 224));
        GraphColours.doAddColor("lightyellow1", new Color(255, 255, 224), false);
        GraphColours.doAddColor("lightyellow2", new Color(238, 238, 209), false);
        GraphColours.doAddColor("lightyellow3", new Color(205, 205, 180), false);
        GraphColours.doAddColor("lightyellow4", new Color(139, 139, 122), false);
        GraphColours.doAddColor("limegreen", new Color(50, 205, 50));
        GraphColours.doAddColor("linen", new Color(250, 240, 230));
        GraphColours.doAddColor("magenta", new Color(255, 0, 255));
        GraphColours.doAddColor("magenta1", new Color(255, 0, 255), false);
        GraphColours.doAddColor("magenta2", new Color(238, 0, 238), false);
        GraphColours.doAddColor("magenta3", new Color(205, 0, 205), false);
        GraphColours.doAddColor("magenta4", new Color(139, 0, 139), false);
        GraphColours.doAddColor("maroon", new Color(176, 48, 96));
        GraphColours.doAddColor("maroon1", new Color(255, 52, 179), false);
        GraphColours.doAddColor("maroon2", new Color(238, 48, 167), false);
        GraphColours.doAddColor("maroon3", new Color(205, 41, 144), false);
        GraphColours.doAddColor("maroon4", new Color(139, 28, 98), false);
        GraphColours.doAddColor("mediumaquamarine", new Color(102, 205, 170));
        GraphColours.doAddColor("mediumblue", new Color(0, 0, 205));
        GraphColours.doAddColor("mediumorchid", new Color(186, 85, 211));
        GraphColours.doAddColor("mediumorchid1", new Color(224, 102, 255), false);
        GraphColours.doAddColor("mediumorchid2", new Color(209, 95, 238), false);
        GraphColours.doAddColor("mediumorchid3", new Color(180, 82, 205), false);
        GraphColours.doAddColor("mediumorchid4", new Color(122, 55, 139), false);
        GraphColours.doAddColor("mediumpurple", new Color(147, 112, 219));
        GraphColours.doAddColor("mediumpurple1", new Color(171, 130, 255), false);
        GraphColours.doAddColor("mediumpurple2", new Color(159, 121, 238), false);
        GraphColours.doAddColor("mediumpurple3", new Color(137, 104, 205), false);
        GraphColours.doAddColor("mediumpurple4", new Color(93, 71, 139), false);
        GraphColours.doAddColor("mediumseagreen", new Color(60, 179, 113));
        GraphColours.doAddColor("mediumslateblue", new Color(123, 104, 238));
        GraphColours.doAddColor("mediumspringgreen", new Color(0, 250, 154));
        GraphColours.doAddColor("mediumturquoise", new Color(72, 209, 204));
        GraphColours.doAddColor("mediumvioletred", new Color(199, 21, 133));
        GraphColours.doAddColor("midnightblue", new Color(25, 25, 112));
        GraphColours.doAddColor("mintcream", new Color(245, 255, 250));
        GraphColours.doAddColor("mistyrose", new Color(255, 228, 225));
        GraphColours.doAddColor("mistyrose1", new Color(255, 228, 225), false);
        GraphColours.doAddColor("mistyrose2", new Color(238, 213, 210), false);
        GraphColours.doAddColor("mistyrose3", new Color(205, 183, 181), false);
        GraphColours.doAddColor("mistyrose4", new Color(139, 125, 123), false);
        GraphColours.doAddColor("moccasin", new Color(255, 228, 181));
        GraphColours.doAddColor("navajowhite", new Color(255, 222, 173));
        GraphColours.doAddColor("navajowhite1", new Color(255, 222, 173), false);
        GraphColours.doAddColor("navajowhite2", new Color(238, 207, 161), false);
        GraphColours.doAddColor("navajowhite3", new Color(205, 179, 139), false);
        GraphColours.doAddColor("navajowhite4", new Color(139, 121, 94), false);
        GraphColours.doAddColor("navy", new Color(0, 0, 128));
        GraphColours.doAddColor("navyblue", new Color(0, 0, 128), false);
        GraphColours.doAddColor("oldlace", new Color(253, 245, 230));
        GraphColours.doAddColor("olivedrab", new Color(107, 142, 35));
        GraphColours.doAddColor("olivedrab1", new Color(192, 255, 62), false);
        GraphColours.doAddColor("olivedrab2", new Color(179, 238, 58), false);
        GraphColours.doAddColor("olivedrab3", new Color(154, 205, 50), false);
        GraphColours.doAddColor("olivedrab4", new Color(105, 139, 34), false);
        GraphColours.doAddColor("orange", new Color(255, 165, 0));
        GraphColours.doAddColor("orange1", new Color(255, 165, 0), false);
        GraphColours.doAddColor("orange2", new Color(238, 154, 0), false);
        GraphColours.doAddColor("orange3", new Color(205, 133, 0), false);
        GraphColours.doAddColor("orange4", new Color(139, 90, 0), false);
        GraphColours.doAddColor("orangered", new Color(255, 69, 0));
        GraphColours.doAddColor("orangered1", new Color(255, 69, 0), false);
        GraphColours.doAddColor("orangered2", new Color(238, 64, 0), false);
        GraphColours.doAddColor("orangered3", new Color(205, 55, 0), false);
        GraphColours.doAddColor("orangered4", new Color(139, 37, 0), false);
        GraphColours.doAddColor("orchid", new Color(218, 112, 214));
        GraphColours.doAddColor("orchid1", new Color(255, 131, 250), false);
        GraphColours.doAddColor("orchid2", new Color(238, 122, 233), false);
        GraphColours.doAddColor("orchid3", new Color(205, 105, 201), false);
        GraphColours.doAddColor("orchid4", new Color(139, 71, 137), false);
        GraphColours.doAddColor("palegoldenrod", new Color(238, 232, 170));
        GraphColours.doAddColor("palegreen", new Color(152, 251, 152));
        GraphColours.doAddColor("palegreen1", new Color(154, 255, 154), false);
        GraphColours.doAddColor("palegreen2", new Color(144, 238, 144), false);
        GraphColours.doAddColor("palegreen3", new Color(124, 205, 124), false);
        GraphColours.doAddColor("palegreen4", new Color(84, 139, 84), false);
        GraphColours.doAddColor("paleturquoise", new Color(175, 238, 238));
        GraphColours.doAddColor("paleturquoise1", new Color(187, 255, 255), false);
        GraphColours.doAddColor("paleturquoise2", new Color(174, 238, 238), false);
        GraphColours.doAddColor("paleturquoise3", new Color(150, 205, 205), false);
        GraphColours.doAddColor("paleturquoise4", new Color(102, 139, 139), false);
        GraphColours.doAddColor("palevioletred", new Color(219, 112, 147));
        GraphColours.doAddColor("palevioletred1", new Color(255, 130, 171), false);
        GraphColours.doAddColor("palevioletred2", new Color(238, 121, 159), false);
        GraphColours.doAddColor("palevioletred3", new Color(205, 104, 137), false);
        GraphColours.doAddColor("palevioletred4", new Color(139, 71, 93), false);
        GraphColours.doAddColor("papayawhip", new Color(255, 239, 213));
        GraphColours.doAddColor("peachpuff", new Color(255, 218, 185));
        GraphColours.doAddColor("peachpuff1", new Color(255, 218, 185), false);
        GraphColours.doAddColor("peachpuff2", new Color(238, 203, 173), false);
        GraphColours.doAddColor("peachpuff3", new Color(205, 175, 149), false);
        GraphColours.doAddColor("peachpuff4", new Color(139, 119, 101), false);
        GraphColours.doAddColor("peru", new Color(205, 133, 63));
        GraphColours.doAddColor("pink", new Color(255, 192, 203));
        GraphColours.doAddColor("pink1", new Color(255, 181, 197), false);
        GraphColours.doAddColor("pink2", new Color(238, 169, 184), false);
        GraphColours.doAddColor("pink3", new Color(205, 145, 158), false);
        GraphColours.doAddColor("pink4", new Color(139, 99, 108), false);
        GraphColours.doAddColor("plum", new Color(221, 160, 221));
        GraphColours.doAddColor("plum1", new Color(255, 187, 255), false);
        GraphColours.doAddColor("plum2", new Color(238, 174, 238), false);
        GraphColours.doAddColor("plum3", new Color(205, 150, 205), false);
        GraphColours.doAddColor("plum4", new Color(139, 102, 139), false);
        GraphColours.doAddColor("powderblue", new Color(176, 224, 230));
        GraphColours.doAddColor("purple", new Color(160, 32, 240));
        GraphColours.doAddColor("purple1", new Color(155, 48, 255), false);
        GraphColours.doAddColor("purple2", new Color(145, 44, 238), false);
        GraphColours.doAddColor("purple3", new Color(125, 38, 205), false);
        GraphColours.doAddColor("purple4", new Color(85, 26, 139), false);
        GraphColours.doAddColor("red", new Color(255, 0, 0));
        GraphColours.doAddColor("red1", new Color(255, 0, 0), false);
        GraphColours.doAddColor("red2", new Color(238, 0, 0), false);
        GraphColours.doAddColor("red3", new Color(205, 0, 0), false);
        GraphColours.doAddColor("red4", new Color(139, 0, 0), false);
        GraphColours.doAddColor("rosybrown", new Color(188, 143, 143));
        GraphColours.doAddColor("rosybrown1", new Color(255, 193, 193), false);
        GraphColours.doAddColor("rosybrown2", new Color(238, 180, 180), false);
        GraphColours.doAddColor("rosybrown3", new Color(205, 155, 155), false);
        GraphColours.doAddColor("rosybrown4", new Color(139, 105, 105), false);
        GraphColours.doAddColor("royalblue", new Color(65, 105, 225));
        GraphColours.doAddColor("royalblue1", new Color(72, 118, 255), false);
        GraphColours.doAddColor("royalblue2", new Color(67, 110, 238), false);
        GraphColours.doAddColor("royalblue3", new Color(58, 95, 205), false);
        GraphColours.doAddColor("royalblue4", new Color(39, 64, 139), false);
        GraphColours.doAddColor("saddlebrown", new Color(139, 69, 19));
        GraphColours.doAddColor("salmon", new Color(250, 128, 114));
        GraphColours.doAddColor("salmon1", new Color(255, 140, 105), false);
        GraphColours.doAddColor("salmon2", new Color(238, 130, 98), false);
        GraphColours.doAddColor("salmon3", new Color(205, 112, 84), false);
        GraphColours.doAddColor("salmon4", new Color(139, 76, 57), false);
        GraphColours.doAddColor("sandybrown", new Color(244, 164, 96));
        GraphColours.doAddColor("seagreen", new Color(46, 139, 87));
        GraphColours.doAddColor("seagreen1", new Color(84, 255, 159), false);
        GraphColours.doAddColor("seagreen2", new Color(78, 238, 148), false);
        GraphColours.doAddColor("seagreen3", new Color(67, 205, 128), false);
        GraphColours.doAddColor("seagreen4", new Color(46, 139, 87), false);
        GraphColours.doAddColor("seashell", new Color(255, 245, 238));
        GraphColours.doAddColor("seashell1", new Color(255, 245, 238), false);
        GraphColours.doAddColor("seashell2", new Color(238, 229, 222), false);
        GraphColours.doAddColor("seashell3", new Color(205, 197, 191), false);
        GraphColours.doAddColor("seashell4", new Color(139, 134, 130), false);
        GraphColours.doAddColor("sgiindigo2", new Color(33, 136, 104), false);
        GraphColours.doAddColor("sienna", new Color(160, 82, 45));
        GraphColours.doAddColor("sienna1", new Color(255, 130, 71), false);
        GraphColours.doAddColor("sienna2", new Color(238, 121, 66), false);
        GraphColours.doAddColor("sienna3", new Color(205, 104, 57), false);
        GraphColours.doAddColor("sienna4", new Color(139, 71, 38), false);
        GraphColours.doAddColor("skyblue", new Color(135, 206, 235));
        GraphColours.doAddColor("skyblue1", new Color(135, 206, 255), false);
        GraphColours.doAddColor("skyblue2", new Color(126, 192, 238), false);
        GraphColours.doAddColor("skyblue3", new Color(108, 166, 205), false);
        GraphColours.doAddColor("skyblue4", new Color(74, 112, 139), false);
        GraphColours.doAddColor("slateblue", new Color(106, 90, 205));
        GraphColours.doAddColor("slateblue1", new Color(131, 111, 255), false);
        GraphColours.doAddColor("slateblue2", new Color(122, 103, 238), false);
        GraphColours.doAddColor("slateblue3", new Color(105, 89, 205), false);
        GraphColours.doAddColor("slateblue4", new Color(71, 60, 139), false);
        GraphColours.doAddColor("slategray", new Color(112, 128, 144));
        GraphColours.doAddColor("slategray1", new Color(198, 226, 255), false);
        GraphColours.doAddColor("slategray2", new Color(185, 211, 238), false);
        GraphColours.doAddColor("slategray3", new Color(159, 182, 205), false);
        GraphColours.doAddColor("slategray4", new Color(108, 123, 139), false);
        GraphColours.doAddColor("slategrey", new Color(112, 128, 144), false);
        GraphColours.doAddColor("snow", new Color(255, 250, 250));
        GraphColours.doAddColor("snow1", new Color(255, 250, 250), false);
        GraphColours.doAddColor("snow2", new Color(238, 233, 233), false);
        GraphColours.doAddColor("snow3", new Color(205, 201, 201), false);
        GraphColours.doAddColor("snow4", new Color(139, 137, 137), false);
        GraphColours.doAddColor("springgreen", new Color(0, 255, 127));
        GraphColours.doAddColor("springgreen1", new Color(0, 255, 127), false);
        GraphColours.doAddColor("springgreen2", new Color(0, 238, 118), false);
        GraphColours.doAddColor("springgreen3", new Color(0, 205, 102), false);
        GraphColours.doAddColor("springgreen4", new Color(0, 139, 69), false);
        GraphColours.doAddColor("steelblue", new Color(70, 130, 180));
        GraphColours.doAddColor("steelblue1", new Color(99, 184, 255), false);
        GraphColours.doAddColor("steelblue2", new Color(92, 172, 238), false);
        GraphColours.doAddColor("steelblue3", new Color(79, 148, 205), false);
        GraphColours.doAddColor("steelblue4", new Color(54, 100, 139), false);
        GraphColours.doAddColor("tan", new Color(210, 180, 140));
        GraphColours.doAddColor("tan1", new Color(255, 165, 79), false);
        GraphColours.doAddColor("tan2", new Color(238, 154, 73), false);
        GraphColours.doAddColor("tan3", new Color(205, 133, 63), false);
        GraphColours.doAddColor("tan4", new Color(139, 90, 43), false);
        GraphColours.doAddColor("thistle", new Color(216, 191, 216));
        GraphColours.doAddColor("thistle1", new Color(255, 225, 255), false);
        GraphColours.doAddColor("thistle2", new Color(238, 210, 238), false);
        GraphColours.doAddColor("thistle3", new Color(205, 181, 205), false);
        GraphColours.doAddColor("thistle4", new Color(139, 123, 139), false);
        GraphColours.doAddColor("tomato", new Color(255, 99, 71));
        GraphColours.doAddColor("tomato1", new Color(255, 99, 71), false);
        GraphColours.doAddColor("tomato2", new Color(238, 92, 66), false);
        GraphColours.doAddColor("tomato3", new Color(205, 79, 57), false);
        GraphColours.doAddColor("tomato4", new Color(139, 54, 38), false);
        GraphColours.doAddColor("turquoise", new Color(64, 224, 208));
        GraphColours.doAddColor("turquoise1", new Color(0, 245, 255), false);
        GraphColours.doAddColor("turquoise2", new Color(0, 229, 238), false);
        GraphColours.doAddColor("turquoise3", new Color(0, 197, 205), false);
        GraphColours.doAddColor("turquoise4", new Color(0, 134, 139), false);
        GraphColours.doAddColor("violet", new Color(238, 130, 238));
        GraphColours.doAddColor("violetred", new Color(208, 32, 144));
        GraphColours.doAddColor("violetred1", new Color(255, 62, 150), false);
        GraphColours.doAddColor("violetred2", new Color(238, 58, 140), false);
        GraphColours.doAddColor("violetred3", new Color(205, 50, 120), false);
        GraphColours.doAddColor("violetred4", new Color(139, 34, 82), false);
        GraphColours.doAddColor("wheat", new Color(245, 222, 179));
        GraphColours.doAddColor("wheat1", new Color(255, 231, 186), false);
        GraphColours.doAddColor("wheat2", new Color(238, 216, 174), false);
        GraphColours.doAddColor("wheat3", new Color(205, 186, 150), false);
        GraphColours.doAddColor("wheat4", new Color(139, 126, 102), false);
        GraphColours.doAddColor("white", new Color(255, 255, 255));
        GraphColours.doAddColor("whitesmoke", new Color(245, 245, 245));
        GraphColours.doAddColor("yellow", new Color(255, 255, 0));
        GraphColours.doAddColor("yellow1", new Color(255, 255, 0), false);
        GraphColours.doAddColor("yellow2", new Color(238, 238, 0), false);
        GraphColours.doAddColor("yellow3", new Color(205, 205, 0), false);
        GraphColours.doAddColor("yellow4", new Color(139, 139, 0), false);
        GraphColours.doAddColor("yellowgreen", new Color(154, 205, 50));
        defaultForeground = GraphColours.getColour("black", null);
        defaultBackground = GraphColours.getColour("white", null);
        defaultXOR = GraphColours.getColour("light gray", null);
        defaultFontcolor = GraphColours.getColour("black", null);
        defaultColor = GraphColours.getColour("black", null);
    }
}

