/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.AntModel;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.CommonNode;
import org.biomoby.service.dashboard.ConsoleStream;
import org.biomoby.service.dashboard.DeploymentTable;
import org.biomoby.service.dashboard.GraphColours;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.ServicesBoard;
import org.biomoby.service.dashboard.ServicesTree;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.shared.MobyException;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.gui.JFileChooserWithHistory;
import org.tulsoft.tools.gui.JTextFieldWithHistory;
import org.tulsoft.tools.gui.SwingUtils;

public class GeneratorPanel
extends AbstractPanel {
    protected static final String ANT_ERROR = "Sorry, an error happened when running a task.\n\nThe details should be in the console area, or\nthey might had been reported to a log (file)\n\n";
    protected static final String JMOBY_ERROR = "Sorry, but in order to use MoSeS Generators\nyou need to have full jMoby installation, and\nyou need to start Dashboard from a jMoby directory.\n\nThis application does not allow me to change\ndirectories. Please, close Dashboard, go to\nthe jMoby directory, and start Dashboard again.\n\n";
    protected static final String NOSEL_ERROR = "Sorry, you need first to select some services\nwhich you wish Moses generates code for.\n\nYou can select several (or even many) of them\nby using CTRL and SHIFT when selecting them.\nYou can also select one or more authorities\n(then code for all their services will be made).\n\n";
    protected static final String NODEPL_ERROR = "Sorry, you need first to select some services\nwhich you wish to be deployed (or undeployed).\n\nYou can select several (or even many) of them\nby using CTRL and SHIFT when selecting them.\nYou can also select one or more authorities\n(it will add all their services to the list).\n\n";
    protected static final String NOIMPL_ERROR = "Sorry, each service that is going to be deployed\nneeds to have assigned a class that implements it.\n\n";
    AntModel antModel;
    RegistryModel registryModel;
    CommonConsole console;
    JFileChooserWithHistory outputDir;
    JFileChooserWithHistory javadocDir;
    JFileChooserWithHistory dotLocation;
    JLabel labelDotLocation;
    JButton dtgenButton;
    JButton sgenButton;
    JButton bothButton;
    JButton dtclsButton;
    JButton sclsButton;
    JButton deployButton;
    JButton undeployButton;
    JLabel aSelectedCount;
    JLabel sSelectedCount;
    JCheckBox dtGenerate;
    JCheckBox dtCompile;
    JCheckBox dtJavadoc;
    JCheckBox dtJar;
    JCheckBox sGenerate;
    JCheckBox sCompile;
    JCheckBox sJavadoc;
    JCheckBox sJar;
    JTextFieldWithHistory pattern;
    DeploymentTable dTable;
    JCheckBox copyBySelect;
    JRadioButton locally;
    protected static Icon genDTIcon;
    protected static Icon genDTIconDis;
    protected static Icon genSIcon;
    protected static Icon genSIconDis;
    protected static Icon genIcon;
    protected static Icon genIconDis;
    protected static Icon trashIcon;
    protected static Icon trashIconDis;
    protected static Icon deployIcon;
    protected static Icon deployIconDis;
    protected static Icon undeployIcon;
    protected static Icon undeployIconDis;
    private ActionListener deployListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String local = e.getActionCommand();
            boolean isLocal = UUtils.is((String)local);
            GeneratorPanel.this.setPrefValue("use-local-deploy", isLocal);
            GeneratorPanel.this.propertyChannel.put("use-local-deploy", local);
            GeneratorPanel.this.undeployButton.setEnabled(isLocal);
            GeneratorPanel.this.undeployButton.setEnabled(false);
        }
    };

    public GeneratorPanel() {
        this.panelIconFileName = "images/bricks.gif";
    }

    @Override
    protected void loadIcons() {
        super.loadIcons();
        if (genDTIcon == null) {
            genDTIcon = GeneratorPanel.loadIcon("images/yellowDiamond.gif");
        }
        if (genDTIconDis == null) {
            genDTIconDis = GeneratorPanel.loadIcon("images/yellowDiamond_dis.gif");
        }
        if (genSIcon == null) {
            genSIcon = GeneratorPanel.loadIcon("images/smallClass.gif");
        }
        if (genSIconDis == null) {
            genSIconDis = GeneratorPanel.loadIcon("images/smallClass_dis.gif");
        }
        if (genIcon == null) {
            genIcon = GeneratorPanel.loadIcon("images/smallClass2.gif");
        }
        if (genIconDis == null) {
            genIconDis = GeneratorPanel.loadIcon("images/smallClass2_dis.gif");
        }
        if (trashIcon == null) {
            trashIcon = GeneratorPanel.loadIcon("images/smallTrash.gif");
        }
        if (trashIconDis == null) {
            trashIconDis = GeneratorPanel.loadIcon("images/smallTrash_dis.gif");
        }
        if (deployIcon == null) {
            deployIcon = GeneratorPanel.loadIcon("images/smallDeploy.gif");
        }
        if (deployIconDis == null) {
            deployIconDis = GeneratorPanel.loadIcon("images/smallDeploy_dis.gif");
        }
        if (undeployIcon == null) {
            undeployIcon = GeneratorPanel.loadIcon("images/smallUnDeploy.gif");
        }
        if (undeployIconDis == null) {
            undeployIconDis = GeneratorPanel.loadIcon("images/smallUnDeploy_dis.gif");
        }
    }

    @Override
    public JComponent getComponent(PropertyChannel aPropertyChannel) {
        this.setPropertyChannel(aPropertyChannel);
        this.registryModel = this.createRegistryModel();
        this.antModel = new AntModel(this.registryModel);
        this.antModel.setPropertyChannel(aPropertyChannel);
        if (this.pComponent != null) {
            return this.pComponent;
        }
        this.pComponent = new JPanel(new GridBagLayout(), true);
        this.console = new CommonConsole();
        this.console.setAppendMode(true);
        this.console.setVerboseMode(true);
        this.antModel.setOutputStream(new ConsoleStream(this.console, false));
        this.antModel.setErrorStream(new ConsoleStream(this.console, true));
        this.antModel.setMsgOutputLevel(2);
        JPanel selection = this.getServicesSelectionPanel();
        JPanel generators = this.getGeneratorsPanel();
        JPanel deployment = this.getDeploymentPanel();
        JSplitPane split = this.hSplit(this.vSplit(this.hSplit(selection, generators, 0.9), this.console, 0.2), deployment, 0.9);
        SwingUtils.addComponent((JComponent)this.pComponent, (Component)split, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        return this.pComponent;
    }

    protected JPanel getServicesSelectionPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(GeneratorPanel.createFatBorder("Select services to work with", GraphColours.getColour("cadetblue", Color.blue)));
        ServicesBoard servicesBoard = new ServicesBoard(this.registryModel, this.console, this.propertyChannel, new CustomServicesTree(this.registryModel, this.console));
        servicesBoard.updateTree(1);
        JPanel counters = new JPanel(new GridBagLayout());
        JLabel lASelected = new JLabel(" selected authorities");
        this.aSelectedCount = new JLabel("0");
        this.aSelectedCount.setHorizontalAlignment(4);
        JLabel lSSelected = new JLabel(" selected services");
        this.sSelectedCount = new JLabel("0");
        this.sSelectedCount.setHorizontalAlignment(4);
        SwingUtils.addComponent((JComponent)counters, (Component)this.aSelectedCount, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)counters, (Component)lASelected, (int)1, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)counters, (Component)this.sSelectedCount, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)counters, (Component)lSSelected, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)servicesBoard, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        SwingUtils.addComponent((JComponent)p, (Component)counters, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        return p;
    }

    protected JPanel getGeneratorsPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(GeneratorPanel.createFatBorder("Code Generators", GraphColours.getColour("cadetblue", Color.blue)));
        JPanel genData = GeneratorPanel.createTitledPanel("Data Types");
        this.dtGenerate = this.createActionBox("Generate code", "use-dt-gen");
        this.dtCompile = this.createActionBox("Compile code", "use-dt-comp");
        this.dtJavadoc = this.createActionBox("Generate javadoc", "use-dt-doc");
        this.dtJar = this.createActionBox("Packed into jar", "use-dt-jar");
        this.dtgenButton = GeneratorPanel.createButton(" Process datatypes ", "Deal with all datatypes - do what is selected in the boxes above", 68, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GeneratorPanel.this.isInJMobyDirectory()) {
                    GeneratorPanel.this.onDataTypes();
                }
            }
        });
        this.dtgenButton.setIcon(genDTIcon);
        this.dtgenButton.setDisabledIcon(genDTIconDis);
        this.dtclsButton = GeneratorPanel.createButton("", "Remove generated code for all datatypes", -1, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GeneratorPanel.this.isInJMobyDirectory()) {
                    GeneratorPanel.this.onCleanDataTypes();
                }
            }
        });
        this.dtclsButton.setIcon(trashIcon);
        this.dtclsButton.setDisabledIcon(trashIconDis);
        SwingUtils.compact((JButton)this.dtclsButton);
        SwingUtils.addComponent((JComponent)genData, (Component)this.dtGenerate, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)genData, (Component)this.dtclsButton, (int)1, (int)0, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)genData, (Component)this.dtCompile, (int)0, (int)1, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)genData, (Component)this.dtJavadoc, (int)0, (int)2, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)genData, (Component)this.dtJar, (int)0, (int)3, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)genData, (Component)this.dtgenButton, (int)0, (int)4, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        JPanel genSkel = GeneratorPanel.createTitledPanel("Services");
        this.sGenerate = this.createActionBox("Generate code", "use-s-gen");
        this.sCompile = this.createActionBox("Compile code", "use-s-comp");
        this.sJavadoc = this.createActionBox("Generate javadoc", "use-s-doc");
        this.sJar = this.createActionBox("Packed into jar", "use-s-jar");
        this.sgenButton = GeneratorPanel.createButton(" Process skeletons ", "Deal with all (or for selected, filtered) service skeletons", 83, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector a = (Vector)GeneratorPanel.this.propertyChannel.get("selectedAuthorities");
                Vector s = (Vector)GeneratorPanel.this.propertyChannel.get("selectedServices");
                if (!(a != null && a.size() != 0 || s != null && s.size() != 0)) {
                    String msg = GeneratorPanel.NOSEL_ERROR.replaceAll("\\\\n", "<br>");
                    AbstractPanel.error("<html>" + msg);
                } else if (GeneratorPanel.this.isInJMobyDirectory()) {
                    GeneratorPanel.this.onSkeletons();
                }
            }
        });
        this.sgenButton.setIcon(genSIcon);
        this.sgenButton.setDisabledIcon(genSIconDis);
        this.sclsButton = GeneratorPanel.createButton("", "Remove generated code for all skeletons", -1, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GeneratorPanel.this.isInJMobyDirectory()) {
                    GeneratorPanel.this.onCleanSkeletons();
                }
            }
        });
        this.sclsButton.setIcon(trashIcon);
        this.sclsButton.setDisabledIcon(trashIconDis);
        SwingUtils.compact((JButton)this.sclsButton);
        SwingUtils.addComponent((JComponent)genSkel, (Component)this.sGenerate, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)genSkel, (Component)this.sclsButton, (int)1, (int)0, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)genSkel, (Component)this.sCompile, (int)0, (int)1, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)genSkel, (Component)this.sJavadoc, (int)0, (int)2, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)genSkel, (Component)this.sJar, (int)0, (int)3, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)genSkel, (Component)this.sgenButton, (int)0, (int)4, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        JPanel options = GeneratorPanel.createTitledPanel("Options");
        boolean usingSimulate = this.getPrefValue("use-simulate", false);
        JCheckBox simulate = GeneratorPanel.createCheckBox("Only simulate generating", usingSimulate, -1, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() == 1;
                GeneratorPanel.this.onSimulate(enabled);
                GeneratorPanel.this.setPrefValue("use-simulate", enabled);
                GeneratorPanel.this.propertyChannel.put("use-simulate", new Boolean(enabled).toString());
            }
        });
        this.onSimulate(usingSimulate);
        boolean usingDot = this.getPrefValue("use-dot", true);
        JCheckBox useDot = GeneratorPanel.createCheckBox("Add graphics to generated javadoc", usingDot, -1, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GeneratorPanel.this.onUseDot(e.getStateChange() == 1);
            }
        });
        this.labelDotLocation = new JLabel("Path and name of Graphviz 'dot' program");
        this.dotLocation = this.createFileSelector("Select a 'dot' program", "Select", null, "dotLocation", "dotLocation");
        this.onUseDot(usingDot);
        SwingUtils.addComponent((JComponent)options, (Component)simulate, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)options, (Component)useDot, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)options, (Component)this.labelDotLocation, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)options, (Component)this.dotLocation, (int)0, (int)3, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        this.bothButton = GeneratorPanel.createButton(" All-In-One: Do it all ", "Do everything for all/selected datatypes and service", 65, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GeneratorPanel.this.isInJMobyDirectory()) {
                    GeneratorPanel.this.onBoth();
                }
            }
        });
        this.bothButton.setIcon(genIcon);
        this.bothButton.setDisabledIcon(genIconDis);
        SwingUtils.addComponent((JComponent)p, (Component)options, (int)0, (int)0, (int)2, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)genData, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)genSkel, (int)1, (int)1, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.bothButton, (int)0, (int)2, (int)2, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        return p;
    }

    protected JPanel getDeploymentPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(GeneratorPanel.createFatBorder("Services deployment", GraphColours.getColour("cadetblue", Color.blue)));
        JPanel pDeploy = new JPanel(new GridBagLayout());
        boolean deployLocally = this.getPrefValue("use-local-deploy", true);
        this.propertyChannel.put("use-local-deploy", new Boolean(deployLocally).toString());
        this.locally = new JRadioButton("On local machine", deployLocally);
        this.locally.setActionCommand("true");
        this.locally.addActionListener(this.deployListener);
        JRadioButton remotely = new JRadioButton("On remote machine", !deployLocally);
        remotely.setActionCommand("false");
        remotely.addActionListener(this.deployListener);
        ButtonGroup group = new ButtonGroup();
        group.add(this.locally);
        group.add(remotely);
        Component glue = Box.createHorizontalGlue();
        SwingUtils.addComponent((JComponent)pDeploy, (Component)this.locally, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pDeploy, (Component)glue, (int)1, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pDeploy, (Component)remotely, (int)2, (int)0, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0);
        JPanel pServer = GeneratorPanel.createTitledPanel("Server/Axis locations");
        String initValue = null;
        String os = System.getProperty("os.name");
        initValue = os.startsWith("Windows") ? null : (os.startsWith("Mac") ? null : "/usr/local/");
        JLabel lTomcatHome = new JLabel("Server home directory");
        JFileChooserWithHistory tomcatHome = this.createFileSelector("Select server home directory", "Select", initValue, "tomcatHome", "tomcatHome");
        tomcatHome.getFileChooser().setFileSelectionMode(1);
        JLabel lDeployInT = new JLabel("Deployment relative path");
        JTextFieldWithHistory deployInT = this.createText("webapps", "deployInTomcat", "deployInTomcat");
        deployInT.setToolTipText("The relative path to the web application deployment directory - e.g. webapps for tomcat or server/default/depoy for jboss");
        JLabel lAxisInT = new JLabel("Axis relative path ");
        JTextFieldWithHistory axisInT = this.createText("axis", "axisInTomcat", "axisInTomcat");
        axisInT.setToolTipText("The path to Axis - e.g. axis for Tomcat or axis.war for JBoss");
        JLabel lHost = new JLabel("Hostname");
        JTextFieldWithHistory host = this.createText("localhost", "tomcatHostname", "tomcatHostname");
        JLabel lPort = new JLabel("Port");
        JTextFieldWithHistory port = this.createText("8080", "tomcatPort", "tomcatPort");
        JLabel lAxisAdm = new JLabel("URL-path of Axis Admin servlet");
        JTextFieldWithHistory axisAdm = this.createText("axis/servlet/AxisServlet", "axisAdminURLPath", "axisAdminURLPath");
        SwingUtils.addComponent((JComponent)pServer, (Component)lTomcatHome, (int)0, (int)0, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pServer, (Component)tomcatHome, (int)0, (int)1, (int)2, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pServer, (Component)lDeployInT, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pServer, (Component)deployInT, (int)0, (int)3, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pServer, (Component)lAxisInT, (int)1, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pServer, (Component)axisInT, (int)1, (int)3, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pServer, (Component)lHost, (int)0, (int)4, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pServer, (Component)host, (int)0, (int)5, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pServer, (Component)lPort, (int)1, (int)4, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pServer, (Component)port, (int)1, (int)5, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pServer, (Component)lAxisAdm, (int)0, (int)6, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pServer, (Component)axisAdm, (int)0, (int)7, (int)2, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        JPanel pWSDD = GeneratorPanel.createTitledPanel("WSDD Template file");
        JFileChooserWithHistory wsdd = this.createFileSelector("Select file with a WSDD template", "Select", null, "wsddTemplate", "wsddTemplate");
        wsdd.getFileChooser().setFileSelectionMode(0);
        SwingUtils.addComponent((JComponent)pWSDD, (Component)wsdd, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        JPanel pImpl = GeneratorPanel.createTitledPanel("User implementation classes");
        JLabel lUserJars = new JLabel("Directory with user's jar files");
        JFileChooserWithHistory userJars = this.createFileSelector("Select directory with user's implementation", "Select", null, "dirWithUserJars", "dirWithUserJars");
        JLabel lPattern = new JLabel("Pattern for implementation class names");
        this.pattern = this.createText(null, "classnamePattern", "classnamePattern");
        this.dTable = new DeploymentTable();
        boolean usingCopyBySelect = this.getPrefValue("copy-by-select-deploy", true);
        this.copyBySelect = GeneratorPanel.createCheckBox("Add services here by selecting them in the tree", usingCopyBySelect, -1, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GeneratorPanel.this.setPrefValue("copy-by-select-deploy", e.getStateChange() == 1);
            }
        });
        SwingUtils.addComponent((JComponent)pImpl, (Component)lUserJars, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pImpl, (Component)userJars, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pImpl, (Component)lPattern, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pImpl, (Component)this.pattern, (int)0, (int)3, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)pImpl, (Component)this.dTable.scrollable(), (int)0, (int)4, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)pImpl, (Component)this.copyBySelect, (int)0, (int)5, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        this.deployButton = GeneratorPanel.createButton(" Deploy ", "Move all needed files to a server and register services", 89, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GeneratorPanel.this.isInJMobyDirectory()) {
                    GeneratorPanel.this.onDeploy();
                }
            }
        });
        this.deployButton.setIcon(deployIcon);
        this.deployButton.setDisabledIcon(deployIconDis);
        this.undeployButton = GeneratorPanel.createButton(" Undeploy ", "Unregister selected services from a server", 85, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GeneratorPanel.this.isInJMobyDirectory()) {
                    GeneratorPanel.this.onUndeploy();
                }
            }
        });
        this.undeployButton.setIcon(undeployIcon);
        this.undeployButton.setDisabledIcon(undeployIconDis);
        this.undeployButton.setEnabled(this.locally.isSelected());
        this.undeployButton.setEnabled(false);
        Component glue2 = Box.createHorizontalGlue();
        SwingUtils.addComponent((JComponent)p, (Component)pDeploy, (int)0, (int)0, (int)3, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)pServer, (int)0, (int)1, (int)3, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)p, (Component)pWSDD, (int)0, (int)2, (int)3, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)pImpl, (int)0, (int)3, (int)3, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.deployButton, (int)0, (int)4, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)p, (Component)glue2, (int)1, (int)4, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)BREATH_TOP);
        SwingUtils.addComponent((JComponent)p, (Component)this.undeployButton, (int)2, (int)4, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_TOP);
        return p;
    }

    private JCheckBox createActionBox(String title, final String preferenceKey) {
        boolean initValue = this.getPrefValue(preferenceKey, true);
        this.propertyChannel.put(preferenceKey, new Boolean(initValue).toString());
        return GeneratorPanel.createCheckBox(title, initValue, -1, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() == 1;
                GeneratorPanel.this.setPrefValue(preferenceKey, enabled);
                GeneratorPanel.this.propertyChannel.put(preferenceKey, new Boolean(enabled).toString());
            }
        });
    }

    protected boolean isInJMobyDirectory() {
        File f = AntModel.createFileName(new String[]{System.getProperty("user.dir"), "src", "main", "org", "biomoby", "service", "dashboard", "Dashboard.java"});
        if (f.exists()) {
            return true;
        }
        String msg = JMOBY_ERROR.replaceAll("\\\\n", "<br>");
        GeneratorPanel.error("<html>" + msg);
        return false;
    }

    protected void onDataTypes() {
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;

            @Override
            public Object construct() {
                try {
                    GeneratorPanel.this.propertyChannel.fire("status-msg", "Processing MoSeS datatypes...");
                    GeneratorPanel.this.console.setEnabledAppendMode(false);
                    GeneratorPanel.this.antModel.setMsgOutputLevel(GeneratorPanel.this.console.isVerboseMode() ? 2 : 100);
                    GeneratorPanel.this.setEnabledAntButtons(false);
                    GeneratorPanel.this.antModel.mosesDatatypes();
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error(GeneratorPanel.ANT_ERROR, (Exception)((Object)this.exception));
                }
                GeneratorPanel.this.setEnabledAntButtons(true);
                GeneratorPanel.this.console.setEnabledAppendMode(true);
                GeneratorPanel.this.propertyChannel.fire("status-msg", "MoSeS datatypes done");
            }
        };
        worker.start();
    }

    protected void onCleanDataTypes() {
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;

            @Override
            public Object construct() {
                try {
                    GeneratorPanel.this.propertyChannel.fire("status-msg", "Removing MoSeS datatypes...");
                    GeneratorPanel.this.console.setEnabledAppendMode(false);
                    GeneratorPanel.this.antModel.setMsgOutputLevel(GeneratorPanel.this.console.isVerboseMode() ? 2 : 100);
                    GeneratorPanel.this.setEnabledAntButtons(false);
                    GeneratorPanel.this.antModel.mosesCleanDatatypes();
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error(GeneratorPanel.ANT_ERROR, (Exception)((Object)this.exception));
                }
                GeneratorPanel.this.setEnabledAntButtons(true);
                GeneratorPanel.this.console.setEnabledAppendMode(true);
                GeneratorPanel.this.propertyChannel.fire("status-msg", "MoSeS datatypes removed");
            }
        };
        worker.start();
    }

    protected void onSkeletons() {
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;

            @Override
            public Object construct() {
                try {
                    GeneratorPanel.this.propertyChannel.fire("status-msg", "Processing MoSeS skeletons...");
                    GeneratorPanel.this.console.setEnabledAppendMode(false);
                    GeneratorPanel.this.antModel.setMsgOutputLevel(GeneratorPanel.this.console.isVerboseMode() ? 2 : 100);
                    GeneratorPanel.this.setEnabledAntButtons(false);
                    GeneratorPanel.this.antModel.mosesSkeletons();
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error(GeneratorPanel.ANT_ERROR, (Exception)((Object)this.exception));
                }
                GeneratorPanel.this.setEnabledAntButtons(true);
                GeneratorPanel.this.console.setEnabledAppendMode(true);
                GeneratorPanel.this.propertyChannel.fire("status-msg", "MoSeS skeletons done");
            }
        };
        worker.start();
    }

    protected void onCleanSkeletons() {
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;

            @Override
            public Object construct() {
                try {
                    GeneratorPanel.this.propertyChannel.fire("status-msg", "Removing MoSeS skeletons...");
                    GeneratorPanel.this.console.setEnabledAppendMode(false);
                    GeneratorPanel.this.antModel.setMsgOutputLevel(GeneratorPanel.this.console.isVerboseMode() ? 2 : 100);
                    GeneratorPanel.this.setEnabledAntButtons(false);
                    GeneratorPanel.this.antModel.mosesCleanSkeletons();
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error(GeneratorPanel.ANT_ERROR, (Exception)((Object)this.exception));
                }
                GeneratorPanel.this.setEnabledAntButtons(true);
                GeneratorPanel.this.console.setEnabledAppendMode(true);
                GeneratorPanel.this.propertyChannel.fire("status-msg", "MoSeS skeletons removed");
            }
        };
        worker.start();
    }

    protected void onBoth() {
        this.dtGenerate.setSelected(true);
        this.dtCompile.setSelected(true);
        this.dtJavadoc.setSelected(false);
        this.dtJar.setSelected(true);
        this.sGenerate.setSelected(true);
        this.sCompile.setSelected(true);
        this.sJavadoc.setSelected(true);
        this.sJar.setSelected(true);
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;

            @Override
            public Object construct() {
                try {
                    GeneratorPanel.this.propertyChannel.fire("status-msg", "Processing MoSeS datatypes...");
                    GeneratorPanel.this.console.setEnabledAppendMode(false);
                    GeneratorPanel.this.antModel.setMsgOutputLevel(GeneratorPanel.this.console.isVerboseMode() ? 2 : 100);
                    GeneratorPanel.this.setEnabledAntButtons(false);
                    GeneratorPanel.this.antModel.mosesDatatypes();
                    GeneratorPanel.this.propertyChannel.fire("status-msg", "Processing MoSeS skeletons...");
                    GeneratorPanel.this.antModel.mosesSkeletons();
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error(GeneratorPanel.ANT_ERROR, (Exception)((Object)this.exception));
                }
                GeneratorPanel.this.setEnabledAntButtons(true);
                GeneratorPanel.this.console.setEnabledAppendMode(true);
                GeneratorPanel.this.propertyChannel.fire("status-msg", "MoSeS all-in-one done");
            }
        };
        worker.start();
    }

    protected void onDeploy() {
        if (!this.onCheckData()) {
            return;
        }
        Map data = this.dTable.getData();
        for (Map.Entry entry : data.entrySet()) {
            String className = (String)entry.getValue();
            if (!UUtils.isEmpty((String)className)) continue;
            String msg = NOIMPL_ERROR.replaceAll("\\\\n", "<br>");
            GeneratorPanel.error("<html>" + msg);
            return;
        }
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;

            @Override
            public Object construct() {
                try {
                    GeneratorPanel.this.propertyChannel.fire("status-msg", "Deploying services...");
                    GeneratorPanel.this.console.setEnabledAppendMode(false);
                    GeneratorPanel.this.antModel.setMsgOutputLevel(GeneratorPanel.this.console.isVerboseMode() ? 2 : 100);
                    GeneratorPanel.this.setEnabledAntButtons(false);
                    GeneratorPanel.this.antModel.mosesDeploy();
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error(GeneratorPanel.ANT_ERROR, (Exception)((Object)this.exception));
                }
                GeneratorPanel.this.setEnabledAntButtons(true);
                GeneratorPanel.this.console.setEnabledAppendMode(true);
                GeneratorPanel.this.propertyChannel.fire("status-msg", "Deployment done");
            }
        };
        worker.start();
    }

    protected void onUndeploy() {
        if (!this.onCheckData()) {
            return;
        }
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;

            @Override
            public Object construct() {
                try {
                    GeneratorPanel.this.propertyChannel.fire("status-msg", "Undeploying services...");
                    GeneratorPanel.this.console.setEnabledAppendMode(false);
                    GeneratorPanel.this.antModel.setMsgOutputLevel(GeneratorPanel.this.console.isVerboseMode() ? 2 : 100);
                    GeneratorPanel.this.setEnabledAntButtons(false);
                    GeneratorPanel.this.antModel.mosesUndeploy();
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error(GeneratorPanel.ANT_ERROR, (Exception)((Object)this.exception));
                }
                GeneratorPanel.this.setEnabledAntButtons(true);
                GeneratorPanel.this.console.setEnabledAppendMode(true);
                GeneratorPanel.this.propertyChannel.fire("status-msg", "Undeployment done");
            }
        };
        worker.start();
    }

    protected boolean onCheckData() {
        Map data = this.dTable.getData();
        if (data.size() == 0) {
            String msg = NODEPL_ERROR.replaceAll("\\\\n", "<br>");
            GeneratorPanel.error("<html>" + msg);
            return false;
        }
        this.propertyChannel.put("servicesToDeploy", data);
        return true;
    }

    protected void setEnabledAntButtons(boolean enabled) {
        this.dtgenButton.setEnabled(enabled);
        this.sgenButton.setEnabled(enabled);
        this.bothButton.setEnabled(enabled);
        this.dtclsButton.setEnabled(enabled);
        this.sclsButton.setEnabled(enabled);
        this.deployButton.setEnabled(enabled);
    }

    protected void onSimulate(boolean enabled) {
        this.setPrefValue("use-simulate", enabled);
        this.propertyChannel.put("use-simulate", new Boolean(enabled).toString());
    }

    protected void onUseDot(boolean enabled) {
        this.setPrefValue("use-dot", enabled);
        this.propertyChannel.put("use-dot", new Boolean(enabled).toString());
        this.labelDotLocation.setEnabled(enabled);
        this.dotLocation.setEnabled(enabled);
    }

    @Override
    public String getName() {
        return "MoSeS Generator";
    }

    @Override
    public String getDescription() {
        return "A panel allowing to generate datatypes and skeletons that can be used by Biomoby service providers to implements their services.";
    }

    @Override
    public boolean loadOnlyOnDemand() {
        return true;
    }

    protected void addToTable(String serviceName) {
        String[] parts = serviceName.split("/", 2);
        if (parts.length == 0) {
            return;
        }
        this.dTable.addData(parts[0], this.applyPattern(parts[0]));
    }

    protected String applyPattern(String serviceName) {
        String patt = this.pattern.getText();
        if (UUtils.isEmpty((String)patt)) {
            return serviceName + "Impl";
        }
        if (serviceName.length() < 2) {
            return patt.replaceAll("\\{SERVICE\\}", serviceName);
        }
        return patt.replaceAll("\\{SERVICE\\}", serviceName).replaceAll("\\{Service\\}", serviceName.substring(0, 1).toUpperCase() + serviceName.substring(1));
    }

    protected class CustomServicesTree
    extends ServicesTree {
        public CustomServicesTree(RegistryModel model, CommonConsole console) {
            super(model, console);
            this.getSelectionModel().setSelectionMode(4);
        }

        @Override
        protected void createPopups(String title) {
            super.createPopups(title);
            this.removeFromPopups("ac-reload");
            this.removeSeparatorAfter("ac-collapse");
        }

        @Override
        protected void selected(DefaultMutableTreeNode node) {
            String name;
            if (node == null) {
                this.console.setText("Nothing selected\n");
                GeneratorPanel.this.setPrefValue("selectedAuthorities", "");
                this.propertyChannel.remove("selectedAuthorities");
                GeneratorPanel.this.setPrefValue("selectedServices", "");
                this.propertyChannel.remove("selectedServices");
                GeneratorPanel.this.aSelectedCount.setText("0");
                GeneratorPanel.this.sSelectedCount.setText("0");
                return;
            }
            TreePath[] paths = this.getSelectionModel().getSelectionPaths();
            if (paths == null) {
                return;
            }
            Vector<String> a = new Vector<String>();
            Vector<String> s = new Vector<String>();
            for (int i = 0; i < paths.length; ++i) {
                DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                Object uo = aNode.getUserObject();
                if (!(uo instanceof CommonNode)) continue;
                int nodeType = ((CommonNode)uo).getType();
                if (nodeType == 15) {
                    if (aNode.isLeaf()) continue;
                    a.addElement(((CommonNode)uo).getValue());
                    if (!GeneratorPanel.this.copyBySelect.isSelected()) continue;
                    Enumeration<TreeNode> en = aNode.children();
                    while (en.hasMoreElements()) {
                        Object uo2 = ((DefaultMutableTreeNode)en.nextElement()).getUserObject();
                        if (!(uo2 instanceof CommonNode)) continue;
                        GeneratorPanel.this.addToTable(((CommonNode)uo2).getValue());
                    }
                    continue;
                }
                if (nodeType != 14) continue;
                s.addElement(((CommonNode)uo).getValue());
                if (!GeneratorPanel.this.copyBySelect.isSelected()) continue;
                GeneratorPanel.this.addToTable((String)s.lastElement());
            }
            StringBuffer conBuf = new StringBuffer(100);
            StringBuffer prefBufA = new StringBuffer(100);
            StringBuffer prefBufS = new StringBuffer(100);
            if (a.size() > 0) {
                conBuf.append("Selected authorities:\n");
                Enumeration en = a.elements();
                while (en.hasMoreElements()) {
                    name = en.nextElement().toString();
                    conBuf.append("\t");
                    conBuf.append(name);
                    conBuf.append("\n");
                    if (prefBufA.length() > 0) {
                        prefBufA.append("|");
                    }
                    prefBufA.append(name);
                }
                this.propertyChannel.put("selectedAuthorities", a);
            } else {
                this.propertyChannel.remove("selectedAuthorities");
            }
            GeneratorPanel.this.setPrefValue("selectedAuthorities", new String(prefBufA));
            GeneratorPanel.this.aSelectedCount.setText("" + a.size());
            if (s.size() > 0) {
                conBuf.append("Selected services:\n");
                Enumeration en = s.elements();
                while (en.hasMoreElements()) {
                    name = en.nextElement().toString();
                    conBuf.append("\t");
                    conBuf.append(name);
                    conBuf.append("\n");
                    if (prefBufS.length() > 0) {
                        prefBufS.append("|");
                    }
                    prefBufS.append(name);
                }
                this.propertyChannel.put("selectedServices", s);
            } else {
                this.propertyChannel.remove("selectedServices");
            }
            GeneratorPanel.this.setPrefValue("selectedServices", new String(prefBufS));
            GeneratorPanel.this.sSelectedCount.setText("" + s.size());
            if (conBuf.length() > 0) {
                this.console.setText(new String(conBuf));
            } else {
                this.console.setText("Nothing selected\n");
            }
        }
    }
}

