/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.biomoby.service.dashboard.CommonDataTable;
import org.biomoby.shared.MobyData;

public class DeploymentTable
extends CommonDataTable {
    public static final int COL_SERVICE = 1;
    public static final int COL_CLASSNAME = 2;

    public DeploymentTable() {
        this.tableModel = new DeploymentTableModel();
        this.setModel(this.tableModel);
        this.createItself();
    }

    public void addData(String serviceName, String className) {
        ((DeploymentTableModel)this.tableModel).addData(serviceName, className);
    }

    public Map getData() {
        Vector v = this.tableModel.getData();
        HashMap<String, String> result = new HashMap<String, String>(v.size() + 1);
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            TableDataBag bag = (TableDataBag)en.nextElement();
            result.put(bag.serviceName, bag.className);
        }
        return result;
    }

    @Override
    public void setData(MobyData[] newData) {
    }

    protected class DeploymentTableModel
    extends CommonDataTable.CommonDataTableModel {
        public static final int COL_SERVICE = 1;
        public static final int COL_CLASSNAME = 2;

        public DeploymentTableModel() {
            this.columnToolTips = new String[]{"Click in this column to remove service", "Add here services by selecting them in the service tree", "Click to edit service's implementation class name"};
            this.columnNames = new String[]{"Remove", "Service name", "Implemented by class"};
            this.columnClasses = new Class[]{Integer.class, String.class, String.class};
        }

        @Override
        public void setData(MobyData[] newData) {
        }

        public void addData(String serviceName, String className) {
            Enumeration en = this.data.elements();
            while (en.hasMoreElements()) {
                String sName = ((TableDataBag)en.nextElement()).serviceName;
                if (!sName.equals(serviceName)) continue;
                return;
            }
            TableDataBag bag = new TableDataBag(serviceName, className);
            this.data.addElement(bag);
            int rowCount = this.getRowCount();
            this.fireTableRowsInserted(rowCount - 1, rowCount - 1);
            this.fireTableDataChanged();
        }

        @Override
        public void addEmptyData() {
        }

        @Override
        public Object getValueAt(int row, int col) {
            try {
                TableDataBag d = (TableDataBag)this.data.elementAt(row);
                switch (col) {
                    case 0: {
                        return new Integer(row);
                    }
                    case 1: {
                        return d.serviceName;
                    }
                    case 2: {
                        return d.className;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (value == null) {
                return;
            }
            try {
                TableDataBag d = (TableDataBag)this.data.elementAt(row);
                switch (col) {
                    case 1: {
                        d.serviceName = value.toString();
                        break;
                    }
                    case 2: {
                        d.className = value.toString();
                    }
                }
                this.fireTableCellUpdated(row, col);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }
    }

    protected class TableDataBag {
        public String serviceName = "";
        public String className = "";

        public TableDataBag(String serviceName, String className) {
            this.serviceName = serviceName;
            this.className = className;
        }
    }
}

