/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.PropertyChannel;
import org.tulsoft.tools.gui.SwingUtils;

public class DebuggingPanel
extends AbstractPanel
implements PropertyChangeListener {
    JProgressBar memory;
    CommonConsole console;

    public DebuggingPanel() {
        this.panelIconFileName = "images/console.gif";
    }

    @Override
    public JComponent getComponent(PropertyChannel newPropertyChannel) {
        this.setPropertyChannel(newPropertyChannel);
        this.propertyChannel.addPropertyChangeListener(this);
        this.memory = new JProgressBar(0, (int)Runtime.getRuntime().maxMemory());
        this.memory.setValue(this.calculateMemory());
        this.memory.setStringPainted(true);
        JButton gcButton = DebuggingPanel.createButton(" Perform GC ", "Call the garbage collector", -1, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Runtime.getRuntime().gc();
                    }
                });
            }
        });
        this.console = new CommonConsole();
        this.console.setAppendMode(true);
        this.console.setVerboseMode(false);
        Timer timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggingPanel.this.memory.setValue(DebuggingPanel.this.calculateMemory());
            }
        });
        JLabel memLabel = new JLabel("Memory: ");
        JPanel p = new JPanel(new GridBagLayout(), true);
        SwingUtils.addComponent((JComponent)p, (Component)memLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.memory, (int)1, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)gcButton, (int)2, (int)0, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)this.console, (int)0, (int)1, (int)3, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        timer.start();
        return p;
    }

    private int calculateMemory() {
        Runtime runtime = Runtime.getRuntime();
        return (int)(runtime.totalMemory() - runtime.freeMemory());
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.console == null) {
            return;
        }
        String prop = event.getPropertyName();
        if (prop == null) {
            return;
        }
        Object obj = event.getNewValue();
        if (obj == null) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("---[ ");
        buf.append(prop);
        buf.append(" ]------------------------------------------------------------------------\n");
        buf.append(obj.toString());
        buf.append("\n");
        this.console.setText(new String(buf));
    }

    @Override
    public String getName() {
        return "Debugging Panel";
    }

    @Override
    public String getDescription() {
        return "A panel with a loosely defined purpose. It serves for debugging and for finding loose ends.";
    }

    @Override
    public boolean loadOnlyOnDemand() {
        return true;
    }
}

