/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.CommonConsole;
import org.biomoby.service.dashboard.CommonNode;
import org.biomoby.service.dashboard.CommonTree;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.service.generator.DataTypesGenerator;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyRelationship;
import org.tulsoft.shared.UUtils;

public class DataTypesTree
extends CommonTree {
    private static Log log = LogFactory.getLog(DataTypesTree.class);
    protected static final String AC_HASA = "ac-hasa";
    protected static final String AC_DEPR = "ac-depr";
    RegistryModel registryModel;
    CommonConsole console;
    boolean showBadGuys = false;
    boolean showMembers = false;
    JCheckBoxMenuItem deprecatedBox;
    static final String DATA_TYPES_ACCESS_ERROR = "An error happened when accessing a list of available data types.\n\nCheck please values in text fields (in Registry Browser)\nspecifying registry endpoint and namespace, and in the\none specifying directory used as a local cache. Then\nright-click in the data types area and select 'Reload'.\n\n";

    public DataTypesTree(RegistryModel registryModel, CommonConsole console) {
        super("Data Types");
        this.registryModel = registryModel;
        this.console = console;
        this.createPopups("Data Types Menu");
        this.setLeafIcon(dtLeafIcon);
    }

    @Override
    protected void createPopups(String title) {
        super.createPopups(title);
        this.addSortingItems();
        this.popup.addSeparator();
        JCheckBoxMenuItem showBox = new JCheckBoxMenuItem("Show HAS/HASA members");
        showBox.setActionCommand(AC_HASA);
        showBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DataTypesTree.this.showMembers = e.getStateChange() == 1;
                DataTypesTree.this.update(DataTypesTree.this.lastSorted, null);
            }
        });
        this.popup.add(showBox);
        this.deprecatedBox = new JCheckBoxMenuItem("Show deprecated objects");
        this.deprecatedBox.setActionCommand(AC_DEPR);
        this.deprecatedBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean bl = DataTypesTree.this.showBadGuys = e.getStateChange() == 1;
                if (DataTypesTree.this.showBadGuys) {
                    DataTypesTree.this.update(DataTypesTree.this.lastSorted, null);
                } else {
                    DataTypesTree.this.removeBadGuys();
                }
            }
        });
        this.popup.add(this.deprecatedBox);
    }

    @Override
    public void update(int howSorted, Object newData) {
        if (howSorted < 0) {
            howSorted = this.lastSorted;
        }
        this.lastSorted = howSorted;
        this.setEnabledPopup(false);
        final DataTypesTree source = this;
        final int sorted = howSorted;
        final MobyDataType[] newDataTypes = newData == null ? null : (MobyDataType[])newData;
        SwingWorker worker = new SwingWorker(){
            MobyException updateException = null;
            MobyDataType[] dataTypes = null;

            @Override
            public Object construct() {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Tree " + DataTypesTree.this.treeId + " update request. Sorted: " + sorted + ", Data: " + newDataTypes));
                    }
                    this.dataTypes = newDataTypes == null ? DataTypesTree.this.registryModel.getDataTypes(source) : newDataTypes;
                }
                catch (MobyException e) {
                    this.updateException = e;
                }
                return this.dataTypes;
            }

            @Override
            public void finished() {
                if (this.updateException != null) {
                    CommonTree.error(DataTypesTree.DATA_TYPES_ACCESS_ERROR, (Exception)((Object)this.updateException));
                }
                if (this.dataTypes != null) {
                    if (sorted == 1) {
                        DataTypesTree.this.onUpdateDataTreeByAuth(this.dataTypes);
                    } else {
                        DataTypesTree.this.onUpdateDataTree(this.dataTypes);
                    }
                    if (this.dataTypes.length > 0) {
                        DataTypesTree.this.setEnabledPopup(true);
                        if (sorted == 1) {
                            DataTypesTree.this.deprecatedBox.setEnabled(false);
                        } else {
                            DataTypesTree.this.deprecatedBox.setEnabled(true);
                        }
                    }
                }
            }
        };
        worker.start();
    }

    void onUpdateDataTree(MobyDataType[] theDataTypes) {
        Object[] dataTypes = this.copy(theDataTypes);
        Arrays.sort(dataTypes);
        DefaultTreeModel tModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tModel.getRoot();
        root.removeAllChildren();
        HashMap<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>(dataTypes.length);
        for (int i = 0; i < dataTypes.length; ++i) {
            String[] parents;
            String thisName = dataTypes[i].getName();
            DefaultMutableTreeNode thisNode = (DefaultMutableTreeNode)nodes.get(thisName);
            if (thisNode == null) {
                thisNode = new DefaultMutableTreeNode(new CommonNode(thisName, 11));
                nodes.put(thisName, thisNode);
            }
            if ((parents = dataTypes[i].getParentNames()).length == 0) {
                root.add(thisNode);
                continue;
            }
            String parentName = parents[0];
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)nodes.get(parentName);
            if (parentNode == null) {
                parentNode = new DefaultMutableTreeNode(new CommonNode(parentName, 11));
                nodes.put(parentName, parentNode);
            }
            if (this.showMembers) {
                this.addMembers(thisNode, (MobyDataType)dataTypes[i]);
            }
            parentNode.add(thisNode);
        }
        if (this.showBadGuys) {
            tModel.reload();
        } else {
            this.removeBadGuys();
        }
    }

    void onUpdateDataTreeByAuth(MobyDataType[] theDataTypes) {
        MobyDataType[] dataTypes = this.copy(theDataTypes);
        Arrays.sort(dataTypes, MobyDataType.getAuthorityComparator());
        DefaultTreeModel tModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tModel.getRoot();
        root.removeAllChildren();
        HashMap<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>(dataTypes.length);
        for (int i = 0; i < dataTypes.length; ++i) {
            DefaultMutableTreeNode authNode;
            String authority;
            String thisName = dataTypes[i].getName();
            DefaultMutableTreeNode thisNode = (DefaultMutableTreeNode)nodes.get(thisName);
            if (thisNode == null) {
                thisNode = new DefaultMutableTreeNode(new CommonNode(thisName, 11));
                nodes.put(thisName, thisNode);
            }
            if (UUtils.isEmpty((String)(authority = dataTypes[i].getAuthority()))) {
                authority = "<unknown>";
            }
            if ((authNode = (DefaultMutableTreeNode)nodes.get(authority)) == null) {
                authNode = new DefaultMutableTreeNode(new CommonNode(authority, 15));
                nodes.put(authority, authNode);
                root.add(authNode);
            }
            if (this.showMembers) {
                this.addMembers(thisNode, dataTypes[i]);
            }
            authNode.add(thisNode);
        }
        tModel.reload();
    }

    void removeBadGuys() {
        DefaultMutableTreeNode node;
        DefaultTreeModel tModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tModel.getRoot();
        Vector<DefaultMutableTreeNode> removeFromParent = new Vector<DefaultMutableTreeNode>();
        Vector<DefaultMutableTreeNode> removeAllChildren = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> en = root.children();
        while (en.hasMoreElements()) {
            node = (DefaultMutableTreeNode)en.nextElement();
            String value = ((CommonNode)node.getUserObject()).getValue();
            if (value.equals("Object")) {
                Enumeration<TreeNode> en2 = node.children();
                while (en2.hasMoreElements()) {
                    DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)en2.nextElement();
                    String value2 = ((CommonNode)node2.getUserObject()).getValue();
                    if (!DataTypesGenerator.isPrimitiveType((String)value2)) continue;
                    removeAllChildren.addElement(node2);
                }
                continue;
            }
            removeFromParent.addElement(node);
        }
        en = removeFromParent.elements();
        while (en.hasMoreElements()) {
            node = (DefaultMutableTreeNode)en.nextElement();
            node.removeFromParent();
        }
        en = removeAllChildren.elements();
        while (en.hasMoreElements()) {
            node = (DefaultMutableTreeNode)en.nextElement();
            node.removeAllChildren();
        }
        tModel.reload();
    }

    void addMembers(DefaultMutableTreeNode node, MobyDataType dataType) {
        MobyRelationship[] rels = dataType.getChildren();
        for (int i = 0; i < rels.length; ++i) {
            node.add(new DefaultMutableTreeNode(new MemberNode(rels[i])));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MobyDataType[] copy(MobyDataType[] s) {
        MobyDataType[] mobyDataTypeArray = s;
        synchronized (s) {
            MobyDataType[] result = new MobyDataType[s.length];
            System.arraycopy(s, 0, result, 0, s.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    @Override
    protected void reload() {
        this.update(this.lastSorted, null);
    }

    @Override
    protected void search(String searchText) {
        final String regex = searchText;
        SwingWorker worker = new SwingWorker(){
            HashSet found = new HashSet();

            @Override
            public Object construct() {
                try {
                    if (UUtils.notEmpty((String)regex)) {
                        this.found = DataTypesTree.this.registryModel.findInDataTypes(regex);
                    }
                }
                catch (MobyException e) {
                    CommonTree.error(DataTypesTree.DATA_TYPES_ACCESS_ERROR, (Exception)((Object)e));
                }
                return this.found;
            }

            @Override
            public void finished() {
                if (this.found != null) {
                    DataTypesTree.this.highlightAndJumpTo(this.found);
                }
            }
        };
        worker.start();
    }

    @Override
    protected void selected(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        final CommonNode nodeObject = (CommonNode)node.getUserObject();
        SwingWorker worker = new SwingWorker(){
            MobyDataType dataType;

            @Override
            public Object construct() {
                try {
                    this.dataType = DataTypesTree.this.registryModel.getDataType(nodeObject.getValue());
                }
                catch (MobyException e) {
                    CommonTree.error(DataTypesTree.DATA_TYPES_ACCESS_ERROR, (Exception)((Object)e));
                }
                return this.dataType;
            }

            @Override
            public void finished() {
                if (this.dataType != null) {
                    DataTypesTree.this.console.setText(this.dataType.toString());
                }
            }
        };
        worker.start();
    }

    class MemberNode
    extends CommonNode {
        MobyRelationship rel;

        public MemberNode(MobyRelationship rel) {
            this.rel = rel;
        }

        @Override
        public String getValue() {
            return this.rel.getDataTypeName();
        }

        @Override
        public String toString() {
            String memberName = this.rel.getName();
            String memberType = this.rel.getDataTypeName();
            int memberRel = this.rel.getRelationshipType();
            StringBuffer buf = new StringBuffer(100);
            buf.append("<html><b>");
            buf.append(memberRel == 3 ? "HAS" : "HASA");
            buf.append(": </b>");
            buf.append(memberType);
            if (UUtils.notEmpty((String)memberName)) {
                buf.append(" (<font color='blue'>");
                buf.append(memberName);
                buf.append("</font>)");
            }
            return buf.toString();
        }
    }
}

