/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DashboardConfig {
    private static Log log = LogFactory.getLog(DashboardConfig.class);
    private static CompositeConfiguration config;
    private static Set<String> configFilenames;
    public static final String DASHBOARD_CONFIG_FILENAME = "dashboard.properties";
    public static final String PROP_DASHBOARD_CONFIGURATION = "dashboard.configuration";

    public static synchronized CompositeConfiguration get() {
        if (config == null) {
            CompositeConfiguration cfg = new CompositeConfiguration();
            cfg.addConfiguration((Configuration)new SystemConfiguration());
            DashboardConfig.addPropertiesConfiguration(cfg, "build.properties", false);
            String[] configFilenames = cfg.getStringArray(PROP_DASHBOARD_CONFIGURATION);
            if (configFilenames == null || configFilenames.length == 0) {
                configFilenames = new String[]{DASHBOARD_CONFIG_FILENAME};
            }
            for (int i = 0; i < configFilenames.length; ++i) {
                log.info((Object)("Using configuration file: " + configFilenames[i]));
                DashboardConfig.addPropertiesConfiguration(cfg, configFilenames[i], true);
            }
            config = cfg;
        }
        return config;
    }

    private static ArrayList<Configuration> getAndClearCurrentConfigurations() {
        DashboardConfig.get();
        ArrayList<Configuration> cfgs = new ArrayList<Configuration>();
        while (config.getNumberOfConfigurations() > 2) {
            Configuration cfg = config.getConfiguration(1);
            cfgs.add(cfg);
            config.removeConfiguration(cfg);
        }
        return cfgs;
    }

    private static boolean isExistingConfig(FileConfiguration cfg) {
        if (cfg.getFile() == null) {
            return false;
        }
        String filename = cfg.getFile().getAbsolutePath();
        if (configFilenames.contains(filename)) {
            return true;
        }
        configFilenames.add(filename);
        return false;
    }

    private static boolean addPropertiesConfiguration(CompositeConfiguration cfg, String configFilename, boolean errorsEnabled) {
        try {
            PropertiesConfiguration propsConfig = new PropertiesConfiguration(configFilename);
            if (DashboardConfig.isExistingConfig((FileConfiguration)propsConfig)) {
                return true;
            }
            propsConfig.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
            cfg.addConfiguration((Configuration)propsConfig);
            return true;
        }
        catch (ConfigurationException e) {
            if (errorsEnabled) {
                log.error((Object)("Loading properties configuration from '" + configFilename + "' failed: " + e.getMessage()));
            }
            return false;
        }
    }

    public static synchronized boolean addConfigPropertyFile(String configFilename) {
        log.info((Object)("Adding property configuration file: " + configFilename));
        ArrayList<Configuration> cfgs = DashboardConfig.getAndClearCurrentConfigurations();
        boolean success = DashboardConfig.addPropertiesConfiguration(DashboardConfig.get(), configFilename, true);
        for (Configuration cfg : cfgs) {
            DashboardConfig.get().addConfiguration(cfg);
        }
        return success;
    }

    public static String getString(String key, String defaultValue) {
        return DashboardConfig.get().getString(key, defaultValue);
    }

    public static String[] getStrings(String key, String defaultValue) {
        String[] values = DashboardConfig.get().getStringArray(key);
        if (values.length > 0) {
            return values;
        }
        if (defaultValue == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return new String[]{defaultValue};
    }

    public static int getInt(String key, int defaultValue) {
        String strValue = DashboardConfig.getString(key, "" + defaultValue);
        try {
            return Integer.decode(strValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean isEnabled(String key, boolean defaultValue, String serviceName, Object owner) {
        String strValue = DashboardConfig.getString(key, null);
        if (strValue == null) {
            return defaultValue;
        }
        if (StringUtils.isBlank((String)strValue)) {
            return true;
        }
        return BooleanUtils.toBoolean((String)strValue);
    }

    static {
        configFilenames = new HashSet<String>();
    }
}

