/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.discovery.tools.Service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.registry.meta.Registries;
import org.biomoby.registry.meta.RegistriesList;
import org.biomoby.registry.meta.Registry;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.DashboardConfig;
import org.biomoby.service.dashboard.DashboardPanel;
import org.biomoby.service.dashboard.DashboardProperties;
import org.biomoby.service.dashboard.ExitSecurityManager;
import org.biomoby.service.dashboard.GraphColours;
import org.biomoby.service.dashboard.LookAndFeelUtils;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.shared.Utils;
import org.tulsoft.shared.PrefsUtils;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.gui.AwtUtils;
import org.tulsoft.tools.gui.ProgressView;
import org.tulsoft.tools.gui.SwingUtils;

public class Dashboard
implements DashboardPanel,
DashboardProperties,
ChangeListener {
    private static Log log = LogFactory.getLog(Dashboard.class);
    protected static final String SELECTION_PROLOGUE = "<html>Choose panels that you wish to be shown in the dashboard.<br>Some panels may be mandatory so you cannot remove them.<p>";
    protected static final String CONNECTED_TO = "          Connected to: ";
    protected static final Insets BREATH = new Insets(10, 10, 10, 10);
    protected static final Insets BREATH_TOP = new Insets(10, 0, 0, 0);
    protected static final Insets BREATH_BOT = new Insets(0, 0, 10, 0);
    protected static final Insets BREATH_SMALL = new Insets(5, 5, 5, 5);
    protected static final String AC_EXIT = "ac-exit";
    protected static final String AC_ABOUT = "ac-about";
    protected static final String AC_HELP = "ac-help";
    protected static final String AC_PSELECT = "ac-pselect";
    protected static final String AC_MYPREF = "ac-mypref";
    protected static final String AC_EXPORT = "ac-export";
    protected static final String AC_IMPORT = "ac-import";
    public static boolean useLoadMonitor = true;
    protected static Properties dashboardProperties;
    protected static ExitSecurityManager exitman;
    private JComponent dashboard;
    private DashboardHeader header;
    protected JTabbedPane tabbedPane;
    protected Color bgcolor;
    protected DashboardPanel[] panels;
    protected DashboardPanel[] shownPanels;
    protected JCheckBox[] panelBoxes;
    protected PropertyChannel propertyChannel;
    protected JMenuBar menuBar;
    protected JMenu helpMenu;
    protected JMenu titleMenu;
    protected int countOfPermanentHelpItems;
    protected static Icon exitIcon;
    protected static Icon aboutIcon;
    protected static Icon helpIcon;
    protected static Icon helpIconDis;
    protected static Icon pselectIcon;
    protected static Icon pselectIconDis;
    protected static Icon prefIcon;
    protected static Icon prefIconDis;
    protected static Icon exportIcon;
    protected static Icon exportIconDis;
    protected static Icon importIcon;
    protected static Icon importIconDis;
    protected static Icon lafIcon;
    static final String PANEL_PROTOCOL = "panel://";

    public Dashboard() {
        log.debug((Object)"----------------------- new dashboard start ------------------------");
        this.loadIcons();
        this.loadPanels();
        this.propertyChannel = new PropertyChannel();
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        this.dashboard = this.getComponent(this.propertyChannel);
        KeyStroke ks = KeyStroke.getKeyStroke(112, 0);
        this.dashboard.getInputMap(1).put(ks, "HELP");
        this.dashboard.getActionMap().put("HELP", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (Dashboard.this.shownPanels == null) {
                    return;
                }
                try {
                    DashboardPanel currentPanel = Dashboard.this.shownPanels[Dashboard.this.tabbedPane.getSelectedIndex()];
                    Dashboard.this.openWindow(Dashboard.this.getPanelHelpPage(currentPanel), "About " + currentPanel.getName() + "...");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static String getProperty(String propertyName) {
        return DashboardConfig.getString(propertyName, null);
    }

    protected void loadIcons() {
        if (aboutIcon == null) {
            aboutIcon = AbstractPanel.loadIcon("images/smallInfo.gif");
        }
        if (exitIcon == null) {
            exitIcon = AbstractPanel.loadIcon("images/smallWarning.gif");
        }
        if (lafIcon == null) {
            lafIcon = AbstractPanel.loadIcon("images/smallLaF.gif");
        }
        if (helpIcon == null) {
            helpIcon = AbstractPanel.loadIcon("images/smallHelp.gif");
        }
        if (helpIconDis == null) {
            helpIconDis = AbstractPanel.loadIcon("images/smallHelp_dis.gif");
        }
        if (prefIcon == null) {
            prefIcon = AbstractPanel.loadIcon("images/smallPref.gif");
        }
        if (prefIconDis == null) {
            prefIconDis = AbstractPanel.loadIcon("images/smallPref_dis.gif");
        }
        if (pselectIcon == null) {
            pselectIcon = AbstractPanel.loadIcon("images/smallSelect.gif");
        }
        if (pselectIconDis == null) {
            pselectIconDis = AbstractPanel.loadIcon("images/smallSelect_dis.gif");
        }
        if (exportIcon == null) {
            exportIcon = AbstractPanel.loadIcon("images/smallExport.gif");
        }
        if (exportIconDis == null) {
            exportIconDis = AbstractPanel.loadIcon("images/smallExport_dis.gif");
        }
        if (importIcon == null) {
            importIcon = AbstractPanel.loadIcon("images/smallImport.gif");
        }
        if (importIconDis == null) {
            importIconDis = AbstractPanel.loadIcon("images/smallImport_dis.gif");
        }
    }

    public void loadPanels() {
        Enumeration spe = Service.providers(DashboardPanel.class);
        Vector<DashboardPanel> v = new Vector<DashboardPanel>();
        Vector<JCheckBox> c = new Vector<JCheckBox>();
        while (spe.hasMoreElements()) {
            DashboardPanel panel = (DashboardPanel)spe.nextElement();
            v.addElement(panel);
            c.addElement(this.createPanelBox(panel));
        }
        this.panels = new DashboardPanel[v.size()];
        v.copyInto(this.panels);
        this.panelBoxes = new JCheckBox[c.size()];
        c.copyInto(this.panelBoxes);
        this.chooseShownPanels();
    }

    protected void chooseShownPanels() {
        Vector<DashboardPanel> v = new Vector<DashboardPanel>();
        for (int i = 0; i < this.panels.length; ++i) {
            String prefKey = this.panels[i].getClass().getName();
            if (!this.panels[i].isMandatory() && !PrefsUtils.getNode(Dashboard.class).getBoolean(prefKey, !this.panels[i].loadOnlyOnDemand())) continue;
            v.addElement(this.panels[i]);
        }
        this.shownPanels = new DashboardPanel[v.size()];
        v.copyInto(this.shownPanels);
    }

    protected JCheckBox createPanelBox(DashboardPanel panel) {
        final String prefKey = panel.getClass().getName();
        JCheckBox box = new JCheckBox(panel.getName());
        boolean selected = panel.isMandatory() || PrefsUtils.getNode(Dashboard.class).getBoolean(prefKey, !panel.loadOnlyOnDemand());
        PrefsUtils.getNode(Dashboard.class).putBoolean(prefKey, selected);
        box.setSelected(selected);
        box.setFocusPainted(false);
        if (panel.isMandatory()) {
            box.setEnabled(false);
        }
        box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PrefsUtils.getNode(Dashboard.class).putBoolean(prefKey, e.getStateChange() == 1);
            }
        });
        return box;
    }

    public void show() {
        final JFrame frame = SwingUtils.createSoftMainFrame((JComponent)this.getComponent(this.propertyChannel), (String)this.getName());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (exitman != null) {
                    exitman.setExitForbidden(false);
                }
                System.exit(0);
            }
        });
        this.addMenuBar(frame);
        if ((this.panels == null || this.panels.length == 0) && this.menuBar.getComponentCount() > 1) {
            this.menuBar.remove(1);
        }
        this.propertyChannel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("dp-registry-namespace".equals(e.getPropertyName())) {
                    Dashboard.this.titleMenu.setText(Dashboard.CONNECTED_TO + Dashboard.this.findRegistryName((String)e.getNewValue()) + " registry");
                }
            }
        });
        Dimension screenSize = frame.getToolkit().getScreenSize();
        final int width = screenSize.width * 4 / 5;
        final int height = screenSize.height * 5 / 6;
        exitman = ExitSecurityManager.createAndInstall();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtils.showMainFrame((JFrame)frame, (int)width, (int)height);
            }
        });
    }

    public Dimension getPreferredSize() {
        return new Dimension(800, 640);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.panels.length; ++i) {
            buf.append(i + 1);
            buf.append(": ");
            buf.append(this.panels[i].getName());
            buf.append("\n");
        }
        return new String(buf);
    }

    @Override
    public String getName() {
        return "Biomoby Dashboard";
    }

    @Override
    public JLabel getTitle() {
        Icon titleIcon = SwingUtils.createIcon((String)Dashboard.getProperty("dashboard.title.icon"), (Object)this);
        String titleStr = Dashboard.getProperty("dashboard.title");
        if (titleStr == null) {
            titleStr = this.getName();
        }
        JLabel title = new JLabel(titleStr, titleIcon, 0);
        title.setFont(new Font("Serif", 1, 30));
        return title;
    }

    @Override
    public String getHelp() {
        String panelClassName = Utils.simpleClassName((String)this.getClass().getName());
        String help = null;
        try {
            help = Utils.readResource((String)("help" + System.getProperty("file.separator") + panelClassName + ".html"), this.getClass());
            if (help != null) {
                return help;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        help = this.getDescription();
        if (help != null) {
            return help;
        }
        return "";
    }

    @Override
    public URL getHelpURL() {
        return null;
    }

    @Override
    public String getDescription() {
        return this.getDescription("dashboard.description", "dashboard.description.file");
    }

    protected String getDescription(String descriptionPropName, String descriptionFilePropName) {
        String description = Dashboard.getProperty(descriptionPropName);
        if (UUtils.isEmpty((String)description)) {
            String filename = Dashboard.getProperty(descriptionFilePropName);
            if (UUtils.isEmpty((String)filename)) {
                return "";
            }
            try {
                return Utils.readResource((String)filename, this.getClass());
            }
            catch (IOException e) {
                return "";
            }
        }
        return description;
    }

    @Override
    public Icon getIcon() {
        return SwingUtils.createIcon((String)Dashboard.getProperty("dashboard.title.icon"), (Object)this);
    }

    @Override
    public URL getIconURL() {
        return null;
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public boolean loadOnlyOnDemand() {
        return false;
    }

    @Override
    public JComponent getComponent(PropertyChannel propertyChannel) {
        if (this.dashboard != null) {
            return this.dashboard;
        }
        if (useLoadMonitor) {
            ProgressView.monitor = new ProgressView(this.shownPanels.length);
            ProgressView.monitor.show("Welcome to Biomoby Dashboard");
        }
        JPanel p = new JPanel(new GridBagLayout(), true);
        this.bgcolor = GraphColours.getColour(Dashboard.getProperty("dashboard.bgcolor"), p.getBackground());
        p.setBackground(this.bgcolor);
        this.header = this.getHeader();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.addPanels();
        StatusBar statusBar = this.getStatusBar();
        propertyChannel.addPropertyChangeListener(statusBar);
        if (useLoadMonitor) {
            ProgressView.monitor.destroy();
        }
        if (this.panels == null || this.panels.length == 0) {
            JLabel labNoPanels = new JLabel("<html><center><font color='red' size='+2'>Sorry, but no Dashboard panel was specified.<br><p>The most probable cause is that no Dasboard configuration file was found.<br>Please run '<font color='black'>ant dashboard</font>' first.<br></center></font>");
            SwingUtils.addComponent((JComponent)p, (Component)labNoPanels, (int)0, (int)0, (int)1, (int)1, (int)10, (int)10, (double)1.0, (double)1.0);
        } else {
            SwingUtils.addComponent((JComponent)p, (Component)this.header, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
            SwingUtils.addComponent((JComponent)p, (Component)this.tabbedPane, (int)0, (int)1, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
            SwingUtils.addComponent((JComponent)p, (Component)statusBar, (int)0, (int)2, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (Insets)BREATH_SMALL);
        }
        return p;
    }

    protected void addPanels() {
        for (int i = 0; i < this.shownPanels.length; ++i) {
            String name = this.shownPanels[i].getName();
            if (useLoadMonitor) {
                ProgressView.monitor.setTextAndAdd("Loading " + name + "...");
            }
            this.tabbedPane.addTab("<html>" + name + "<br>&nbsp;", this.shownPanels[i].getIcon(), this.shownPanels[i].getComponent(this.propertyChannel));
            if (i >= 10) continue;
            this.tabbedPane.setMnemonicAt(i, 48 + i + 1);
        }
    }

    protected DashboardHeader getHeader() {
        DashboardHeader h = new DashboardHeader();
        if (this.shownPanels.length > 0) {
            h.setPanelTitle(this.shownPanels[0].getTitle());
        }
        return h;
    }

    protected StatusBar getStatusBar() {
        return new StatusBar("Dashboard is ready. Fasten your seat belts - it's going to be a bumpy ride.");
    }

    protected void addMenuBar(JFrame frame) {
        this.menuBar = new JMenuBar();
        frame.setJMenuBar(this.menuBar);
        String title = null;
        if (this.propertyChannel != null) {
            title = (String)this.propertyChannel.get("dp-registry-namespace");
        }
        title = title == null ? "" : CONNECTED_TO + this.findRegistryName(title) + " registry";
        JMenu dashmenu = Dashboard.createMenu("Dashboard", 68, null, null);
        JMenu setting = Dashboard.createMenu("Setting", 83, null, null);
        this.titleMenu = Dashboard.createMenu(title, -1, null, null);
        this.helpMenu = Dashboard.createMenu("Help", 72, null, null);
        this.menuBar.add(dashmenu);
        this.menuBar.add(setting);
        this.menuBar.add(this.titleMenu);
        this.menuBar.add(Box.createHorizontalGlue());
        this.menuBar.add(this.helpMenu);
        dashmenu.add(Dashboard.createMenuItem(new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (exitman != null) {
                    exitman.setExitForbidden(false);
                }
                System.exit(0);
            }
        }, AC_EXIT, 88, exitIcon, null));
        setting.add(Dashboard.createMenuItem(new AbstractAction("Panels selection"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dashboard.this.onPanelsSelection();
            }
        }, AC_PSELECT, 80, pselectIcon, pselectIconDis));
        setting.add(LookAndFeelUtils.getLookAndFeelMenu("Look & Feel", lafIcon, frame));
        setting.addSeparator();
        setting.add(Dashboard.createMenuItem(new AbstractAction("Manage My Dashboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }, AC_MYPREF, 77, prefIcon, prefIconDis));
        this.setEnabledMenuItem(AC_MYPREF, false);
        setting.add(Dashboard.createMenuItem(new AbstractAction("Export My Dashboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }, AC_EXPORT, 69, exportIcon, exportIconDis));
        this.setEnabledMenuItem(AC_EXPORT, false);
        setting.add(Dashboard.createMenuItem(new AbstractAction("Import My Dashboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }, AC_IMPORT, 73, importIcon, importIconDis));
        this.setEnabledMenuItem(AC_IMPORT, false);
        this.helpMenu.add(Dashboard.createMenuItem(new AbstractAction("About..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dashboard.this.openWindow(Dashboard.this.getWelcomePage(null), "About Dashboard...");
            }
        }, AC_ABOUT, 65, aboutIcon, null));
        this.helpMenu.add(Dashboard.createMenuItem(new AbstractAction("Dashboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dashboard.this.openWindow(Dashboard.this.getPanelHelpPage(Dashboard.this), "About " + Dashboard.this.getName() + "...");
            }
        }, AC_HELP, 68, helpIcon, null));
        this.helpMenu.addSeparator();
        this.countOfPermanentHelpItems = this.helpMenu.getMenuComponentCount();
        this.putPanelsToHelp();
    }

    protected void putPanelsToHelp() {
        int i;
        int count = this.helpMenu.getMenuComponentCount();
        while (count > this.countOfPermanentHelpItems) {
            this.helpMenu.remove(count - 1);
            count = this.helpMenu.getMenuComponentCount();
        }
        int maxIconWidth = 0;
        for (i = 0; i < this.shownPanels.length; ++i) {
            final DashboardPanel panel = this.shownPanels[i];
            final String name = panel.getName();
            Icon icon = panel.getIcon();
            if (icon != null) {
                maxIconWidth = Math.max(maxIconWidth, icon.getIconWidth());
            }
            this.helpMenu.add(Dashboard.createMenuItem(new AbstractAction(name){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Dashboard.this.openWindow(Dashboard.this.getPanelHelpPage(panel), "About " + name + "...");
                }
            }, name, -1, icon, null));
        }
        if (maxIconWidth > 0) {
            count = this.helpMenu.getMenuComponentCount();
            for (i = this.countOfPermanentHelpItems; i < count; ++i) {
                Icon icon;
                Component item = this.helpMenu.getMenuComponent(i);
                if (!(item instanceof JMenuItem) || (icon = ((JMenuItem)item).getIcon()) == null) continue;
                ((JMenuItem)item).setIconTextGap(maxIconWidth - icon.getIconWidth() + 4);
            }
        }
    }

    protected JPanel getWelcomePage(JProgressBar progressBar) {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(this.bgcolor);
        JScrollPane lDesc = this.createPane(this.getWelcomePageContents());
        String contact = Dashboard.getProperty("dashboard.contact");
        if (UUtils.isEmpty((String)contact)) {
            contact = "";
        }
        JLabel lContact = new JLabel("Contact: " + contact);
        JLabel title = this.getTitle();
        JLabel icon = new JLabel("", SwingUtils.createIcon((String)Dashboard.getProperty("dashboard.icon"), (Object)this), 0);
        SwingUtils.addComponent((JComponent)p, (Component)icon, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH);
        SwingUtils.addComponent((JComponent)p, (Component)title, (int)1, (int)0, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0, (Insets)BREATH);
        SwingUtils.addComponent((JComponent)p, (Component)lDesc, (int)0, (int)1, (int)2, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (Insets)BREATH);
        SwingUtils.addComponent((JComponent)p, (Component)lContact, (int)0, (int)2, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        return p;
    }

    protected String getWelcomePageContents() {
        StringBuffer buf = new StringBuffer(500);
        buf.append(this.getDescription("dashboard.description", "dashboard.description.file"));
        buf.append("<p>");
        buf.append(this.getDescription("project.description", "project.description.file"));
        buf.append("<h2>Dashboard panels</h2>");
        for (int i = 0; i < this.shownPanels.length; ++i) {
            URL iconURL = this.shownPanels[i].getIconURL();
            if (iconURL != null) {
                buf.append("<img src='");
                buf.append(iconURL.toString());
                buf.append("' border='0' hspace='5' align='left'></img>");
            }
            buf.append("<b>");
            buf.append(this.shownPanels[i].getName());
            buf.append("</b><blockquote>");
            buf.append(this.shownPanels[i].getDescription());
            buf.append("</blockquote><p>");
        }
        return new String(buf);
    }

    protected JPanel getPanelHelpPage(DashboardPanel panel) {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(this.bgcolor);
        String help = panel.getHelp();
        if (help == null) {
            help = panel.getDescription();
        }
        JScrollPane pHelp = this.createPane(help);
        SwingUtils.addComponent((JComponent)p, (Component)pHelp, (int)0, (int)0, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (Insets)BREATH);
        return p;
    }

    JScrollPane createPane(String contents) {
        final JEditorPane pane = new JEditorPane();
        pane.setBackground(this.bgcolor);
        pane.setEditable(false);
        pane.setContentType("text/html");
        pane.setText(contents);
        pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        String link = event.getDescription();
                        if (link != null && link.startsWith(Dashboard.PANEL_PROTOCOL)) {
                            boolean panelFound = false;
                            String panelClassName = link.substring(Dashboard.PANEL_PROTOCOL.length());
                            for (int i = 0; i < Dashboard.this.panels.length; ++i) {
                                if (!Dashboard.this.panels[i].getClass().getName().equals(panelClassName)) continue;
                                pane.setText(Dashboard.this.panels[i].getHelp());
                                panelFound = true;
                                break;
                            }
                            if (!panelFound) {
                                AbstractPanel.error("Can't follow link to panel " + panelClassName + ".\n Perhaps the panel is not loaded.\n");
                            }
                        } else {
                            pane.setPage(event.getURL());
                        }
                    }
                    catch (IOException e) {
                        String msg = event.getURL() == null ? event.getDescription() : event.getURL().toExternalForm();
                        AbstractPanel.error("Can't follow link to " + msg + ": " + e);
                    }
                }
            }
        });
        JScrollPane scroll = new JScrollPane(pane);
        scroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return scroll;
    }

    JEditorPane createSimplePane(String contents) {
        JEditorPane pane = new JEditorPane();
        pane.setEditable(false);
        pane.setContentType("text/html");
        pane.setText(contents);
        return pane;
    }

    protected void openWindow(final JComponent component, final String name) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = SwingUtils.createSoftMainFrame((JComponent)component, (String)name);
                Dimension screenSize = frame.getToolkit().getScreenSize();
                int width = screenSize.width / 3;
                int height = screenSize.height * 2 / 3;
                SwingUtils.showMainFrame((JFrame)frame, (int)width, (int)height);
            }
        });
    }

    protected void onPanelsSelection() {
        int result = JOptionPane.showConfirmDialog(null, this.getPanelsSelection(), "Selecting panels...", 2, 3, AbstractPanel.confirmIcon);
        if (result == 0) {
            this.chooseShownPanels();
            this.tabbedPane.removeAll();
            useLoadMonitor = false;
            this.addPanels();
            this.putPanelsToHelp();
        }
    }

    protected JPanel getPanelsSelection() {
        JPanel p = new JPanel(new GridBagLayout());
        JLabel prologue = new JLabel(SELECTION_PROLOGUE);
        SwingUtils.addComponent((JComponent)p, (Component)prologue, (int)0, (int)0, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH_BOT);
        for (int i = 0; i < this.panelBoxes.length; ++i) {
            SwingUtils.addComponent((JComponent)p, (Component)this.panelBoxes[i], (int)0, (int)(i + 1), (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        }
        return p;
    }

    private void setEnabledMenuItem(String actionCommand, boolean enabled) {
        AbstractPanel.setEnabledMenuItem(this.menuBar, actionCommand, enabled);
    }

    private static JMenuItem createMenuItem(AbstractAction action, String actionCommand, int mnemonic, Icon icon, Icon disabledIcon) {
        return AbstractPanel.createMenuItem(action, actionCommand, mnemonic, icon, disabledIcon);
    }

    private static JMenu createMenu(String name, int mnemonic, Icon icon, Icon disabledIcon) {
        return AbstractPanel.createMenu(name, mnemonic, icon, disabledIcon);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int panelIndex = this.tabbedPane.getSelectedIndex();
        if (panelIndex < 0 || panelIndex >= this.shownPanels.length) {
            this.header.setPanelTitle(null);
        } else {
            this.header.setPanelTitle(this.shownPanels[panelIndex].getTitle());
        }
    }

    private String findRegistryName(String namespace) {
        Registries regList = RegistriesList.getInstance();
        Registry[] regs = regList.getAll();
        for (int i = 0; i < regs.length; ++i) {
            if (!namespace.equals(regs[i].getNamespace())) continue;
            return regs[i].getSynonym();
        }
        return namespace;
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("-nop")) {
            useLoadMonitor = false;
        }
        new Dashboard().show();
    }

    static {
        ToolTipManager.sharedInstance().setDismissDelay(30000);
    }

    class StatusBar
    extends JLabel
    implements PropertyChangeListener {
        DateFormat df;
        Icon myIcon;

        public StatusBar(String text) {
            super(text);
            this.df = DateFormat.getTimeInstance();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == null) {
                return;
            }
            Object value = e.getNewValue();
            if (value == null) {
                return;
            }
            if (prop.equalsIgnoreCase("status-msg")) {
                this.setText("[" + this.df.format(new Date()) + "] " + value.toString());
            }
        }

        @Override
        public Icon getIcon() {
            if (this.myIcon == null) {
                this.myIcon = SwingUtils.createIcon((String)"images/smallDone.gif", Dashboard.class);
            }
            return this.myIcon;
        }
    }

    class DashboardHeader
    extends JPanel {
        public DashboardHeader() {
            super(new GridBagLayout());
            this.setBackground(Dashboard.this.bgcolor);
            JLabel mainTitle = Dashboard.this.getTitle();
            JLabel panelTitle = new JLabel();
            Component glue = Box.createHorizontalGlue();
            SwingUtils.addComponent((JComponent)this, (Component)mainTitle, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)BREATH);
            SwingUtils.addComponent((JComponent)this, (Component)glue, (int)1, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
            SwingUtils.addComponent((JComponent)this, (Component)panelTitle, (int)2, (int)0, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0, (Insets)BREATH);
        }

        public void setPanelTitle(JLabel newTitle) {
            if (newTitle == null) {
                newTitle = new JLabel();
            }
            this.remove(2);
            SwingUtils.addComponent((JComponent)this, (Component)newTitle, (int)2, (int)0, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0, (Insets)BREATH);
            AwtUtils.redisplay((Component)this);
        }
    }
}

