/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.CommonNode;
import org.biomoby.service.dashboard.Dashboard;
import org.biomoby.service.dashboard.DashboardProperties;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.SwingWorker;
import org.tulsoft.shared.PrefsUtils;
import org.tulsoft.tools.gui.SwingUtils;

public class CommonTree
extends JTree
implements DashboardProperties {
    protected static final String AC_SEARCH = "ac-search";
    protected static final String AC_EXPAND = "ac-expand";
    protected static final String AC_COLLAPSE = "ac-collapse";
    protected static final String AC_RELOAD = "ac-reload";
    protected static final String AC_NSORT = "ac-nsort";
    protected static final String AC_ASORT = "ac-asort";
    protected static final int SORTED_AS_PREVIOUSLY = -1;
    protected static final int SORTED_BY_NAME = 0;
    protected static final int SORTED_BY_AUTHORITY = 1;
    protected static final int SORTED_UNUSUAL = 9;
    protected static final int SORTED_BY_SERVICE_TYPE = 11;
    protected static final int SORTED_BY_INPUT_DATA = 12;
    protected static final int SORTED_BY_OUTPUT_DATA = 13;
    protected static final String PREF_KEY_SEARCH = "searchKey";
    private static int allTreeCounter = 0;
    protected int treeId;
    protected JPopupMenu popup;
    protected static String lastSearchText = PrefsUtils.getNode(Dashboard.class).get("searchKey", "");
    protected int lastSorted = 0;
    protected PropertyChannel propertyChannel;
    protected static Icon searchIcon;
    protected static Icon menuSearchIcon;
    protected static Icon menuSearchIconDis;
    protected static Icon menuExpandIcon;
    protected static Icon menuExpandIconDis;
    protected static Icon menuCollapseIcon;
    protected static Icon menuCollapseIconDis;
    protected static Icon menuReloadIcon;
    protected static Icon menuReloadIconDis;
    protected static Icon smallNIcon;
    protected static Icon smallNIconDis;
    protected static Icon smallAIcon;
    protected static Icon smallAIconDis;
    protected static Icon smallTIcon;
    protected static Icon smallTIconDis;
    protected static Icon smallIIcon;
    protected static Icon smallIIconDis;
    protected static Icon smallOIcon;
    protected static Icon smallOIconDis;
    protected static Icon sLeafIcon;
    protected static Icon stLeafIcon;
    protected static Icon dtLeafIcon;
    protected static Icon nsLeafIcon;
    protected String rootNode;
    protected static final String ACCESS_ERROR_INTRO = "Check please values in text fields (in Registry Browser)\nspecifying registry endpoint and namespace, and in the\none specifying directory used as a local cache. Then\nright-click in the data types area and select 'Reload'.\n\n";

    public CommonTree(String rootNode) {
        super(new DefaultTreeModel(new DefaultMutableTreeNode(new CommonNode(rootNode))));
        this.rootNode = rootNode;
        this.treeId = ++allTreeCounter;
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setCellRenderer(new CommonTreeCellRenderer());
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)CommonTree.this.getLastSelectedPathComponent();
                CommonTree.this.selected(node);
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this);
        this.loadIcons();
    }

    public void setPropertyChannel(PropertyChannel propertyChannel) {
        this.propertyChannel = propertyChannel;
    }

    public void setLeafIcon(Icon icon) {
        CommonTreeCellRenderer r = (CommonTreeCellRenderer)this.getCellRenderer();
        r.setLeafIcon(icon);
    }

    public JScrollPane scrollable() {
        return new JScrollPane(this);
    }

    public void update(int howSorted, Object data) {
    }

    protected void selected(DefaultMutableTreeNode node) {
    }

    protected void loadIcons() {
        if (menuSearchIcon == null) {
            menuSearchIcon = SwingUtils.createIcon((String)"images/smallSearch.gif", Dashboard.class);
        }
        if (menuSearchIconDis == null) {
            menuSearchIconDis = SwingUtils.createIcon((String)"images/smallSearch_dis.gif", Dashboard.class);
        }
        if (menuExpandIcon == null) {
            menuExpandIcon = SwingUtils.createIcon((String)"images/smallExpand.gif", Dashboard.class);
        }
        if (menuExpandIconDis == null) {
            menuExpandIconDis = SwingUtils.createIcon((String)"images/smallExpand_dis.gif", Dashboard.class);
        }
        if (menuCollapseIcon == null) {
            menuCollapseIcon = SwingUtils.createIcon((String)"images/smallCollapse.gif", Dashboard.class);
        }
        if (menuCollapseIconDis == null) {
            menuCollapseIconDis = SwingUtils.createIcon((String)"images/smallCollapse_dis.gif", Dashboard.class);
        }
        if (menuReloadIcon == null) {
            menuReloadIcon = SwingUtils.createIcon((String)"images/smallReload.gif", Dashboard.class);
        }
        if (menuReloadIconDis == null) {
            menuReloadIconDis = SwingUtils.createIcon((String)"images/smallReload_dis.gif", Dashboard.class);
        }
        if (smallNIcon == null) {
            smallNIcon = CommonTree.loadIcon("images/smallSortAZ.gif");
        }
        if (smallNIconDis == null) {
            smallNIconDis = CommonTree.loadIcon("images/smallSortAZ_dis.gif");
        }
        if (smallAIcon == null) {
            smallAIcon = CommonTree.loadIcon("images/smallAuth.gif");
        }
        if (smallAIconDis == null) {
            smallAIconDis = CommonTree.loadIcon("images/smallAuth_dis.gif");
        }
        if (smallTIcon == null) {
            smallTIcon = CommonTree.loadIcon("images/smallInher.gif");
        }
        if (smallTIconDis == null) {
            smallTIconDis = CommonTree.loadIcon("images/smallInher_dis.gif");
        }
        if (smallIIcon == null) {
            smallIIcon = CommonTree.loadIcon("images/smallImport.gif");
        }
        if (smallIIconDis == null) {
            smallIIconDis = CommonTree.loadIcon("images/smallImport_dis.gif");
        }
        if (smallOIcon == null) {
            smallOIcon = CommonTree.loadIcon("images/smallExport.gif");
        }
        if (smallOIconDis == null) {
            smallOIconDis = CommonTree.loadIcon("images/smallExport_dis.gif");
        }
        if (nsLeafIcon == null) {
            nsLeafIcon = CommonTree.loadIcon("images/small_yellow.gif");
        }
        if (stLeafIcon == null) {
            stLeafIcon = CommonTree.loadIcon("images/magentaDiamond.gif");
        }
        if (sLeafIcon == null) {
            sLeafIcon = CommonTree.loadIcon("images/console.gif");
        }
        if (dtLeafIcon == null) {
            dtLeafIcon = CommonTree.loadIcon("images/smallPage.gif");
        }
    }

    protected static Icon loadIcon(String path) {
        return AbstractPanel.loadIcon(path);
    }

    protected void createPopups(String title) {
        this.popup = new JPopupMenu(title);
        this.popup.add(CommonTree.createMenuItem(new AbstractAction("Search"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String searchText = CommonTree.this.searchDialog();
                if (searchText != null) {
                    CommonTree.this.search(searchText);
                }
            }
        }, AC_SEARCH, menuSearchIcon, menuSearchIconDis));
        this.popup.add(CommonTree.createMenuItem(new AbstractAction("Expand all nodes"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonTree.this.expand();
            }
        }, AC_EXPAND, menuExpandIcon, menuExpandIconDis));
        this.popup.add(CommonTree.createMenuItem(new AbstractAction("Collapse all nodes"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonTree.this.collapse();
            }
        }, AC_COLLAPSE, menuCollapseIcon, menuCollapseIconDis));
        this.popup.addSeparator();
        this.popup.add(CommonTree.createMenuItem(new AbstractAction("Reload"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonTree.this.reload();
            }
        }, AC_RELOAD, menuReloadIcon, menuReloadIconDis));
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
    }

    public static JMenuItem createMenuItem(AbstractAction action, String actionCommand) {
        return AbstractPanel.createMenuItem(action, actionCommand);
    }

    public static JMenuItem createMenuItem(AbstractAction action, String actionCommand, Icon icon, Icon disabledIcon) {
        return AbstractPanel.createMenuItem(action, actionCommand, -1, icon, disabledIcon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setEnabledPopup(boolean enabled) {
        JPopupMenu jPopupMenu = this.popup;
        synchronized (jPopupMenu) {
            Component[] components = this.popup.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof JMenuItem) || AC_RELOAD.equals(((JMenuItem)components[i]).getActionCommand())) continue;
                ((JMenuItem)components[i]).setEnabled(enabled);
            }
        }
    }

    protected void addSortingItems() {
        this.popup.addSeparator();
        this.popup.add(CommonTree.createMenuItem(new AbstractAction("Sort by names"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonTree.this.lastSorted = 0;
                CommonTree.this.update(0, null);
            }
        }, AC_NSORT, smallNIcon, smallNIconDis));
        this.popup.add(CommonTree.createMenuItem(new AbstractAction("Sort by authorities"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonTree.this.lastSorted = 1;
                CommonTree.this.update(1, null);
            }
        }, AC_ASORT, smallAIcon, smallAIconDis));
    }

    protected void collapse() {
        SwingUtils.collapseTree((JTree)this, (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.getModel().getRoot()));
    }

    protected void expand() {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                SwingUtils.expandTree((JTree)CommonTree.this, (DefaultMutableTreeNode)((DefaultMutableTreeNode)CommonTree.this.getModel().getRoot()));
                return null;
            }

            @Override
            public void finished() {
                CommonTree.this.repaint();
            }
        };
        worker.start();
    }

    protected void reload() {
    }

    protected void search(String searchText) {
    }

    protected String searchDialog() {
        String result;
        if (searchIcon == null) {
            searchIcon = SwingUtils.createIcon((String)"images/viewerButton.gif", Dashboard.class);
        }
        if ((result = (String)JOptionPane.showInputDialog(null, "The search will highlight nodes in this tree that\ncontain (or are related to) the text you enter here.\nText is treated as a regular expression. The case-\ninsensitivity is, however, always added by default.\n \nFor example, try: germplasm or mark|kawas.\n \n", "Search", 2, searchIcon, null, lastSearchText)) != null) {
            lastSearchText = result;
            PrefsUtils.getNode(Dashboard.class).put(PREF_KEY_SEARCH, lastSearchText);
        }
        return result;
    }

    protected void highlightAndJumpTo(Set<String> toBeHighlighted) {
        this.setSelectionPath(null);
        CommonTreeCellRenderer r = (CommonTreeCellRenderer)this.getCellRenderer();
        r.setToBeHighlighted(toBeHighlighted);
        this.collapse();
        DefaultTreeModel tModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tModel.getRoot();
        Enumeration<TreeNode> en = root.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            if (!toBeHighlighted.contains(((CommonNode)node.getUserObject()).getValue())) continue;
            this.makeVisible(new TreePath(tModel.getPathToRoot(node)));
        }
    }

    protected static void error(String prologue, Exception e) {
        AbstractPanel.error(prologue, e);
    }

    protected void removeFromPopups(String actionCommand) {
        if (this.popup == null) {
            return;
        }
        Component[] components = this.popup.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JMenuItem) || !actionCommand.equals(((JMenuItem)components[i]).getActionCommand())) continue;
            this.popup.remove(components[i]);
            return;
        }
    }

    protected void removeSeparatorAfter(String actionCommand) {
        if (this.popup == null) {
            return;
        }
        Component[] components = this.popup.getComponents();
        boolean found = false;
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof JSeparator && found) {
                this.popup.remove(components[i]);
                return;
            }
            found = components[i] instanceof JMenuItem && actionCommand.equals(((JMenuItem)components[i]).getActionCommand());
        }
    }

    protected void setEnabledPopupItem(String actionCommand, boolean enabled) {
        AbstractPanel.setEnabledMenuItem(this.popup, actionCommand, enabled);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && CommonTree.this.popup.isEnabled()) {
                CommonTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class CommonTreeCellRenderer
    extends DefaultTreeCellRenderer {
        Set<String> toBeHighlighted;
        Icon leafImage;

        CommonTreeCellRenderer() {
        }

        @Override
        public void setLeafIcon(Icon icon) {
            this.leafImage = icon;
        }

        public void setToBeHighlighted(Set<String> toBeHighlighted) {
            this.toBeHighlighted = toBeHighlighted;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasAFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasAFocus);
            if (row == 0) {
                this.setToolTipText("Right-click will show other options");
                this.setFont(new Font("Dialog", 1, 12));
            } else {
                this.setToolTipText(null);
                this.setFont(new Font("Dialog", 0, 10));
            }
            if (row == 0) {
                this.setText(CommonTree.this.rootNode);
            }
            if (leaf) {
                ((JLabel)c).setIcon(this.leafImage);
            }
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            CommonNode nodeObject = (CommonNode)userObject;
            if (this.toBeHighlighted != null && this.toBeHighlighted.contains(nodeObject.getValue())) {
                this.setText("<html><font color='red'>" + nodeObject + "</font></html>");
            }
            return c;
        }
    }
}

