/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biomoby.service.dashboard.Dashboard;
import org.biomoby.shared.MobyData;
import org.tulsoft.tools.gui.SwingUtils;

public class CommonDataTable
extends JTable {
    private static Log log = LogFactory.getLog(CommonDataTable.class);
    public static final int COL_BUTTON = 0;
    protected CommonDataTableModel tableModel;
    protected static Icon deleteDataIcon;
    protected static Icon trashIcon;
    protected static Icon tAreaIcon;

    protected CommonDataTable() {
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public CommonDataTable(CommonDataTableModel model) {
        super(model);
        this.tableModel = model;
        this.setModel(this.tableModel);
        this.createItself();
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public void addEmptyData() {
        this.tableModel.addEmptyData();
        int rowCount = this.getRowCount();
        this.clearSelection();
        this.addRowSelectionInterval(rowCount - 1, rowCount - 1);
    }

    public void setData(MobyData[] newData) {
        this.tableModel.setData(newData);
    }

    protected void createItself() {
        this.loadIcons();
        this.getTableHeader().setReorderingAllowed(false);
        TableColumn buttonColumn = this.getColumnModel().getColumn(0);
        if (trashIcon != null) {
            buttonColumn.setMaxWidth(trashIcon.getIconWidth() + 15);
        }
        buttonColumn.setCellRenderer(new ButtonRenderer());
        buttonColumn.setCellEditor(new ButtonEditor());
        buttonColumn.setHeaderRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return (JComponent)value;
            }
        });
        buttonColumn.setHeaderValue(new JButton("", trashIcon));
    }

    protected void loadIcons() {
        if (deleteDataIcon == null) {
            deleteDataIcon = CommonDataTable.loadIcon("images/smallRemove.gif");
        }
        if (trashIcon == null) {
            trashIcon = CommonDataTable.loadIcon("images/smallTrash.gif");
        }
        if (tAreaIcon == null) {
            tAreaIcon = CommonDataTable.loadIcon("images/smallMoreLines.gif");
        }
    }

    protected static Icon loadIcon(String path) {
        return SwingUtils.createIcon((String)path, Dashboard.class);
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return CommonDataTable.this.tableModel.columnToolTips[realIndex];
            }
        };
    }

    public JScrollPane scrollable() {
        return new JScrollPane(this);
    }

    protected abstract class CommonDataTableModel
    extends AbstractTableModel {
        protected String[] columnToolTips;
        protected String[] columnNames = new String[0];
        protected Class[] columnClasses = new Class[0];
        protected Vector data = new Vector();

        protected CommonDataTableModel() {
        }

        public abstract void addEmptyData();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setData(MobyData[] newData) {
            CommonDataTableModel commonDataTableModel = this;
            synchronized (commonDataTableModel) {
                int i;
                int rowCount = this.getRowCount();
                for (i = rowCount - 1; i >= 0; --i) {
                    this.removeRow(i);
                }
                for (i = 0; i < newData.length; ++i) {
                    this.data.addElement(newData[i]);
                }
                this.fireTableDataChanged();
            }
        }

        public Vector getData() {
            return this.data;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int col) {
            return this.columnClasses[col];
        }

        public void removeRow(int row) {
            try {
                this.data.removeElementAt(row);
                this.fireTableRowsDeleted(row, row);
            }
            catch (Exception e) {
                log.error((Object)e.toString());
            }
        }
    }

    class ButtonEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        ButtonEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            DeleteRowButton button = new DeleteRowButton();
            button.setRowToDelete(row);
            return button;
        }
    }

    class ButtonRenderer
    extends DeleteRowButton
    implements TableCellRenderer {
        public ButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }

    class DeleteRowButton
    extends JButton {
        int rowToDelete = -1;

        public DeleteRowButton() {
            this.setText("");
            this.setIcon(deleteDataIcon);
            this.setToolTipText("Remove this data from this service");
            this.setFocusPainted(false);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DeleteRowButton.this.rowToDelete >= 0) {
                        CommonDataTable.this.tableModel.removeRow(DeleteRowButton.this.rowToDelete);
                    }
                }
            });
        }

        public void setRowToDelete(int row) {
            this.rowToDelete = row;
        }
    }
}

