/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.biomoby.service.dashboard.AbstractPanel;
import org.biomoby.service.dashboard.Dashboard;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.Utils;
import org.tulsoft.shared.PrefsUtils;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.gui.SwingUtils;

public class CommonConsole
extends JPanel
implements PropertyChangeListener {
    public static final String VERBOSE_EVENT = "verbose-msg";
    protected static final String SAVE_ERROR = "Sorry, an error happened when saving...\n\n";
    JTextArea textArea;
    JCheckBox appendModeBox;
    JCheckBox verboseModeBox;
    JButton cleanButton;
    JButton saveButton;
    boolean appendMode = true;
    boolean verboseMode = false;
    JFileChooser saveChooser;
    PropertyChannel propertyChannel;
    String verboseEventName = "verbose-msg";
    static Icon clearIcon;
    static Icon clearIconDis;
    static Icon saveIcon;
    static Icon saveIconDis;
    static Icon zoomInIcon;
    static Icon zoomInIconDis;
    static Icon zoomOutIcon;
    static Icon zoomOutIconDis;

    public CommonConsole() {
        this.loadIcons();
        this.setLayout(new GridBagLayout());
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("Courier", 0, 10));
        this.textArea.setEditable(false);
        JScrollPane scroller = new JScrollPane(this.textArea);
        this.cleanButton = AbstractPanel.createButton("", "Remove all messages from the console area", -1, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!"".equals(CommonConsole.this.textArea.getText()) && AbstractPanel.confirm(CommonConsole.this, "Remove all messages?")) {
                    CommonConsole.this.textArea.setText("");
                    CommonConsole.this.cleanButton.setEnabled(false);
                    CommonConsole.this.saveButton.setEnabled(false);
                }
            }
        });
        this.cleanButton.setIcon(clearIcon);
        this.cleanButton.setDisabledIcon(clearIconDis);
        this.cleanButton.setEnabled(false);
        SwingUtils.compact((JButton)this.cleanButton);
        this.saveChooser = new JFileChooser();
        this.saveChooser.setDialogTitle("Save console contents");
        this.saveButton = AbstractPanel.createButton("", "Save the contents of the console area to a file", -1, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonConsole.this.onSave();
            }
        });
        this.saveButton.setIcon(saveIcon);
        this.saveButton.setDisabledIcon(saveIconDis);
        this.saveButton.setEnabled(false);
        SwingUtils.compact((JButton)this.saveButton);
        JButton zoomInButton = AbstractPanel.createButton("", "Increase font in the console window", -1, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font font = CommonConsole.this.textArea.getFont();
                CommonConsole.this.textArea.setFont(font.deriveFont(font.getSize2D() + 1.0f));
            }
        });
        zoomInButton.setIcon(zoomInIcon);
        zoomInButton.setDisabledIcon(zoomInIconDis);
        SwingUtils.compact((JButton)zoomInButton);
        JButton zoomOutButton = AbstractPanel.createButton("", "Decrease font in the console window", -1, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font font = CommonConsole.this.textArea.getFont();
                CommonConsole.this.textArea.setFont(font.deriveFont(Math.max(1.0f, font.getSize2D() - 1.0f)));
            }
        });
        zoomOutButton.setIcon(zoomOutIcon);
        zoomOutButton.setDisabledIcon(zoomOutIconDis);
        SwingUtils.compact((JButton)zoomOutButton);
        this.appendModeBox = AbstractPanel.createCheckBox("append mode", this.appendMode, -1, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CommonConsole.this.appendMode = e.getStateChange() == 1;
            }
        });
        this.verboseModeBox = AbstractPanel.createCheckBox("verbose", this.verboseMode, -1, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean bl = CommonConsole.this.verboseMode = e.getStateChange() == 1;
                if (CommonConsole.this.propertyChannel != null) {
                    if (CommonConsole.this.verboseMode) {
                        CommonConsole.this.propertyChannel.addPropertyChangeListener(CommonConsole.this);
                    } else {
                        CommonConsole.this.propertyChannel.removePropertyChangeListener(CommonConsole.this);
                    }
                }
            }
        });
        Component glue = Box.createHorizontalGlue();
        SwingUtils.addComponent((JComponent)this, (Component)scroller, (int)0, (int)0, (int)7, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        if (this.hasCleanButton()) {
            SwingUtils.addComponent((JComponent)this, (Component)this.cleanButton, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        }
        if (this.hasSaveButton()) {
            SwingUtils.addComponent((JComponent)this, (Component)this.saveButton, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        }
        if (this.hasAppendModeSwitcher()) {
            SwingUtils.addComponent((JComponent)this, (Component)this.appendModeBox, (int)2, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        }
        if (this.hasVerboseModeSwitcher()) {
            SwingUtils.addComponent((JComponent)this, (Component)this.verboseModeBox, (int)3, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        }
        SwingUtils.addComponent((JComponent)this, (Component)glue, (int)4, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)this, (Component)zoomInButton, (int)5, (int)1, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)this, (Component)zoomOutButton, (int)6, (int)1, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0);
    }

    protected String showSaveDialog() {
        Preferences node = PrefsUtils.getNode(this.getClass());
        String initValue = node.get("dp-cons-savefile", System.getProperty("user.dir"));
        if (UUtils.notEmpty((String)initValue)) {
            File file = new File(initValue);
            this.saveChooser.setSelectedFile(file);
        }
        if (this.saveChooser.showSaveDialog(this) != 0) {
            return null;
        }
        String fileName = this.saveChooser.getSelectedFile().getAbsolutePath();
        node.put("dp-cons-savefile", fileName);
        return fileName;
    }

    protected void onSave() {
        final String fileName = this.showSaveDialog();
        if (UUtils.isEmpty((String)fileName)) {
            return;
        }
        SwingWorker worker = new SwingWorker(){
            MobyException exception = null;

            @Override
            public Object construct() {
                try {
                    Utils.createFile((File)new File(fileName), (String)CommonConsole.this.getArea().getText());
                }
                catch (MobyException e) {
                    this.exception = e;
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.exception != null) {
                    AbstractPanel.error(CommonConsole.SAVE_ERROR, (Exception)((Object)this.exception));
                }
            }
        };
        worker.start();
    }

    public JTextArea getArea() {
        return this.textArea;
    }

    public void setText(String value) {
        this.realSetText(value);
    }

    private void realSetText(String value) {
        if (this.appendMode || !this.appendModeBox.isEnabled()) {
            this.textArea.append(value);
            this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        } else {
            this.textArea.setText(value);
        }
        this.cleanButton.setEnabled(true);
        this.saveButton.setEnabled(true);
    }

    public void clean() {
        this.textArea.setText("");
        this.cleanButton.setEnabled(true);
        this.saveButton.setEnabled(true);
    }

    public boolean setAppendMode(boolean enabled) {
        boolean oldMode = this.appendMode;
        this.appendMode = enabled;
        this.appendModeBox.setSelected(this.appendMode);
        return oldMode;
    }

    public boolean isAppendMode() {
        return this.appendMode;
    }

    public void setEnabledAppendMode(boolean enabled) {
        this.appendModeBox.setEnabled(enabled);
    }

    public boolean setVerboseMode(boolean enabled) {
        boolean oldMode = this.verboseMode;
        this.verboseMode = enabled;
        this.verboseModeBox.setSelected(this.verboseMode);
        return oldMode;
    }

    public boolean isVerboseMode() {
        return this.verboseMode;
    }

    public void setPropertyChannel(PropertyChannel propertyChannel) {
        this.propertyChannel = propertyChannel;
    }

    public void setVerboseEventName(String eventName) {
        this.verboseEventName = eventName;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getPropertyName();
        if (prop == null) {
            return;
        }
        Object obj = event.getNewValue();
        if (obj == null || !(obj instanceof String)) {
            return;
        }
        String value = (String)obj;
        if (this.verboseEventName.equals(prop)) {
            this.setText(value);
        }
    }

    protected void loadIcons() {
        if (clearIcon == null) {
            clearIcon = CommonConsole.loadIcon("images/smallClear.gif");
        }
        if (clearIconDis == null) {
            clearIconDis = CommonConsole.loadIcon("images/smallClear_dis.gif");
        }
        if (saveIcon == null) {
            saveIcon = CommonConsole.loadIcon("images/smallSave.gif");
        }
        if (saveIconDis == null) {
            saveIconDis = CommonConsole.loadIcon("images/smallSave_dis.gif");
        }
        if (zoomInIcon == null) {
            zoomInIcon = CommonConsole.loadIcon("images/smallZoomIn.gif");
        }
        if (zoomInIconDis == null) {
            zoomInIconDis = CommonConsole.loadIcon("images/smallZoomIn_dis.gif");
        }
        if (zoomOutIcon == null) {
            zoomOutIcon = CommonConsole.loadIcon("images/smallZoomOut.gif");
        }
        if (zoomOutIconDis == null) {
            zoomOutIconDis = CommonConsole.loadIcon("images/smallZoomOut_dis.gif");
        }
    }

    protected static Icon loadIcon(String path) {
        return SwingUtils.createIcon((String)path, Dashboard.class);
    }

    public boolean hasCleanButton() {
        return true;
    }

    public boolean hasSaveButton() {
        return true;
    }

    public boolean hasAppendModeSwitcher() {
        return true;
    }

    public boolean hasVerboseModeSwitcher() {
        return true;
    }
}

