/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.biomoby.service.dashboard.CommonTree;
import org.biomoby.service.dashboard.DashboardProperties;
import org.biomoby.service.dashboard.JProgressBarWithCancel;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.shared.event.NotificationEvent;
import org.biomoby.shared.event.NotificationListener;
import org.tulsoft.tools.gui.SwingUtils;

public abstract class CommonBoard
extends JPanel
implements DashboardProperties,
NotificationListener {
    protected RegistryModel model;
    protected PropertyChannel channel;
    private static int allBoardCounter = 0;
    protected int boardId;
    protected JLabel treeTitle;
    protected JProgressBarWithCancel pBar;
    protected CommonTree tree;
    protected GridBagConstraints gbc;

    protected CommonBoard(RegistryModel model, PropertyChannel channel) {
        this.model = model;
        this.channel = channel;
        this.treeTitle = new JLabel("");
        this.boardId = ++allBoardCounter;
    }

    public void updateTree(int howSorted) {
        this.tree.update(howSorted, null);
    }

    public abstract void notified(NotificationEvent var1);

    protected void createItself() {
        this.setLayout(new GridBagLayout());
        SwingUtils.addComponent((JComponent)this, (Component)this.treeTitle, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0);
        SwingUtils.addComponent((JComponent)this, (Component)this.tree.scrollable(), (int)0, (int)1, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0);
        this.gbc = ((GridBagLayout)this.getLayout()).getConstraints(this.treeTitle);
    }

    protected synchronized void createProgressBar(int callbackSignal) {
        this.pBar = new JProgressBarWithCancel();
        JProgressBar pB = this.pBar.get();
        pB.setStringPainted(true);
        pB.setString("");
        pB.setIndeterminate(true);
        final int signal = callbackSignal;
        this.pBar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonBoard.this.model.callback(signal);
                CommonBoard.this.removeProgressBar();
            }
        });
    }

    protected synchronized void insertProgressBar() {
        if (this.pBar != null) {
            this.remove(0);
            this.addImpl(this.pBar, this.gbc, 0);
            this.validate();
        }
    }

    protected synchronized void calibrateProgressBar(int maximum) {
        if (this.pBar != null && maximum > 0) {
            JProgressBar pB = this.pBar.get();
            pB.setMinimum(0);
            pB.setMaximum(maximum);
            pB.setValue(0);
            pB.setIndeterminate(false);
            pB.setString(null);
        }
    }

    protected synchronized void addToProgressBar() {
        if (this.pBar != null) {
            JProgressBar pB = this.pBar.get();
            pB.setValue(pB.getValue() + 1);
        }
    }

    protected synchronized void removeProgressBar() {
        if (this.pBar != null) {
            this.remove(0);
            this.addImpl(this.treeTitle, this.gbc, 0);
            this.validate();
            this.pBar = null;
        }
    }
}

