/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.biomoby.service.dashboard.CommonNode;
import org.biomoby.service.dashboard.CommonTree;
import org.biomoby.service.dashboard.Dashboard;
import org.biomoby.service.dashboard.DashboardProperties;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.SwingWorker;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyRelationship;
import org.tulsoft.shared.UUtils;
import org.tulsoft.tools.gui.SwingUtils;

public class BuildDataTypeTree
extends JTree
implements DashboardProperties,
PropertyChangeListener {
    protected static final String AC_RENAME = "ac-rename";
    protected static final String AC_REFRESH = "ac-refresh";
    protected static final String AC_REMOVE = "ac-remove";
    protected static final String AC_REMOVEALL = "ac-remove-all";
    protected static Icon renameIcon;
    protected static Icon menuRenameIcon;
    protected static Icon menuRenameIconDis;
    protected static Icon menuRefreshIcon;
    protected static Icon menuRefreshIconDis;
    protected static Icon menuRemoveIcon;
    protected static Icon menuRemoveIconDis;
    protected static Icon menuRemoveAllIcon;
    protected static Icon menuRemoveAllIconDis;
    protected JPopupMenu popup;
    protected PropertyChannel propertyChannel;
    protected ISANode rootContents;
    protected MainNode nameContents;
    protected DefaultMutableTreeNode nameNode;
    private DefaultMutableTreeNode lastTriggeredNode;
    private MemberNode lastTriggeredMember;

    public BuildDataTypeTree(PropertyChannel propertyChannel) {
        super(new DefaultTreeModel(new DefaultMutableTreeNode()));
        DefaultTreeModel tModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tModel.getRoot();
        this.rootContents = new ISANode();
        root.setUserObject(this.rootContents);
        this.propertyChannel = propertyChannel;
        this.propertyChannel.addPropertyChangeListener(this);
        this.nameContents = new MainNode(this.propertyChannel.getString("dp-reg-dt-name"));
        this.nameNode = new DefaultMutableTreeNode(this.nameContents);
        root.add(this.nameNode);
        this.setFont(new Font("Dialog", 0, 12));
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setCellRenderer(new BuildTreeCellRenderer());
        this.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.loadIcons();
        this.createPopups("Building new Data Type Menu");
        this.updateTree();
    }

    public JScrollPane scrollable() {
        return new JScrollPane(this);
    }

    public void setParent(String parentDataTypeName) {
        this.rootContents.setValue(parentDataTypeName);
        this.rootContents.setName(parentDataTypeName);
        this.updateTree();
    }

    public void setMainName(String newDataTypeName) {
        this.nameContents.setValue(newDataTypeName);
        this.nameContents.setName(newDataTypeName);
        this.updateTree();
    }

    public void addMember(String childDataTypeName, int relationshipType) {
        MemberNode newNode = new MemberNode(new MobyRelationship(childDataTypeName, childDataTypeName, relationshipType));
        this.nameNode.add(new DefaultMutableTreeNode(newNode));
    }

    public void addMember(MobyRelationship child) {
        MemberNode newNode = new MemberNode(child);
        this.nameNode.add(new DefaultMutableTreeNode(newNode));
    }

    public void removeAllChildren() {
        this.nameNode.removeAllChildren();
        this.updateTree();
    }

    protected void loadIcons() {
        if (renameIcon == null) {
            renameIcon = SwingUtils.createIcon((String)"images/renameButton.gif", Dashboard.class);
        }
        if (menuRenameIcon == null) {
            menuRenameIcon = SwingUtils.createIcon((String)"images/smallRename.gif", Dashboard.class);
        }
        if (menuRenameIconDis == null) {
            menuRenameIconDis = SwingUtils.createIcon((String)"images/smallRename_dis.gif", Dashboard.class);
        }
        if (menuRefreshIcon == null) {
            menuRefreshIcon = SwingUtils.createIcon((String)"images/smallRefresh.gif", Dashboard.class);
        }
        if (menuRefreshIconDis == null) {
            menuRefreshIconDis = SwingUtils.createIcon((String)"images/smallRefresh_dis.gif", Dashboard.class);
        }
        if (menuRemoveIcon == null) {
            menuRemoveIcon = SwingUtils.createIcon((String)"images/smallRemove.gif", Dashboard.class);
        }
        if (menuRemoveIconDis == null) {
            menuRemoveIconDis = SwingUtils.createIcon((String)"images/smallRemove_dis.gif", Dashboard.class);
        }
        if (menuRemoveAllIcon == null) {
            menuRemoveAllIcon = SwingUtils.createIcon((String)"images/smallWarning.gif", Dashboard.class);
        }
        if (menuRemoveAllIconDis == null) {
            menuRemoveAllIconDis = SwingUtils.createIcon((String)"images/smallWarning_dis.gif", Dashboard.class);
        }
    }

    protected void createPopups(String title) {
        this.popup = new JPopupMenu(title);
        this.popup.add(CommonTree.createMenuItem(new AbstractAction("Rename article"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BuildDataTypeTree.this.renamingDialog() != null) {
                    BuildDataTypeTree.this.updateTree();
                }
            }
        }, AC_RENAME, menuRenameIcon, menuRenameIconDis));
        this.popup.add(CommonTree.createMenuItem(new AbstractAction("Remove child"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuildDataTypeTree.this.lastTriggeredNode.removeFromParent();
                BuildDataTypeTree.this.updateTree();
            }
        }, AC_REMOVE, menuRemoveIcon, menuRemoveIconDis));
        this.popup.add(CommonTree.createMenuItem(new AbstractAction("Refresh"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuildDataTypeTree.this.updateTree();
            }
        }, AC_REFRESH, menuRefreshIcon, menuRefreshIconDis));
        this.popup.addSeparator();
        this.popup.add(CommonTree.createMenuItem(new AbstractAction("Remove all children"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuildDataTypeTree.this.nameNode.removeAllChildren();
                BuildDataTypeTree.this.updateTree();
            }
        }, AC_REMOVEALL, menuRemoveAllIcon, menuRemoveAllIconDis));
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
    }

    protected String renamingDialog() {
        String result = (String)JOptionPane.showInputDialog(null, "Rename article name.\n \nArticle names identify children\nwithin newly created data types\n \n", "Renaming article name", 2, renameIcon, null, this.lastTriggeredMember.getRelationship().getName());
        if (result != null) {
            this.lastTriggeredMember.getRelationship().setName(result);
        }
        return result;
    }

    protected void expand() {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                SwingUtils.expandTree((JTree)BuildDataTypeTree.this, (DefaultMutableTreeNode)((DefaultMutableTreeNode)BuildDataTypeTree.this.getModel().getRoot()));
                return null;
            }

            @Override
            public void finished() {
                BuildDataTypeTree.this.repaint();
            }
        };
        worker.start();
    }

    protected void updateTree() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTreeModel tModel = (DefaultTreeModel)BuildDataTypeTree.this.getModel();
                tModel.reload();
                BuildDataTypeTree.this.propertyChannel.put("dp-reg-dt-tree", BuildDataTypeTree.this.extractFromTree());
                BuildDataTypeTree.this.expand();
            }
        });
    }

    protected MobyDataType extractFromTree() {
        MobyDataType dataType = new MobyDataType();
        String name = this.nameContents.getValue();
        if (UUtils.isEmpty((String)name)) {
            return dataType;
        }
        dataType.setName(name);
        String parent = this.rootContents.getValue();
        if (UUtils.isEmpty((String)parent)) {
            return dataType;
        }
        dataType.addParentName(parent);
        Enumeration<TreeNode> en = this.nameNode.children();
        while (en.hasMoreElements()) {
            MemberNode member = (MemberNode)((DefaultMutableTreeNode)en.nextElement()).getUserObject();
            dataType.addChild(member.getRelationship());
        }
        return dataType;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getPropertyName();
        if (prop == null) {
            return;
        }
        Object obj = event.getNewValue();
        if (obj == null || !(obj instanceof String)) {
            return;
        }
        final String value = (String)obj;
        if ("dp-reg-dt-name".equals(prop)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BuildDataTypeTree.this.setMainName(value);
                }
            });
        }
    }

    class MemberNode
    extends CommonNode {
        MobyRelationship rel;

        public MemberNode(MobyRelationship rel) {
            this.rel = rel;
        }

        @Override
        public String getValue() {
            return this.rel.getDataTypeName();
        }

        public MobyRelationship getRelationship() {
            return this.rel;
        }

        @Override
        public String toString() {
            String memberName = this.rel.getName();
            String memberType = this.rel.getDataTypeName();
            int memberRel = this.rel.getRelationshipType();
            StringBuffer buf = new StringBuffer(100);
            buf.append("<html><b>");
            buf.append(memberRel == 3 ? "HAS" : "HASA");
            buf.append(": </b>");
            buf.append(memberType);
            if (UUtils.notEmpty((String)memberName)) {
                buf.append(" (<font color='blue'>");
                buf.append(memberName);
                buf.append("</font>)");
            }
            return buf.toString();
        }
    }

    class MainNode
    extends CommonNode {
        public MainNode(String value) {
            super(value);
        }

        @Override
        public String toString() {
            String value = this.getValue();
            StringBuffer buf = new StringBuffer(100);
            buf.append("<html>");
            if (UUtils.isEmpty((String)value)) {
                buf.append("<em>Data type not yet defined</em>");
            } else {
                buf.append("<b><font color='red'>");
                buf.append(value);
                buf.append("</font></b>");
            }
            return buf.toString();
        }
    }

    class ISANode
    extends CommonNode {
        ISANode() {
        }

        @Override
        public String toString() {
            String value = this.getValue();
            StringBuffer buf = new StringBuffer(100);
            buf.append("<html><b>ISA: </b>");
            if (UUtils.isEmpty((String)value)) {
                buf.append("<em>Not yet defined</em>");
            } else {
                buf.append(value);
            }
            return buf.toString();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            TreePath lastTriggeredPopup;
            int row;
            if (e.isPopupTrigger() && BuildDataTypeTree.this.popup.isEnabled() && (row = BuildDataTypeTree.this.getRowForLocation(e.getX(), e.getY())) > 1 && (lastTriggeredPopup = BuildDataTypeTree.this.getPathForLocation(e.getX(), e.getY())) != null) {
                BuildDataTypeTree.this.lastTriggeredNode = (DefaultMutableTreeNode)lastTriggeredPopup.getLastPathComponent();
                BuildDataTypeTree.this.lastTriggeredMember = (MemberNode)BuildDataTypeTree.this.lastTriggeredNode.getUserObject();
                BuildDataTypeTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class BuildTreeCellRenderer
    extends DefaultTreeCellRenderer {
        JPanel cellPanel;
        TitledBorder cellBorder;
        JLabel dataTypeName;
        JLabel articleName;

        public BuildTreeCellRenderer() {
            Border blackline = BorderFactory.createLineBorder(Color.black);
            this.cellBorder = BorderFactory.createTitledBorder(blackline, "");
            this.cellPanel = new JPanel(new GridBagLayout());
            this.cellPanel.setBorder(this.cellBorder);
            this.dataTypeName = new JLabel("");
            this.articleName = new JLabel("");
            this.articleName.setForeground(Color.blue);
            JLabel articleLabel = new JLabel("Article name: ");
            articleLabel.setFont(new Font("Dialog", 1, 8));
            SwingUtils.addComponent((JComponent)this.cellPanel, (Component)this.dataTypeName, (int)0, (int)0, (int)2, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
            SwingUtils.addComponent((JComponent)this.cellPanel, (Component)articleLabel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
            SwingUtils.addComponent((JComponent)this.cellPanel, (Component)this.articleName, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object aNode;
            this.setToolTipText("Right-click will show other options");
            if (row > 1 && (aNode = ((DefaultMutableTreeNode)value).getUserObject()) instanceof MemberNode) {
                MemberNode member = (MemberNode)aNode;
                MobyRelationship rel = member.getRelationship();
                this.cellBorder.setTitle(MobyRelationship.type2str((int)rel.getRelationshipType()));
                this.dataTypeName.setText(member.getValue());
                this.articleName.setText(rel.getName());
                if (rel.getRelationshipType() == 2) {
                    this.cellPanel.setBackground(new Color(255, 255, 204));
                } else {
                    this.cellPanel.setBackground(new Color(204, 255, 204));
                }
                return this.cellPanel;
            }
            return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }
}

