/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.ExitException;
import org.apache.tools.ant.NoBannerLogger;
import org.biomoby.service.dashboard.AbstractModel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.service.dashboard.SimpleAnt;
import org.biomoby.shared.MobyException;
import org.tulsoft.shared.UUtils;

public class AntModel
extends AbstractModel {
    private static Log log = LogFactory.getLog(AntModel.class);
    public static final int MSG_QUIET = 100;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    protected RegistryModel registryModel;
    protected OutputStream outputStream = null;
    protected OutputStream errorStream = null;
    protected int msgOutputLevel = -1;

    public AntModel() {
    }

    public AntModel(RegistryModel registryModel) {
        this.registryModel = registryModel;
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public void setErrorStream(OutputStream os) {
        this.errorStream = os;
    }

    public void setMsgOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    public static File createFileName(String[] parts) {
        if (parts == null || parts.length == 0) {
            return new File(System.getProperty("user.dir"));
        }
        File f = new File(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            f = new File(f, parts[i]);
        }
        return f;
    }

    public void mosesDatatypes() throws MobyException {
        boolean toGenerate = this.propertyChannel.getBoolean("use-dt-gen", true);
        boolean toCompile = this.propertyChannel.getBoolean("use-dt-comp", true);
        boolean toJavadoc = this.propertyChannel.getBoolean("use-dt-doc", true);
        boolean toJar = this.propertyChannel.getBoolean("use-dt-jar", true);
        Properties props = new Properties();
        this.addRegistryProps(props);
        this.addGeneratorProps(props);
        Vector<String> v = new Vector<String>();
        if (toGenerate && toCompile && toJavadoc && toJar) {
            v.addElement("moses-datatypes");
        } else {
            if (toGenerate) {
                v.addElement("generate-datatypes");
            }
            if (toJavadoc) {
                v.addElement("moses-docs");
            }
            if (toJar) {
                v.addElement("jar-datatypes");
            }
            if (toCompile && !toJavadoc && !toJar) {
                v.addElement("moses-compile");
            }
        }
        Object[] targets = new String[v.size()];
        v.copyInto(targets);
        this.runAnt((String[])targets, props);
    }

    public void mosesCleanDatatypes() throws MobyException {
        this.runAnt(new String[]{"clean-datatypes"}, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mosesSkeletons() throws MobyException {
        File f = AntModel.createFileName(new String[]{System.getProperty("user.dir"), "build", "others", "datatypes", "org", "biomoby", "shared", "datatypes", "MapDataTypes.class"});
        if (!f.exists()) {
            boolean origToGenerate = this.propertyChannel.getBoolean("use-dt-gen", true);
            boolean origToCompile = this.propertyChannel.getBoolean("use-dt-comp", true);
            boolean origToJavadoc = this.propertyChannel.getBoolean("use-dt-doc", true);
            boolean origToJar = this.propertyChannel.getBoolean("use-dt-jar", true);
            try {
                this.propertyChannel.put("use-dt-gen", Boolean.TRUE.toString());
                this.propertyChannel.put("use-dt-comp", Boolean.TRUE.toString());
                this.propertyChannel.put("use-dt-doc", Boolean.FALSE.toString());
                this.propertyChannel.put("use-dt-jar", Boolean.FALSE.toString());
                this.mosesDatatypes();
            }
            finally {
                this.propertyChannel.put("use-dt-gen", new Boolean(origToGenerate).toString());
                this.propertyChannel.put("use-dt-comp", new Boolean(origToCompile).toString());
                this.propertyChannel.put("use-dt-doc", new Boolean(origToJavadoc).toString());
                this.propertyChannel.put("use-dt-jar", new Boolean(origToJar).toString());
            }
        }
        Properties props = new Properties();
        this.addRegistryProps(props);
        this.addGeneratorProps(props);
        this.filterAndRun(props, "selectedAuthorities", "moses.authority");
        props.remove("moses.authority");
        this.filterAndRun(props, "selectedServices", "moses.service");
        props.remove("moses.service");
    }

    public void mosesDeploy() throws MobyException {
        Properties props = new Properties();
        this.addDeploymentProps(props);
        this.add(props, "users.lib.dir", "dirWithUserJars");
        this.add(props, "wsdd.template", "wsddTemplate");
        if (this.propertyChannel.getBoolean("use-local-deploy", true)) {
            this.runAnt(new String[]{"deploy-services"}, props);
        } else {
            this.runAnt(new String[]{"deploy-remote"}, props);
        }
    }

    public void mosesUndeploy() throws MobyException {
        Properties props = new Properties();
        this.addDeploymentProps(props);
        if (this.propertyChannel.getBoolean("use-local-deploy", true)) {
            this.runAnt(new String[]{"undeploy-services"}, props);
        }
    }

    private void filterAndRun(Properties props, String channelNameForFilter, String antNameForFilter) throws MobyException {
        boolean toGenerate = this.propertyChannel.getBoolean("use-s-gen", true);
        boolean toCompile = this.propertyChannel.getBoolean("use-s-comp", true);
        boolean toJavadoc = this.propertyChannel.getBoolean("use-s-doc", true);
        boolean toJar = this.propertyChannel.getBoolean("use-s-jar", true);
        Vector x = (Vector)this.propertyChannel.get(channelNameForFilter);
        if (x == null || x.size() == 0) {
            return;
        }
        boolean specialCase = x.size() == 1;
        String authority = null;
        StringBuffer buf = new StringBuffer();
        Enumeration en = x.elements();
        while (en.hasMoreElements()) {
            String value;
            String[] parts;
            if (buf.length() > 0) {
                buf.append("|");
            }
            if ((parts = (value = (String)en.nextElement()).split("/", 2)).length > 1 && specialCase) {
                authority = parts[1];
            }
            buf.append("^");
            buf.append(parts[0]);
            buf.append("$");
        }
        if (authority == null) {
            this.add2(props, antNameForFilter, new String(buf));
        } else {
            this.add2(props, antNameForFilter, new String(buf));
            this.add2(props, "moses.authority", authority);
        }
        Vector<String> v = new Vector<String>();
        if (toGenerate && toCompile && toJavadoc && toJar) {
            v.addElement("moses-services");
        } else {
            if (toGenerate) {
                v.addElement("generate-services");
            }
            if (toJavadoc) {
                v.addElement("moses-docs");
            }
            if (toJar) {
                v.addElement("jar-services");
            }
            if (toCompile && !toJavadoc && !toJar) {
                v.addElement("moses-compile");
            }
        }
        Object[] targets = new String[v.size()];
        v.copyInto(targets);
        this.runAnt((String[])targets, props);
    }

    public void mosesCleanSkeletons() throws MobyException {
        this.runAnt(new String[]{"clean-services"}, new Properties());
    }

    public void mosesAll() throws MobyException {
    }

    protected void runAnt(String[] targets, Properties props) throws MobyException {
        if (targets.length == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ready to go targets: " + StringUtils.join((Object[])targets, (String)",")));
        }
        try {
            SimpleAnt ant = new SimpleAnt();
            NoBannerLogger logger = new NoBannerLogger();
            if (this.outputStream != null) {
                logger.setOutputPrintStream(new PrintStream(this.outputStream));
            }
            if (this.errorStream != null) {
                logger.setErrorPrintStream(new PrintStream(this.errorStream));
            }
            if (this.msgOutputLevel > -1 && this.msgOutputLevel != 100) {
                ant.setMsgOutputLevel(this.msgOutputLevel);
            }
            ant.addBuildListener((BuildListener)logger);
            ant.startAnt(targets, props);
        }
        catch (ExitException e) {
            log.warn((Object)("Ant tried to use System.exit() with exit code " + e.getStatus()));
        }
        catch (BuildException e) {
            throw new MobyException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)("Error: " + e.toString()));
            throw new MobyException(e.getMessage(), (Throwable)e);
        }
    }

    protected void addRegistryProps(Properties props) {
        this.add(props, "default.endpoint", "dp-registry-endpoint");
        this.add(props, "default.namespace", "dp-registry-namespace");
        if (this.propertyChannel.getBoolean("dp-use-cache", true)) {
            this.add(props, "registry.cache.dir", "dp-cache-dir");
        }
    }

    protected void addGeneratorProps(Properties props) {
        if (this.msgOutputLevel == 100) {
            this.add(props, "moses.quiet", true);
        }
        this.add(props, "moses.nogener", this.propertyChannel.getBoolean("use-simulate", false));
        if (!this.propertyChannel.getBoolean("use-dot", true)) {
            this.add(props, "moses.nographs", true);
        }
        this.add(props, "dot.location", "dotLocation");
    }

    protected void addDeploymentProps(Properties props) {
        this.add(props, "catalina.home", "tomcatHome");
        this.add(props, "axis.relative.path", "axisInTomcat");
        this.add(props, "tomcat.host", "tomcatHostname");
        this.add(props, "tomcat.port", "tomcatPort");
        this.add(props, "axis.admin.url", "axisAdminURLPath");
        this.add(props, "tomcat.webapps", "deployInTomcat");
        Map services = (Map)this.propertyChannel.get("servicesToDeploy");
        if (services == null) {
            return;
        }
        for (Map.Entry entry : services.entrySet()) {
            String serviceName = (String)entry.getKey();
            String className = (String)entry.getValue();
            props.put("service." + serviceName, className);
        }
    }

    private void add(Properties props, String antPropName, String channelPropName) {
        String value = (String)this.propertyChannel.get(channelPropName);
        if (UUtils.notEmpty((String)value)) {
            props.put(antPropName, value);
            if (log.isDebugEnabled()) {
                log.debug((Object)(antPropName + " => " + value));
            }
        }
    }

    private void add2(Properties props, String antPropName, String value) {
        if (UUtils.notEmpty((String)value)) {
            props.put(antPropName, value);
            if (log.isDebugEnabled()) {
                log.debug((Object)(antPropName + " => " + value));
            }
        }
    }

    private void add(Properties props, String antPropName, boolean value) {
        props.put(antPropName, new Boolean(value).toString());
        if (log.isDebugEnabled()) {
            log.debug((Object)(antPropName + " => " + value));
        }
    }
}

