/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.service.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.biomoby.service.dashboard.Dashboard;
import org.biomoby.service.dashboard.DashboardPanel;
import org.biomoby.service.dashboard.DashboardProperties;
import org.biomoby.service.dashboard.PropertyChannel;
import org.biomoby.service.dashboard.RegistryModel;
import org.biomoby.shared.Utils;
import org.tulsoft.shared.PrefsUtils;
import org.tulsoft.tools.gui.JFileChooserWithHistory;
import org.tulsoft.tools.gui.JTextFieldWithHistory;
import org.tulsoft.tools.gui.SwingUtils;

public abstract class AbstractPanel
extends JPanel
implements DashboardPanel,
DashboardProperties {
    protected static final int RELATIVE = -1;
    protected static final int REMAINDER = 0;
    protected static final int NONE = 0;
    protected static final int BOTH = 1;
    protected static final int HORI = 2;
    protected static final int VERT = 3;
    protected static final int CENTER = 10;
    protected static final int NORTH = 11;
    protected static final int NEAST = 12;
    protected static final int EAST = 13;
    protected static final int SEAST = 14;
    protected static final int SOUTH = 15;
    protected static final int SWEST = 16;
    protected static final int WEST = 17;
    protected static final int NWEST = 18;
    protected String panelIconFileName;
    protected Icon panelIcon;
    protected JComponent pComponent;
    public static Icon confirmIcon;
    public static Icon warningIcon;
    public static Icon clearIcon;
    protected static final Insets BREATH_TOP;
    protected static final Insets BREATH_TOP_LEFT;
    protected static final Insets BREATH_LEFT;
    protected static final Font MSG_AREA_FONT;
    protected static final Font TITLE_FONT;
    protected static final Font FAT_BORDER_FONT;
    protected static final Color TITLE_FGCOLOR;
    protected PropertyChannel propertyChannel;
    private static final String MRVAJS = "#MRVAJS#";

    protected AbstractPanel() {
        this.loadIcons();
    }

    @Override
    public String getHelp() {
        String panelClassName = Utils.simpleClassName((String)this.getClass().getName());
        String help = null;
        try {
            help = Utils.readResource((String)("help" + File.separator + panelClassName + ".html"), this.getClass());
            if (help != null) {
                return help;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        help = this.getDescription();
        if (help != null) {
            return help;
        }
        return "";
    }

    @Override
    public URL getHelpURL() {
        String panelClassName = Utils.simpleClassName((String)this.getClass().getName());
        return Utils.getResourceURL((String)("help" + File.separator + panelClassName + ".html"), this.getClass());
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public Icon getIcon() {
        if (this.panelIcon == null && this.panelIconFileName != null) {
            this.panelIcon = SwingUtils.createIcon((String)this.panelIconFileName, (Object)this);
        }
        return this.panelIcon;
    }

    @Override
    public URL getIconURL() {
        return Utils.getResourceURL((String)this.panelIconFileName, this.getClass());
    }

    @Override
    public JLabel getTitle() {
        JLabel title = new JLabel(this.getName(), this.getIcon(), 0);
        title.setFont(TITLE_FONT);
        title.setForeground(TITLE_FGCOLOR);
        return title;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public boolean loadOnlyOnDemand() {
        return false;
    }

    protected void setPropertyChannel(PropertyChannel propertyChannel) {
        this.propertyChannel = propertyChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RegistryModel createRegistryModel() {
        PropertyChannel propertyChannel = this.propertyChannel;
        synchronized (propertyChannel) {
            RegistryModel rm;
            if (this.propertyChannel.containsKey("dp-registry-model")) {
                rm = (RegistryModel)this.propertyChannel.get("dp-registry-model");
            } else {
                rm = new RegistryModel();
                this.propertyChannel.put("dp-registry-model", rm);
            }
            rm.setPropertyChannel(this.propertyChannel);
            return rm;
        }
    }

    @Override
    public abstract JComponent getComponent(PropertyChannel var1);

    @Override
    public abstract String getName();

    protected void loadIcons() {
        if (clearIcon == null) {
            clearIcon = AbstractPanel.loadIcon("images/smallClear.gif");
        }
        if (warningIcon == null) {
            warningIcon = AbstractPanel.loadIcon("images/warningButton.gif");
        }
        if (confirmIcon == null) {
            confirmIcon = AbstractPanel.loadIcon("images/confirmButton.gif");
        }
    }

    public static Icon loadIcon(String path) {
        return SwingUtils.createIcon((String)path, Dashboard.class);
    }

    protected static void commonButtonLookAndFeel(AbstractButton but) {
        but.setFocusPainted(false);
    }

    protected static JButton createButton(String name, String toolTipText, int mnemonic, ActionListener listener) {
        JButton button = new JButton(name);
        AbstractPanel.commonButtonLookAndFeel(button);
        button.setToolTipText(toolTipText);
        if (mnemonic > 0) {
            button.setMnemonic(mnemonic);
        }
        button.addActionListener(listener);
        return button;
    }

    protected static JCheckBox createCheckBox(String label, boolean isSelected, int mnemonic, ItemListener listener) {
        JCheckBox box = new JCheckBox(label, isSelected);
        if (mnemonic > 0) {
            box.setMnemonic(mnemonic);
        }
        if (listener != null) {
            box.addItemListener(listener);
        }
        box.setFocusPainted(false);
        return box;
    }

    protected static JPanel createButtonPanel(JButton[] buttons) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 10));
        buttonPanel.add(Box.createHorizontalGlue());
        for (int i = 0; i < buttons.length; ++i) {
            buttonPanel.add(buttons[i]);
        }
        return buttonPanel;
    }

    protected static JPanel createTitledPanel(String title) {
        JPanel titledPanel = new JPanel(new GridBagLayout());
        Border blackline = BorderFactory.createLineBorder(Color.black);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(blackline, title), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        titledPanel.setBorder(compoundBorder);
        return titledPanel;
    }

    protected static Border createFatBorder(String title, Color color) {
        Border colorline = BorderFactory.createLineBorder(color, 3);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(colorline, title);
        titledBorder.setTitleJustification(2);
        titledBorder.setTitleFont(FAT_BORDER_FONT);
        return BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    protected JFileChooserWithHistory createFileSelector(String chooserTitle, String approveButtonText, String defaultValue, String preferenceNode, String eventName) {
        JFileChooserWithHistory chooser = new JFileChooserWithHistory(null, (Object)this, preferenceNode);
        JFileChooser ch = chooser.getFileChooser();
        ch.setApproveButtonText(approveButtonText);
        ch.setDialogTitle(chooserTitle);
        if (StringUtils.isNotBlank((String)defaultValue) && chooser.getSelectedFile() == null) {
            chooser.setSelectedFile(new File(defaultValue));
        }
        if (eventName != null) {
            JTextFieldWithHistory textField = chooser.getTextField();
            textField.addActionListener(this.getTextFieldListener(eventName));
            String text = textField.getText();
            if (StringUtils.isNotBlank((String)text)) {
                this.propertyChannel.put(eventName, text);
            }
        }
        return chooser;
    }

    protected JTextFieldWithHistory createText(String initValue, String preferenceNode, String eventName) {
        JTextFieldWithHistory textField = new JTextFieldWithHistory(initValue, (Object)this, preferenceNode);
        if (eventName != null) {
            textField.addActionListener(this.getTextFieldListener(eventName));
            String text = textField.getText();
            if (StringUtils.isNotBlank((String)text)) {
                this.propertyChannel.put(eventName, text);
            }
        }
        return textField;
    }

    private ActionListener getTextFieldListener(String eventName) {
        final String name = eventName;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String contents = ((JTextFieldWithHistory)e.getSource()).getText();
                AbstractPanel.this.propertyChannel.put(name, contents == null ? "" : contents);
            }
        };
    }

    protected JPanel createCustomTextArea(String title, String initValue, String preferenceKey, String eventName) {
        return this.createCustomTextArea(title, initValue, preferenceKey, eventName, new JTextArea());
    }

    protected JPanel createCustomTextArea(String title, String initValue, String preferenceKey, String eventName, JTextArea myArea) {
        JPanel p = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(title);
        final JTextArea area = myArea;
        area.setEditable(true);
        if (initValue == null) {
            area.setText(preferenceKey == null ? "" : this.getPrefValue(preferenceKey, ""));
        } else {
            area.setText(initValue);
        }
        area.setCaretPosition(0);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        if (eventName != null) {
            final String eName = eventName;
            if (preferenceKey == null) {
                area.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        String contents = ((JTextArea)e.getSource()).getText();
                        AbstractPanel.this.propertyChannel.put(eName, contents);
                    }
                });
            } else {
                final String pKey = preferenceKey;
                area.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        String contents = ((JTextArea)e.getSource()).getText();
                        AbstractPanel.this.propertyChannel.put(eName, contents);
                        AbstractPanel.this.setPrefValue(pKey, contents);
                    }
                });
            }
            String text = area.getText();
            if (StringUtils.isNotBlank((String)text)) {
                this.propertyChannel.put(eventName, text);
            }
        }
        JButton clearButton = new JButton(clearIcon);
        clearButton.setFocusPainted(false);
        clearButton.setMargin(new Insets(0, 0, 0, 0));
        clearButton.setContentAreaFilled(false);
        clearButton.setToolTipText("Clear " + title.toLowerCase() + " text area");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.requestFocusInWindow();
                area.setText("");
            }
        });
        SwingUtils.addComponent((JComponent)p, (Component)label, (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)clearButton, (int)1, (int)0, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)new JScrollPane(area), (int)0, (int)1, (int)2, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        return p;
    }

    public static JMenuItem createMenuItem(AbstractAction action, String actionCommand) {
        JMenuItem mi = new JMenuItem(action);
        mi.setActionCommand(actionCommand);
        return mi;
    }

    public static JMenuItem createMenuItem(AbstractAction action, String actionCommand, int mnemonic, Icon icon, Icon disabledIcon) {
        JMenuItem mi = AbstractPanel.createMenuItem(action, actionCommand);
        mi.setIcon(icon);
        mi.setDisabledIcon(disabledIcon);
        if (mnemonic > 0) {
            mi.setMnemonic(mnemonic);
        }
        return mi;
    }

    public static JMenu createMenu(String name, int mnemonic, Icon icon, Icon disabledIcon) {
        JMenu m = new JMenu(name);
        m.setIcon(icon);
        m.setDisabledIcon(disabledIcon);
        if (mnemonic > 0) {
            m.setMnemonic(mnemonic);
        }
        return m;
    }

    public static void setEnabledMenuItem(Container container, String actionCommand, boolean enabled) {
        Component[] components = container instanceof JMenu ? ((JMenu)container).getMenuComponents() : container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof JMenu) {
                AbstractPanel.setEnabledMenuItem((JMenu)components[i], actionCommand, enabled);
                continue;
            }
            if (!(components[i] instanceof JMenuItem) || !actionCommand.equals(((JMenuItem)components[i]).getActionCommand())) continue;
            ((JMenuItem)components[i]).setEnabled(enabled);
            return;
        }
    }

    protected JSplitPane hSplit(Component a, Component b, double weight) {
        JSplitPane split = new JSplitPane(1, a, b);
        split.setResizeWeight(weight);
        split.setDividerLocation(weight);
        split.setContinuousLayout(true);
        split.setOneTouchExpandable(true);
        return split;
    }

    protected JSplitPane vSplit(Component a, Component b, double weight) {
        JSplitPane split = new JSplitPane(0, a, b);
        split.setResizeWeight(weight);
        split.setDividerLocation(weight);
        split.setContinuousLayout(true);
        split.setOneTouchExpandable(true);
        return split;
    }

    protected String getPrefValue(String key, String defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        Preferences node = PrefsUtils.getNode(this.getClass());
        return AbstractPanel.showNewlines(node.get(key, defaultValue));
    }

    protected boolean getPrefValue(String key, boolean defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        Preferences node = PrefsUtils.getNode(this.getClass());
        return node.getBoolean(key, defaultValue);
    }

    protected void setPrefValue(String key, String value) {
        if (key != null) {
            Preferences node = PrefsUtils.getNode(this.getClass());
            node.put(key, AbstractPanel.hideNewlines(value));
        }
    }

    protected void setPrefValue(String key, boolean value) {
        if (key != null) {
            Preferences node = PrefsUtils.getNode(this.getClass());
            node.putBoolean(key, value);
        }
    }

    private static String hideNewlines(String value) {
        return value.replaceAll("\n", MRVAJS);
    }

    private static String showNewlines(String value) {
        return value.replaceAll(MRVAJS, "\n");
    }

    public static boolean confirm(Object msg) {
        return SwingUtils.confirm(null, (Object)msg, (Icon)confirmIcon);
    }

    public static boolean confirm(Component parent, Object msg) {
        return SwingUtils.confirm((Component)parent, (Object)msg, (Icon)confirmIcon);
    }

    public static void error(Object msg) {
        JOptionPane.showMessageDialog(null, msg, "Error message", -1, warningIcon);
    }

    public static void error(String prologue, Exception e) {
        if (!(prologue = prologue + "The actual error is:\n\n").startsWith("<html")) {
            prologue = "<html>" + prologue + "</html>";
            prologue = prologue.replaceAll("\n", "<br>\n");
        }
        String msg = e.getMessage();
        JTextArea area = new JTextArea(15, 50);
        area.setEditable(false);
        area.setFont(MSG_AREA_FONT);
        area.setText(msg);
        area.setCaretPosition(0);
        JPanel p = new JPanel(new GridBagLayout());
        SwingUtils.addComponent((JComponent)p, (Component)new JLabel(prologue), (int)0, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        SwingUtils.addComponent((JComponent)p, (Component)new JScrollPane(area), (int)0, (int)1, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        AbstractPanel.error(p);
    }

    protected static FileFilter getXMLFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = FilenameUtils.getExtension((String)f.getName());
                return "xml".equalsIgnoreCase(extension);
            }

            @Override
            public String getDescription() {
                return "XML files";
            }
        };
    }

    static {
        BREATH_TOP = new Insets(10, 0, 0, 0);
        BREATH_TOP_LEFT = new Insets(10, 10, 0, 0);
        BREATH_LEFT = new Insets(0, 10, 0, 0);
        MSG_AREA_FONT = new Font("Courier", 0, 10);
        TITLE_FONT = new Font("Serif", 1, 20);
        FAT_BORDER_FONT = new Font("Serif", 1, 16);
        TITLE_FGCOLOR = new Color(12, 55, 241);
    }
}

