/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.registry.rdfagent.util;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.JenaException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.biomoby.registry.rdfagent.util.CentralDataAccessImpl;
import org.biomoby.registry.rdfagent.util.Constants;
import org.biomoby.registry.rdfagent.util.Log;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.extended.ServiceInstanceParser;

public class SignatureURLConnection {
    private String newline = System.getProperty("line.separator");
    private Map badURLs = new HashMap();
    private Vector invalidServicesFound = new Vector();

    public Model getRdfFromURL(String url) {
        Log.info("Trying to retrieve the RDF document located at " + url);
        Model model = ModelFactory.createDefaultModel();
        HttpURLConnection urlConnection = null;
        int code = -1;
        try {
            Log.info("Opening a connection to the url");
            urlConnection = (HttpURLConnection)new URL(url).openConnection();
            urlConnection.setRequestProperty("User-Agent", "RDFAgent/1.0");
            urlConnection.setDefaultUseCaches(false);
            urlConnection.setUseCaches(false);
        }
        catch (MalformedURLException e) {
            Log.exception(this.getClass().getName(), "getRdfFromURL(String)", e);
            Log.severe("Malformed url: " + url);
            code = 404;
        }
        catch (IOException e) {
            Log.exception(this.getClass().getName(), "getRdfFromURL(String)", e);
            Log.severe("IO Exception on the following url: " + url + ". Please ensure that you have an internet connection.");
            code = 404;
        }
        if (urlConnection != null) {
            try {
                code = urlConnection.getResponseCode();
                Log.info("Obtained response code " + code);
            }
            catch (IOException e) {
                Log.exception(this.getClass().getName(), "getRdfFromURL(String)", e);
            }
            if (code == 200 || code == 202) {
                try {
                    Log.info("reading from the url");
                    Connector c = new Connector();
                    c.setModel(model);
                    c.setConnection(urlConnection);
                    c.start();
                    long endTime = System.currentTimeMillis() + 60000L;
                    while (c.isAlive()) {
                        if (System.currentTimeMillis() > endTime) {
                            Log.severe("The URL, " + url + ", timed out while trying to read the RDF." + this.newline + "Please ensure that you have an internet connection and that the remote location is readable.");
                            if (!c.isAlive()) break;
                            code = 404;
                            ModelFactory.createDefaultModel();
                            c.interrupt();
                            break;
                        }
                        try {
                            Thread.sleep(4000L);
                        }
                        catch (InterruptedException ie) {}
                    }
                    code = c.getCode();
                    model = c.getModel();
                    if (code == 200 || code == 202) {
                        Log.info("Closing the url connection.");
                        Log.info("Got an RDF model.");
                        return model;
                    }
                }
                catch (JenaException e) {
                    Log.exception(this.getClass().getName(), "getRdfFromURL(String)", e);
                    Log.severe("Couldn't parse the RDF document located at: " + url + "." + this.newline + "This document is invalid.");
                    code = 415;
                }
            }
        }
        this.performURLErrorHandling(url, code);
        return model;
    }

    public MobyService[] extractServicesFromURL(String url) {
        Log.info("Loading the RDF model.");
        Model m = this.getRdfFromURL(url);
        Log.info("Loaded the RDF model.");
        if (m != null && !m.isEmpty()) {
            ServiceInstanceParser parser = null;
            try {
                parser = new ServiceInstanceParser(url);
            }
            catch (MobyException e) {
                Log.exception(this.getClass().getName(), "extractServicesFromURL(String)", e);
                Log.severe(e.getLocalizedMessage());
                this.performURLErrorHandling(url, 400);
                return new MobyService[0];
            }
            Log.info("Parsing services from the model.");
            MobyService[] services = null;
            try {
                services = parser.getMobyServicesFromRDF(m);
            }
            catch (MobyException e) {
                Log.exception(this.getClass().getName(), "extractServicesFromURL(String)", e);
                Log.severe("There was something wrong with the model: " + this.newline + e.getLocalizedMessage());
                this.performURLErrorHandling(url, 501);
                return new MobyService[0];
            }
            Log.info("Parsing complete.");
            if (parser.isRDFValid()) {
                if (services.length == 0) {
                    this.performURLErrorHandling(url, 501);
                    return services;
                }
                if (services != null) {
                    this.removeFromHitlist(url);
                    return services;
                }
            } else {
                Log.info("RDF contained some invalid services.");
                String errors = parser.getErrors();
                String[] badServices = errors.split(this.newline);
                HashMap<String, String> duplicates = new HashMap<String, String>();
                for (int i = 0; i < badServices.length; ++i) {
                    String[] contents;
                    String line;
                    StringTokenizer st = new StringTokenizer(badServices[i], "{");
                    String string = line = st.hasMoreTokens() ? st.nextToken() : null;
                    if (line == null || duplicates.containsKey(line) || (contents = line.split(",")) == null || contents.length != 2) continue;
                    duplicates.put(line, "");
                    MobyService s = new MobyService(contents[0]);
                    s.setAuthority(contents[1]);
                    this.invalidServicesFound.add(s);
                }
                if (services.length == 0) {
                    this.performURLErrorHandling(url, 501);
                    return services;
                }
                if (services != null) {
                    this.removeFromHitlist(url);
                    return services;
                }
            }
        }
        return new MobyService[0];
    }

    private void removeFromHitlist(String url) {
        if (Constants.REGISTRY_ENABLE_DEREGISTER) {
            CentralDataAccessImpl central = null;
            try {
                central = new CentralDataAccessImpl();
                int count = central.getErrorCountForURL(url);
                if (count != 0) {
                    Log.info("Attempting to remove " + url + " from the 'hit list'.");
                    if (central.deleteErrorCountForURL(url)) {
                        Log.info("Removal success!");
                    } else {
                        Log.info("Removal failed.");
                    }
                }
                if (central != null) {
                    central.cleanup();
                }
            }
            catch (MobyException e) {
                Log.exception(this.getClass().getName(), "getRdfFromURL(String)", e);
                Log.severe(e.getLocalizedMessage());
            }
        }
    }

    private void performURLErrorHandling(String url, int code) {
        if (code == 400) {
            Log.warning("The request could not be understood by the server due to malformed syntax. The client SHOULD NOT repeat the request without modifications.");
        } else if (code == 401) {
            Log.warning("The request requires user authentication.");
        } else if (code == 402) {
            Log.warning("The request requires payment. The agent is unwilling to pay while it scavenges!");
        } else if (code == 403) {
            Log.warning("The server understood the request, but is refusing to fulfill it. Authorization will not help and the request SHOULD NOT be repeated.");
        } else if (code == 404) {
            Log.warning("The server has not found anything matching the Request-URI.");
        } else if (code != 415) {
            if (code == 417) {
                Log.warning("The agent had connection problems with the data store.");
            } else if (code == 500) {
                Log.warning("The server encountered an unexpected condition which prevented it from fulfilling the request.");
            } else if (code == 501) {
                Log.warning("The agent encountered problems parsing the RDF document into valid services.");
            } else if (code == 502) {
                Log.warning("The agent encountered an invalid service in the registry.");
            } else {
                Log.warning("Error retrieving the RDF at " + url + ". The HTTP response code given was: " + code + ".");
            }
        }
        if (Constants.REGISTRY_ENABLE_DEREGISTER) {
            CentralDataAccessImpl central = null;
            try {
                central = new CentralDataAccessImpl();
                int count = central.getErrorCountForURL(url);
                if (count == 0) {
                    if (central.insertErrorCountForURL(url, code)) {
                        Log.info("Error count for " + url + " was inserted! The count is 1.");
                    } else {
                        Log.warning("Error count for " + url + " was not inserted! Make sure that the DB parameters are correct!");
                    }
                } else if (++count >= Constants.REGISTRY_DEREGISTER_COUNT) {
                    central.deleteErrorCountForURL(url);
                } else {
                    central.incrementErrorCountForURL(url, code);
                }
                this.badURLs.put(url, new Integer(count));
            }
            catch (MobyException e) {
                Log.exception(this.getClass().getName(), "perfromURLErrorHandling(String, int)", e);
                Log.severe(e.getLocalizedMessage());
            }
            if (central != null) {
                central.cleanup();
            }
        } else {
            this.badURLs.put(url, new Integer(0));
        }
    }

    public Map getBadUrlMap() {
        return this.badURLs;
    }

    public Vector getInvalidServicesFoundInRDF() {
        return this.invalidServicesFound;
    }

    private class Connector
    extends Thread {
        private Model model = null;
        private HttpURLConnection con = null;
        private int code = -1;

        private Connector() {
        }

        @Override
        public void run() {
            try {
                this.model.read(this.con.getInputStream(), "");
                this.code = this.con.getResponseCode();
                this.con.disconnect();
            }
            catch (Exception e) {
                Log.exception(this.getClass().getName(), "getRdfFromURL(String)", e);
                Log.severe("IO Exception on the url " + this.con.getURL().toExternalForm() + " while trying to read the RDF." + SignatureURLConnection.this.newline + "Please ensure that you have an internet connection.");
                this.code = 404;
            }
        }

        public int getCode() {
            return this.code;
        }

        public void setConnection(HttpURLConnection c) {
            this.con = c;
        }

        public void setModel(Model m) {
            this.model = m;
        }

        public Model getModel() {
            return this.model;
        }
    }
}

