/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.rdf.util;

import java.util.Enumeration;
import org.w3c.rdf.model.Model;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.SetModel;
import org.w3c.rdf.model.Statement;

public class SetOperations {
    public static void copy(Model model, Model model2) throws ModelException {
        SetOperations.subtract(model2, model2);
        SetOperations.unite(model2, model);
    }

    public static Model difference(Model model, Model model2) throws ModelException {
        Model model3 = model.duplicate();
        SetOperations.subtract(model3, model2);
        return model3;
    }

    public static void intersect(Model model, Model model2) throws ModelException {
        if (model instanceof SetModel) {
            ((SetModel)model).intersect(model2);
        } else {
            Model model3 = model2;
            synchronized (model3) {
                Model model4 = model.duplicate();
                Enumeration enumeration = model4.elements();
                while (enumeration.hasMoreElements()) {
                    Statement statement = (Statement)enumeration.nextElement();
                    if (model2.contains(statement)) continue;
                    model.remove(statement);
                }
            }
        }
    }

    public static Model intersection(Model model, Model model2) throws ModelException {
        Model model3 = model.duplicate();
        SetOperations.intersect(model3, model2);
        return model3;
    }

    public static void subtract(Model model, Model model2) throws ModelException {
        if (model instanceof SetModel) {
            ((SetModel)model).subtract(model2);
        } else {
            Model model3 = model2;
            synchronized (model3) {
                Enumeration enumeration = model2.elements();
                while (enumeration.hasMoreElements()) {
                    model.remove((Statement)enumeration.nextElement());
                }
            }
        }
    }

    public static Model union(Model model, Model model2) throws ModelException {
        Model model3 = model.duplicate();
        SetOperations.unite(model3, model2);
        return model3;
    }

    public static void unite(Model model, Model model2) throws ModelException {
        if (model instanceof SetModel) {
            ((SetModel)model).unite(model2);
        } else {
            Model model3 = model2;
            synchronized (model3) {
                Enumeration enumeration = model2.elements();
                while (enumeration.hasMoreElements()) {
                    model.add((Statement)enumeration.nextElement());
                }
            }
        }
    }
}

