/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.rdf.schema;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.w3c.rdf.model.Model;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;
import org.w3c.rdf.vocabulary.rdf_schema_19990303.RDFS;
import org.w3c.rdf.vocabulary.rdf_syntax_19990222.RDF;

public class RDFSchemaModelEnumeration
implements Enumeration {
    Model instances;
    Model schema;
    Enumeration statements;
    Enumeration derived;
    Hashtable derivedList;
    Statement current;

    public RDFSchemaModelEnumeration(Model model, Model model2) throws ModelException {
        this.instances = model;
        this.schema = model2;
        this.statements = model.elements();
        this.derivedList = new Hashtable();
        this.derived = this.derivedList.elements();
        this.current = null;
    }

    private void fetchNext() throws ModelException {
        Statement statement = (Statement)this.statements.nextElement();
        this.derivedList.clear();
        if (RDF.type.equals(statement.predicate())) {
            Model model = this.schema.find((Resource)statement.object(), RDFS.subClassOf, null);
            if (!model.isEmpty()) {
                Enumeration enumeration = model.elements();
                while (enumeration.hasMoreElements()) {
                    Statement statement2 = this.instances.getNodeFactory().createStatement(statement.subject(), RDF.type, ((Statement)enumeration.nextElement()).object());
                    this.derivedList.put(statement2, statement2);
                }
            }
        } else {
            Model model = this.schema.find(statement.predicate(), RDFS.subPropertyOf, null);
            if (!model.isEmpty()) {
                Enumeration enumeration = model.elements();
                while (enumeration.hasMoreElements()) {
                    Statement statement3 = this.instances.getNodeFactory().createStatement(statement.subject(), (Resource)((Statement)enumeration.nextElement()).object(), statement.object());
                    this.derivedList.put(statement3, statement3);
                }
            }
        }
        this.derived = this.derivedList.elements();
        this.current = statement;
    }

    public boolean hasMoreElements() {
        if (this.current != null || this.derived.hasMoreElements()) {
            return true;
        }
        try {
            if (this.statements.hasMoreElements()) {
                this.fetchNext();
                return true;
            }
        }
        catch (ModelException modelException) {}
        return false;
    }

    public Object nextElement() {
        if (this.current != null) {
            Statement statement = this.current;
            this.current = null;
            return statement;
        }
        if (this.derived.hasMoreElements()) {
            return this.derived.nextElement();
        }
        throw new NoSuchElementException("RDFSchemaModelEnumeration");
    }
}

