/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.rdf.model.i;

import edu.stanford.db.rdf.model.i.LiteralImpl;
import edu.stanford.db.rdf.model.i.ResourceImpl;
import edu.stanford.db.rdf.model.i.StatementImpl;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.w3c.rdf.model.Literal;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.NodeFactory;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;

public class NodeFactoryImpl
implements NodeFactory {
    Map rmap = new WeakHashMap();
    Map lmap = new WeakHashMap();
    int lastNodeID;
    static String uniquePrefix = "uri:rdf:" + System.currentTimeMillis() + "-";

    public Literal createLiteral(byte by) throws ModelException {
        return this.createLiteral(String.valueOf(by));
    }

    public Literal createLiteral(char c) throws ModelException {
        return this.createLiteral(String.valueOf(c));
    }

    public Literal createLiteral(double d) throws ModelException {
        return this.createLiteral(String.valueOf(d));
    }

    public Literal createLiteral(float f) throws ModelException {
        return this.createLiteral(String.valueOf(f));
    }

    public Literal createLiteral(int n) throws ModelException {
        return this.createLiteral(String.valueOf(n));
    }

    public Literal createLiteral(long l) throws ModelException {
        return this.createLiteral(String.valueOf(l));
    }

    public Literal createLiteral(String string) {
        Literal literal = (Literal)this.lmap.get(string);
        if (literal == null) {
            literal = new LiteralImpl(this.getUnusedNodeID(), string);
            this.lmap.put(string, literal);
        }
        return literal;
    }

    public Literal createLiteral(short s) throws ModelException {
        return this.createLiteral(String.valueOf(s));
    }

    public Literal createLiteral(boolean bl) throws ModelException {
        return this.createLiteral(String.valueOf(bl));
    }

    public Resource createOrdinal(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Attempt to construct invalid ordinal resource");
        }
        return this.createResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + n);
    }

    public synchronized Resource createResource(String string) {
        Resource resource = (Resource)this.rmap.get(string);
        if (resource == null) {
            resource = new ResourceImpl(this.getUnusedNodeID(), string);
            this.rmap.put(string, resource);
        }
        return resource;
    }

    public Statement createStatement(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        if (!(resource instanceof ResourceImpl)) {
            resource = this.createResource(resource.getLabel());
        }
        if (!(resource2 instanceof ResourceImpl)) {
            resource2 = this.createResource(resource2.getLabel());
        }
        if (rDFNode instanceof Resource) {
            if (!(resource2 instanceof ResourceImpl)) {
                rDFNode = this.createResource(rDFNode.getLabel());
            }
        } else if (rDFNode instanceof Literal && !(rDFNode instanceof LiteralImpl)) {
            rDFNode = this.createLiteral(rDFNode.getLabel());
        }
        return resource != null && resource2 != null && rDFNode != null ? new StatementImpl(resource, resource2, rDFNode) : null;
    }

    public synchronized Resource createUniqueResource() {
        int n = this.getUnusedNodeID();
        ResourceImpl resourceImpl = new ResourceImpl(n, String.valueOf(uniquePrefix) + n);
        return resourceImpl;
    }

    public synchronized int getLastNodeID() {
        return this.lastNodeID;
    }

    public Collection getLiterals() {
        return this.lmap.values();
    }

    public Collection getResources() {
        return this.rmap.values();
    }

    public int getUnusedNodeID() {
        return this.lastNodeID++;
    }
}

