/*
 * Decompiled with CFR 0.152.
 */
package jena;

import com.hp.hpl.jena.ontology.tidy.CheckerResults;
import com.hp.hpl.jena.ontology.tidy.StreamingChecker;
import com.hp.hpl.jena.ontology.tidy.SyntaxProblem;
import com.hp.hpl.jena.ontology.tidy.test.WGTests;
import com.hp.hpl.jena.shared.BrokenException;
import java.io.InputStream;
import java.util.Iterator;
import jena.cmdline.ArgDecl;
import jena.cmdline.CommandLine;

public class owlsyntax {
    static final String NL = System.getProperty("line.separator", "\n");
    private static ArgDecl quietDecl = new ArgDecl(false, "-q", "--quiet");
    private static ArgDecl helpDecl = new ArgDecl(false, "-h", "--help");
    private static ArgDecl liteDecl = new ArgDecl(false, "-l", "--lite");
    private static ArgDecl bigDecl = new ArgDecl(false, "-b", "--big");
    private static ArgDecl shortDecl = new ArgDecl(false, "-s", "--short");
    private static ArgDecl textUIDecl = new ArgDecl(false, "--textui");
    private static ArgDecl testDecl = new ArgDecl(false, "--test");
    private static String usageMessage = "    " + (class$jena$owlsyntax == null ? (class$jena$owlsyntax = owlsyntax.class$("jena.owlsyntax")) : class$jena$owlsyntax).getName() + " [--lite|--quiet] [--big] [file1] [file2]" + NL + "    " + (class$jena$owlsyntax == null ? (class$jena$owlsyntax = owlsyntax.class$("jena.owlsyntax")) : class$jena$owlsyntax).getName() + " --help" + NL + "    " + (class$jena$owlsyntax == null ? (class$jena$owlsyntax = owlsyntax.class$("jena.owlsyntax")) : class$jena$owlsyntax).getName() + " [--textui] --test [ManifestURL]" + NL + NL + "The first form reports \"Lite\", \"DL\", or \"Full\"" + NL + "If two files are specified, then both files are checked, and" + NL + "the vocabulary usage by both files together must be separated." + NL + "If no files are specified then standard input is used," + NL + "(in this case, relative URIs and rdf:ID's are resolved" + NL + " against <urn:x-jena:syntaxchecker>)." + NL + NL + "  -l --lite     Give error messages for OWL DL or OWL Full constructions." + NL + "  -q --quiet    No error messages." + NL + "  -s --short    Give short error messages" + NL + "                (Default is long messages for OWL Full only)" + NL + "  -b --big      Input file is big - optimize memory usage." + NL + "                Quality of long error messages suffers." + NL + NL + "  --test        Run a test suite - default latest OWL Test publication." + NL + "                URL of file:testing/wg/OWLManifest.rdf uses local copy." + NL + "  --textui      Use the junit.textui instead of the swingui" + NL;
    static /* synthetic */ Class class$jena$owlsyntax;

    private owlsyntax() {
    }

    public static void main(String[] args) {
        boolean bad;
        boolean running;
        CommandLine cmd = new CommandLine();
        cmd.setUsage(usageMessage);
        cmd.setOutput(System.err);
        cmd.add(quietDecl).add(helpDecl).add(liteDecl).add(bigDecl).add(shortDecl).add(textUIDecl).add(testDecl);
        try {
            cmd.process(args);
        }
        catch (IllegalArgumentException illEx) {
            System.exit(1);
        }
        boolean testing = cmd.contains(testDecl) || cmd.contains(textUIDecl);
        boolean bl = running = !testing || cmd.contains(quietDecl) || cmd.contains(shortDecl) || cmd.contains(liteDecl) || cmd.contains(bigDecl);
        boolean bl2 = testing ? running || cmd.items().size() > 1 : (bad = cmd.items().size() > 2 || cmd.contains(liteDecl) && cmd.contains(quietDecl));
        if (cmd.contains(helpDecl) || bad) {
            System.out.println(usageMessage);
            System.exit(bad ? 1 : 0);
        }
        if (testing) {
            String manifest = "http://www.w3.org/TR/owl-test/Manifest";
            if (cmd.items().size() > 0) {
                manifest = (String)cmd.items().get(0);
            }
            WGTests.test(cmd.contains(textUIDecl), manifest);
        } else {
            StreamingChecker chk = new StreamingChecker(cmd.contains(liteDecl));
            boolean big = cmd.contains(bigDecl) || cmd.contains(quietDecl) || cmd.contains(shortDecl);
            chk.setOptimizeMemory(big);
            switch (cmd.items().size()) {
                case 0: {
                    owlsyntax.check(chk, System.in, "", cmd);
                    break;
                }
                case 1: {
                    owlsyntax.check(chk, (String)cmd.items().get(0), "", cmd);
                    break;
                }
                case 2: {
                    owlsyntax.check(chk, (String)cmd.items().get(0), (String)cmd.items().get(0), cmd);
                    StreamingChecker chk2 = new StreamingChecker(cmd.contains(liteDecl));
                    chk2.setOptimizeMemory(big);
                    owlsyntax.check(chk2, (String)cmd.items().get(1), (String)cmd.items().get(1), cmd);
                    owlsyntax.check(chk, (String)cmd.items().get(1), "togther", cmd);
                    break;
                }
                default: {
                    throw new BrokenException("Logic error");
                }
            }
        }
    }

    private static void check(StreamingChecker chk, InputStream in, String msgPrefix, CommandLine cmd) {
        chk.load(in, "urn:x-jena:syntaxchecker");
        owlsyntax.results(chk, msgPrefix, cmd);
    }

    private static void check(StreamingChecker chk, String url, String msgPrefix, CommandLine cmd) {
        chk.load(url);
        owlsyntax.results(chk, msgPrefix, cmd);
    }

    private static String prefix(String m) {
        if (m.length() == 0) {
            return m;
        }
        return m + ": ";
    }

    private static void results(CheckerResults chk, String msgPrefix, CommandLine cmd) {
        String subLang = chk.getSubLanguage();
        String p = owlsyntax.prefix(msgPrefix);
        System.out.println(p + subLang);
        if (cmd.contains(quietDecl)) {
            return;
        }
        Iterator it = chk.getProblems();
        while (it.hasNext()) {
            SyntaxProblem sp = (SyntaxProblem)it.next();
            System.err.println(p + (cmd.contains(shortDecl) ? sp.shortDescription() : sp.longDescription()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

