/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.impl;

import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.URI;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.shared.BadBooleanException;
import com.hp.hpl.jena.shared.BadURIException;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.shared.InvalidPropertyURIException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RDFSyntax;
import com.hp.hpl.jena.vocabulary.RSS;
import com.hp.hpl.jena.vocabulary.VCARD;
import com.hp.hpl.jena.xmloutput.RDFXMLWriterI;
import com.hp.hpl.jena.xmloutput.impl.Relation;
import com.hp.hpl.jena.xmloutput.impl.SimpleLogger;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.xerces.util.EncodingMap;
import org.apache.xerces.util.XMLChar;

public abstract class BaseXMLWriter
implements RDFXMLWriterI {
    private static Log xlogger = LogFactory.getLog((Class)(class$com$hp$hpl$jena$xmloutput$impl$BaseXMLWriter == null ? (class$com$hp$hpl$jena$xmloutput$impl$BaseXMLWriter = BaseXMLWriter.class$("com.hp.hpl.jena.xmloutput.impl.BaseXMLWriter")) : class$com$hp$hpl$jena$xmloutput$impl$BaseXMLWriter));
    protected static SimpleLogger logger = new SimpleLogger(){

        public void warn(String string) {
            xlogger.warn((Object)string);
        }

        public void warn(String string, Exception exception) {
            xlogger.warn((Object)string, (Throwable)exception);
        }
    };
    private String attributeQuoteChar = "\"";
    private static Set badRDF;
    private int jenaPrefixCount;
    static String RDFNS;
    private static Perl5Matcher matcher;
    private static Pattern jenaNamespace;
    String xmlBase = null;
    private URI baseURI;
    boolean longId = false;
    private boolean demandGoodURIs = true;
    int tab = 2;
    int width = 60;
    HashMap anonMap = new HashMap();
    int anonCount = 0;
    private static RDFDefaultErrorHandler defaultErrorHandler;
    RDFErrorHandler errorHandler = defaultErrorHandler;
    Boolean showXmlDeclaration = null;
    private boolean writingAllModelPrefixNamespaces = true;
    private Relation nameSpaces = new Relation();
    private Map ns;
    private Set namespacesNeeded;
    private static final int FAST = 1;
    private static final int START = 2;
    private static final int END = 3;
    private static final int ATTR = 4;
    private static final int FASTATTR = 5;
    public static boolean dbg;
    private static final char ESCAPE = 'X';
    static final char[] hexchar;
    private Resource[] blockedRules = new Resource[]{RDFSyntax.propertyAttr};
    private int relativeFlags = 29;
    static /* synthetic */ Class class$com$hp$hpl$jena$xmloutput$impl$BaseXMLWriter;

    public BaseXMLWriter() {
        this.setupMaps();
    }

    public static SimpleLogger setLogger(SimpleLogger simpleLogger) {
        SimpleLogger simpleLogger2 = logger;
        logger = simpleLogger;
        return simpleLogger2;
    }

    abstract void unblockAll();

    abstract void blockRule(Resource var1);

    abstract void writeBody(Model var1, PrintWriter var2, String var3, boolean var4);

    protected String q(String string) {
        return this.attributeQuoteChar + string + this.attributeQuoteChar;
    }

    protected String qq(String string) {
        return this.q(Util.substituteStandardEntities(string));
    }

    String anonId(Resource resource) {
        return this.longId ? this.longAnonId(resource) : this.shortAnonId(resource);
    }

    private String shortAnonId(Resource resource) {
        String string = (String)this.anonMap.get(resource.getId());
        if (string == null) {
            string = "A" + Integer.toString(this.anonCount++);
            this.anonMap.put(resource.getId(), string);
        }
        return string;
    }

    private String longAnonId(Resource resource) {
        String string = resource.getId().toString();
        return XMLChar.isValidNCName((String)string) ? string : BaseXMLWriter.escapedId(string);
    }

    void addNameSpace(String string) {
        this.namespacesNeeded.add(string);
    }

    boolean isDefaultNamespace(String string) {
        return "".equals(this.ns.get(string));
    }

    private void addNameSpaces(Model model) {
        NsIterator nsIterator = model.listNameSpaces();
        while (nsIterator.hasNext()) {
            this.addNameSpace(nsIterator.nextNs());
        }
    }

    private void primeNamespace(Model model) {
        Map map = model.getNsPrefixMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            String string3 = this.getPrefixFor(string2);
            if (string3 != null) continue;
            this.setNsPrefix(string, string2);
            if (!this.writingAllModelPrefixNamespaces) continue;
            this.addNameSpace(string2);
        }
    }

    void setupMaps() {
        this.nameSpaces.set11(RDF.getURI(), "rdf");
        this.nameSpaces.set11(RDFS.getURI(), "rdfs");
        this.nameSpaces.set11(DC.getURI(), "dc");
        this.nameSpaces.set11(RSS.getURI(), "rss");
        this.nameSpaces.set11("http://www.daml.org/2001/03/daml+oil.daml#", "daml");
        this.nameSpaces.set11(VCARD.getURI(), "vcard");
        this.nameSpaces.set11("http://www.w3.org/2002/07/owl#", "owl");
    }

    void workOutNamespaces() {
        if (this.ns == null) {
            this.ns = new HashMap();
            HashSet hashSet = new HashSet();
            this.setFromWriterSystemProperties(this.ns, hashSet);
            this.setFromGivenNamespaces(this.ns, hashSet);
        }
    }

    private void setFromWriterSystemProperties(Map map, Set set) {
        Iterator iterator = this.namespacesNeeded.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = Util.getProperty("com.hp.hpl.jena.nsprefix." + string);
            if (string2 == null || !this.checkLegalPrefix(string2) || set.contains(string2)) continue;
            map.put(string, string2);
            set.add(string2);
        }
    }

    private void setFromGivenNamespaces(Map map, Set set) {
        Iterator iterator = this.namespacesNeeded.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (map.containsKey(string)) continue;
            String string2 = null;
            Set set2 = this.nameSpaces.forward(string);
            if (set2 != null) {
                Iterator iterator2 = set2.iterator();
                if (iterator2.hasNext()) {
                    string2 = (String)iterator2.next();
                }
                if (set.contains(string2)) {
                    string2 = null;
                }
            }
            if (string2 == null) {
                while (set.contains(string2 = "j." + this.jenaPrefixCount++)) {
                }
            }
            map.put(string, string2);
            set.add(string2);
        }
    }

    public final synchronized void setNsPrefix(String string, String string2) {
        if (this.checkLegalPrefix(string)) {
            this.nameSpaces.set11(string2, string);
        }
    }

    public final String getPrefixFor(String string) {
        Set set = this.nameSpaces.backward(string);
        if (set != null && set.size() == 1) {
            return (String)set.iterator().next();
        }
        return null;
    }

    String xmlnsDecl() {
        this.workOutNamespaces();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.ns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getValue();
            String string2 = (String)entry.getKey();
            stringBuffer.append("\n    xmlns");
            if (string.length() > 0) {
                stringBuffer.append(':').append(string);
            }
            stringBuffer.append('=').append(this.qq(this.checkURI(string2)));
        }
        return stringBuffer.toString();
    }

    String rdfEl(String string) {
        return this.tag(RDFNS, string, 1, true);
    }

    String startElementTag(String string, String string2) {
        return this.tag(string, string2, 2, false);
    }

    String startElementTag(String string) {
        return this.splitTag(string, 2);
    }

    String attributeTag(String string) {
        return this.splitTag(string, 4);
    }

    String attributeTag(String string, String string2) {
        return this.tag(string, string2, 4, false);
    }

    String rdfAt(String string) {
        return this.tag(RDFNS, string, 5, true);
    }

    String endElementTag(String string, String string2) {
        return this.tag(string, string2, 3, false);
    }

    String endElementTag(String string) {
        return this.splitTag(string, 3);
    }

    String splitTag(String string, int n) {
        int n2 = Util.splitNamespace(string);
        if (n2 == string.length()) {
            throw new InvalidPropertyURIException(string);
        }
        return this.tag(string.substring(0, n2), string.substring(n2), n, true);
    }

    String tag(String string, String string2, int n, boolean bl) {
        if (dbg) {
            System.err.println(string + " - " + string2);
        }
        String string3 = (String)this.ns.get(string);
        if (n != 1 && n != 5) {
            if (!bl && !XMLChar.isValidNCName((String)string2)) {
                return this.splitTag(string + string2, n);
            }
            if (string.equals(RDFNS) && badRDF.contains(string2)) {
                logger.warn("The URI rdf:" + string2 + " cannot be serialized in RDF/XML.");
                throw new InvalidPropertyURIException("rdf:" + string2);
            }
        }
        boolean bl2 = false;
        if (string3 == null) {
            this.checkURI(string);
            logger.warn("Internal error: unexpected QName URI: <" + string + ">.  Fixing up with j.cook.up code.", new BrokenException("unexpected QName URI " + string));
            bl2 = true;
        } else if (string3.length() == 0) {
            if (n == 4 || n == 5) {
                bl2 = true;
            } else {
                return string2;
            }
        }
        if (bl2) {
            return this.cookUpAttribution(n, string, string2);
        }
        return string3 + ":" + string2;
    }

    private String cookUpAttribution(int n, String string, String string2) {
        String string3 = "j.cook.up";
        switch (n) {
            case 4: 
            case 5: {
                return "xmlns:" + string3 + "=" + this.qq(string) + " " + string3 + ":" + string2;
            }
            case 2: {
                return string3 + ":" + string2 + " xmlns:" + string3 + "=" + this.qq(string);
            }
            default: {
                return string3 + ":" + string2;
            }
            case 1: 
        }
        throw new BrokenException("cookup reached final FAST");
    }

    public final void write(Model model, OutputStream outputStream, String string) {
        this.write(model, FileUtils.asUTF8(outputStream), string);
    }

    public synchronized void write(Model model, Writer writer, String string) {
        PrintWriter printWriter;
        Model model2 = ModelFactory.withHiddenStatements(model);
        this.namespacesNeeded = new HashSet();
        this.ns = null;
        this.primeNamespace(model);
        this.addNameSpace(RDF.getURI());
        this.addNameSpaces(model2);
        this.jenaPrefixCount = 0;
        PrintWriter printWriter2 = printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        if (!Boolean.FALSE.equals(this.showXmlDeclaration)) {
            this.writeXMLDeclaration(writer, printWriter);
        }
        this.writeXMLBody(model2, printWriter, string);
        printWriter.flush();
    }

    private void writeXMLBody(Model model, PrintWriter printWriter, String string) {
        try {
            if (this.xmlBase == null) {
                this.baseURI = string == null || string.length() == 0 ? null : new URI(string);
                this.writeBody(model, printWriter, string, false);
            } else {
                this.baseURI = this.xmlBase.length() == 0 ? null : new URI(this.xmlBase);
                this.writeBody(model, printWriter, this.xmlBase, true);
            }
        }
        catch (MalformedURIException malformedURIException) {
            throw new BadURIException("", malformedURIException);
        }
    }

    private void writeXMLDeclaration(Writer writer, PrintWriter printWriter) {
        String string;
        String string2 = null;
        if (writer instanceof OutputStreamWriter && !(string = ((OutputStreamWriter)writer).getEncoding()).equals("UTF8") && !string.equals("UTF-16")) {
            String string3 = EncodingMap.getJava2IANAMapping((String)string);
            if (string3 == null) {
                logger.warn("IANA name for Java encoding: " + string + " is not known. \n" + "   Not including any encoding declaration in the RDF/XML output.\n" + "   It is better to use a FileOutputStream, in place of a FileWriter.");
            } else {
                string2 = "<?xml version=" + this.q("1.0") + " encoding=" + this.q(string3) + "?>";
            }
        }
        if (string2 == null && this.showXmlDeclaration != null) {
            string2 = "<?xml version=" + this.q("1.0") + "?>";
        }
        if (string2 != null) {
            printWriter.println(string2);
        }
    }

    public synchronized RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        if (rDFErrorHandler2 == defaultErrorHandler) {
            rDFErrorHandler2 = null;
        }
        this.errorHandler = rDFErrorHandler == null ? defaultErrorHandler : rDFErrorHandler;
        return rDFErrorHandler2;
    }

    private static String escapedId(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != 'X' && (i == 0 ? XMLChar.isNCNameStart((int)c) : XMLChar.isNCName((int)c))) {
                stringBuffer.append(c);
                continue;
            }
            BaseXMLWriter.escape(stringBuffer, c);
        }
        return stringBuffer.toString();
    }

    private static void escape(StringBuffer stringBuffer, char n) {
        stringBuffer.append('X');
        int n2 = n;
        do {
            stringBuffer.append(hexchar[n2 & 0xF]);
        } while ((n2 >>= 4) != 0);
        stringBuffer.append('X');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Object setProperty(String string, Object object) {
        if (string.equalsIgnoreCase("showXmlDeclaration")) {
            return this.setShowXmlDeclaration(object);
        }
        if (string.equalsIgnoreCase("minimalPrefixes")) {
            Boolean bl;
            try {
                bl = new Boolean(!this.writingAllModelPrefixNamespaces);
            }
            catch (Throwable throwable) {
                this.writingAllModelPrefixNamespaces = !BaseXMLWriter.getBoolean(object);
                throw throwable;
            }
            this.writingAllModelPrefixNamespaces = !BaseXMLWriter.getBoolean(object);
            return bl;
        }
        if (string.equalsIgnoreCase("xmlbase")) {
            String string2 = this.xmlBase;
            this.xmlBase = (String)object;
            return string2;
        }
        if (string.equalsIgnoreCase("tab")) {
            return this.setTab(object);
        }
        if (string.equalsIgnoreCase("width")) {
            return this.setWidth(object);
        }
        if (string.equalsIgnoreCase("longid")) {
            Boolean bl = new Boolean(this.longId);
            this.longId = BaseXMLWriter.getBoolean(object);
            return bl;
        }
        if (string.equalsIgnoreCase("attributeQuoteChar")) {
            return this.setAttributeQuoteChar(object);
        }
        if (string.equalsIgnoreCase("allowBadURIs")) {
            Boolean bl = new Boolean(!this.demandGoodURIs);
            this.demandGoodURIs = !BaseXMLWriter.getBoolean(object);
            return bl;
        }
        if (string.equalsIgnoreCase("prettyTypes")) {
            return this.setTypes((Resource[])object);
        }
        if (string.equalsIgnoreCase("relativeURIs")) {
            int n = this.relativeFlags;
            this.relativeFlags = BaseXMLWriter.str2flags((String)object);
            return BaseXMLWriter.flags2str(n);
        }
        if (string.equalsIgnoreCase("blockRules")) {
            return this.setBlockRules(object);
        }
        logger.warn("Unsupported property: " + string);
        return null;
    }

    private String setAttributeQuoteChar(Object object) {
        String string = this.attributeQuoteChar;
        if ("\"".equals(object) || "'".equals(object)) {
            this.attributeQuoteChar = (String)object;
        } else {
            logger.warn("attributeQutpeChar must be either \"\\\"\" or ', not \"" + object + "\"");
        }
        return string;
    }

    private Integer setWidth(Object object) {
        Integer n = new Integer(this.width);
        if (object instanceof Integer) {
            this.width = (Integer)object;
        } else {
            try {
                this.width = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                logger.warn("Bad value for width: '" + object + "' [" + exception.getMessage() + "]");
            }
        }
        return n;
    }

    private Integer setTab(Object object) {
        Integer n = new Integer(this.tab);
        if (object instanceof Integer) {
            this.tab = (Integer)object;
        } else {
            try {
                this.tab = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                logger.warn("Bad value for tab: '" + object + "' [" + exception.getMessage() + "]");
            }
        }
        return n;
    }

    private String setShowXmlDeclaration(Object object) {
        String string = this.showXmlDeclaration == null ? null : this.showXmlDeclaration.toString();
        if (object == null) {
            this.showXmlDeclaration = null;
        } else if (object instanceof Boolean) {
            this.showXmlDeclaration = (Boolean)object;
        } else if (object instanceof String) {
            String string2 = (String)object;
            if (string2.equalsIgnoreCase("default")) {
                this.showXmlDeclaration = null;
            }
            if (string2.equalsIgnoreCase("true")) {
                this.showXmlDeclaration = Boolean.TRUE;
            } else if (string2.equalsIgnoreCase("false")) {
                this.showXmlDeclaration = Boolean.FALSE;
            } else {
                throw new BadBooleanException(string2);
            }
        }
        return string;
    }

    private static boolean getBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.valueOf((String)object);
    }

    Resource[] setTypes(Resource[] resourceArray) {
        logger.warn("prettyTypes is not a property on the Basic RDF/XML writer.");
        return null;
    }

    Resource[] setBlockRules(Object object) {
        Resource[] resourceArray = this.blockedRules;
        this.unblockAll();
        if (object instanceof Resource[]) {
            this.blockedRules = (Resource[])object;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ", ");
            Vector<Resource> vector = new Vector<Resource>();
            while (stringTokenizer.hasMoreElements()) {
                String string = stringTokenizer.nextToken();
                if (string.equals("daml:collection")) {
                    vector.add(DAML_OIL.collection);
                    continue;
                }
                vector.add(new ResourceImpl(RDFSyntax.getURI() + string));
            }
            this.blockedRules = new Resource[vector.size()];
            vector.copyInto(this.blockedRules);
        }
        for (int i = 0; i < this.blockedRules.length; ++i) {
            this.blockRule(this.blockedRules[i]);
        }
        return resourceArray;
    }

    protected String relativize(String string) {
        return this.relativeFlags != 0 && this.baseURI != null ? this.relativize(this.baseURI, string) : this.checkURI(string);
    }

    private String relativize(URI uRI, String string) {
        try {
            return uRI.relativize(string, this.relativeFlags);
        }
        catch (MalformedURIException malformedURIException) {
            throw new JenaException(malformedURIException);
        }
    }

    private String checkURI(String string) {
        if (this.demandGoodURIs) {
            try {
                new URI(string);
            }
            catch (MalformedURIException malformedURIException) {
                throw new BadURIException("Only well-formed absolute URIrefs can be included in RDF/XML output", malformedURIException);
            }
        }
        return string;
    }

    private boolean checkLegalPrefix(String string) {
        if (string.equals("")) {
            return true;
        }
        if (string.toLowerCase().startsWith("xml")) {
            logger.warn("Namespace prefix '" + string + "' is reserved by XML.");
        } else if (!XMLChar.isValidNCName((String)string)) {
            logger.warn("'" + string + "' is not a legal namespace prefix.");
        } else if (matcher.matches(string, jenaNamespace)) {
            logger.warn("Namespace prefix '" + string + "' is reserved by Jena.");
        } else {
            return true;
        }
        return false;
    }

    private static String flags2str(int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if ((n & 1) != 0) {
            stringBuffer.append("same-document, ");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("network, ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("absolute, ");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("relative, ");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("parent, ");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append("grandparent, ");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        return stringBuffer.toString();
    }

    public static int str2flags(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("same-document")) {
                n |= 1;
                continue;
            }
            if (string2.equals("network")) {
                n |= 2;
                continue;
            }
            if (string2.equals("absolute")) {
                n |= 4;
                continue;
            }
            if (string2.equals("relative")) {
                n |= 8;
                continue;
            }
            if (string2.equals("parent")) {
                n |= 0x10;
                continue;
            }
            if (string2.equals("grandparent")) {
                n |= 0x20;
                continue;
            }
            logger.warn("Incorrect property value for relativeURIs: " + string2);
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ARP.initEncoding();
        badRDF = new HashSet();
        RDFNS = RDF.getURI();
        matcher = new Perl5Matcher();
        try {
            jenaNamespace = new Perl5Compiler().compile("j\\.([1-9][0-9]*|cook\\.up)");
        }
        catch (MalformedPatternException malformedPatternException) {
            // empty catch block
        }
        badRDF.add("RDF");
        badRDF.add("Description");
        badRDF.add("li");
        badRDF.add("about");
        badRDF.add("aboutEach");
        badRDF.add("aboutEachPrefix");
        badRDF.add("ID");
        badRDF.add("nodeID");
        badRDF.add("parseType");
        badRDF.add("datatype");
        badRDF.add("bagID");
        badRDF.add("resource");
        defaultErrorHandler = new RDFDefaultErrorHandler();
        dbg = false;
        hexchar = "0123456789abcdef".toCharArray();
    }
}

