/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPBRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPRuleStore;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FBLPRuleInfGraph
extends FBRuleInfGraph {
    protected LPBRuleEngine lpbEngine;
    static Log logger = LogFactory.getLog((Class)(class$com$hp$hpl$jena$reasoner$rulesys$impl$oldCode$FBLPRuleInfGraph == null ? (class$com$hp$hpl$jena$reasoner$rulesys$impl$oldCode$FBLPRuleInfGraph = FBLPRuleInfGraph.class$("com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.FBLPRuleInfGraph")) : class$com$hp$hpl$jena$reasoner$rulesys$impl$oldCode$FBLPRuleInfGraph));
    static /* synthetic */ Class class$com$hp$hpl$jena$reasoner$rulesys$impl$oldCode$FBLPRuleInfGraph;

    public FBLPRuleInfGraph(Reasoner reasoner, Graph graph) {
        super(reasoner, graph);
        this.initLP(graph);
    }

    public FBLPRuleInfGraph(Reasoner reasoner, List list, Graph graph) {
        super(reasoner, list, graph);
        this.initLP(graph);
    }

    public FBLPRuleInfGraph(Reasoner reasoner, List list, Graph graph, Graph graph2) {
        super(reasoner, list, graph, graph2);
        this.initLP(graph);
    }

    private void initLP(Graph graph) {
        if (graph != null && graph instanceof FBLPRuleInfGraph) {
            LPRuleStore lPRuleStore = new LPRuleStore();
            lPRuleStore.addAll(((FBLPRuleInfGraph)graph).lpbEngine.getRuleStore());
            this.lpbEngine = new LPBRuleEngine(this, lPRuleStore);
        } else {
            this.lpbEngine = new LPBRuleEngine(this);
        }
    }

    public boolean processBuiltin(Object object, Rule rule, BindingEnvironment bindingEnvironment) {
        throw new ReasonerException("Internal error in FBLP rule engine, incorrect invocation of building in rule " + rule);
    }

    public void addBRule(Rule rule) {
        this.lpbEngine.addRule(rule);
        this.lpbEngine.reset();
    }

    public void deleteBRule(Rule rule) {
        this.lpbEngine.deleteRule(rule);
        this.lpbEngine.reset();
    }

    public void addBRules(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            this.lpbEngine.addRule(rule);
        }
        this.lpbEngine.reset();
    }

    public List getBRules() {
        return this.lpbEngine.getAllRules();
    }

    public void setTabled(Node node) {
        this.lpbEngine.tablePredicate(node);
        if (this.traceOn) {
            logger.info((Object)("LP TABLE " + node));
        }
    }

    public void rebind() {
        if (this.lpbEngine != null) {
            this.lpbEngine.reset();
        }
        this.isPrepared = false;
    }

    public void setTraceOn(boolean bl) {
        super.setTraceOn(bl);
        this.lpbEngine.setTraceOn(bl);
    }

    public void setDerivationLogging(boolean bl) {
        this.recordDerivations = bl;
        this.engine.setDerivationLogging(bl);
        this.lpbEngine.setDerivationLogging(bl);
        this.derivations = bl ? new OneToManyMap() : null;
    }

    public long getNRulesFired() {
        return this.engine.getNRulesFired();
    }

    public ExtendedIterator findWithContinuation(TriplePattern triplePattern, Finder finder) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        ExtendedIterator extendedIterator = new UniqueExtendedIterator(this.lpbEngine.find(triplePattern));
        if (finder != null) {
            extendedIterator = extendedIterator.andThen(finder.find(triplePattern));
        }
        return extendedIterator.filterDrop(Functor.acceptFilter);
    }

    public void reset() {
        this.lpbEngine.reset();
        this.isPrepared = false;
    }

    public synchronized void performAdd(Triple triple) {
        this.fdata.getGraph().add(triple);
        if (this.useTGCCaching && this.transitiveEngine.add(triple)) {
            this.isPrepared = false;
        }
        if (this.isPrepared) {
            this.engine.add(triple);
        }
        this.lpbEngine.reset();
    }

    public void performDelete(Triple triple) {
        this.fdata.getGraph().delete(triple);
        if (this.useTGCCaching && this.transitiveEngine.delete(triple)) {
            if (this.isPrepared) {
                this.bEngine.deleteAllRules();
            }
            this.isPrepared = false;
        }
        if (this.isPrepared) {
            this.getDeductionsGraph().delete(triple);
            this.engine.delete(triple);
        }
        this.lpbEngine.reset();
    }

    public void resetLPProfile(boolean bl) {
        this.lpbEngine.resetProfile(bl);
    }

    public void printLPProfile() {
        this.lpbEngine.printProfile();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

