/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import java.util.ArrayList;
import java.util.Arrays;

public class BindingStack
implements BindingEnvironment {
    protected Node[] environment;
    protected ArrayList trail = new ArrayList();
    protected int index = 0;
    protected int highWater = 0;
    protected static final int MAX_VAR = 10;

    public BindingStack() {
        this.trail.add(new Node[10]);
        this.environment = (Node[])this.trail.get(0);
        this.highWater = 0;
        this.index = 0;
    }

    public void push() {
        if (this.index == this.highWater) {
            this.trail.add(new Node[10]);
            ++this.highWater;
        }
        Node[] nodeArray = (Node[])this.trail.get(++this.index);
        System.arraycopy(this.environment, 0, nodeArray, 0, 10);
        this.environment = nodeArray;
    }

    public void unwind() throws IndexOutOfBoundsException {
        if (this.index <= 0) {
            throw new IndexOutOfBoundsException("Underflow of BindingEnvironment");
        }
        this.environment = (Node[])this.trail.get(--this.index);
    }

    public void commit() throws IndexOutOfBoundsException {
        if (this.index > 0) {
            Node[] nodeArray = (Node[])this.trail.get(this.index - 1);
            this.trail.set(this.index - 1, this.environment);
            this.trail.set(this.index, nodeArray);
            --this.index;
        } else {
            throw new IndexOutOfBoundsException("Underflow of BindingEnvironment");
        }
    }

    public void reset() {
        this.index = 0;
        this.environment = (Node[])this.trail.get(0);
        Arrays.fill(this.environment, null);
    }

    public Node[] getEnvironment() {
        return this.environment;
    }

    public Node getBinding(Node node) {
        if (node instanceof Node_RuleVariable) {
            return this.environment[((Node_RuleVariable)node).getIndex()];
        }
        if (node instanceof Node_ANY) {
            return null;
        }
        if (Functor.isFunctor(node)) {
            Object object;
            Functor functor = (Functor)node.getLiteral().getValue();
            if (functor.isGround()) {
                return node;
            }
            Node[] nodeArray = functor.getArgs();
            ArrayList<Node> arrayList = new ArrayList<Node>(nodeArray.length);
            for (int i = 0; i < nodeArray.length; ++i) {
                object = this.getBinding(nodeArray[i]);
                if (object == null) {
                    return null;
                }
                arrayList.add((Node)object);
            }
            Functor functor2 = new Functor(functor.getName(), arrayList);
            object = new LiteralLabel(functor2, null, Functor.FunctorDatatype.theFunctorDatatype);
            return new Node_Literal(object);
        }
        return node;
    }

    public Node getGroundVersion(Node node) {
        Node node2 = this.getBinding(node);
        if (node2 == null) {
            return node;
        }
        return node2;
    }

    public boolean bind(int n, Node node) {
        Node node2 = this.environment[n];
        if (node2 == null) {
            this.environment[n] = node;
            return true;
        }
        return node2.sameValueAs(node);
    }

    public boolean bind(Node node, Node node2) {
        if (node instanceof Node_RuleVariable) {
            return this.bind(((Node_RuleVariable)node).getIndex(), node2);
        }
        return node.sameValueAs(node2);
    }

    public void bindNoCheck(Node_RuleVariable node_RuleVariable, Node node) {
        this.environment[node_RuleVariable.getIndex()] = node;
    }

    public Triple instantiate(TriplePattern triplePattern) {
        Node node;
        Node node2;
        Node node3 = this.getGroundVersion(triplePattern.getSubject());
        if (node3.isVariable()) {
            node3 = Node.createAnon();
        }
        if ((node2 = this.getGroundVersion(triplePattern.getPredicate())).isVariable()) {
            node2 = Node.createAnon();
        }
        if ((node = this.getGroundVersion(triplePattern.getObject())).isVariable()) {
            node = Node.createAnon();
        }
        return new Triple(node3, node2, node);
    }
}

