/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.builtins;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.vocabulary.RDFS;

public class IsDType
extends BaseBuiltin {
    public String getName() {
        return "isDType";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] nodeArray, int n, RuleContext ruleContext) {
        this.checkArgs(n, ruleContext);
        Node node = this.getArg(0, nodeArray, ruleContext);
        Node node2 = this.getArg(1, nodeArray, ruleContext);
        return IsDType.isTypeOK(node, node2);
    }

    public static boolean isTypeOK(Node node, Node node2) {
        if (!node2.isURI()) {
            return false;
        }
        if (node.isBlank()) {
            return true;
        }
        if (node.isLiteral()) {
            LiteralLabel literalLabel = node.getLiteral();
            if (literalLabel.getDatatype() != null && !literalLabel.isWellFormed()) {
                return false;
            }
            if (node2.equals(RDFS.Nodes.Literal)) {
                return true;
            }
            RDFDatatype rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(node2.getURI());
            return rDFDatatype.isValidLiteral(node.getLiteral());
        }
        return false;
    }
}

