/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class DIGReasonerFactory
implements ReasonerFactory {
    public static final String URI = "http://jena.hpl.hp.com/2003/DIGReasoner";
    private static DIGReasonerFactory s_instance = new DIGReasonerFactory();
    private Model m_capabilities = null;

    private DIGReasonerFactory() {
    }

    public static DIGReasonerFactory theInstance() {
        return s_instance;
    }

    public Reasoner create(Resource resource) {
        return new DIGReasoner(null, this, resource);
    }

    public Model getCapabilities() {
        if (this.m_capabilities == null) {
            this.m_capabilities = ModelFactory.createDefaultModel();
            Resource resource = this.m_capabilities.createResource(this.getURI());
            resource.addProperty(ReasonerVocabulary.nameP, "DIG external Reasoner").addProperty(ReasonerVocabulary.descriptionP, "Adapter for external (i.e. non-Jena) DIG reasoner.").addProperty(ReasonerVocabulary.supportsP, RDFS.subClassOf).addProperty(ReasonerVocabulary.supportsP, RDFS.subPropertyOf).addProperty(ReasonerVocabulary.supportsP, RDFS.member).addProperty(ReasonerVocabulary.supportsP, RDFS.range).addProperty(ReasonerVocabulary.supportsP, RDFS.domain).addProperty(ReasonerVocabulary.supportsP, ReasonerVocabulary.directSubClassOf).addProperty(ReasonerVocabulary.supportsP, ReasonerVocabulary.directSubPropertyOf).addProperty(ReasonerVocabulary.versionP, "0.1");
        }
        return this.m_capabilities;
    }

    public String getURI() {
        return URI;
    }
}

