/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGConnectionPool;
import com.hp.hpl.jena.reasoner.dig.DIGIdentifier;
import com.hp.hpl.jena.reasoner.dig.DIGProfile;
import com.hp.hpl.jena.reasoner.dig.DIGQueryAllConceptsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryAncestorsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryClassHierarchyTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryDisjointTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryEquivalentsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryInstanceTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryInstancesTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryIsEquivalentTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryParentsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryRoleAncestorsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryRoleFillersTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryRoleHierarchyTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryRoleParentsTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQuerySubsumesTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTypesTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.util.xml.SimpleXMLPath;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DIGAdapter {
    public static final DIGProfile RACER_17_PROFILE = new DIGProfile(){

        public String getDIGNamespace() {
            return "http://dl.kr.org/dig/lang";
        }

        public String getSchemaLocation() {
            return "http://potato.cs.man.ac.uk/dig/level0/dig.xsd";
        }

        public String getContentType() {
            return "application/x-www-form-urlencoded";
        }
    };
    private static final int UNION = 1;
    private static final int INTERSECTION = 2;
    private static final int COMPLEMENT = 3;
    private static final int ENUMERATED = 4;
    private static final int RESTRICTION = 5;
    public static final String ANON_MARKER = "anon:";
    protected static DIGQueryTranslator[] s_queryTable = new DIGQueryTranslator[]{new DIGQuerySubsumesTranslator(RDFS.subClassOf.getURI()), new DIGQuerySubsumesTranslator(DAML_OIL.subClassOf.getURI()), new DIGQueryDisjointTranslator(OWL.disjointWith.getURI()), new DIGQueryDisjointTranslator(DAML_OIL.disjointWith.getURI()), new DIGQueryAncestorsTranslator(RDFS.subClassOf.getURI(), true), new DIGQueryAncestorsTranslator(RDFS.subClassOf.getURI(), false), new DIGQueryAncestorsTranslator(DAML_OIL.subClassOf.getURI(), true), new DIGQueryAncestorsTranslator(DAML_OIL.subClassOf.getURI(), false), new DIGQueryParentsTranslator(ReasonerVocabulary.directSubClassOf.getURI(), true), new DIGQueryParentsTranslator(ReasonerVocabulary.directSubClassOf.getURI(), false), new DIGQueryClassHierarchyTranslator(RDFS.subClassOf.getURI()), new DIGQueryClassHierarchyTranslator(DAML_OIL.subClassOf.getURI()), new DIGQueryEquivalentsTranslator(OWL.equivalentClass.getURI(), true), new DIGQueryEquivalentsTranslator(OWL.equivalentClass.getURI(), false), new DIGQueryEquivalentsTranslator(DAML_OIL.sameClassAs.getURI(), true), new DIGQueryEquivalentsTranslator(DAML_OIL.sameClassAs.getURI(), false), new DIGQueryIsEquivalentTranslator(OWL.equivalentClass.getURI()), new DIGQueryIsEquivalentTranslator(DAML_OIL.sameClassAs.getURI()), new DIGQueryRoleAncestorsTranslator(RDFS.subPropertyOf.getURI(), true), new DIGQueryRoleAncestorsTranslator(RDFS.subPropertyOf.getURI(), false), new DIGQueryRoleAncestorsTranslator(DAML_OIL.subPropertyOf.getURI(), true), new DIGQueryRoleAncestorsTranslator(DAML_OIL.subPropertyOf.getURI(), false), new DIGQueryRoleParentsTranslator(ReasonerVocabulary.directSubPropertyOf.getURI(), true), new DIGQueryRoleParentsTranslator(ReasonerVocabulary.directSubPropertyOf.getURI(), false), new DIGQueryRoleHierarchyTranslator(RDFS.subPropertyOf.getURI()), new DIGQueryRoleHierarchyTranslator(DAML_OIL.subPropertyOf.getURI()), new DIGQueryInstancesTranslator(RDF.type.getURI()), new DIGQueryInstancesTranslator(DAML_OIL.type.getURI()), new DIGQueryTypesTranslator(RDF.type.getURI()), new DIGQueryTypesTranslator(DAML_OIL.type.getURI()), new DIGQueryInstanceTranslator(RDF.type.getURI()), new DIGQueryInstanceTranslator(DAML_OIL.type.getURI()), new DIGQueryRoleFillersTranslator(), new DIGQueryAllConceptsTranslator(RDF.type.getURI(), RDFS.Class.getURI()), new DIGQueryAllConceptsTranslator(RDF.type.getURI(), OWL.Class.getURI()), new DIGQueryAllConceptsTranslator(RDF.type.getURI(), DAML_OIL.Class.getURI())};
    protected DIGProfile m_profile = RACER_17_PROFILE;
    protected OntModel m_sourceData;
    private int m_skolemCounter = 0;
    private DIGConnection m_connection;
    protected Set m_indNames = null;
    protected Set m_conceptNames = null;
    protected Set m_roleNames = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Restriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Individual;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$ObjectProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$DatatypeProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$AllDifferent;

    public DIGAdapter(OntModelSpec ontModelSpec, Graph graph) {
        this(ontModelSpec, graph, DIGConnectionPool.getInstance().allocate());
    }

    public DIGAdapter(OntModelSpec ontModelSpec, Graph graph, DIGConnection dIGConnection) {
        this.m_connection = dIGConnection;
        this.m_sourceData = ModelFactory.createOntologyModel(ontModelSpec, ModelFactory.createModelForGraph(graph));
        this.m_sourceData.setStrictMode(false);
    }

    public DIGProfile getProfile() {
        return this.m_profile;
    }

    public void setProfile(DIGProfile dIGProfile) {
        this.m_profile = dIGProfile;
    }

    public Profile getOntLanguage() {
        return this.m_sourceData.getProfile();
    }

    public DIGIdentifier getDigIdentifier() {
        Document document = this.getConnection().createDigVerb("getIdentifier", this.getProfile());
        return new DigIdentifierImpl(this.getConnection().sendDigVerb(document, this.getProfile()));
    }

    public boolean uploadKB() {
        this.getConnection().bindKB(false, this.getProfile());
        Document document = this.translateKbToDig();
        Document document2 = this.getConnection().sendDigVerb(document, this.getProfile());
        return !this.getConnection().warningCheck(document2);
    }

    public Document translateKbToDig() {
        Document document = this.getConnection().createDigVerb("tells", this.getProfile());
        Element element = document.getDocumentElement();
        this.addNamedEntities(element);
        this.translateClasses(element);
        this.translateRoles(element);
        this.translateAttributes(element);
        this.translateIndividuals(element);
        this.translateAllDifferentAxioms(element);
        return document;
    }

    public void resetKB() {
        this.getConnection().bindKB(true, this.getProfile());
        this.m_indNames = null;
        this.m_conceptNames = null;
        this.m_roleNames = null;
    }

    public DIGConnection getConnection() {
        return this.m_connection;
    }

    public void close() {
        this.getConnection().release();
        this.m_connection = null;
    }

    public ExtendedIterator find(TriplePattern triplePattern) {
        DIGQueryTranslator dIGQueryTranslator = this.getQueryTranslator(triplePattern);
        ExtendedIterator extendedIterator = dIGQueryTranslator == null ? null : dIGQueryTranslator.find(triplePattern, this);
        ExtendedIterator extendedIterator2 = this.m_sourceData.getGraph().find(triplePattern.getSubject(), triplePattern.getPredicate(), triplePattern.getObject());
        ExtendedIterator extendedIterator3 = extendedIterator == null ? extendedIterator2 : extendedIterator.andThen(extendedIterator2);
        return UniqueExtendedIterator.create(extendedIterator3);
    }

    public DIGQueryTranslator getQueryTranslator(TriplePattern triplePattern) {
        for (int i = 0; i < s_queryTable.length; ++i) {
            if (!s_queryTable[i].trigger(triplePattern, this)) continue;
            return s_queryTable[i];
        }
        return null;
    }

    public Graph getGraph() {
        return this.m_sourceData.getGraph();
    }

    public String getResourceID(Resource resource) {
        return this.getNodeID(resource.asNode());
    }

    public String getNodeID(Node node) {
        if (node.isBlank()) {
            return ANON_MARKER + node.getBlankNodeId().toString();
        }
        return node.getURI();
    }

    public void addClassDescription(Element element, Node node) {
        this.translateClassIdentifier(element, (Resource)this.m_sourceData.getRDFNode(node));
    }

    public boolean isIndividual(Node node) {
        return this.getKnownIndividuals().contains(this.getNodeID(node));
    }

    public boolean isRole(Node node) {
        return this.getKnownRoles().contains(this.getNodeID(node));
    }

    public boolean isConcept(Node node) {
        return this.getKnownConcepts().contains(this.getNodeID(node));
    }

    protected void addNamedEntities(Element element) {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet();
        HashSet hashSet4 = new HashSet();
        this.addAll(this.m_sourceData.listClasses(), hashSet3);
        this.addAll(this.m_sourceData.listDatatypeProperties(), hashSet2);
        this.addAll(this.m_sourceData.listIndividuals(), hashSet4);
        this.collectRoleProperties(hashSet);
        this.addNamedDefs(element, hashSet3.iterator(), "defconcept");
        this.addNamedDefs(element, hashSet.iterator(), "defrole");
        this.addNamedDefs(element, hashSet2.iterator(), "defattribute");
        this.addNamedDefs(element, hashSet4.iterator(), "defindividual");
    }

    protected void collectRoleProperties(Collection collection) {
        this.addAll(this.m_sourceData.listObjectProperties(), collection);
        this.addAll(this.m_sourceData.listInverseFunctionalProperties(), collection);
        this.addAll(this.m_sourceData.listSymmetricProperties(), collection);
        this.addAll(this.m_sourceData.listTransitiveProperties(), collection);
    }

    protected void addNamedDefs(Element element, Iterator iterator, String string) {
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (!(resource instanceof Resource)) continue;
            this.addNamedElement(element, string, this.getNodeID(resource.asNode()));
        }
    }

    protected Element addNamedElement(Element element, String string, String string2) {
        Element element2 = this.addElement(element, string);
        element2.setAttribute("name", string2);
        return element2;
    }

    protected Element addElement(Element element, String string) {
        Element element2 = element.getOwnerDocument().createElement(string);
        return (Element)element.appendChild(element2);
    }

    private void addAll(Iterator iterator, Collection collection) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
    }

    protected void translateClasses(Element element) {
        this.translateSubClassAxioms(element);
        this.translateClassEquivalences(element);
        this.translateClassDisjointAxioms(element);
        this.translateRestrictions(element);
        this.translateClassExpressions(element, this.m_sourceData.getProfile().INTERSECTION_OF(), 2);
        this.translateClassExpressions(element, this.m_sourceData.getProfile().UNION_OF(), 1);
        this.translateClassExpressions(element, this.m_sourceData.getProfile().COMPLEMENT_OF(), 3);
        this.translateClassExpressions(element, this.m_sourceData.getProfile().ONE_OF(), 4);
    }

    protected void translateSubClassAxioms(Element element) {
        StmtIterator stmtIterator = this.m_sourceData.listStatements(null, this.m_sourceData.getProfile().SUB_CLASS_OF(), (RDFNode)null);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Element element2 = this.addElement(element, "impliesc");
            this.translateClassIdentifier(element2, statement.getSubject());
            this.translateClassIdentifier(element2, statement.getResource());
        }
    }

    protected void translateClassEquivalences(Element element) {
        StmtIterator stmtIterator = this.m_sourceData.listStatements(null, this.m_sourceData.getProfile().EQUIVALENT_CLASS(), (RDFNode)null);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Element element2 = this.addElement(element, "equalc");
            this.translateClassIdentifier(element2, statement.getSubject());
            this.translateClassIdentifier(element2, statement.getResource());
        }
    }

    protected void translateClassExpressions(Element element, Property property, int n) {
        this.translateClassExpressions(element, this.m_sourceData.listStatements(null, property, (RDFNode)null), n);
    }

    protected void translateRestrictions(Element element) {
        this.translateClassExpressions(element, this.m_sourceData.listStatements(null, RDF.type, this.m_sourceData.getProfile().RESTRICTION()), 5);
    }

    protected void translateClassExpressions(Element element, StmtIterator stmtIterator, int n) {
        while (stmtIterator.hasNext()) {
            OntClass ontClass = (OntClass)stmtIterator.nextStatement().getSubject().as(class$com$hp$hpl$jena$ontology$OntClass == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.OntClass") : class$com$hp$hpl$jena$ontology$OntClass);
            Element element2 = this.addElement(element, "equalc");
            this.translateClassIdentifier(element2, ontClass);
            switch (n) {
                case 1: {
                    this.translateUnionClass(element2, ontClass);
                    break;
                }
                case 2: {
                    this.translateIntersectionClass(element2, ontClass);
                    break;
                }
                case 3: {
                    this.translateComplementClass(element2, ontClass);
                    break;
                }
                case 4: {
                    this.translateEnumeratedClass(element2, ontClass);
                    break;
                }
                case 5: {
                    this.translateRestrictionClass(element2, ontClass);
                }
            }
        }
    }

    protected void translateClassDisjointAxioms(Element element) {
        StmtIterator stmtIterator = this.m_sourceData.listStatements(null, this.m_sourceData.getProfile().DISJOINT_WITH(), (RDFNode)null);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Element element2 = this.addElement(element, "disjoint");
            this.translateClassIdentifier(element2, statement.getSubject());
            this.translateClassIdentifier(element2, statement.getResource());
        }
    }

    protected void translateClassIdentifier(Element element, Resource resource) {
        if (((Object)resource).equals(this.m_sourceData.getProfile().THING())) {
            this.addElement(element, "top");
            return;
        }
        if (((Object)resource).equals(this.m_sourceData.getProfile().NOTHING())) {
            this.addElement(element, "bottom");
            return;
        }
        Element element2 = this.addElement(element, "catom");
        element2.setAttribute("name", this.getNodeID(resource.asNode()));
    }

    protected void translateRestrictionClass(Element element, Resource resource) {
        Restriction restriction = (Restriction)resource.as(class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = DIGAdapter.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction);
        if (restriction.isAllValuesFromRestriction()) {
            Element element2 = this.addElement(element, "all");
            this.addNamedElement(element2, "ratom", restriction.getOnProperty().getURI());
            this.translateClassIdentifier(element2, restriction.asAllValuesFromRestriction().getAllValuesFrom());
        } else if (restriction.isSomeValuesFromRestriction()) {
            Element element3 = this.addElement(element, "some");
            this.addNamedElement(element3, "ratom", restriction.getOnProperty().getURI());
            this.translateClassIdentifier(element3, restriction.asSomeValuesFromRestriction().getSomeValuesFrom());
        } else if (restriction.isHasValueRestriction()) {
            this.translateHasValueRestriction(element, restriction.asHasValueRestriction());
        } else if (restriction.isMinCardinalityRestriction()) {
            this.translateCardinalityRestriction(element, restriction.asMinCardinalityRestriction().getMinCardinality(), restriction, "atleast", this.m_sourceData.getProfile().THING());
        } else if (restriction.isMaxCardinalityRestriction()) {
            this.translateCardinalityRestriction(element, restriction.asMaxCardinalityRestriction().getMaxCardinality(), restriction, "atmost", this.m_sourceData.getProfile().THING());
        } else if (restriction.isCardinalityRestriction()) {
            Element element4 = this.addElement(element, "and");
            this.translateCardinalityRestriction(element4, restriction.asCardinalityRestriction().getCardinality(), restriction, "atmost", this.m_sourceData.getProfile().THING());
            this.translateCardinalityRestriction(element4, restriction.asCardinalityRestriction().getCardinality(), restriction, "atleast", this.m_sourceData.getProfile().THING());
        }
    }

    protected void translateEnumeratedClass(Element element, OntClass ontClass) {
        Element element2 = this.addElement(element, "iset");
        ExtendedIterator extendedIterator = ontClass.asEnumeratedClass().listOneOf();
        while (extendedIterator.hasNext()) {
            this.addNamedElement(element2, "individual", ((Resource)extendedIterator.next()).getURI());
        }
    }

    protected void translateComplementClass(Element element, OntClass ontClass) {
        Element element2 = this.addElement(element, "not");
        this.translateClassIdentifier(element2, ontClass.asComplementClass().getOperand());
    }

    protected void translateIntersectionClass(Element element, OntClass ontClass) {
        Element element2 = this.addElement(element, "and");
        this.translateClassList(element2, ontClass.asIntersectionClass().getOperands());
    }

    protected void translateUnionClass(Element element, OntClass ontClass) {
        Element element2 = this.addElement(element, "or");
        this.translateClassList(element2, ontClass.asUnionClass().getOperands());
    }

    private void translateCardinalityRestriction(Element element, int n, Restriction restriction, String string, Resource resource) {
        Element element2 = this.addElement(element, string);
        element2.setAttribute("num", Integer.toString(n));
        this.addNamedElement(element2, "ratom", restriction.getOnProperty().getURI());
        this.translateClassIdentifier(element2, resource);
    }

    protected void translateHasValueRestriction(Element element, HasValueRestriction hasValueRestriction) {
        RDFNode rDFNode = hasValueRestriction.getHasValue();
        OntProperty ontProperty = hasValueRestriction.getOnProperty();
        if (rDFNode instanceof Literal) {
            Literal literal = (Literal)rDFNode;
            boolean bl = this.isIntegerType(literal.getDatatype());
            Element element2 = this.addElement(element, bl ? "intequals" : "stringequals");
            element2.setAttribute("val", literal.getLexicalForm());
            this.addNamedElement(element2, "attribute", ontProperty.getURI());
        } else {
            Element element3 = this.addElement(element, "some");
            this.addNamedElement(element3, "ratom", ontProperty.getURI());
            Element element4 = this.addElement(element3, "iset");
            this.addNamedElement(element4, "individual", ((Resource)rDFNode).getURI());
        }
    }

    protected void translateClassList(Element element, RDFList rDFList) {
        ExtendedIterator extendedIterator = rDFList.iterator();
        while (extendedIterator.hasNext()) {
            this.translateClassIdentifier(element, (Resource)extendedIterator.next());
        }
    }

    protected void translateIndividuals(Element element) {
        ExtendedIterator extendedIterator = this.m_sourceData.listIndividuals();
        while (extendedIterator.hasNext()) {
            this.translateIndividual(element, (Resource)extendedIterator.next());
        }
    }

    protected void translateIndividual(Element element, Resource resource) {
        Individual individual = (Individual)resource.as(class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual);
        this.translateInstanceTypes(element, individual);
        StmtIterator stmtIterator = individual.listProperties();
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            OntProperty ontProperty = (OntProperty)statement.getPredicate().as(class$com$hp$hpl$jena$ontology$OntProperty == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.OntProperty") : class$com$hp$hpl$jena$ontology$OntProperty);
            if (ontProperty.equals(this.m_sourceData.getProfile().DIFFERENT_FROM())) {
                this.translateDifferentIndividuals(element, individual, (Individual)statement.getResource().as(class$com$hp$hpl$jena$ontology$Individual == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual));
                continue;
            }
            if (ontProperty.equals(this.m_sourceData.getProfile().SAME_AS())) {
                this.translateSameIndividuals(element, individual, (Individual)statement.getResource().as(class$com$hp$hpl$jena$ontology$Individual == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual));
                continue;
            }
            if (ontProperty.isObjectProperty() || ontProperty.isTransitiveProperty() || ontProperty.isSymmetricProperty() || ontProperty.isInverseFunctionalProperty()) {
                this.translateInstanceRole(element, individual, ontProperty, (Individual)statement.getResource().as(class$com$hp$hpl$jena$ontology$Individual == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual));
                continue;
            }
            if (!ontProperty.isDatatypeProperty()) continue;
            this.translateInstanceAttrib(element, individual, ontProperty, statement.getLiteral());
        }
    }

    protected void translateInstanceTypes(Element element, Individual individual) {
        ExtendedIterator extendedIterator = individual.listRDFTypes(true);
        while (extendedIterator.hasNext()) {
            Resource resource = (Resource)extendedIterator.next();
            Element element2 = this.addElement(element, "instanceof");
            this.addNamedElement(element2, "individual", this.getResourceID(individual));
            this.addNamedElement(element2, "catom", resource.getURI());
        }
    }

    protected void translateInstanceRole(Element element, Individual individual, OntProperty ontProperty, Individual individual2) {
        Element element2 = this.addElement(element, "related");
        this.addNamedElement(element2, "individual", this.getResourceID(individual));
        this.addNamedElement(element2, "ratom", ontProperty.getURI());
        this.addNamedElement(element2, "individual", this.getResourceID(individual2));
    }

    protected void translateInstanceAttrib(Element element, Individual individual, OntProperty ontProperty, Literal literal) {
        Element element2 = this.addElement(element, "value");
        this.addNamedElement(element2, "individual", this.getResourceID(individual));
        this.addNamedElement(element2, "attribute", ontProperty.getURI());
        if (this.isIntegerType(literal.getDatatype())) {
            Element element3 = this.addElement(element2, "ival");
            element3.appendChild(element.getOwnerDocument().createTextNode(literal.getLexicalForm()));
        } else {
            Element element4 = this.addElement(element2, "sval");
            element4.appendChild(element.getOwnerDocument().createTextNode(literal.getLexicalForm()));
        }
    }

    protected void translateDifferentIndividuals(Element element, Individual individual, Individual individual2) {
        Element element2 = this.addElement(element, "disjoint");
        Element element3 = this.addElement(element2, "iset");
        this.addNamedElement(element3, "individual", this.getResourceID(individual));
        Element element4 = this.addElement(element2, "iset");
        this.addNamedElement(element4, "individual", this.getResourceID(individual2));
    }

    protected void translateSameIndividuals(Element element, Individual individual, Individual individual2) {
        Element element2 = this.addElement(element, "equalc");
        Element element3 = this.addElement(element2, "iset");
        this.addNamedElement(element3, "individual", this.getResourceID(individual));
        Element element4 = this.addElement(element2, "iset");
        this.addNamedElement(element4, "individual", this.getResourceID(individual2));
    }

    protected void translateRoles(Element element) {
        HashSet hashSet = new HashSet();
        this.collectRoleProperties(hashSet);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.translateRole(element, (ObjectProperty)((Property)iterator.next()).as(class$com$hp$hpl$jena$ontology$ObjectProperty == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.ObjectProperty") : class$com$hp$hpl$jena$ontology$ObjectProperty));
        }
    }

    protected void translateRole(Element element, ObjectProperty objectProperty) {
        this.translateBinaryPropertyAxioms(element, objectProperty.getURI(), "impliesr", objectProperty.listSuperProperties(), "ratom");
        this.translateBinaryPropertyAxioms(element, objectProperty.getURI(), "equalr", objectProperty.listEquivalentProperties(), "ratom");
        this.translateDomainRangeAxioms(element, objectProperty.getURI(), "domain", objectProperty.listDomain(), "ratom");
        this.translateDomainRangeAxioms(element, objectProperty.getURI(), "range", objectProperty.listRange(), "ratom");
        this.translateInverseAxioms(element, objectProperty, "ratom");
        if (objectProperty.isTransitiveProperty()) {
            this.translateUnaryPropertyAxiom(element, objectProperty.getURI(), "transitive", "ratom");
        }
        if (objectProperty.isFunctionalProperty()) {
            this.translateUnaryPropertyAxiom(element, objectProperty.getURI(), "functional", "ratom");
        }
        if (objectProperty.isInverseFunctionalProperty()) {
            this.translateInverseFunctionalAxiom(element, objectProperty, "ratom");
        }
        if (objectProperty.isSymmetricProperty()) {
            this.translateInverseAxiom(element, objectProperty, "ratom", objectProperty);
        }
    }

    protected void translateAttributes(Element element) {
        ExtendedIterator extendedIterator = this.m_sourceData.listDatatypeProperties();
        while (extendedIterator.hasNext()) {
            this.translateAttribute(element, (DatatypeProperty)((Property)extendedIterator.next()).as(class$com$hp$hpl$jena$ontology$DatatypeProperty == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.DatatypeProperty") : class$com$hp$hpl$jena$ontology$DatatypeProperty));
        }
    }

    protected void translateAttribute(Element element, DatatypeProperty datatypeProperty) {
        this.translateBinaryPropertyAxioms(element, datatypeProperty.getURI(), "impliesr", datatypeProperty.listSuperProperties(), "attribute");
        this.translateBinaryPropertyAxioms(element, datatypeProperty.getURI(), "equalr", datatypeProperty.listEquivalentProperties(), "attribute");
        this.translateDomainRangeAxioms(element, datatypeProperty.getURI(), "domain", datatypeProperty.listDomain(), "attribute");
        this.translateAttribRangeAxioms(element, datatypeProperty.getURI(), datatypeProperty.listRange(), "attribute");
        if (datatypeProperty.isFunctionalProperty()) {
            this.translateUnaryPropertyAxiom(element, datatypeProperty.getURI(), "functional", "attribute");
        }
    }

    protected void translateBinaryPropertyAxioms(Element element, String string, String string2, Iterator iterator, String string3) {
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            Element element2 = this.addElement(element, string2);
            this.addNamedElement(element2, string3, string);
            this.addNamedElement(element2, string3, property.getURI());
        }
    }

    protected void translateUnaryPropertyAxiom(Element element, String string, String string2, String string3) {
        Element element2 = this.addElement(element, string2);
        this.addNamedElement(element2, string3, string);
    }

    protected void translateDomainRangeAxioms(Element element, String string, String string2, Iterator iterator, String string3) {
        while (iterator.hasNext()) {
            Element element2 = this.addElement(element, string2);
            this.addNamedElement(element2, string3, string);
            this.translateClassIdentifier(element2, (Resource)iterator.next());
        }
    }

    protected void translateAttribRangeAxioms(Element element, String string, Iterator iterator, String string2) {
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            RDFDatatype rDFDatatype = TypeMapper.getInstance().getTypeByName(resource.getURI());
            Element element2 = this.addElement(element, this.isIntegerType(rDFDatatype) ? "rangeint" : "rangestring");
            this.addNamedElement(element2, string2, string);
        }
    }

    protected void translateInverseAxioms(Element element, ObjectProperty objectProperty, String string) {
        ExtendedIterator extendedIterator = objectProperty.listInverse();
        while (extendedIterator.hasNext()) {
            this.translateInverseAxiom(element, objectProperty, string, (Property)extendedIterator.next());
        }
    }

    protected void translateInverseAxiom(Element element, Property property, String string, Property property2) {
        Element element2 = this.addElement(element, "equalr");
        this.addNamedElement(element2, string, property.getURI());
        Element element3 = this.addElement(element2, "inverse");
        this.addNamedElement(element3, string, property2.getURI());
    }

    protected void translateInverseFunctionalAxiom(Element element, ObjectProperty objectProperty, String string) {
        String string2 = this.getSkolemName(objectProperty.getLocalName());
        this.addNamedElement(element, "defrole", string2);
        Element element2 = this.addElement(element, "functional");
        this.addNamedElement(element2, string, string2);
        Element element3 = this.addElement(element, "equalr");
        this.addNamedElement(element3, string, objectProperty.getURI());
        Element element4 = this.addElement(element3, "inverse");
        this.addNamedElement(element4, string, string2);
    }

    protected void translateAllDifferentAxioms(Element element) {
        ExtendedIterator extendedIterator = this.m_sourceData.listAllDifferent();
        while (extendedIterator.hasNext()) {
            AllDifferent allDifferent = (AllDifferent)((Resource)extendedIterator.next()).as(class$com$hp$hpl$jena$ontology$AllDifferent == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.AllDifferent") : class$com$hp$hpl$jena$ontology$AllDifferent);
            this.translateAllDifferent(element, allDifferent.getDistinctMembers());
        }
    }

    protected void translateAllDifferent(Element element, RDFList rDFList) {
        List list = rDFList.asJavaList();
        for (int i = 0; i < list.size(); ++i) {
            Individual individual = (Individual)((Resource)list.get(i)).as(class$com$hp$hpl$jena$ontology$Individual == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
            for (int j = i + 1; j < list.size(); ++j) {
                Individual individual2 = (Individual)((Resource)list.get(j)).as(class$com$hp$hpl$jena$ontology$Individual == null ? DIGAdapter.class$("com.hp.hpl.jena.ontology.Individual") : class$com$hp$hpl$jena$ontology$Individual);
                this.translateDifferentIndividuals(element, individual, individual2);
            }
        }
    }

    private boolean isIntegerType(RDFDatatype rDFDatatype) {
        String string = rDFDatatype != null ? rDFDatatype.getURI() : null;
        return string != null && (string.equals(XSDDatatype.XSDint.getURI()) || string.equals(XSDDatatype.XSDinteger.getURI()) || string.equals(XSDDatatype.XSDnonNegativeInteger.getURI()));
    }

    private String getSkolemName(String string) {
        return "skolem(" + string + "," + this.m_skolemCounter++ + ")";
    }

    protected Set getKnownIndividuals() {
        if (this.m_indNames == null) {
            this.m_indNames = this.collectNamedTerms("allIndividuals", new String[]{"individualSet", "individual"});
        }
        return this.m_indNames;
    }

    protected Set getKnownConcepts() {
        if (this.m_conceptNames == null) {
            this.m_conceptNames = this.collectNamedTerms("allConceptNames", new String[]{"conceptSet", "synonyms", "catom"});
        }
        return this.m_conceptNames;
    }

    protected Set getKnownRoles() {
        if (this.m_roleNames == null) {
            this.m_roleNames = this.collectNamedTerms("allRoleNames", new String[]{"roleSet", "synonyms", "ratom"});
        }
        return this.m_roleNames;
    }

    protected Set collectNamedTerms(String string, String[] stringArray) {
        HashSet hashSet = new HashSet();
        Document document = this.getConnection().createDigVerb("asks", this.getProfile());
        this.addElement(document.getDocumentElement(), string);
        Document document2 = this.getConnection().sendDigVerb(document, this.getProfile());
        SimpleXMLPath simpleXMLPath = new SimpleXMLPath(true);
        for (int i = 0; i < stringArray.length; ++i) {
            simpleXMLPath.appendElementPath(stringArray[i]);
        }
        simpleXMLPath.appendAttrPath("name");
        this.addAll(simpleXMLPath.getAll(document2), hashSet);
        return hashSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DigIdentifierImpl
    implements DIGIdentifier {
        private Document m_id;

        private DigIdentifierImpl(Document document) {
            this.m_id = document;
        }

        public String getName() {
            return this.m_id.getDocumentElement().getAttribute("name");
        }

        public String getVersion() {
            return this.m_id.getDocumentElement().getAttribute("version");
        }

        public String getMessage() {
            return this.m_id.getDocumentElement().getAttribute("message");
        }

        public Iterator supportsLanguage() {
            return this.supports("language");
        }

        public Iterator supportsTell() {
            return this.supports("tell");
        }

        public Iterator supportsAsk() {
            return this.supports("ask");
        }

        private Iterator supports(String string) {
            Element element = this.getChild(this.m_id.getDocumentElement(), "supports");
            return this.childElementNames(this.getChild(element, string));
        }

        private Iterator childElementNames(Element element) {
            ArrayList<String> arrayList = new ArrayList<String>();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                org.w3c.dom.Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                arrayList.add(node.getNodeName());
            }
            return arrayList.iterator();
        }

        private Element getChild(Element element, String string) {
            return (Element)element.getElementsByTagName(string).item(0);
        }
    }
}

