/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashMap;
import java.util.Map;

public class TriplePattern
implements ClauseEntry {
    protected Node subject;
    protected Node predicate;
    protected Node object;

    public TriplePattern(Node node, Node node2, Node node3) {
        this.subject = TriplePattern.normalize(node);
        this.predicate = TriplePattern.normalize(node2);
        this.object = TriplePattern.normalize(node3);
    }

    public TriplePattern(TripleMatch tripleMatch) {
        this.subject = TriplePattern.normalize(tripleMatch.getMatchSubject());
        this.predicate = TriplePattern.normalize(tripleMatch.getMatchPredicate());
        this.object = TriplePattern.normalize(tripleMatch.getMatchObject());
    }

    public TriplePattern(Triple triple) {
        this.subject = TriplePattern.normalize(triple.getSubject());
        this.predicate = TriplePattern.normalize(triple.getPredicate());
        this.object = TriplePattern.normalize(triple.getObject());
    }

    public Node getObject() {
        return this.object;
    }

    public Node getPredicate() {
        return this.predicate;
    }

    public Node getSubject() {
        return this.subject;
    }

    public TripleMatch asTripleMatch() {
        return Triple.createMatch(TriplePattern.toMatch(this.subject), TriplePattern.toMatch(this.predicate), TriplePattern.toMatch(this.object));
    }

    public Triple asTriple() {
        return new Triple(this.subject, this.predicate, this.object);
    }

    public boolean compatibleWith(TriplePattern triplePattern) {
        boolean bl;
        boolean bl2 = bl = this.subject.isVariable() || triplePattern.subject.isVariable() || this.subject.equals(triplePattern.subject);
        if (!bl) {
            return false;
        }
        boolean bl3 = bl = this.predicate.isVariable() || triplePattern.predicate.isVariable() || this.predicate.equals(triplePattern.predicate);
        if (!bl) {
            return false;
        }
        if (this.object.isVariable() || triplePattern.object.isVariable()) {
            return true;
        }
        if (Functor.isFunctor(this.object) && Functor.isFunctor(triplePattern.object)) {
            Functor functor = (Functor)this.object.getLiteral().getValue();
            Functor functor2 = (Functor)triplePattern.object.getLiteral().getValue();
            return functor.getName().equals(functor2.getName()) && functor.getArgs().length == functor2.getArgs().length;
        }
        return this.object.sameValueAs(triplePattern.object);
    }

    public boolean variantOf(TriplePattern triplePattern) {
        HashMap hashMap = new HashMap();
        if (!this.variantOf(this.subject, triplePattern.subject, hashMap)) {
            return false;
        }
        if (!this.variantOf(this.predicate, triplePattern.predicate, hashMap)) {
            return false;
        }
        if (Functor.isFunctor(this.object) && Functor.isFunctor(triplePattern.object)) {
            Node[] nodeArray;
            Functor functor = (Functor)this.object.getLiteral().getValue();
            Functor functor2 = (Functor)triplePattern.object.getLiteral().getValue();
            if (!functor.getName().equals(functor2.getName())) {
                return false;
            }
            Node[] nodeArray2 = functor.getArgs();
            if (nodeArray2.length != (nodeArray = functor2.getArgs()).length) {
                return false;
            }
            for (int i = 0; i < nodeArray2.length; ++i) {
                if (this.variantOf(nodeArray2[i], nodeArray[i], hashMap)) continue;
                return false;
            }
            return true;
        }
        return this.variantOf(this.object, triplePattern.object, hashMap);
    }

    private boolean variantOf(Node node, Node node2, Map map) {
        if (node instanceof Node_RuleVariable) {
            if (node2 instanceof Node_RuleVariable) {
                Object v = map.get(node);
                if (v == null) {
                    map.put(node, node2);
                    return true;
                }
                return v == node2;
            }
            return false;
        }
        return node.sameValueAs(node2);
    }

    public boolean isLegal() {
        if (this.subject.isLiteral() || this.predicate.isLiteral()) {
            return false;
        }
        if (Functor.isFunctor(this.subject)) {
            return false;
        }
        if (Functor.isFunctor(this.object)) {
            Node[] nodeArray = ((Functor)this.object.getLiteral().getValue()).getArgs();
            for (int i = 0; i < nodeArray.length; ++i) {
                if (!Functor.isFunctor(nodeArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean subsumes(TriplePattern triplePattern) {
        return !(!this.subject.isVariable() && !this.subject.equals(triplePattern.subject) || !this.predicate.isVariable() && !this.predicate.equals(triplePattern.predicate) || !this.object.isVariable() && !this.object.equals(triplePattern.object));
    }

    public boolean isGround() {
        if (this.subject.isVariable() || this.predicate.isVariable() || this.object.isVariable()) {
            return false;
        }
        if (Functor.isFunctor(this.object)) {
            return ((Functor)this.object.getLiteral().getValue()).isGround();
        }
        return true;
    }

    public String toString() {
        return TriplePattern.simplePrintString(this.subject) + " @" + TriplePattern.simplePrintString(this.predicate) + " " + TriplePattern.simplePrintString(this.object);
    }

    public static String simplePrintString(Triple triple) {
        return TriplePattern.simplePrintString(triple.getSubject()) + " @" + TriplePattern.simplePrintString(triple.getPredicate()) + " " + TriplePattern.simplePrintString(triple.getObject());
    }

    public static String simplePrintString(Node node) {
        if (node instanceof Node_URI) {
            String string = node.getURI();
            int n = string.lastIndexOf(35);
            if (n == -1 && (n = string.lastIndexOf(47)) == -1) {
                n = -1;
            }
            String string2 = string.substring(0, n + 1);
            String string3 = "";
            if (string2.equals(RDF.getURI())) {
                string3 = "rdf:";
            } else if (string2.equals(RDFS.getURI())) {
                string3 = "rdfs:";
            }
            return string3 + string.substring(n + 1);
        }
        return node.toString();
    }

    private static Node normalize(Node node) {
        if (node == null || node == Node.ANY) {
            return Node_RuleVariable.WILD;
        }
        return node;
    }

    private static Node toMatch(Node node) {
        return node.isVariable() ? null : node;
    }

    public boolean equals(Object object) {
        return object instanceof TriplePattern && this.nodeEqual(this.subject, ((TriplePattern)object).subject) && this.nodeEqual(this.predicate, ((TriplePattern)object).predicate) && this.nodeEqual(this.object, ((TriplePattern)object).object);
    }

    private boolean nodeEqual(Node node, Node node2) {
        if (node instanceof Node_RuleVariable && node2 instanceof Node_RuleVariable) {
            return true;
        }
        return node.equals(node2);
    }

    public int hashCode() {
        int n = 0;
        if (!(this.subject instanceof Node_RuleVariable)) {
            n ^= this.subject.hashCode() >> 1;
        }
        if (!(this.predicate instanceof Node_RuleVariable)) {
            n ^= this.predicate.hashCode();
        }
        if (!(this.object instanceof Node_RuleVariable)) {
            n ^= this.object.hashCode() << 1;
        }
        return n;
    }

    public boolean sameAs(Object object) {
        if (!(object instanceof TriplePattern)) {
            return false;
        }
        TriplePattern triplePattern = (TriplePattern)object;
        return Node_RuleVariable.sameNodeAs(this.subject, triplePattern.subject) && Node_RuleVariable.sameNodeAs(this.predicate, triplePattern.predicate) && Node_RuleVariable.sameNodeAs(this.object, triplePattern.object);
    }
}

