/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.QueryResultsFormatter;
import com.hp.hpl.jena.rdql.QueryResultsRewindable;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.ModelLoader;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.ResultSet;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryResultsMem
implements QueryResultsRewindable {
    static final boolean DEBUG = false;
    List rows = new ArrayList();
    List varNames = null;
    int rowNumber = 0;
    Iterator iterator = null;

    public QueryResultsMem(QueryResultsMem queryResultsMem) {
        this(queryResultsMem, false);
    }

    public QueryResultsMem(QueryResultsMem queryResultsMem, boolean bl) {
        this.varNames = queryResultsMem.varNames;
        if (bl) {
            Iterator iterator = queryResultsMem.rows.iterator();
            while (iterator.hasNext()) {
                this.rows.add((ResultBinding)iterator.next());
            }
        } else {
            this.rows = queryResultsMem.rows;
        }
        this.reset();
    }

    public QueryResultsMem(QueryResults queryResults) {
        if (queryResults instanceof QueryResultsMem) {
            QueryResultsMem queryResultsMem = (QueryResultsMem)queryResults;
            this.rows = queryResultsMem.rows;
            this.varNames = queryResultsMem.varNames;
        } else {
            this.varNames = queryResults.getResultVars();
            while (queryResults.hasNext()) {
                ResultBinding resultBinding = (ResultBinding)queryResults.next();
                this.rows.add(resultBinding);
            }
            queryResults.close();
        }
        this.reset();
    }

    public QueryResultsMem(Model model) {
        this.buildFromDumpFormat(model);
    }

    public QueryResultsMem(String string) throws FileNotFoundException {
        Model model = ModelLoader.loadModel(string);
        this.buildFromDumpFormat(model);
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("QueryResultsMem: Attempt to remove an element");
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        ++this.rowNumber;
        return this.iterator.next();
    }

    public void close() {
        this.rows = null;
        this.iterator = null;
        this.varNames = null;
    }

    public void rewind() {
        this.reset();
    }

    public void reset() {
        this.iterator = this.rows.iterator();
        this.rowNumber = 0;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int size() {
        return this.rows.size();
    }

    public List getResultVars() {
        return this.varNames;
    }

    public List getAll() {
        return this.rows;
    }

    private void buildFromDumpFormat(Model model) {
        this.varNames = new ArrayList();
        StmtIterator stmtIterator = model.listStatements(null, RDF.type, ResultSet.ResultSet);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Resource resource = statement.getSubject();
            StmtIterator stmtIterator2 = resource.listProperties(ResultSet.resultVariable);
            while (stmtIterator2.hasNext()) {
                String string = stmtIterator2.nextStatement().getString();
                this.varNames.add(string);
            }
            stmtIterator2.close();
            int n = 0;
            StmtIterator stmtIterator3 = resource.listProperties(ResultSet.solution);
            while (stmtIterator3.hasNext()) {
                ResultBinding resultBinding = new ResultBinding();
                ++n;
                Resource resource2 = stmtIterator3.nextStatement().getResource();
                StmtIterator stmtIterator4 = resource2.listProperties(ResultSet.binding);
                while (stmtIterator4.hasNext()) {
                    Resource resource3 = stmtIterator4.nextStatement().getResource();
                    String string = resource3.getRequiredProperty(ResultSet.variable).getString();
                    RDFNode rDFNode = resource3.getRequiredProperty(ResultSet.value).getObject();
                    resultBinding.add(string, rDFNode);
                }
                stmtIterator4.close();
                this.rows.add(resultBinding);
            }
            stmtIterator3.close();
            if (resource.hasProperty(ResultSet.size)) {
                try {
                    int n2 = resource.getRequiredProperty(ResultSet.size).getInt();
                    if (n2 < n) {
                        System.err.println("Warning: Declared size = " + n2 + " : Count = " + n);
                    }
                }
                catch (JenaException jenaException) {
                    // empty catch block
                }
            }
            stmtIterator.close();
        }
        this.reset();
    }

    public static boolean equivalent(QueryResultsMem queryResultsMem, QueryResultsMem queryResultsMem2) {
        QueryResultsFormatter queryResultsFormatter = new QueryResultsFormatter(queryResultsMem);
        Model model = queryResultsFormatter.toModel();
        QueryResultsFormatter queryResultsFormatter2 = new QueryResultsFormatter(queryResultsMem2);
        Model model2 = queryResultsFormatter2.toModel();
        return model.isIsomorphicWith(model2);
    }

    public Model toModel() {
        Model model = ModelFactory.createDefaultModel();
        this.asRDF(model);
        return model;
    }

    public Resource asRDF(Model model) {
        QueryResultsFormatter queryResultsFormatter = new QueryResultsFormatter(this);
        Resource resource = queryResultsFormatter.asRDF(model);
        queryResultsFormatter.close();
        return resource;
    }

    public void list(PrintWriter printWriter) {
        QueryResultsMem queryResultsMem = new QueryResultsMem(this);
        QueryResultsFormatter queryResultsFormatter = new QueryResultsFormatter(queryResultsMem);
        queryResultsFormatter.dump(printWriter, false);
        queryResultsMem.close();
    }
}

