/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestResourceFactory
extends TestCase {
    static final String uri1 = "http://example.org/example#a1";
    static final String uri2 = "http://example.org/example#a2";
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$test$TestResourceFactory;

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$rdf$model$test$TestResourceFactory == null ? (class$com$hp$hpl$jena$rdf$model$test$TestResourceFactory = TestResourceFactory.class$("com.hp.hpl.jena.rdf.model.test.TestResourceFactory")) : class$com$hp$hpl$jena$rdf$model$test$TestResourceFactory);
    }

    public TestResourceFactory(String string) {
        super(string);
    }

    public void testCreateResource() {
        Resource resource = ResourceFactory.createResource();
        TestResourceFactory.assertTrue((boolean)resource.isAnon());
        Resource resource2 = ResourceFactory.createResource();
        TestResourceFactory.assertTrue((boolean)resource2.isAnon());
        TestResourceFactory.assertTrue((!((Object)resource).equals(resource2) ? 1 : 0) != 0);
        resource = ResourceFactory.createResource(uri1);
        TestResourceFactory.assertTrue((boolean)resource.getURI().equals(uri1));
    }

    public void testCreateProperty() {
        Property property = ResourceFactory.createProperty(uri1);
        TestResourceFactory.assertTrue((boolean)property.getURI().equals(uri1));
        Property property2 = ResourceFactory.createProperty(uri1, "2");
        TestResourceFactory.assertTrue((boolean)property2.getURI().equals("http://example.org/example#a12"));
    }

    public void testCreateStatement() {
        Resource resource = ResourceFactory.createResource();
        Property property = ResourceFactory.createProperty(uri2);
        Resource resource2 = ResourceFactory.createResource();
        Statement statement = ResourceFactory.createStatement(resource, property, resource2);
        TestResourceFactory.assertTrue((boolean)((Object)statement.getSubject()).equals(resource));
        TestResourceFactory.assertTrue((boolean)statement.getPredicate().equals(property));
        TestResourceFactory.assertTrue((boolean)statement.getObject().equals(resource2));
    }

    public void testGetInstance() {
        ResourceFactory.Interface interface_ = ResourceFactory.getInstance();
        Resource resource = ResourceFactory.createResource();
        TestResourceFactory.assertTrue((boolean)resource.isAnon());
        Resource resource2 = ResourceFactory.createResource();
        TestResourceFactory.assertTrue((boolean)resource2.isAnon());
        TestResourceFactory.assertTrue((!((Object)resource).equals(resource2) ? 1 : 0) != 0);
    }

    public void testSetInstance() {
        Resource resource = ResourceFactory.createResource();
        TestFactory testFactory = new TestFactory(resource);
        ResourceFactory.setInstance(testFactory);
        TestResourceFactory.assertTrue((boolean)testFactory.equals(ResourceFactory.getInstance()));
        TestResourceFactory.assertTrue((ResourceFactory.createResource() == resource ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TestFactory
    implements ResourceFactory.Interface {
        Resource resource;

        TestFactory(Resource resource) {
            this.resource = resource;
        }

        public Resource createResource() {
            return this.resource;
        }

        public Resource createResource(String string) {
            return null;
        }

        public Literal createPlainLiteral(String string) {
            return null;
        }

        public Property createProperty(String string) {
            return null;
        }

        public Property createProperty(String string, String string2) {
            return null;
        }

        public Statement createStatement(Resource resource, Property property, RDFNode rDFNode) {
            return null;
        }
    }
}

