/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.ModelQueryUtil;
import com.hp.hpl.jena.util.QueryMapper;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Arrays;
import junit.framework.TestSuite;

public class TestQuery
extends ModelTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$test$TestQuery;

    public TestQuery(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$rdf$model$test$TestQuery == null ? (class$com$hp$hpl$jena$rdf$model$test$TestQuery = TestQuery.class$("com.hp.hpl.jena.rdf.model.test.TestQuery")) : class$com$hp$hpl$jena$rdf$model$test$TestQuery);
    }

    public void testAAA() {
        this.testQueryTranslates("", "");
        this.testQueryTranslates("x R y", "x R y");
        this.testQueryTranslates("x R _y; p S 99", "x R _y; p S 99");
        this.testQueryTranslates("x R ?y", "x R ?y");
        this.testQueryTranslates("jqv:x jqv:H y", "?x ?H y");
    }

    public void testBBB() {
        Model model = ModelFactory.createDefaultModel();
        String[][] stringArrayArray = new String[][]{{"x", "x"}, {"jqv:x", "?x"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            this.testVariablesTranslate(TestQuery.resources(model, stringArrayArray[i][0]), TestQuery.nodes(stringArrayArray[i][1]));
        }
    }

    private void testQueryTranslates(String string, String string2) {
        String string3 = "must translate <" + string + "> to <" + string2 + ">";
        Model model = TestQuery.modelWithStatements(string);
        Graph graph = GraphTestBase.graphWith(string2);
        QueryMapper queryMapper = new QueryMapper(model, new Resource[0]);
        GraphTestBase.assertIsomorphic(string3, graph, queryMapper.getGraph());
    }

    public void testVariablesTranslate(Resource[] resourceArray, Node[] nodeArray) {
        TestQuery.assertEquals((String)"broken test", (int)resourceArray.length, (int)nodeArray.length);
        QueryMapper queryMapper = new QueryMapper(TestQuery.modelWithStatements(""), resourceArray);
        Node[] nodeArray2 = queryMapper.getVariables();
        TestQuery.assertEquals((int)nodeArray.length, (int)nodeArray2.length);
        for (int i = 0; i < nodeArray2.length; ++i) {
            TestQuery.assertEquals((String)"variable did not convert", (Object)nodeArray[i], (Object)nodeArray2[i]);
        }
    }

    public void testModelQuery() {
        ModelCom modelCom = (ModelCom)TestQuery.modelWithStatements("a R b; b S c; a R p; p T d");
        Model model = TestQuery.modelWithStatements("jqv:x R jqv:y; jqv:y S jqv:z");
        ExtendedIterator extendedIterator = ModelQueryUtil.queryBindingsWith(modelCom, model, TestQuery.resources(model, "jqv:x jqv:z"));
        TestQuery.assertTrue((boolean)extendedIterator.hasNext());
        TestQuery.assertEquals(Arrays.asList(TestQuery.resources(modelCom, "a c b")), extendedIterator.next());
        TestQuery.assertFalse((boolean)extendedIterator.hasNext());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

