/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.test.NTripleTestSuite;
import com.hp.hpl.jena.rdf.arp.test.WGTestSuite;
import com.hp.hpl.jena.shared.wg.URI;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ARPTests {
    public static boolean internet = false;
    static URI wgTestDir = URI.create("http://www.w3.org/2000/10/rdf-tests/rdfcore/");
    private static URI arpTestDir = URI.create("http://jcarroll.hpl.hp.com/arp-tests/");
    static int cnt = 0;

    public static Test suite() {
        TestSuite testSuite = new TestSuite("ARP");
        if (internet) {
            testSuite.addTest((Test)NTripleTestSuite.suite(wgTestDir, wgTestDir, "WG Parser Tests"));
        } else {
            testSuite.addTest((Test)WGTestSuite.suite(wgTestDir, "wg", "WG Parser Tests"));
            testSuite.addTest((Test)WGTestSuite.suite(arpTestDir, "arp", "ARP Tests"));
            testSuite.addTest((Test)NTripleTestSuite.suite(wgTestDir, "wg", "NTriple WG Tests"));
        }
        return testSuite;
    }

    static String toJava(Test test, PrintWriter printWriter, String string) {
        String string2 = "test" + cnt++;
        if (test instanceof TestSuite) {
            TestSuite testSuite = (TestSuite)test;
            if (test instanceof WGTestSuite) {
                printWriter.println("WGTestSuite " + string2 + " = " + ((WGTestSuite)test).createMe + ";");
                string = string2;
            } else {
                printWriter.println("TestSuite " + string2 + " = new TestSuite(\"" + testSuite.getName() + "\");");
            }
            Enumeration enumeration = testSuite.tests();
            while (enumeration.hasMoreElements()) {
                Test test2 = (Test)enumeration.nextElement();
                if (test2 == null) continue;
                String string3 = ARPTests.toJava(test2, printWriter, string);
                printWriter.println(string2 + ".addTest(" + string3 + ");");
            }
        } else if (test instanceof WGTestSuite.Test) {
            String string4 = test.getClass().getName();
            String string5 = string4.substring(string4.lastIndexOf(36) + 1);
            printWriter.println("Test " + string2 + " = " + string + ".create" + string5 + "(" + ((WGTestSuite.Test)test).createMe() + ");");
        } else {
            printWriter.println(string2 + " is of class " + test.getClass().getName());
        }
        return string2;
    }

    public static void main(String[] stringArray) throws IOException {
        Test test = ARPTests.suite();
        PrintWriter printWriter = new PrintWriter(new FileWriter("src/com/hp/hpl/jena/rdf/arp/test/TestPackage.java"));
        printWriter.println("/*");
        printWriter.println(" *  (c) Copyright 2002-2003 Hewlett-Packard Development Company, LP");
        printWriter.println(" *  All rights reserved.");
        printWriter.println(" *");
        printWriter.println(" * Redistribution and use in source and binary forms, with or without");
        printWriter.println(" * modification, are permitted provided that the following conditions");
        printWriter.println(" * are met:");
        printWriter.println(" * 1. Redistributions of source code must retain the above copyright");
        printWriter.println(" *    notice, this list of conditions and the following disclaimer.");
        printWriter.println(" * 2. Redistributions in binary form must reproduce the above copyright");
        printWriter.println(" *    notice, this list of conditions and the following disclaimer in the");
        printWriter.println(" *    documentation and/or other materials provided with the distribution.");
        printWriter.println(" * 3. The name of the author may not be used to endorse or promote products");
        printWriter.println(" *    derived from this software without specific prior written permission.");
        printWriter.println("");
        printWriter.println(" * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR");
        printWriter.println(" * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES");
        printWriter.println(" * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.");
        printWriter.println(" * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,");
        printWriter.println(" * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT");
        printWriter.println(" * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,");
        printWriter.println(" * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY");
        printWriter.println(" * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT");
        printWriter.println(" * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF");
        printWriter.println(" * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.");
        printWriter.println(" *");
        printWriter.println(" */");
        printWriter.println("package com.hp.hpl.jena.rdf.arp.test;");
        printWriter.println("import junit.framework.TestSuite;");
        printWriter.println("import junit.framework.Test;");
        printWriter.println("import com.hp.hpl.jena.shared.wg.*;");
        printWriter.println("public class TestPackage{");
        printWriter.println("static public Test suite() {");
        String string = ARPTests.toJava(test, printWriter, "xx");
        printWriter.println("return " + string + ";");
        printWriter.println("} }");
        printWriter.println("");
        printWriter.flush();
    }
}

